/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.completion;

import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import java.util.ArrayList;

public class EnumValueCompleter
implements PrefixCompleter {
    private Class<? extends Enum> enumClass;

    public EnumValueCompleter(Class<? extends Enum> enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public DSLCompletion complete(String prefix) {
        ArrayList<String> enumValues = new ArrayList<String>();
        for (Enum value : this.enumClass.getEnumConstants()) {
            if (prefix != null && prefix.length() != 0 && !value.name().startsWith(prefix)) continue;
            enumValues.add(value.name());
        }
        DSLCompletion completion = DSLCompletion.buildPrefixAndCompletion(prefix, enumValues);
        if (completion != null) {
            for (String value : enumValues) {
                completion.addSuggestion(new TokenSuggestion(value, SuggestionGroup.ENUM_VALUE).setOffset(prefix));
            }
            completion.checkAndCompress();
            completion.moveSingleSuggestionToCompletion();
        }
        return completion;
    }
}

