/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.completion;

import com.streamscape.omf.serializer.SerializerUtils;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.slex.lang.PrefixTree;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.tools.console.autocompletion.PrefixTreeCompleter;

public class DataspaceTypesCompleter
implements PrefixCompleter {
    private FabricContext context;
    private boolean allTypes = true;
    private boolean onlyForColumns = false;
    private boolean onlyForSnapshot = false;

    public DataspaceTypesCompleter(FabricContext context) {
        this.context = context;
    }

    public DataspaceTypesCompleter onlyForColumns(boolean onlyForColumns) {
        this.allTypes = false;
        this.onlyForSnapshot = false;
        this.onlyForColumns = onlyForColumns;
        return this;
    }

    public DataspaceTypesCompleter onlyForSnapshot(boolean onlyForSnapshot) {
        this.allTypes = false;
        this.onlyForColumns = false;
        this.onlyForSnapshot = onlyForSnapshot;
        return this;
    }

    @Override
    public DSLCompletion complete(String prefix) {
        PrefixTree<SuggestionGroup> prefixTree = new PrefixTree<SuggestionGroup>(true);
        if (this.onlyForSnapshot) {
            prefixTree.add("char", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("varchar", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("tinyint", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("smallint", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("integer", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("int", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("short", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("long", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("real", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("float", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("double", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("decimal", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("numeric", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("bigint", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("boolean", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("binary", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("varbinary", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("bit", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("string", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("category", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("date", SuggestionGroup.TYPE_COMPLEX);
            prefixTree.add("SqlDate", SuggestionGroup.TYPE_COMPLEX);
            prefixTree.add("SqlTime", SuggestionGroup.TYPE_COMPLEX);
            prefixTree.add("SqlTimestamp", SuggestionGroup.TYPE_COMPLEX);
        }
        if (this.allTypes || this.onlyForColumns) {
            prefixTree.add("char", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("varchar", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("interval", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("tinyint", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("smallint", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("integer", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("int", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("short", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("long", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("real", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("float", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("double", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("decimal", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("numeric", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("bigint", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("boolean", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("binary", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("varbinary", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("clob", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("blob", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("bit", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("string", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("flob", SuggestionGroup.TYPE_PRIMITIVE);
            prefixTree.add("event", SuggestionGroup.TYPE_COMPLEX);
            prefixTree.add("object", SuggestionGroup.TYPE_COMPLEX);
            prefixTree.add("date", SuggestionGroup.TYPE_COMPLEX);
            prefixTree.add("SqlDate", SuggestionGroup.TYPE_COMPLEX);
            prefixTree.add("SqlTime", SuggestionGroup.TYPE_COMPLEX);
            prefixTree.add("SqlTimestamp", SuggestionGroup.TYPE_COMPLEX);
        }
        if (this.allTypes || this.onlyForColumns) {
            for (String typeName : this.context.getSemanticTypeCache().listSemanticTypes()) {
                SemanticType semanticType = this.context.getSemanticTypeCache().lookupSemanticType(typeName);
                if (semanticType.isSystem() && (semanticType.getAncestorType() == null || !semanticType.getAncestorType().equals(SerializerUtils.SemanticTypeAncestor.complex.toString()))) continue;
                prefixTree.add(typeName, SuggestionGroup.TYPE_COMPLEX);
            }
            prefixTree.add("list", SuggestionGroup.TYPE_COLLECTION);
            prefixTree.add("map", SuggestionGroup.TYPE_COLLECTION);
            prefixTree.add("mapentry", SuggestionGroup.TYPE_COLLECTION);
            prefixTree.add("queue", SuggestionGroup.TYPE_COLLECTION);
            prefixTree.add("set", SuggestionGroup.TYPE_COLLECTION);
            prefixTree.add(Types.ROW.getName(), SuggestionGroup.TYPE_COMPLEX);
            prefixTree.add(Types.ROWSET.getName(), SuggestionGroup.TYPE_COMPLEX);
            prefixTree.add(Types.ROWARRAY.getName(), SuggestionGroup.TYPE_COMPLEX);
        }
        if (this.allTypes) {
            prefixTree.add(Types.DATASPACE.getName(), SuggestionGroup.TYPE_CONTEXT);
            prefixTree.add(Types.SERVICE.getName(), SuggestionGroup.TYPE_CONTEXT);
            prefixTree.add(Types.RUNTIME.getName(), SuggestionGroup.TYPE_CONTEXT);
        }
        PrefixTreeCompleter completer = new PrefixTreeCompleter(prefixTree);
        return completer.completeDsl(prefix);
    }
}

