/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.completion;

import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.trigger.event.FunctionUnit;
import com.streamscape.ds.trigger.event.FunctionUnitBasedOnType;
import com.streamscape.ds.trigger.event.FunctionUnitEntry;
import com.streamscape.ds.trigger.event.TriggerFunctionUnitManager;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitType;
import com.streamscape.sef.scheduler.Scheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataspaceFunctionUnitManagerForCompletion {
    private Map<String, FunctionUnit> units = new HashMap<String, FunctionUnit>();

    public DataspaceFunctionUnitManagerForCompletion() {
        this.registerUnit(new FunctionUnitBasedOnType(FunctionsUnitType.SCHEDULER, Scheduler.class));
        this.registerUnit(new FunctionUnitBasedOnType(FunctionsUnitType.SNAPTABLE, SnapshotTable.class));
    }

    public boolean hasFunctionUnit(String unitName) {
        return TriggerFunctionUnitManager.hasFunctionUnit(unitName) || this.hasFunctionUnit(unitName);
    }

    public FunctionUnit lookupFunctionUnit(String unitName) {
        FunctionUnit unit = TriggerFunctionUnitManager.lookupFunctionUnit(unitName);
        if (unit == null) {
            unit = this.units.get(unitName);
        }
        return unit;
    }

    public FunctionUnitEntry getUnitEntry(String unitName, String entryName) {
        FunctionUnit unit = this.lookupFunctionUnit(unitName);
        if (unit != null) {
            return unit.getEntry(entryName);
        }
        return null;
    }

    public List<String> listEntries() {
        ArrayList<String> result = new ArrayList<String>(TriggerFunctionUnitManager.listEntries());
        result.addAll(this.units.keySet());
        return result;
    }

    private void registerUnit(FunctionUnit unit) {
        this.units.put(unit.getType().getName(), unit);
    }
}

