/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.completion;

import com.streamscape.ds.parser.completion.DataspaceFunctionUnitManagerForCompletion;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DataspaceFunctionUnitCompleter
implements PrefixCompleter {
    private final List<String> toCompleteList;

    public DataspaceFunctionUnitCompleter(boolean withFunctions) {
        DataspaceFunctionUnitManagerForCompletion m = new DataspaceFunctionUnitManagerForCompletion();
        if (withFunctions) {
            this.toCompleteList = m.listEntries().stream().flatMap(unitName -> m.lookupFunctionUnit((String)unitName).listEntryNames().stream().map(functionName -> unitName + "." + functionName)).collect(Collectors.toList());
        } else {
            this.toCompleteList = new ArrayList<String>(m.listEntries());
            this.toCompleteList.add("metaset");
        }
    }

    @Override
    public DSLCompletion complete(String prefix) {
        ArrayList<String> units = new ArrayList<String>();
        for (String unitName : this.toCompleteList) {
            if (prefix != null && !unitName.startsWith(prefix)) continue;
            units.add(unitName);
        }
        DSLCompletion completion = DSLCompletion.buildPrefixAndCompletion(prefix, units);
        if (completion != null) {
            for (String unit : units) {
                completion.addSuggestion(new TokenSuggestion(unit, SuggestionGroup.FUNCTION_UNIT).setOffset(prefix));
            }
            completion.checkAndCompress();
            completion.moveSingleSuggestionToCompletion();
        }
        return completion;
    }
}

