/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser.completion;

import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.rights.Grantee;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.procedure.SQLFunctionsMetaData;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.TypedParameterSuggestion;
import java.util.ArrayList;

public class CollectionColumnCompleter
implements PrefixCompleter {
    private HashMappedList columns;

    public CollectionColumnCompleter(Collection collection, Grantee grantee) {
        this(collection.getBaseTable());
        OrderedHashSet allowedColumnSet = grantee.getSelectColumnSet(collection.getBaseTable());
        if (allowedColumnSet != null) {
            HashMappedList allowedColumnList = new HashMappedList();
            Iterator iter = this.columns.values().iterator();
            while (iter.hasNext()) {
                ColumnSchema column = (ColumnSchema)iter.next();
                if (!allowedColumnSet.contains(column.getObjectName())) continue;
                allowedColumnList.add(column.getNameString(), column);
            }
            this.columns = allowedColumnList;
        }
    }

    public CollectionColumnCompleter(Collection collection) {
        this(collection.getBaseTable());
    }

    public CollectionColumnCompleter(Table table) {
        this.columns = table.columnList;
    }

    public CollectionColumnCompleter(HashMappedList columns) {
        this.columns = columns;
    }

    @Override
    public DSLCompletion complete(String prefix) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i = 0; i < this.columns.size(); ++i) {
            String name = ((ColumnSchema)this.columns.get((int)i)).getObjectName().name;
            if (prefix != null && !name.startsWith(prefix)) continue;
            columnNames.add(name);
        }
        DSLCompletion completion = DSLCompletion.buildPrefixAndCompletion(prefix, columnNames);
        if (completion != null) {
            for (String columnName : columnNames) {
                ColumnSchema column = (ColumnSchema)this.columns.get(columnName);
                completion.addSuggestion(new TypedParameterSuggestion(columnName, SQLFunctionsMetaData.SQLFunctionMetaData.getTypeName(column.dataType), SuggestionGroup.COLUMN).setOffset(prefix));
            }
            completion.checkAndCompress();
            completion.moveSingleSuggestionToCompletion();
        }
        return completion;
    }
}

