/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser;

import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.types.Type;

public class Token {
    String tokenString = "";
    public int tokenType = -1;
    Type dataType;
    Object tokenValue;
    String charsetSchema;
    String charsetName;
    String fullString;
    int lobMultiplierType = -1;
    boolean isDelimiter;
    boolean isDelimitedIdentifier;
    boolean isUndelimitedIdentifier;
    boolean isReservedIdentifier;
    boolean isCoreReservedIdentifier;
    boolean isHostParameter;
    boolean isMalformed;
    int position;
    Object expression;

    void reset() {
        this.tokenString = "";
        this.tokenType = -1;
        this.dataType = null;
        this.tokenValue = null;
        this.charsetSchema = null;
        this.charsetName = null;
        this.fullString = null;
        this.expression = null;
        this.lobMultiplierType = -1;
        this.isDelimiter = false;
        this.isDelimitedIdentifier = false;
        this.isUndelimitedIdentifier = false;
        this.isReservedIdentifier = false;
        this.isCoreReservedIdentifier = false;
        this.isHostParameter = false;
        this.isMalformed = false;
    }

    Token duplicate() {
        Token token = new Token();
        token.tokenString = this.tokenString;
        token.tokenType = this.tokenType;
        token.dataType = this.dataType;
        token.tokenValue = this.tokenValue;
        token.charsetSchema = this.charsetSchema;
        token.charsetName = this.charsetName;
        token.fullString = this.fullString;
        token.lobMultiplierType = this.lobMultiplierType;
        token.isDelimiter = this.isDelimiter;
        token.isDelimitedIdentifier = this.isDelimitedIdentifier;
        token.isUndelimitedIdentifier = this.isUndelimitedIdentifier;
        token.isReservedIdentifier = this.isReservedIdentifier;
        token.isCoreReservedIdentifier = this.isCoreReservedIdentifier;
        token.isHostParameter = this.isHostParameter;
        token.isMalformed = this.isMalformed;
        return token;
    }

    public String getFullString() {
        return this.fullString;
    }

    public void setExpression(Object expression) {
        this.expression = expression;
    }

    String getSQL() {
        if (this.expression instanceof ExpressionColumn) {
            if (this.tokenType == 771) {
                StringBuffer sb = new StringBuffer();
                Expression expression = (Expression)this.expression;
                if (expression != null && expression.opType == 97 && expression.nodes.length > 0) {
                    sb.append(' ');
                    for (int i = 0; i < expression.nodes.length; ++i) {
                        Object name;
                        Expression e = expression.nodes[i];
                        ColumnSchema c = e.getColumn();
                        if (e.opType == 3) {
                            if (i > 0) {
                                sb.append(',');
                            }
                            sb.append(e.getColumnName());
                            continue;
                        }
                        if (e.getRangeVariable().getTableAlias() == null) {
                            name = c.getObjectName().getSchemaQualifiedStatementName();
                        } else {
                            RangeVariable range = e.getRangeVariable();
                            name = range.getTableAlias().getStatementName() + "." + c.getObjectName().statementName;
                        }
                        if (i > 0) {
                            sb.append(',');
                        }
                        sb.append((String)name);
                    }
                } else {
                    return this.tokenString;
                }
                sb.append(' ');
                return sb.toString();
            }
        } else {
            if (this.expression instanceof Type) {
                this.isDelimiter = false;
                Type type = (Type)this.expression;
                if (type.isDistinctType() || type.isDomainType()) {
                    return type.getObjectName().getSchemaQualifiedStatementName();
                }
                return type.getNameString();
            }
            if (this.expression instanceof SchemaObject) {
                this.isDelimiter = false;
                return ((SchemaObject)this.expression).getObjectName().getSchemaQualifiedStatementName();
            }
        }
        if (this.isUndelimitedIdentifier) {
            return this.tokenString;
        }
        if (this.tokenType == 845) {
            return this.dataType.convertToSQLString(this.tokenValue);
        }
        if (this.isDelimitedIdentifier) {
            StringBuffer sb = new StringBuffer();
            sb.append('\"');
            sb.append(this.tokenString);
            sb.append('\"');
            this.isDelimiter = false;
            return sb.toString();
        }
        return this.tokenString;
    }

    public static String getSQL(Token[] statement) {
        boolean wasDelimiter = true;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < statement.length; ++i) {
            String sql = statement[i].getSQL();
            if (!statement[i].isDelimiter && !wasDelimiter) {
                sb.append(' ');
            }
            wasDelimiter = statement[i].isDelimiter;
            if (sql.equals("*")) {
                sb.append(' ');
                wasDelimiter = false;
            }
            sb.append(sql);
        }
        return sb.toString();
    }

    static Object[] getSimplifiedTokens(Token[] tokens) {
        Object[] array = new Object[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            array[i] = tokens[i].expression == null ? tokens[i].getSQL() : tokens[i].expression;
        }
        return array;
    }

    public boolean isDelimiter() {
        return this.isDelimiter;
    }

    public boolean isDelimitedIdentifier() {
        return this.isDelimitedIdentifier;
    }

    public boolean isUndelimitedIdentifier() {
        return this.isUndelimitedIdentifier;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public static class TokenPrefix {
        String prefix;
        boolean isDelimited;

        TokenPrefix() {
        }

        TokenPrefix(String prefix, boolean isDelimited) {
            this.prefix = prefix;
            this.isDelimited = isDelimited;
        }
    }
}

