/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceCompleteException;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.parser.ParserCommand;
import com.streamscape.ds.parser.completion.MethodCompleter;
import com.streamscape.ds.parser.completion.RPLMethodCompleter;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.expression.ExpressionOp;
import com.streamscape.ds.parser.expression.ExpressionValue;
import com.streamscape.ds.parser.expression.ReferenceExpression;
import com.streamscape.ds.parser.expression.SnapshotCallExpression;
import com.streamscape.ds.schema.collection.tspace.table.SnapshotCollection;
import com.streamscape.ds.schema.table.SnapshotDataspaceTable;
import com.streamscape.ds.stable.aggregate.AggregateFunction;
import com.streamscape.ds.stable.aggregate.AggregateFunctionPair;
import com.streamscape.ds.stable.aggregate.AggregateFunctions;
import com.streamscape.ds.stable.aggregate.Summarizer;
import com.streamscape.ds.stable.columns.CategoryStringColumn;
import com.streamscape.ds.stable.columns.Column;
import com.streamscape.ds.stable.columns.DecimalColumn;
import com.streamscape.ds.stable.columns.StringColumn;
import com.streamscape.ds.stable.rplmethod.ColumnOperation;
import com.streamscape.ds.stable.rplmethod.IsMethod;
import com.streamscape.ds.stable.rplmethod.RPLMethodsCache;
import com.streamscape.ds.stable.rplmethod.SnapshotRPLMethodsCache;
import com.streamscape.ds.stable.table.Snapshot;
import com.streamscape.ds.stable.table.SnapshotJoiner;
import com.streamscape.ds.stable.table.SnapshotSlice;
import com.streamscape.ds.stable.table.SnapshotTable;
import com.streamscape.ds.stable.utils.ContinuousSelection;
import com.streamscape.ds.stable.utils.Order;
import com.streamscape.ds.stable.utils.Selection;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContextImpl;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.SyntaxSuggestion;
import com.streamscape.slex.lang.completion.TypedParameterSuggestion;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ParserSnapshotCollectionCall {
    private ParserCommand parser;
    Set<SnapshotCollection> dependedSnapshotCollections = new HashSet<SnapshotCollection>();

    public ParserSnapshotCollectionCall(ParserCommand parserCommand) {
        this.parser = parserCommand;
    }

    public Expression readMethod(SnapshotCollection collection, List<String> spath) {
        if (this.parser.isCompleteMode() && this.parser.isSpathForCompletion(spath)) {
            this.parser.addCompletion(new RPLMethodCompleter(new SnapshotRPLMethodsCache(), SnapshotTable.class).complete(this.parser.getPrefixFromSpath(spath)));
            throw new DataspaceCompleteException();
        }
        if (spath != null && spath.size() == 1 && this.parser.isNextCharacterOpenBracket()) {
            this.parser.read();
            return this.readMethod(collection, spath.get(0));
        }
        this.parser.read();
        return this.readMethod(collection, (String)null);
    }

    public Expression readMethod(ExpressionColumn snapshotTableColumnExpression, List<String> spath) {
        if (this.parser.isCompleteMode() && this.parser.isSpathForCompletion(spath)) {
            this.parser.addCompletion(new RPLMethodCompleter(new SnapshotRPLMethodsCache(), SnapshotTable.class).complete(this.parser.getPrefixFromSpath(spath)));
            throw new DataspaceCompleteException();
        }
        try {
            snapshotTableColumnExpression.metaResultObject = OtherTypeWrapper.unwrap(snapshotTableColumnExpression.getValue(this.parser.session));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (snapshotTableColumnExpression.metaResultObject == null) {
            snapshotTableColumnExpression.dataType = new OtherType(SnapshotTable.class.getSimpleName(), SnapshotTable.class);
        }
        if (spath != null && spath.size() == 1 && this.parser.isNextCharacterOpenBracket()) {
            this.parser.read();
            return this.readMethod((Expression)snapshotTableColumnExpression, spath.get(0));
        }
        this.parser.read();
        return snapshotTableColumnExpression;
    }

    private Expression readMethod(SnapshotCollection collection, String methodName) {
        ExpressionValue tableValue = this.wrapExpressionValue(((SnapshotDataspaceTable)collection.getBaseTable()).getSTable());
        Expression expression = null;
        expression = methodName != null ? this.readMethod(tableValue, methodName) : tableValue;
        return new SnapshotCallExpression(expression, tableValue, collection, this.dependedSnapshotCollections);
    }

    private Expression readMethod(Expression parentExpression, String methodName) {
        Expression expression;
        while (true) {
            Class parentClass = Object.class;
            Object parentObject = null;
            if (parentExpression instanceof ExpressionValue) {
                parentObject = ((ExpressionValue)parentExpression).valueData;
                if (parentObject != null) {
                    parentClass = parentObject.getClass();
                }
            } else if (parentExpression.metaResultObject != null) {
                parentObject = parentExpression.metaResultObject;
                if (parentObject != null) {
                    parentClass = parentObject.getClass();
                }
            } else if (parentExpression.dataType != null) {
                parentClass = parentExpression.dataType.getInternalClass(this.parser.session);
            }
            if (methodName == null) {
                this.completeMethods(parentClass);
                methodName = this.parser.token.tokenString;
                this.parser.read();
            }
            if (Snapshot.class.isAssignableFrom(parentClass)) {
                expression = this.readOnRelation((Snapshot)parentObject, parentExpression, methodName);
                if (expression == null) {
                    expression = this.readSimpleRPLMethodOn(parentClass, parentExpression, methodName, false, null);
                }
            } else {
                expression = this.readSimpleMethodOn(parentExpression, methodName, null);
            }
            parentExpression.metaResultObject = null;
            if (this.parser.token.tokenType != 1015) break;
            this.parser.read();
            methodName = null;
            parentExpression = expression;
        }
        return expression;
    }

    private void completeMethods(Class<?> parentClass) {
        if (this.parser.isCompleteMode()) {
            SnapshotRPLMethodsCache cache = new SnapshotRPLMethodsCache();
            if (cache.listMethods(parentClass).size() > 0) {
                this.parser.newPrefixDataspaceCompleter().completers(new RPLMethodCompleter(cache, parentClass)).withRead(false).spaceFirst(false).throwException(true).complete();
            } else {
                this.parser.newPrefixDataspaceCompleter().completers(new RPLMethodCompleter(cache, parentClass), new MethodCompleter(parentClass, new TriggerFunctionParserContextImpl(DataspaceManager.getContext()), false)).withRead(false).spaceFirst(false).throwException(true).complete();
            }
        }
    }

    private ExpressionOp readSimpleRPLMethodOn(Class<?> parentClass, Expression parentExpression, String methodName, boolean includeInheritedMethods, Supplier<Expression> argumentReader) {
        List<RPLMethodsCache.RPLMethodInfo> methods;
        List<RPLMethodsCache.RPLMethodInfo> list = methods = includeInheritedMethods ? new SnapshotRPLMethodsCache().lookupMethodWithInherited(parentClass, methodName) : new SnapshotRPLMethodsCache().lookupMethod(parentClass, methodName);
        if (parentClass != Object.class && methods.size() == 0) {
            throw new DataspaceException("Invalid method name '" + methodName + "'.");
        }
        ExpressionOp expression = this.readSimpleMethodOn(parentExpression, methodName, argumentReader);
        if (methods.size() > 0) {
            if ((methods = methods.stream().filter(method -> method.method().getParameterCount() == expression.getParameters().size() || method.method().isVarArgs()).collect(Collectors.toList())).size() == 0) {
                throw new DataspaceException("Method '" + methodName + "' arguments count mismatch.");
            }
            expression.dataType = Types.getParameterSQLType(this.parser.session, methods.get(0).method().getReturnType());
        }
        return expression;
    }

    private ExpressionOp readSimpleMethodOn(Expression parentExpression, String methodName, Supplier<Expression> argumentReader) {
        this.parser.readThis(786);
        ArrayList<Expression> arguments = new ArrayList<Expression>();
        while (this.parser.token.tokenType != 772) {
            arguments.add(argumentReader == null ? this.parser.XreadAllTypesCommonValueExpression(false) : argumentReader.get());
            if (this.parser.token.tokenType == 774) {
                this.parser.read();
                continue;
            }
            if (this.parser.token.tokenType == 772) break;
            throw this.parser.unexpectedToken();
        }
        this.parser.readThis(772);
        ExpressionOp expression = new ExpressionOp(parentExpression, arguments);
        expression.setMethodName(methodName);
        return expression;
    }

    private Expression readOnRelation(Snapshot parentObject, Expression parentExpression, String methodName) {
        Expression expression = null;
        switch (methodName) {
            case "summarize": {
                expression = this.readSummarize(parentObject, parentExpression);
                break;
            }
            case "where": {
                expression = this.readWhere(parentObject, parentExpression);
                break;
            }
            case "deleteWhere": {
                expression = this.readDeleteWhere(parentObject, parentExpression);
                break;
            }
            case "select": {
                expression = this.readSelect(parentObject, parentExpression);
                break;
            }
            case "sortOn": 
            case "orderBy": {
                expression = this.readOrderBy(parentObject, parentExpression);
                break;
            }
            case "insert": {
                expression = this.readInsert(parentObject, parentExpression);
                break;
            }
            case "join": 
            case "joinLeft": 
            case "joinRight": 
            case "joinFull": {
                expression = this.readJoin(parentObject, parentExpression, methodName);
                break;
            }
        }
        return expression;
    }

    private Expression readSummarize(Snapshot parentTable, Expression parentExpression) {
        ArrayList<AggregateFunctionPair> functionPairs = new ArrayList<AggregateFunctionPair>();
        ArrayList<String> byColumnNames = new ArrayList<String>();
        this.parser.readThisTokenOrComplete(786, true, true);
        while (true) {
            this.completeAggregateFunction();
            AggregateFunction function = this.createAggregateFunction(this.parser.token.tokenString);
            this.parser.read();
            this.parser.readThisTokenOrComplete(786, true, true);
            if (parentTable != null) {
                this.completeColumn(parentTable, c -> function.isCompatibleWith(c.type()), true);
                parentTable.column(this.parser.token.tokenString);
            }
            AggregateFunctionPair functionPair = function.on(this.parser.token.tokenString);
            this.parser.read();
            this.parser.readThisTokenOrComplete(772, true, true);
            this.parser.completeSimpleTree("as");
            if (this.parser.token.tokenType == 10) {
                this.parser.read();
                if (this.parser.token.tokenString == null || this.parser.token.tokenString.length() == 0) {
                    throw new DataspaceException("Column AS name should be not empty.");
                }
                functionPair = functionPair.as(this.parser.token.tokenString);
                this.parser.read();
            }
            functionPairs.add(functionPair);
            this.parser.completeSimpleTree(",", ")");
            if (this.parser.token.tokenType != 774) break;
            this.parser.read();
        }
        if (this.parser.token.tokenType != 772) {
            throw this.parser.unexpectedToken();
        }
        this.parser.readThisTokenOrComplete(772, true, true);
        ExpressionOp expression = new ExpressionOp(parentExpression, functionPairs.stream().map(p -> this.wrapExpressionValue(p)).collect(Collectors.toList()));
        expression.setMethodName("summarize");
        expression.dataType = new OtherType(Summarizer.class.getName(), Summarizer.class);
        this.parser.completeSimpleTree(".by(", ".where(");
        this.parser.readThisTokenOrComplete(1015, true, true);
        if (this.parser.isCompleteMode()) {
            this.parser.newPrefixDataspaceCompleter().completers(new RPLMethodCompleter(new SnapshotRPLMethodsCache(), Summarizer.class)).withRead(false).spaceFirst(false).throwException(true).complete();
        }
        if (this.parser.token.tokenType == 316) {
            this.parser.readThisTokenOrComplete(316, true, true);
            ExpressionOp whereExpression = this.readWhere(parentTable, parentExpression);
            expression.dataType = new OtherType(SnapshotTable.class.getName(), SnapshotSlice.class);
            this.parser.completeSimpleTree(".by(");
            this.parser.readThis(1015);
            expression.nodes[0] = whereExpression;
        }
        this.parser.readThisTokenOrComplete(24, true, true);
        this.parser.readThisTokenOrComplete(786, true, true);
        while (this.parser.token.tokenType != 772) {
            if (parentTable != null) {
                this.completeColumn(parentTable, c -> true, true);
                parentTable.column(this.parser.token.tokenString);
            }
            byColumnNames.add(this.parser.token.tokenString);
            this.parser.read();
            this.parser.completeSimpleTree(",", ")");
            if (this.parser.token.tokenType == 774) {
                this.parser.read();
                continue;
            }
            if (this.parser.token.tokenType == 772) break;
            throw this.parser.unexpectedToken();
        }
        this.parser.readThisTokenOrComplete(772, true, true);
        expression = new ExpressionOp((Expression)expression, byColumnNames.stream().map(p -> this.wrapExpressionValue(p)).collect(Collectors.toList()));
        expression.setMethodName("by");
        expression.dataType = new OtherType(SnapshotTable.class.getName(), SnapshotTable.class);
        if (parentTable != null) {
            expression.metaResultObject = null;
            try {
                Column column;
                SnapshotTable resultMetaTable = SnapshotTable.create("resultMetaTable");
                for (AggregateFunctionPair functionPair : functionPairs) {
                    column = parentTable.column(functionPair.getColumnName());
                    column = column.emptyCopy();
                    column.setName(functionPair.asName());
                    resultMetaTable.addColumn(column);
                }
                for (String byColumn : byColumnNames) {
                    column = parentTable.column(byColumn);
                    column = column.emptyCopy();
                    resultMetaTable.addColumn(column);
                }
                expression.metaResultObject = resultMetaTable;
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
            }
        }
        return expression;
    }

    private Expression readSelect(Snapshot parentTable, Expression parentExpression) {
        Type type;
        ArrayList<Expression> columnExpressions = new ArrayList<Expression>();
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<String> columnAliases = new ArrayList<String>();
        this.parser.readThisTokenOrComplete(786, true, true);
        while (true) {
            int[] methodsCount = new int[]{0};
            ExpressionOp expression = this.readColumnOperationExpression(parentTable, parentExpression, columnNames, methodsCount);
            this.parser.completeSimpleTree("as");
            String alias = null;
            if (this.parser.token.tokenType == 10) {
                this.parser.read();
                alias = this.parser.token.tokenString;
                if (alias == null || alias.length() == 0) {
                    throw new DataspaceException("Column alias name should be not empty.");
                }
                if (methodsCount[0] > 0) {
                    type = expression.dataType;
                    expression = new ExpressionOp((Expression)expression, Arrays.asList(this.wrapExpressionValue(alias)));
                    expression.setMethodName("setName");
                    expression.dataType = type;
                } else {
                    type = expression.dataType;
                    expression = new ExpressionOp((Expression)expression, Arrays.asList(this.wrapExpressionValue(alias)));
                    expression.setMethodName("withName");
                    expression.dataType = type;
                }
                this.parser.read();
            }
            columnAliases.add(alias);
            columnExpressions.add(expression);
            this.parser.completeSimpleTree(",", ")");
            if (this.parser.token.tokenType != 774) break;
            this.parser.read();
        }
        if (this.parser.token.tokenType != 772) {
            throw this.parser.unexpectedToken();
        }
        this.parser.readThisTokenOrComplete(772, true, true);
        ExpressionOp expression = new ExpressionOp(parentExpression, columnExpressions);
        expression.setMethodName("select");
        expression.dataType = new OtherType(SnapshotTable.class.getName(), SnapshotTable.class);
        expression.metaResultObject = null;
        try {
            SnapshotTable resultMetaTable = SnapshotTable.create("resultMetaTable");
            for (int i = 0; i < columnExpressions.size(); ++i) {
                type = ((Expression)columnExpressions.get((int)i)).dataType;
                String name = (String)columnAliases.get(i);
                if (name == null) {
                    name = (String)columnNames.get(i);
                }
                Column column = this.createColumnByType(type, name);
                resultMetaTable.addColumn(column);
            }
            expression.metaResultObject = resultMetaTable;
        }
        catch (Exception exception) {
            // empty catch block
        }
        columnExpressions.forEach(e -> {
            e.dataType = new OtherType(Column.class.getSimpleName(), Column.class);
        });
        return expression;
    }

    private Column createColumnByType(Type type, String name) throws InvocationTargetException, IllegalAccessException {
        Class<Object> columnClass = type.getInternalClass(this.parser.session);
        if (columnClass == CategoryStringColumn.class) {
            columnClass = StringColumn.class;
        }
        if (!Column.class.isAssignableFrom(columnClass)) {
            throw new DataspaceException("Column type is unknown.");
        }
        if (DecimalColumn.class.isAssignableFrom(columnClass)) {
            Method createMethod = ClassUtils.getStaticMethod(columnClass, "create", new Class[]{String.class, Integer.TYPE});
            createMethod.setAccessible(true);
            return (Column)createMethod.invoke(null, name, 2);
        }
        Method createMethod = ClassUtils.getStaticMethod(columnClass, "create", new Class[]{String.class});
        createMethod.setAccessible(true);
        return (Column)createMethod.invoke(null, name);
    }

    private ExpressionOp readColumnOperationExpression(Snapshot parentTable, Expression parentExpression, List<String> columnNames, int[] methodsCount) {
        String columnName;
        Column column = null;
        if (parentTable != null) {
            this.completeColumn(parentTable, c -> true, true);
            column = parentTable.column(this.parser.token.tokenString);
        }
        if ((columnName = this.parser.token.tokenString) == null || columnName.length() == 0) {
            throw new DataspaceException("Empty column name is specified");
        }
        ExpressionOp expression = this.buildColumnMethodExpression(parentExpression, column, columnName);
        if (columnNames != null) {
            columnNames.add(columnName);
        }
        this.parser.read();
        this.parser.completeSimpleTree(".", "as");
        methodsCount[0] = 0;
        while (this.parser.token.tokenType == 1015) {
            this.parser.readThisTokenOrComplete(1015, true, true);
            Supplier<Expression> argumentReader = () -> {
                try {
                    if (parentTable != null) {
                        this.completeColumn(parentTable, c -> true, false);
                        String columnArgumentName = this.parser.token.tokenString;
                        if (columnArgumentName != null && columnArgumentName.length() > 0) {
                            Column columnArgument = parentTable.column(this.parser.token.tokenString);
                            return this.readColumnOperationExpression(parentTable, parentExpression, null, new int[]{0});
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return this.parser.XreadAllTypesCommonValueExpression(false);
            };
            expression = this.readMethodOnColumn(column, expression, ColumnOperation.class, argumentReader);
            if (column != null) {
                try {
                    column = this.createColumnByType(expression.dataType, column.name());
                }
                catch (Exception exception) {
                    column = null;
                }
            }
            methodsCount[0] = methodsCount[0] + 1;
        }
        return expression;
    }

    private Expression readOrderBy(Snapshot parentTable, Expression parentExpression) {
        List<Pair<String, Order>> columns = this.readColumnNamesWithOrder(parentTable);
        String[] columnNames = columns.stream().map(p -> (String)p.first).collect(Collectors.toList()).toArray(new String[0]);
        Order[] columnOrder = columns.stream().map(p -> (Order)((Object)((Object)p.second))).collect(Collectors.toList()).toArray(new Order[0]);
        ExpressionOp expression = new ExpressionOp(parentExpression, Arrays.asList(this.wrapExpressionValue(columnNames), this.wrapExpressionValue(columnOrder)));
        expression.setMethodName("orderBy");
        expression.dataType = new OtherType(SnapshotTable.class.getName(), SnapshotTable.class);
        if (parentTable != null) {
            expression.metaResultObject = parentTable.emptyCopy();
        }
        return expression;
    }

    private Expression readJoin(Snapshot parentTable, Expression parentExpression, String methodName) {
        ArrayList<Snapshot> tableModels = new ArrayList<Snapshot>();
        ArrayList<Expression> tableExpressions = new ArrayList<Expression>();
        this.parser.readThis(786);
        while (true) {
            Expression tableExpression = this.parser.XreadAllTypesCommonValueExpression(false);
            if (tableExpression.metaResultObject instanceof Snapshot) {
                tableModels.add((Snapshot)tableExpression.metaResultObject);
            }
            tableExpressions.add(tableExpression);
            if (tableExpression instanceof SnapshotCallExpression) {
                this.dependedSnapshotCollections.add(((SnapshotCallExpression)tableExpression).getSnapshotCollection());
                this.dependedSnapshotCollections.addAll(((SnapshotCallExpression)tableExpression).getDependedSnapshotCollection());
            }
            if (this.parser.token.tokenType == 772) break;
            this.parser.completeSimpleTree(",", ")");
            this.parser.readThis(774);
        }
        this.parser.readThis(772);
        ExpressionOp joinExpression = new ExpressionOp(parentExpression, tableExpressions);
        joinExpression.setMethodName(methodName);
        joinExpression.dataType = new OtherType(SnapshotJoiner.class.getName(), SnapshotJoiner.class);
        this.parser.completeSimpleTree(".on(");
        this.parser.readThisTokenOrComplete(1015, true, true);
        this.parser.readThisTokenOrComplete(194, true, true);
        List<String> columnNames = this.readColumnNames(parentTable);
        ExpressionOp expression = new ExpressionOp((Expression)joinExpression, columnNames.stream().map(n -> this.wrapExpressionValue(n)).collect(Collectors.toList()));
        expression.setMethodName("on");
        expression.dataType = new OtherType(SnapshotTable.class.getName(), SnapshotTable.class);
        if (parentTable != null) {
            expression.metaResultObject = SnapshotJoiner.createResultTable(parentTable, tableModels, false, columnNames);
        }
        return expression;
    }

    private Expression readInsert(Snapshot parentTable, Expression parentExpression) {
        ArrayList tableModels = new ArrayList();
        this.parser.readThis(786);
        Expression tableExpression = this.parser.XreadAllTypesCommonValueExpression(false);
        if (tableExpression instanceof SnapshotCallExpression) {
            this.dependedSnapshotCollections.add(((SnapshotCallExpression)tableExpression).getSnapshotCollection());
            this.dependedSnapshotCollections.addAll(((SnapshotCallExpression)tableExpression).getDependedSnapshotCollection());
        }
        this.parser.readThis(772);
        ExpressionOp insertExpression = new ExpressionOp(parentExpression, Arrays.asList(tableExpression));
        insertExpression.setMethodName("insert");
        insertExpression.dataType = Type.SQL_NUMERIC;
        return insertExpression;
    }

    private List<String> readColumnNames(Snapshot parentTable) {
        ArrayList<String> columnNames = new ArrayList<String>();
        this.parser.readThisTokenOrComplete(786, true, true);
        while (true) {
            columnNames.add(this.readColumnName(parentTable));
            this.parser.completeSimpleTree(",", ")");
            if (this.parser.token.tokenType != 774) break;
            this.parser.read();
        }
        if (this.parser.token.tokenType != 772) {
            throw this.parser.unexpectedToken();
        }
        this.parser.readThisTokenOrComplete(772, true, true);
        return columnNames;
    }

    private List<Pair<String, Order>> readColumnNamesWithOrder(Snapshot parentTable) {
        ArrayList<Pair<String, Order>> columns = new ArrayList<Pair<String, Order>>();
        this.parser.readThisTokenOrComplete(786, true, true);
        while (true) {
            String columnName = this.readColumnName(parentTable);
            Order order = Order.ASC;
            this.parser.completeSimpleTree("asc", "desc", ",", ")");
            if (this.parser.token.tokenType == 338) {
                order = Order.ASC;
                this.parser.read();
            } else if (this.parser.token.tokenType == 389) {
                order = Order.DESC;
                this.parser.read();
            }
            columns.add(new Pair<String, Order>(columnName, order));
            this.parser.completeSimpleTree(",", ")");
            if (this.parser.token.tokenType != 774) break;
            this.parser.read();
        }
        if (this.parser.token.tokenType != 772) {
            throw this.parser.unexpectedToken();
        }
        this.parser.readThisTokenOrComplete(772, true, true);
        return columns;
    }

    private String readColumnName(Snapshot parentTable) {
        String columnName;
        if (parentTable != null) {
            this.completeColumn(parentTable, c -> true, true);
            parentTable.column(this.parser.token.tokenString);
        }
        if ((columnName = this.parser.token.tokenString) == null || columnName.length() == 0) {
            throw new DataspaceException("Empty column name is specified");
        }
        this.parser.read();
        return columnName;
    }

    private ExpressionOp buildColumnMethodExpression(Expression parentExpression, Column column, String columnName) {
        Expression parentExpressionForColumn = parentExpression;
        if (parentExpressionForColumn instanceof ExpressionOp) {
            parentExpressionForColumn = new ReferenceExpression((ExpressionOp)parentExpressionForColumn);
        }
        ExpressionOp expression = new ExpressionOp(parentExpressionForColumn, Arrays.asList(this.wrapExpressionValue(columnName)));
        expression.setMethodName("column");
        expression.dataType = column != null ? new OtherType(column.getClass().getSimpleName(), column.getClass()) : new OtherType(Column.class.getSimpleName(), Column.class.getClass());
        return expression;
    }

    private void completeColumn(final Snapshot table, final Function<Column, Boolean> filter, boolean throwException) {
        if (this.parser.isCompleteMode()) {
            this.parser.newPrefixDataspaceCompleter().completers(new PrefixCompleter(){

                @Override
                public DSLCompletion complete(String prefix) {
                    List columns = table.columns().stream().filter(f -> NameManager.quoteNameIfNeeded(f.name()).startsWith(prefix) && (Boolean)filter.apply(f) != false).collect(Collectors.toList());
                    DSLCompletion completion = DSLCompletion.buildPrefixAndCompletion(prefix, columns.stream().map(f -> NameManager.quoteNameIfNeeded(f.name())).collect(Collectors.toList()));
                    if (completion != null) {
                        for (Column column : columns) {
                            completion.addSuggestion(new TypedParameterSuggestion(NameManager.quoteNameIfNeeded(column.name()), column.type().name(), SuggestionGroup.COLUMN).setOffset(prefix));
                        }
                        completion.checkAndCompress();
                        completion.moveSingleSuggestionToCompletion();
                    }
                    return completion;
                }
            }).withRead(false).spaceFirst(false).throwException(throwException).complete();
        }
    }

    private void completeAggregateFunction() {
        if (this.parser.isCompleteMode()) {
            this.parser.newPrefixDataspaceCompleter().completers(new PrefixCompleter(this){

                @Override
                public DSLCompletion complete(String prefix) {
                    List<AggregateFunctions.AggregateFunctionInfo> functions = AggregateFunctions.listAggregateFunctions();
                    DSLCompletion completion = DSLCompletion.buildPrefixAndCompletion(prefix, (functions = functions.stream().filter(f -> f.name().startsWith(prefix)).collect(Collectors.toList())).stream().map(f -> f.name()).collect(Collectors.toList()));
                    if (completion != null) {
                        for (AggregateFunctions.AggregateFunctionInfo function : functions) {
                            completion.addSuggestion(new SyntaxSuggestion(function.name(), "(" + function.syntax() + ")", SuggestionGroup.METHOD).setOffset(prefix));
                        }
                        completion.checkAndCompress();
                        completion.moveSingleSuggestionToCompletion();
                    }
                    return completion;
                }
            }).withRead(false).spaceFirst(false).throwException(true).complete();
        }
    }

    private ExpressionOp readWhere(Snapshot parentTable, Expression parentExpression) {
        this.parser.readThisTokenOrComplete(786, true, true);
        ExpressionOp expression = this.readColumnsCondition(parentTable, parentExpression);
        this.parser.readThisTokenOrComplete(772, true, true);
        ExpressionOp select = new ExpressionOp(parentExpression, Arrays.asList(expression));
        select.setMethodName("where");
        select.dataType = new OtherType(SnapshotSlice.class.getName(), SnapshotSlice.class);
        if (parentTable != null) {
            select.metaResultObject = new SnapshotSlice(parentTable.emptyCopy(), new ContinuousSelection(0));
        }
        return select;
    }

    private ExpressionOp readDeleteWhere(Snapshot parentTable, Expression parentExpression) {
        this.parser.readThisTokenOrComplete(786, true, true);
        ExpressionOp expression = this.readColumnsCondition(parentTable, parentExpression);
        this.parser.readThisTokenOrComplete(772, true, true);
        ExpressionOp select = new ExpressionOp(parentExpression, Arrays.asList(expression));
        select.setMethodName("deleteWhere");
        select.dataType = Type.SQL_INTEGER;
        return select;
    }

    private ExpressionOp readColumnsCondition(Snapshot parentTable, Expression parentExpression) {
        ExpressionOp resultExpression = null;
        int lastOperation = -1;
        while (true) {
            ExpressionOp expression;
            boolean not = false;
            if (this.parser.token.tokenType == 183) {
                not = true;
                this.parser.read();
            }
            if (this.parser.token.tokenType == 786) {
                this.parser.read();
                expression = this.readColumnsCondition(parentTable, parentExpression);
                this.parser.readThisTokenOrComplete(772, true, true);
            } else {
                String columnName = this.parser.token.tokenString;
                Column column = null;
                if (parentTable != null) {
                    this.completeColumn(parentTable, c -> true, true);
                    column = parentTable.column(columnName);
                }
                if (columnName == null || columnName.length() == 0) {
                    throw new DataspaceException("Empty column name is specified.");
                }
                this.parser.read();
                this.parser.readThisTokenOrComplete(1015, true, true);
                expression = this.buildColumnMethodExpression(parentExpression, column, columnName);
                expression = this.readMethodOnColumn(column, expression, IsMethod.class, null);
            }
            String operationMethodName = null;
            if (not && lastOperation == 5) {
                operationMethodName = "andNot";
                lastOperation = -1;
            } else if (not) {
                throw new DataspaceException("Unary NOT and binary OR NOT operations are not yet supported.");
            }
            if (lastOperation == 5) {
                operationMethodName = "and";
            } else if (lastOperation == 197) {
                operationMethodName = "or";
            }
            if (operationMethodName != null) {
                resultExpression = new ExpressionOp((Expression)resultExpression, Arrays.asList(expression));
                resultExpression.setMethodName(operationMethodName);
            } else {
                resultExpression = expression;
            }
            resultExpression.dataType = new OtherType(Selection.class.getName(), Selection.class);
            this.parser.completeSimpleTree("and", "or", "and not", ")");
            if (this.parser.token.tokenType != 5 && this.parser.token.tokenType != 197) break;
            lastOperation = this.parser.token.tokenType;
            this.parser.read();
        }
        if (this.parser.token.tokenType != 772) {
            throw this.parser.unexpectedToken();
        }
        return resultExpression;
    }

    private ExpressionOp readMethodOnColumn(Column column, ExpressionOp parentExpression, Class<? extends Annotation> annotationClazz, Supplier<Expression> argumentReader) {
        boolean includeInherited;
        Class columnClass = column != null ? column.getClass() : Column.class;
        boolean bl = includeInherited = column == null;
        if (this.parser.isCompleteMode()) {
            this.parser.newPrefixDataspaceCompleter().completers(new RPLMethodCompleter(new SnapshotRPLMethodsCache(), columnClass).includeInherited(includeInherited).filter(m -> ClassUtils.getAnnotationOnMethod(m.method(), annotationClazz) != null)).withRead(false).spaceFirst(false).throwException(true).complete();
        }
        String methodName = this.parser.token.tokenString;
        this.parser.read();
        return this.readSimpleRPLMethodOn(columnClass, parentExpression, methodName, includeInherited, argumentReader);
    }

    ExpressionValue wrapExpressionValue(Object value) {
        return this.wrapExpressionValue(value, value != null ? value.getClass() : Object.class);
    }

    ExpressionValue wrapExpressionValue(Object value, Class<?> type) {
        Type dataType = Types.getParameterSQLType(this.parser.session, type);
        if (dataType == null) {
            dataType = new OtherType(type.getSimpleName(), type);
        }
        return new ExpressionValue(value, dataType);
    }

    private AggregateFunction createAggregateFunction(String name) {
        for (Field field : AggregateFunctions.class.getDeclaredFields()) {
            if (!field.getName().equals(name) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !AggregateFunction.class.isAssignableFrom(field.getType())) continue;
            try {
                field.setAccessible(true);
                return (AggregateFunction)field.get(null);
            }
            catch (IllegalAccessException exception) {
                throw new DataspaceException(exception);
            }
        }
        throw new DataspaceException("Aggregate function '" + name + "' not found.");
    }

    public static interface Methods {
        public static final String INSERT = "insert";
        public static final String SUMMARIZE = "summarize";
        public static final String WHERE = "where";
        public static final String DELETE_WHERE = "deleteWhere";
        public static final String SELECT = "select";
        public static final String SORT_ON = "sortOn";
        public static final String ORDER_BY = "orderBy";
        public static final String JOIN = "join";
        public static final String JOIN_LEFT = "joinLeft";
        public static final String JOIN_RIGHT = "joinRight";
        public static final String JOIN_FULL = "joinFull";
    }
}

