/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.ds.DataspaceCompleteException;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.core.CollectionWindowType;
import com.streamscape.ds.core.MemoryModel;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.lib.LongDeque;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.OrderedIntHashSet;
import com.streamscape.ds.parser.ParserBase;
import com.streamscape.ds.parser.ParserDML;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.RoutineCommandsCompleter;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.parser.completion.CollectionFilter;
import com.streamscape.ds.parser.completion.FunctionSQLCompleter;
import com.streamscape.ds.parser.completion.SchemaObjectCompleter;
import com.streamscape.ds.parser.completion.SchemaObjectFilter;
import com.streamscape.ds.parser.expression.ExecBlockExpression;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.expression.ExpressionLogical;
import com.streamscape.ds.parser.expression.ExpressionValue;
import com.streamscape.ds.parser.expression.QueryExpression;
import com.streamscape.ds.parser.expression.QuerySpecification;
import com.streamscape.ds.parser.expression.SubQuery;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.parser.statement.StatementCommand;
import com.streamscape.ds.parser.statement.StatementCompound;
import com.streamscape.ds.parser.statement.StatementDMQL;
import com.streamscape.ds.parser.statement.StatementExpression;
import com.streamscape.ds.parser.statement.StatementHandler;
import com.streamscape.ds.parser.statement.StatementQuery;
import com.streamscape.ds.parser.statement.StatementRplExec;
import com.streamscape.ds.parser.statement.StatementSchema;
import com.streamscape.ds.parser.statement.StatementSession;
import com.streamscape.ds.parser.statement.StatementSet;
import com.streamscape.ds.parser.statement.StatementSimple;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.replication.AbstractReplicationEntity;
import com.streamscape.ds.replication.ReplicationData;
import com.streamscape.ds.replication.ReplicationEntityName;
import com.streamscape.ds.replication.ReplicationSource;
import com.streamscape.ds.replication.ReplicationSourceInfo;
import com.streamscape.ds.replication.ReplicationTarget;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.cspace.definitions.KGraphInstanceSchemaObject;
import com.streamscape.ds.schema.collection.cspace.definitions.KGraphTypeSchemaObject;
import com.streamscape.ds.schema.collection.cspace.definitions.KLinkTypeSchemaObject;
import com.streamscape.ds.schema.collection.cspace.definitions.KNodeTypeSchemaObject;
import com.streamscape.ds.schema.collection.fspace.table.FileTableCollection;
import com.streamscape.ds.schema.collection.fspace.table.JournalFileTableCollection;
import com.streamscape.ds.schema.collection.qspace.equeue.EventQueueCollection;
import com.streamscape.ds.schema.collection.qspace.queue.BlockingQueueCollection;
import com.streamscape.ds.schema.collection.tspace.etable.EventTableCollection;
import com.streamscape.ds.schema.collection.tspace.map.MapCollection;
import com.streamscape.ds.schema.collection.tspace.table.TableCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.event.Actor;
import com.streamscape.ds.schema.procedure.FunctionCustom;
import com.streamscape.ds.schema.procedure.FunctionSQL;
import com.streamscape.ds.schema.procedure.FunctionSQLInvoked;
import com.streamscape.ds.schema.procedure.FunctionUnitCall;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.View;
import com.streamscape.ds.schema.timer.TimerObject;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.state.DataspaceStateHolder;
import com.streamscape.ds.trigger.AbstractReplicationEventTrigger;
import com.streamscape.ds.trigger.EventTriggerDefSQL;
import com.streamscape.ds.trigger.ReplicationEventTrigger;
import com.streamscape.ds.trigger.ReplicationModifyTrigger;
import com.streamscape.ds.trigger.ReplicationValidateTrigger;
import com.streamscape.ds.trigger.SystemEventTrigger;
import com.streamscape.ds.trigger.SystemEventTriggerType;
import com.streamscape.ds.trigger.TriggerDef;
import com.streamscape.ds.trigger.WindowTriggerDefSQL;
import com.streamscape.ds.trigger.event.SysFunctionUnit;
import com.streamscape.ds.types.ArrayType;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.CharacterType;
import com.streamscape.ds.types.DataspaceType;
import com.streamscape.ds.types.DropboxType;
import com.streamscape.ds.types.EventType;
import com.streamscape.ds.types.FlobType;
import com.streamscape.ds.types.NumberType;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.RuntimeType;
import com.streamscape.ds.types.ServerType;
import com.streamscape.ds.types.ServiceType;
import com.streamscape.ds.types.Type;
import com.streamscape.ds.types.Types;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.lib.concurrent.ThreadPoolType;
import com.streamscape.lib.timer.FabricTimer;
import com.streamscape.lib.timer.FabricTimerManager;
import com.streamscape.lib.timer.FabricTimerState;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.Utils;
import com.streamscape.omf.mapper.SemanticMapRepositoryUtils;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.sdo.enums.AcknowledgeAction;
import com.streamscape.sdo.excp.LanguageException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ParserRPL
extends ParserDML {
    private static RoutineCommandsCompleter routineCommandsCompleter = new RoutineCommandsCompleter();

    public ParserRPL(Session session, Scanner scanner) {
        super(session, scanner);
    }

    @Override
    public void reset(String sql) {
        super.reset(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RplScript compileTriggerRoutine(NameManager.ObjectName triggerName, Table table, RangeVariable[] ranges, boolean forEventTrigger) {
        NameManager.ObjectName routineName = this.store.nameManager.newObjectName(triggerName.name, false, 17);
        routineName.schema = table.getObjectName().schema;
        RplScript routine = new RplScript(this.store, routineName, table, ranges);
        int currentPosition = this.scanner.getPosition();
        this.compileContext.triggerOrActor = true;
        try {
            Statement statement = this.compileSQLProcedureStatementOrNull(routine, null);
            if (statement == null) {
                throw this.unsupportedRequest();
            }
            int end = this.scanner.getPosition();
            String sql = this.scanner.sqlString.substring(currentPosition, end);
            statement.setSQL(sql);
            routine.setProcedure(statement);
            routine.resolve(this.session);
        }
        finally {
            this.compileContext.triggerOrActor = false;
        }
        return routine;
    }

    public final RplScript compileRplRoutine(NameManager.ObjectName handlerName, RangeVariable[] ranges) {
        RplScript routine = new RplScript(this.store, handlerName, ranges);
        int currentPosition = this.scanner.getPosition();
        Statement statement = this.compileSQLProcedureStatementOrNull(routine, null);
        if (statement == null) {
            throw this.unexpectedToken();
        }
        int end = this.scanner.getPosition();
        String sql = this.scanner.sqlString.substring(currentPosition, end);
        statement.setSQL(sql);
        routine.setProcedure(statement);
        routine.resolve(this.session);
        return routine;
    }

    final void checkSchemaUpdateAuthorisation(NameManager.ObjectName schema) {
        if (this.session.isProcessingRecoveryLog) {
            return;
        }
        SqlInvariants.checkSchemaNameNotSystem(schema.name);
        if (this.isSchemaDefinition) {
            if (schema != this.session.getCurrentDataspaceName()) {
                throw Error.error(5505);
            }
        } else {
            this.session.getGrantee().checkSchemaUpdateOrGrantRights(schema.name);
        }
        this.session.checkDDLWrite();
    }

    final void checkSchemaUpdateAuthorisation(Session session, NameManager.ObjectName schema) {
        if (session.isProcessingRecoveryLog) {
            return;
        }
        if (SqlInvariants.isSystemSchemaName(schema.name)) {
            throw Error.error(5503);
        }
        if (session.parser.isSchemaDefinition) {
            if (schema == session.getCurrentDataspaceName()) {
                return;
            }
            Error.error(5505, schema.name);
        }
        session.getGrantee().checkSchemaUpdateOrGrantRights(schema.name);
        session.checkDDLWrite();
    }

    final StatementSchema compileCreateAlterActor(boolean async, boolean alter) {
        return this.compileCreateAlterActor(async, alter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    final StatementSchema compileCreateAlterActor(boolean async, boolean alter, boolean invokeModeChanged) {
        Actor actor = null;
        NameManager.ObjectName actorName = null;
        boolean eventSetSignatureChanged = false;
        boolean ifNotExists = false;
        if (alter) {
            this.readNameTokenForCompleteMode();
            this.completeSchemaObject(null, 32);
            actor = (Actor)this.readSchemaObjectName(32);
            actorName = actor.getObjectName();
        } else {
            this.read();
            ifNotExists = this.readIfNotExists(false);
            actorName = this.readNewSchemaObjectName(32, false);
            actorName.setSchemaIfNull(this.session.getCurrentDataspaceName());
            ifNotExists = this.readIfNotExists(true) || ifNotExists;
        }
        this.checkThatRuntimeOperationIsNotInSDS(actorName, (alter ? "alter" : "create") + " actor");
        Actor.EventSetType eventSetType = null;
        List<Object> eventHandlerEntries = new ArrayList();
        Actor.WindowType windowType = null;
        long windowSize = 0L;
        TimeUnit timeWindowUnit = TimeUnit.MILLISECONDS;
        EventScope eventScope = null;
        RplScript routine = null;
        if (this.token.tokenType == 194) {
            this.readThis(194);
            while (true) {
                String eventId = this.token.tokenString;
                this.read();
                String selector = null;
                NameManager.ObjectName alias = null;
                boolean end = false;
                block18: while (!end) {
                    switch (this.token.tokenType) {
                        case 314: {
                            if (selector != null) {
                                end = true;
                                continue block18;
                            }
                            selector = this.readWhenClause();
                            continue block18;
                        }
                        case 10: {
                            if (alias != null) {
                                end = true;
                                continue block18;
                            }
                            this.read();
                            alias = this.readNewSchemaObjectName(23, false);
                            continue block18;
                        }
                    }
                    end = true;
                }
                if (alias == null) {
                    throw this.unexpectedToken("Event [" + eventId + "] alias is not specified.");
                }
                Actor.ActorEntry entry = new Actor.ActorEntry(eventId, selector, alias);
                eventHandlerEntries.add(entry);
                if (this.token.tokenType != 774) break;
                this.read();
            }
            eventSetSignatureChanged = true;
        } else if (alter) {
            eventHandlerEntries = actor.getActorEntries();
        }
        if (this.token.tokenType == 112) {
            this.readThis(112);
            if (this.token.tokenType == 6) {
                this.read();
                this.readThis(586);
            } else {
                eventSetType = Actor.EventSetType.COMPLETE;
                if (this.token.tokenType != 586) {
                    try {
                        eventSetType = Actor.EventSetType.valueOf(this.token.tokenString.toUpperCase());
                    }
                    catch (IllegalArgumentException error) {
                        throw this.unexpectedToken("Invalid event set type '" + this.token.tokenString + "' specified.");
                    }
                    this.read();
                }
                this.readThis(586);
                this.readThis(254);
                switch (this.token.tokenType) {
                    case 281: {
                        windowType = Actor.WindowType.TIME;
                        this.read();
                        this.readThis(318);
                        windowSize = this.readLong();
                        if (windowSize <= 0L) {
                            throw this.unexpectedToken("Invalid time window size specified.");
                        }
                        timeWindowUnit = this.readTimeUnit(TimeUnit.MILLISECONDS);
                        break;
                    }
                    case 1032: {
                        windowType = Actor.WindowType.BATCH;
                        this.read();
                        this.readThis(318);
                        windowSize = this.readLong();
                        if (windowSize > 0L) break;
                        throw this.unexpectedToken("Invalid time window size specified.");
                    }
                }
            }
            eventSetSignatureChanged = true;
        }
        if (!alter && eventHandlerEntries.size() == 0) {
            throw this.unexpectedToken();
        }
        if (this.token.tokenType == 586) {
            eventScope = this.readEventScope();
        }
        ThreadPoolType workerPoolType = null;
        int workerPoolSize = -1;
        int notifyThreshold = -1;
        if (this.token.tokenType == 89 || this.token.tokenType == 1045 || this.token.tokenType == 986) {
            if (this.token.tokenType != 986) {
                try {
                    workerPoolType = ThreadPoolType.valueOf(this.token.tokenString.toUpperCase());
                    this.read();
                }
                catch (IllegalArgumentException end) {
                    // empty catch block
                }
            }
            this.readThis(986);
            this.readThis(1046);
            workerPoolSize = this.readInteger();
            if (workerPoolSize > 0 && workerPoolType == null) {
                throw this.unexpectedToken("Worker pool type is not specified.");
            }
            if (this.token.tokenType == 1047) {
                this.read();
                this.readThis(1048);
                notifyThreshold = this.readInteger();
            }
        }
        int consumerDepth = 0;
        if (this.readIfThis(387)) {
            consumerDepth = this.readInteger();
        }
        Map<Object, Object> eventQueues = null;
        Expression[] arguments = null;
        StatementRplExec stat = null;
        DataspaceException lastException = null;
        String rpl = null;
        if (this.token.tokenType == 10) {
            block61: {
                RangeVariable[] rangeVars;
                this.readThis(10);
                if (eventSetSignatureChanged) {
                    if (eventSetType == Actor.EventSetType.COMPLETE) {
                        void var28_38;
                        eventQueues = new HashMap();
                        rangeVars = new RangeVariable[eventHandlerEntries.size()];
                        String currentSql = this.scanner.sqlString;
                        int currentPosition = super.getPosition();
                        boolean bl = false;
                        while (var28_38 < eventHandlerEntries.size()) {
                            RangeVariable range;
                            Actor.ActorEntry entry = (Actor.ActorEntry)eventHandlerEntries.get((int)var28_38);
                            NameManager.ObjectName eventQueueName = NameManager.newSystemObjectName(entry.getAlias().name, 4);
                            eventQueueName.schema = actorName.schema;
                            EventQueueCollection collection = new EventQueueCollection(this.store, eventQueueName, MemoryModel.MEMORY, entry.getEventId(), null, null, null, true, false, false, false, 0);
                            collection.compile(this.session, null);
                            this.session.dataspaceStore.schemaManager.addSchemaObject(collection.getBaseTable());
                            collection.compileInternalStatements(this.session);
                            collection.getBaseTable().releaseRowStore(this.session);
                            collection.getBaseTable().persistenceScope = 23;
                            collection.getBaseTable().isSessionBased = true;
                            eventQueues.put(entry.getEventId(), collection);
                            rangeVars[var28_38] = range = new RangeVariable(collection.getBaseTable(), this.compileContext.getNextRangeVarIndex());
                            ++var28_38;
                        }
                        this.reset(currentSql);
                        this.rewind(currentPosition);
                    } else {
                        rangeVars = new RangeVariable[1];
                        HashMappedList eventAliases = new HashMappedList();
                        for (int i = 0; i < eventHandlerEntries.size(); ++i) {
                            Actor.ActorEntry actorEntry = (Actor.ActorEntry)eventHandlerEntries.get(i);
                            Type type = SqlUtils.getEventDataType(this.session, actorEntry.getEventId());
                            ColumnSchema eventVariable = new ColumnSchema(actorEntry.getAlias(), type, true, false, null);
                            eventVariable.setParameterMode((byte)1);
                            eventAliases.add(actorEntry.getAlias().name, eventVariable);
                        }
                        rangeVars[0] = new RangeVariable(eventAliases, null, false, 3);
                    }
                } else {
                    rangeVars = actor.getRoutine().getParameterRangeVariables();
                    RangeVariable[] newRangeVars = Arrays.copyOf(rangeVars, rangeVars.length - 1);
                    rangeVars = newRangeVars;
                }
                int currentPosition = this.scanner.getPosition();
                this.compileContext.triggerOrActor = true;
                try {
                    routine = this.compileRplRoutine(actorName, rangeVars);
                    rpl = this.scanner.sqlString.substring(currentPosition);
                }
                catch (DataspaceException error) {
                    if (this.session.isProcessingLog() || this.session.isProcessingRecoveryLog() || this.isObjectNotFoundException(error) && this.session.sessionData.isIgnoreDependencies()) {
                        lastException = error;
                        rpl = this.getRplAndRewind(currentPosition);
                        break block61;
                    }
                    throw error;
                }
                finally {
                    this.compileContext.triggerOrActor = false;
                }
            }
            if (routine != null && routine.eventIds != null) {
                for (Actor.ActorEntry actorEntry : eventHandlerEntries) {
                    if (!routine.eventIds.contains(actorEntry.getEventId())) continue;
                    throw new DataspaceException("Event " + StringUtils.wrapEventId(actorEntry.getEventId()) + " can not be raised, actor is subscribed to this event.");
                }
            }
            if (eventQueues != null) {
                for (EventQueueCollection eventQueueCollection : eventQueues.values()) {
                    this.session.dataspaceStore.schemaManager.removeSchemaObject(eventQueueCollection.getBaseTable().getObjectName());
                }
            }
            arguments = new Expression[eventHandlerEntries.size()];
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = new ExpressionValue(null, Type.EVENT);
            }
            stat = new StatementRplExec(this.session, routine, arguments, this.compileContext);
            stat.sql = "execute actor " + actorName.name;
            stat.setSchemaHsqlName(actorName.schema);
        } else if (alter && !eventSetSignatureChanged) {
            routine = actor.getRoutine();
            stat = actor.getStatement();
            arguments = actor.getArguments();
            eventQueues = actor.getEventQueues();
        } else {
            throw this.unexpectedToken("Event actor RPL block is missing.");
        }
        boolean isAutoEnable = false;
        if (this.token.tokenType == 948) {
            this.read();
            isAutoEnable = true;
        }
        if (!alter) {
            actor = new Actor(this.store, actorName);
        }
        if (!alter || invokeModeChanged) {
            actor.setAsync(async);
        }
        if (isAutoEnable) {
            actor.setAutoEnable(isAutoEnable);
        }
        if (lastException != null) {
            actor.getStateHolder().setSuspectState(DataspaceStateHolder.syntax, lastException, "Try to alter or re-enable actor.");
        }
        if (rpl != null) {
            actor.setRpl(rpl);
        }
        Object[] args = new Object[]{actor, eventSetType, eventHandlerEntries, eventScope, routine, stat, arguments, eventQueues, windowType, windowSize, timeWindowUnit, workerPoolType, workerPoolSize, notifyThreshold, ifNotExists, consumerDepth};
        String string = this.getLastPart();
        return new StatementSchema(string, alter ? 3155 : 3154, args);
    }

    private String getRplAndRewind(int currentPosition) {
        int pos;
        if (this.scanner.sqlString.toLowerCase().trim().endsWith("enable")) {
            for (pos = this.scanner.sqlString.length(); pos > 0 && this.scanner.sqlString.charAt(pos - 1) == ' '; --pos) {
            }
            pos -= "enable".length();
        }
        String rpl = this.scanner.sqlString.substring(currentPosition, pos);
        this.rewind(pos);
        return rpl;
    }

    final StatementSchema compileCreateAlterEventTrigger(boolean alter) {
        NameManager.ObjectName name;
        EventTriggerDefSQL td;
        Collection collection = null;
        Boolean isForEachRow = null;
        int beforeOrAfterType = -1;
        int operationType = -1;
        Object otherName = null;
        OrderedHashSet columns = null;
        int[] updateColumnIndexes = null;
        EventScope eventScope = EventScope.INHERITED;
        String conditionSQL = null;
        Expression whenClause = null;
        SystemEventTriggerType systemTriggerType = null;
        this.read();
        boolean ifNotExists = false;
        if (alter) {
            this.completeSchemaObject((SchemaObject object) -> object instanceof EventTriggerDefSQL && !(object instanceof AbstractReplicationEventTrigger), 9);
            td = (EventTriggerDefSQL)this.readSchemaObjectName(9);
            name = td.getObjectName();
        } else {
            ifNotExists = this.readIfNotExists(false);
            name = this.readNewSchemaObjectName(9, true);
            ifNotExists = this.readIfNotExists(true) || ifNotExists;
        }
        this.checkThatRuntimeOperationIsNotInSDS(name, (alter ? "alter" : "create") + " event trigger");
        this.completeSimpleTree("on materialize ", "on persist ", "on ");
        this.readThisTokenOrComplete(194, true, true);
        this.completeSimpleTree("materialize ", "persist ");
        switch (this.token.tokenType) {
            case 997: {
                systemTriggerType = SystemEventTriggerType.MATERIALIZE;
                this.read();
                break;
            }
            case 1072: {
                systemTriggerType = SystemEventTriggerType.PERSIST;
                this.read();
                break;
            }
            default: {
                this.completeCollection();
                collection = (Collection)this.readSchemaObjectName(4);
                if (collection != null) break;
                throw new DataspaceException("Specified collection '" + this.token.tokenString + "' does not exist.");
            }
        }
        this.completeSimpleTree("event scope", "instead of", "before", "after", "after commit", "on");
        if (this.token.tokenType == 586) {
            eventScope = this.readEventScope();
        }
        boolean fileTable = collection instanceof FileTableCollection;
        if (collection != null) {
            switch (this.token.tokenType) {
                case 422: {
                    beforeOrAfterType = 7;
                    this.read();
                    this.readThis(191);
                    break;
                }
                case 343: {
                    beforeOrAfterType = 5;
                    this.read();
                    break;
                }
                case 336: {
                    this.read();
                    beforeOrAfterType = 6;
                    if (this.token.tokenType != 44) break;
                    beforeOrAfterType = 9;
                    this.read();
                    break;
                }
                case 194: {
                    beforeOrAfterType = 8;
                    this.read();
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            this.completeSimpleTree("insert", "delete", "put", "add", "remove", "take", "truncate", "update", "malformed data");
            switch (this.token.tokenType) {
                case 135: {
                    operationType = 50;
                    this.read();
                    break;
                }
                case 79: {
                    operationType = 19;
                    this.read();
                    break;
                }
                case 974: {
                    operationType = 3001;
                    this.read();
                    break;
                }
                case 334: {
                    operationType = 3031;
                    this.read();
                    break;
                }
                case 928: {
                    operationType = 3032;
                    this.read();
                    break;
                }
                case 550: {
                    operationType = 3032;
                    this.read();
                    break;
                }
                case 295: {
                    operationType = 1205;
                    this.read();
                    break;
                }
                case 303: {
                    operationType = 82;
                    this.read();
                    if (this.token.tokenType != 191 || beforeOrAfterType == 7) break;
                    this.read();
                    columns = new OrderedHashSet();
                    this.readColumnNameList(columns, null, false);
                    break;
                }
                case 1093: {
                    if (!fileTable) {
                        throw new DataspaceException("After Malformed Data trigger can be created on file table only.");
                    }
                    this.read();
                    this.readThis(378);
                    operationType = 1206;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
        }
        if (collection instanceof JournalFileTableCollection) {
            if (beforeOrAfterType == 9) {
                beforeOrAfterType = 6;
            }
            if ((beforeOrAfterType != 6 || operationType != 50 && operationType != 1206 && operationType != 82 && operationType != 19) && operationType != 1205) {
                throw new DataspaceException("After Insert, After Update, After Delete, After Malformed Data and Truncate triggers are only supported for journal file table.");
            }
        } else if (fileTable && ((FileTableCollection)collection).getFileTable().isForAppend()) {
            if (beforeOrAfterType == 9) {
                beforeOrAfterType = 6;
            }
            if ((beforeOrAfterType != 6 || operationType != 50 && operationType != 1206) && operationType != 1205) {
                throw new DataspaceException("File Table is for Append. After Insert, After Malformed Data and Truncate triggers are only supported.");
            }
        }
        if (collection != null) {
            name.setSchemaIfNull(collection.getSchemaName());
        } else {
            name.setSchemaIfNull(this.session.currentDataspace);
        }
        this.checkSchemaUpdateAuthorisation(name.schema);
        if (collection != null) {
            DataspaceSchema schema = this.store.schemaManager.findSchema(name.schema.name);
            if (schema != null) {
                if (schema.getDataspaceType() == com.streamscape.cli.ds.DataspaceType.TSPACE || schema.getDataspaceType() == com.streamscape.cli.ds.DataspaceType.FSPACE ? operationType == 3031 : schema.getDataspaceType() == com.streamscape.cli.ds.DataspaceType.QSPACE && (operationType == 50 || operationType == 19)) {
                    throw this.unexpectedToken("Unsupported trigger type '" + TriggerDef.getTimingString(beforeOrAfterType) + " " + TriggerDef.getEventTypeString(operationType) + "' for the specified collection.");
                }
            } else {
                throw new DataspaceException("Unable to resolve dataspace for new trigger.");
            }
            if (beforeOrAfterType == 7 ? !collection.getBaseTable().isView() || ((View)collection.getBaseTable()).getCheckOption() == 2 : collection.getBaseTable().isView()) {
                throw Error.error(5538, name.schema.name);
            }
            if (name.schema != collection.getSchemaName()) {
                throw Error.error(5505, name.schema.name);
            }
            name.parent = collection.getBaseTable().getObjectName();
        }
        if (!alter && !ifNotExists) {
            this.store.schemaManager.checkSchemaObjectNotExists(name);
        }
        if (collection != null && columns != null) {
            updateColumnIndexes = collection.getBaseTable().getColumnIndexes(columns);
            for (int i = 0; i < updateColumnIndexes.length; ++i) {
                if (updateColumnIndexes[i] != -1) continue;
                throw Error.error(5544, (String)columns.get(i));
            }
        }
        if (collection != null && this.token.tokenType == 112) {
            this.read();
            this.readThis(90);
            if (this.token.tokenType == 243) {
                if (Boolean.FALSE.equals(isForEachRow)) {
                    throw this.unexpectedToken();
                }
            } else {
                if (this.token.tokenType == 517) {
                    throw this.unsupportedFeature();
                }
                throw this.unexpectedToken();
            }
            isForEachRow = Boolean.TRUE;
            this.read();
        }
        if (isForEachRow == null) {
            isForEachRow = Boolean.TRUE;
        }
        String oldTableName = null;
        String newTableName = null;
        NameManager.SimpleName oldRowName = null;
        NameManager.SimpleName newRowName = null;
        Table[] transitions = new Table[5];
        RangeVariable[] rangeVars = new RangeVariable[5];
        String triggerEventPrototype = null;
        if (collection != null) {
            triggerEventPrototype = collection.getTriggerEventId(beforeOrAfterType, operationType);
            boolean end = false;
            block30: while (!end) {
                switch (this.token.tokenType) {
                    case 223: {
                        this.read();
                        continue block30;
                    }
                    case 193: {
                        RangeVariable range;
                        Table transition;
                        NameManager.ObjectName hsqlName;
                        String n;
                        if (operationType == 50) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        if (this.token.tokenType == 907) {
                            if (Boolean.TRUE.equals(isForEachRow) || oldTableName != null || beforeOrAfterType == 5) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            this.readIfThis(10);
                            this.checkIsSimpleName();
                            this.read();
                            n = oldTableName = this.token.tokenString;
                            if (n.equals(newTableName) || n.equals(oldRowName) || n.equals(newRowName)) {
                                throw this.unexpectedToken();
                            }
                            isForEachRow = Boolean.FALSE;
                            hsqlName = this.store.nameManager.newHsqlName(collection.getSchemaName(), n, this.isDelimitedIdentifier(), 11);
                            transition = new Table(collection.getBaseTable(), hsqlName);
                            range = new RangeVariable(transition, null, null, null, this.compileContext);
                            transitions[2] = transition;
                            rangeVars[2] = range;
                            continue block30;
                        }
                        if (Boolean.FALSE.equals(isForEachRow) || oldRowName != null) {
                            throw this.unexpectedToken();
                        }
                        this.readThis(378);
                        this.readThis(10);
                        this.checkIsSimpleName();
                        oldRowName = NameManager.getSimpleName(this.token.tokenString, this.token.isDelimitedIdentifier);
                        this.read();
                        n = oldRowName.name;
                        if (n.equals(newTableName) || n.equals(oldTableName) || n.equals(newRowName)) {
                            throw this.unexpectedToken();
                        }
                        isForEachRow = Boolean.TRUE;
                        RangeVariable range2 = new RangeVariable(collection.getBaseTable().columnList, oldRowName, false, 2);
                        range2.rangePosition = 0;
                        transitions[0] = null;
                        rangeVars[0] = range2;
                        continue block30;
                    }
                    case 179: {
                        RangeVariable range;
                        Table transition;
                        NameManager.ObjectName hsqlName;
                        String n;
                        if (operationType == 19) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        if (this.token.tokenType == 907) {
                            if (Boolean.TRUE.equals(isForEachRow) || newTableName != null || beforeOrAfterType == 5) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            this.readIfThis(10);
                            this.checkIsSimpleName();
                            newTableName = this.token.tokenString;
                            this.read();
                            isForEachRow = Boolean.FALSE;
                            n = newTableName;
                            if (n.equals(oldTableName) || n.equals(oldRowName) || n.equals(newRowName)) {
                                throw this.unexpectedToken();
                            }
                            hsqlName = this.store.nameManager.newHsqlName(collection.getSchemaName(), n, this.isDelimitedIdentifier(), 11);
                            transition = new Table(collection.getBaseTable(), hsqlName);
                            range = new RangeVariable(transition, null, null, null, this.compileContext);
                            transitions[3] = transition;
                            rangeVars[3] = range;
                            continue block30;
                        }
                        if (Boolean.FALSE.equals(isForEachRow) || newRowName != null) {
                            throw this.unexpectedToken();
                        }
                        this.readThis(378);
                        this.readThis(10);
                        this.checkIsSimpleName();
                        newRowName = NameManager.getSimpleName(this.token.tokenString, this.token.isDelimitedIdentifier);
                        this.read();
                        n = newRowName.name;
                        if (n.equals(oldTableName) || n.equals(newTableName) || n.equals(oldRowName)) {
                            throw this.unexpectedToken();
                        }
                        isForEachRow = Boolean.TRUE;
                        RangeVariable range2 = new RangeVariable(collection.getBaseTable().columnList, newRowName, false, 2);
                        range2.rangePosition = 1;
                        transitions[1] = null;
                        rangeVars[1] = range2;
                        continue block30;
                    }
                    case 1054: {
                        this.read();
                        this.readThis(586);
                        this.readThis(10);
                        this.checkIsSimpleName();
                        NameManager.ObjectName actionableEventName = this.readNewSchemaObjectName(23, false);
                        Type type = SqlUtils.getEventDataType(this.session, triggerEventPrototype);
                        ColumnSchema eventVariable = new ColumnSchema(actionableEventName, type, true, false, null);
                        eventVariable.setParameterMode((byte)1);
                        HashMappedList eventAliases = new HashMappedList();
                        eventAliases.add(actionableEventName.name, eventVariable);
                        rangeVars[4] = new RangeVariable(eventAliases, null, false, 3);
                        continue block30;
                    }
                }
                end = true;
            }
            if (this.token.tokenType == 314 && beforeOrAfterType != 7) {
                this.read();
                this.readThis(786);
                int position = this.getPosition();
                this.isCheckOrTriggerCondition = true;
                whenClause = this.XreadBooleanValueExpression();
                conditionSQL = this.getLastPart(position);
                this.isCheckOrTriggerCondition = false;
                this.readThis(772);
                HsqlList unresolved = whenClause.resolveColumnReferences(this.session, rangeVars, null);
                ExpressionColumn.checkColumnsResolved(unresolved);
                whenClause.resolveTypes(this.session, null);
                if (whenClause.getDataType() != Type.SQL_BOOLEAN) {
                    throw Error.error(5568);
                }
            }
        }
        int triggerOrder = 0;
        if (this.readIfThis(198)) {
            if (this.readIfThis(401)) {
                triggerOrder = Integer.MIN_VALUE;
            } else if (this.readIfThis(430)) {
                triggerOrder = Integer.MAX_VALUE;
            } else {
                triggerOrder = this.readInteger();
                if (triggerOrder < 1) {
                    throw new DataspaceException("Trigger order should be greater or equal to 1.");
                }
            }
        }
        this.readThis(10);
        DataspaceException lastParsingException = null;
        String rpl = null;
        RplScript routine = null;
        int currentPosition = this.scanner.getPosition();
        try {
            if (collection != null) {
                this.session.sessionContext.triggerEventId = triggerEventPrototype;
                routine = this.compileTriggerRoutine(name, collection.getBaseTable(), rangeVars, true);
                this.session.sessionContext.triggerEventId = null;
            } else {
                routine = this.compileRplRoutine(name, rangeVars);
            }
            rpl = this.scanner.sqlString.substring(currentPosition);
        }
        catch (DataspaceException error) {
            if (this.session.isProcessingLog() || this.session.isProcessingRecoveryLog()) {
                lastParsingException = error;
                rpl = this.getRplAndRewind(currentPosition);
            }
            throw error;
        }
        boolean isAutoEnable = false;
        if (this.token.tokenType == 948) {
            this.read();
            isAutoEnable = true;
        }
        td = collection != null ? new EventTriggerDefSQL(name, beforeOrAfterType, operationType, isForEachRow, collection, transitions, rangeVars, whenClause, conditionSQL, updateColumnIndexes, routine, eventScope) : new SystemEventTrigger(name, systemTriggerType, routine, eventScope);
        if (isAutoEnable) {
            td.setAutoEnable(isAutoEnable);
        }
        if (lastParsingException != null) {
            td.getStateHolder().setSuspectState(DataspaceStateHolder.syntax, lastParsingException);
        }
        if (rpl != null) {
            td.setRpl(rpl);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{td, otherName, ifNotExists, triggerOrder};
        if (collection != null) {
            return new StatementSchema(sql, alter ? 3026 : 3022, args, null, new NameManager.ObjectName[]{collection.getObjectName()});
        }
        return new StatementSchema(sql, alter ? 3026 : 3022, args, null, new NameManager.ObjectName[0]);
    }

    final StatementSchema compileCreateAlterReplicationValidateTrigger(boolean alter) {
        NameManager.ObjectName name;
        this.read();
        this.readThis(291);
        boolean ifNotExists = false;
        ReplicationValidateTrigger td = null;
        if (alter) {
            this.completeSchemaObject((SchemaObject object) -> object instanceof ReplicationValidateTrigger, 9);
            td = (ReplicationValidateTrigger)this.readSchemaObjectName(9);
            name = td.getObjectName();
        } else {
            ifNotExists = this.readIfNotExists(false);
            name = this.readNewSchemaObjectName(9, true);
            ifNotExists = this.readIfNotExists(true) || ifNotExists;
        }
        this.checkThatRuntimeOperationIsNotInSDS(name, (alter ? "alter" : "create") + " replication validate trigger");
        ReplicationEntityName replicaEntityName = null;
        this.readThisTokenOrComplete(194, true, true);
        this.completeReplicationSourceNameGlobal(false, e -> e.getName().startsWith(DataspaceStore.getContext().getName() + "://"));
        replicaEntityName = this.readReplicationEntityName();
        if (!replicaEntityName.isLocalNode()) {
            throw new DataspaceException("Creation of replication validate trigger is allowed on local replica only.");
        }
        ReplicationTarget replicationTarget = (ReplicationTarget)this.store.schemaManager.findSchemaObject(replicaEntityName.getSourceOrReplicaName(), replicaEntityName.getDataspaceName(), 29);
        if (replicationTarget == null) {
            throw new DataspaceException("Specified replica does not exist.");
        }
        Collection replicationCollection = replicationTarget.getCollection();
        if (replicationCollection == null) {
            ReplicationEntityName targetInfo = replicationTarget.getTargetEntityName();
            replicationCollection = this.store.schemaManager.getCollection(this.session, targetInfo.getCollectionName(), targetInfo.getDataspaceName());
        }
        name.setSchemaIfNull(replicationTarget.getObjectName().schema);
        this.checkSchemaUpdateAuthorisation(name.schema);
        if (name.schema != replicationTarget.getSchemaName()) {
            throw Error.error(5505, name.schema.name);
        }
        name.parent = null;
        if (!alter && !ifNotExists) {
            this.store.schemaManager.checkSchemaObjectNotExists(name);
        }
        this.readThisTokenOrComplete(343, true, true);
        this.completeSimpleTree(135, 303, 79);
        ReplicationValidateTrigger.Type triggerType = switch (this.token.tokenType) {
            case 135 -> ReplicationValidateTrigger.Type.INSERT;
            case 303 -> ReplicationValidateTrigger.Type.UPDATE;
            case 79 -> ReplicationValidateTrigger.Type.DELETE;
            default -> throw this.unexpectedToken();
        };
        this.read();
        EventScope eventScope = EventScope.INHERITED;
        if (this.token.tokenType == 586) {
            eventScope = this.readEventScope();
        }
        NameManager.SimpleName oldRowName = null;
        NameManager.SimpleName newRowName = null;
        RangeVariable[] rangeVars = new RangeVariable[2];
        boolean end = false;
        block11: while (!end) {
            if (triggerType == ReplicationValidateTrigger.Type.INSERT) {
                this.completeSimpleTree(179);
            } else if (triggerType == ReplicationValidateTrigger.Type.DELETE) {
                this.completeSimpleTree(193);
            } else if (triggerType == ReplicationValidateTrigger.Type.UPDATE) {
                this.completeSimpleTree(193, 179);
            }
            switch (this.token.tokenType) {
                case 193: {
                    this.read();
                    this.readThisTokenOrComplete(378, true, true);
                    this.readThisTokenOrComplete(10, true, true);
                    this.checkIsSimpleName();
                    oldRowName = NameManager.getSimpleName(this.token.tokenString, this.token.isDelimitedIdentifier);
                    this.read();
                    String n = oldRowName.name;
                    if (n.equals(newRowName)) {
                        throw this.unexpectedToken();
                    }
                    ReplicationModifyTrigger.fillSourceRangeVariable(this.session, replicationTarget.getReplicationSourceInfo(), oldRowName, 0, rangeVars);
                    if (newRowName == null && triggerType != ReplicationValidateTrigger.Type.DELETE) continue block11;
                    end = true;
                    continue block11;
                }
                case 179: {
                    this.read();
                    this.readThisTokenOrComplete(378, true, true);
                    this.readThisTokenOrComplete(10, true, true);
                    this.checkIsSimpleName();
                    newRowName = NameManager.getSimpleName(this.token.tokenString, this.token.isDelimitedIdentifier);
                    this.read();
                    String n = newRowName.name;
                    if (n.equals(oldRowName)) {
                        throw this.unexpectedToken();
                    }
                    ReplicationModifyTrigger.fillSourceRangeVariable(this.session, replicationTarget.getReplicationSourceInfo(), newRowName, 1, rangeVars);
                    if (oldRowName == null && triggerType != ReplicationValidateTrigger.Type.INSERT) continue block11;
                    end = true;
                    continue block11;
                }
            }
            end = true;
        }
        if (oldRowName == null && (triggerType == ReplicationValidateTrigger.Type.DELETE || triggerType == ReplicationValidateTrigger.Type.UPDATE)) {
            throw new DataspaceException("Old data name should be specified for 'before " + triggerType.toString().toLowerCase() + "' trigger.");
        }
        if (newRowName == null && (triggerType == ReplicationValidateTrigger.Type.INSERT || triggerType == ReplicationValidateTrigger.Type.UPDATE)) {
            throw new DataspaceException("New data name should be specified for 'before " + triggerType.toString().toLowerCase() + "' trigger.");
        }
        this.completeSimpleTree(10);
        this.readThisTokenOrComplete(10, true, true);
        this.completeSimpleTree(792);
        DataspaceException lastParsingException = null;
        String rpl = null;
        RplScript routine = null;
        int currentPosition = this.scanner.getPosition();
        try {
            routine = this.compileRplRoutine(name, rangeVars);
            rpl = this.scanner.sqlString.substring(currentPosition);
        }
        catch (DataspaceException error) {
            if (this.session.isProcessingLog() || this.session.isProcessingRecoveryLog()) {
                lastParsingException = error;
                rpl = this.getRplAndRewind(currentPosition);
            }
            throw error;
        }
        Expression[] arguments = new Expression[]{};
        StatementRplExec stat = new StatementRplExec(this.session, routine, arguments, this.compileContext);
        stat.sql = "execute replication trigger " + name.name;
        stat.setSchemaHsqlName(name.schema);
        this.completeSimpleTree(948);
        boolean isAutoEnable = false;
        if (this.token.tokenType == 948) {
            this.read();
            isAutoEnable = true;
        }
        td = new ReplicationValidateTrigger(name, triggerType, replicationTarget, routine, rangeVars, stat, eventScope);
        if (isAutoEnable) {
            td.setAutoEnable(isAutoEnable);
        }
        if (lastParsingException != null) {
            td.getStateHolder().setSuspectState(DataspaceStateHolder.syntax, lastParsingException);
        }
        if (rpl != null) {
            td.setRpl(rpl);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{td, ifNotExists};
        return new StatementSchema(sql, alter ? 3246 : 3245, args, null, new NameManager.ObjectName[]{replicationTarget.getObjectName()});
    }

    final StatementSchema compileCreateAlterReplicationModifyTrigger(boolean alter) {
        NameManager.ObjectName name;
        this.read();
        this.readThis(291);
        boolean ifNotExists = false;
        ReplicationModifyTrigger td = null;
        if (alter) {
            this.completeSchemaObject((SchemaObject object) -> object instanceof ReplicationModifyTrigger, 9);
            td = (ReplicationModifyTrigger)this.readSchemaObjectName(9);
            name = td.getObjectName();
        } else {
            ifNotExists = this.readIfNotExists(false);
            name = this.readNewSchemaObjectName(9, true);
            ifNotExists = this.readIfNotExists(true) || ifNotExists;
        }
        this.checkThatRuntimeOperationIsNotInSDS(name, (alter ? "alter" : "create") + " replication modify trigger");
        ReplicationEntityName replicaEntityName = null;
        this.readThisTokenOrComplete(194, true, true);
        this.completeReplicationSourceNameGlobal(false, e -> e.getName().startsWith(DataspaceStore.getContext().getName() + "://"));
        replicaEntityName = this.readReplicationEntityName();
        if (!replicaEntityName.isLocalNode()) {
            throw new DataspaceException("Creation of replication modify trigger is allowed on local replica only.");
        }
        ReplicationTarget replicationTarget = (ReplicationTarget)this.store.schemaManager.findSchemaObject(replicaEntityName.getSourceOrReplicaName(), replicaEntityName.getDataspaceName(), 29);
        if (replicationTarget == null) {
            throw new DataspaceException("Specified replica does not exist.");
        }
        if (!alter && replicationTarget.getReplicationModifyTrigger() != null && !ifNotExists) {
            throw new DataspaceException("Replication modify trigger on specified replica already exists. Drop or alter existing trigger.");
        }
        Collection replicationCollection = replicationTarget.getCollection();
        if (replicationCollection == null) {
            ReplicationEntityName targetInfo = replicationTarget.getTargetEntityName();
            try {
                replicationCollection = this.store.schemaManager.getCollection(this.session, targetInfo.getCollectionName(), targetInfo.getDataspaceName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ReplicationSourceInfo replicationSourceInfo = replicationTarget.getReplicationSourceInfo();
        name.setSchemaIfNull(replicationTarget.getObjectName().schema);
        this.checkSchemaUpdateAuthorisation(name.schema);
        if (name.schema != replicationTarget.getSchemaName()) {
            throw Error.error(5505, name.schema.name);
        }
        name.parent = null;
        if (!alter && !ifNotExists) {
            this.store.schemaManager.checkSchemaObjectNotExists(name);
        }
        this.completeSimpleTree("using mapper", "event scope", "old", "new");
        if (this.token.tokenType == 306) {
            this.readThisTokenOrComplete(306, true, true);
            this.readThisTokenOrComplete(1138, true, true);
            String mapperName = this.token.tokenString;
            try {
                if (!SemanticMapRepositoryUtils.existsSemanticMap(mapperName)) {
                    throw new DataspaceException("Semantic mapper '" + mapperName + "' doesn't exist.");
                }
            }
            catch (ObjectConfigurationException exception) {
                throw new DataspaceException("Semantic mapper '" + mapperName + "' doesn't exist. " + Utils.formatExceptionWithUnrepeatedCauses(exception));
            }
            td = new ReplicationModifyTrigger(name, replicationTarget, mapperName);
            this.read();
        } else {
            EventScope eventScope = EventScope.INHERITED;
            if (this.token.tokenType == 586) {
                eventScope = this.readEventScope();
            }
            NameManager.SimpleName oldSourceRowName = null;
            NameManager.SimpleName newSourceRowName = null;
            NameManager.SimpleName oldReplicaRowName = null;
            NameManager.SimpleName newReplicaRowName = null;
            RangeVariable[] rangeVars = new RangeVariable[4];
            this.completeSimpleTree("old source data as", "old replica data as", "new source data as", "new replica data as");
            if (this.token.tokenType != 193 && this.token.tokenType != 179) {
                throw this.unexpectedToken();
            }
            boolean end = false;
            block18: while (!end) {
                this.completeSimpleTree("old data as", "old replica data as", "new data as", "new replica data as");
                switch (this.token.tokenType) {
                    case 193: {
                        String n;
                        NameManager.SimpleName rowName;
                        this.read();
                        this.completeSimpleTree("replica data as", "source data as");
                        boolean replica = false;
                        switch (this.token.tokenType) {
                            case 513: 
                            case 1081: {
                                if (this.token.tokenType == 1081) {
                                    if (oldReplicaRowName != null) {
                                        throw this.unexpectedToken();
                                    }
                                    replica = true;
                                } else if (this.token.tokenType == 513) {
                                    if (oldSourceRowName != null) {
                                        throw this.unexpectedToken();
                                    }
                                    replica = false;
                                }
                                this.readThisTokenOrComplete(this.token.tokenType, true, true);
                            }
                            case 378: {
                                this.readThisTokenOrComplete(378, true, true);
                                this.readThisTokenOrComplete(10, true, true);
                                this.checkIsSimpleName();
                                rowName = NameManager.getSimpleName(this.token.tokenString, this.token.isDelimitedIdentifier);
                                this.read();
                                n = rowName.name;
                                if (replica) {
                                    oldReplicaRowName = rowName;
                                    if (n.equals(newSourceRowName) || n.equals(newReplicaRowName) || n.equals(oldSourceRowName)) {
                                        throw this.unexpectedToken();
                                    }
                                    ReplicationModifyTrigger.fillReplicaRangeVariable(this.session, replicationCollection, rowName, 2, rangeVars);
                                    continue block18;
                                }
                                if (oldSourceRowName != null) {
                                    throw this.unexpectedToken();
                                }
                                oldSourceRowName = rowName;
                                if (n.equals(newSourceRowName) || n.equals(newReplicaRowName) || n.equals(oldReplicaRowName)) {
                                    throw this.unexpectedToken();
                                }
                                ReplicationModifyTrigger.fillSourceRangeVariable(this.session, replicationSourceInfo, rowName, 0, rangeVars);
                                continue block18;
                            }
                        }
                        throw this.unexpectedToken();
                    }
                    case 179: {
                        String n;
                        NameManager.SimpleName rowName;
                        this.read();
                        this.completeSimpleTree("replica data as", "source data as");
                        boolean replica = false;
                        switch (this.token.tokenType) {
                            case 513: 
                            case 1081: {
                                if (this.token.tokenType == 1081) {
                                    if (newReplicaRowName != null) {
                                        throw this.unexpectedToken();
                                    }
                                    replica = true;
                                } else if (this.token.tokenType == 513) {
                                    if (newSourceRowName != null) {
                                        throw this.unexpectedToken();
                                    }
                                    replica = false;
                                }
                                this.readThisTokenOrComplete(this.token.tokenType, true, true);
                            }
                            case 378: {
                                this.readThisTokenOrComplete(378, true, true);
                                this.readThisTokenOrComplete(10, true, true);
                                this.checkIsSimpleName();
                                rowName = NameManager.getSimpleName(this.token.tokenString, this.token.isDelimitedIdentifier);
                                this.read();
                                n = rowName.name;
                                if (replica) {
                                    newReplicaRowName = rowName;
                                    if (n.equals(newSourceRowName) || n.equals(oldReplicaRowName) || n.equals(oldSourceRowName)) {
                                        throw this.unexpectedToken();
                                    }
                                    ReplicationModifyTrigger.fillReplicaRangeVariable(this.session, replicationCollection, rowName, 3, rangeVars);
                                    continue block18;
                                }
                                if (newSourceRowName != null) {
                                    throw this.unexpectedToken();
                                }
                                newSourceRowName = rowName;
                                if (n.equals(oldSourceRowName) || n.equals(newReplicaRowName) || n.equals(oldReplicaRowName)) {
                                    throw this.unexpectedToken();
                                }
                                ReplicationModifyTrigger.fillSourceRangeVariable(this.session, replicationSourceInfo, rowName, 1, rangeVars);
                                continue block18;
                            }
                        }
                        throw this.unexpectedToken();
                    }
                }
                end = true;
            }
            if (oldSourceRowName != null && oldReplicaRowName == null || oldSourceRowName == null && oldReplicaRowName != null) {
                throw new DataspaceException("Old source data and old replica data should be specified or not specified together.");
            }
            if (newSourceRowName != null && newReplicaRowName == null || newSourceRowName == null && newReplicaRowName != null) {
                throw new DataspaceException("New source data and new replica data should be specified or not specified together.");
            }
            if (oldSourceRowName == null && oldReplicaRowName == null && newSourceRowName == null && newReplicaRowName == null) {
                throw new DataspaceException("Row data names are not specified.");
            }
            this.readThisTokenOrComplete(10, true, true);
            this.completeSimpleTree(792);
            DataspaceException lastParsingException = null;
            String rpl = null;
            RplScript routine = null;
            int currentPosition = this.scanner.getPosition();
            try {
                routine = this.compileRplRoutine(name, rangeVars);
                rpl = this.scanner.sqlString.substring(currentPosition);
            }
            catch (DataspaceException error) {
                if (this.session.isProcessingLog() || this.session.isProcessingRecoveryLog()) {
                    lastParsingException = error;
                    rpl = this.getRplAndRewind(currentPosition);
                }
                throw error;
            }
            Expression[] arguments = new Expression[]{};
            StatementRplExec stat = new StatementRplExec(this.session, routine, arguments, this.compileContext);
            stat.sql = "execute replication trigger " + name.name;
            stat.setSchemaHsqlName(name.schema);
            td = new ReplicationModifyTrigger(name, replicationTarget, routine, rangeVars, stat, eventScope);
            if (lastParsingException != null) {
                td.getStateHolder().setSuspectState(DataspaceStateHolder.syntax, lastParsingException);
            }
            if (rpl != null) {
                td.setRpl(rpl);
            }
        }
        this.completeSimpleTree(948);
        boolean isAutoEnable = false;
        if (this.token.tokenType == 948) {
            this.read();
            isAutoEnable = true;
        }
        if (isAutoEnable) {
            td.setAutoEnable(isAutoEnable);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{td, ifNotExists};
        return new StatementSchema(sql, alter ? 3251 : 3250, args, null, new NameManager.ObjectName[]{replicationTarget.getObjectName()});
    }

    final StatementSchema compileCreateAlterReplicationTrigger(boolean alter) {
        Collection replicationCollection;
        NameManager.ObjectName name;
        ReplicationEventTrigger td;
        boolean ifNotExists;
        ReplicationEventTrigger.Type triggerType;
        EventScope eventScope;
        AbstractReplicationEntity replicationEntity;
        block46: {
            block47: {
                int entityType;
                block45: {
                    String replicationEntityTitle;
                    replicationEntity = null;
                    eventScope = EventScope.INHERITED;
                    triggerType = null;
                    this.read();
                    ifNotExists = false;
                    if (alter) {
                        this.completeSchemaObject((SchemaObject object) -> object instanceof ReplicationEventTrigger, 9);
                        td = (ReplicationEventTrigger)this.readSchemaObjectName(9);
                        name = td.getObjectName();
                    } else {
                        ifNotExists = this.readIfNotExists(false);
                        name = this.readNewSchemaObjectName(9, true);
                        ifNotExists = this.readIfNotExists(true) || ifNotExists;
                    }
                    this.checkThatRuntimeOperationIsNotInSDS(name, (alter ? "alter" : "create") + " replication trigger");
                    this.completeSimpleTree("on source", "on replica");
                    this.readThisTokenOrComplete(194, true, true);
                    this.completeSimpleTree("source", "replica");
                    replicationCollection = null;
                    switch (this.token.tokenType) {
                        case 513: {
                            this.read();
                            entityType = 34;
                            this.completeSchemaObject(null, 34);
                            if (this.getCompletions().size() > 0) {
                                throw new DataspaceCompleteException();
                            }
                            replicationEntityTitle = this.token.tokenString;
                            replicationCollection = (Collection)this.readSchemaObjectName(4);
                            if (replicationCollection == null) break;
                            replicationEntity = replicationCollection.getReplicationSource();
                            break;
                        }
                        case 1081: {
                            this.read();
                            entityType = 29;
                            this.completeSchemaObject(null, 29);
                            if (this.getCompletions().size() > 0) {
                                throw new DataspaceCompleteException();
                            }
                            replicationEntityTitle = this.token.tokenString;
                            replicationEntity = (AbstractReplicationEntity)((Object)this.readSchemaObjectName(29));
                            if (replicationEntity.getCollection() != null) {
                                replicationCollection = replicationEntity.getCollection();
                                break;
                            }
                            if (!(replicationEntity instanceof ReplicationTarget)) break;
                            ReplicationEntityName targetInfo = ((ReplicationTarget)replicationEntity).getTargetEntityName();
                            replicationCollection = this.store.schemaManager.getCollection(this.session, targetInfo.getCollectionName(), targetInfo.getDataspaceName());
                            break;
                        }
                        default: {
                            throw this.unexpectedToken();
                        }
                    }
                    if (replicationEntity == null) {
                        throw new DataspaceException("Specified replication entity '" + replicationEntityTitle + "' does not exist.");
                    }
                    if (entityType == 29) {
                        this.completeSimpleTree("after success", "after fail");
                    } else {
                        this.completeSimpleTree("on rollback");
                    }
                    if (!this.readIfThis(336)) break block45;
                    this.completeSimpleTree("success", "fail");
                    switch (this.token.tokenType) {
                        case 1091: {
                            if (entityType != 29) {
                                throw new DataspaceException("Replication Success Triggers can only be declared on Replica entities.");
                            }
                            triggerType = ReplicationEventTrigger.Type.SUCCESS;
                            break block46;
                        }
                        case 1040: {
                            if (entityType != 29) {
                                throw new DataspaceException("Replication Fail Triggers can only be declared on SYNC Replica entities.");
                            }
                            triggerType = ReplicationEventTrigger.Type.FAIL;
                            break block46;
                        }
                        default: {
                            throw this.unexpectedToken();
                        }
                    }
                }
                if (!this.readIfThis(194)) break block47;
                switch (this.token.tokenType) {
                    case 241: {
                        if (entityType != 34) {
                            throw new DataspaceException("Replication Rollback Triggers can only be declared on Source entities.");
                        }
                        if (!((ReplicationSource)replicationEntity).getReplicationSourceSettings().rollbackOnFailure.booleanValue()) {
                            throw new DataspaceException("Rollback trigger is available only for a source with option \"rollback on failure\".");
                        }
                        triggerType = ReplicationEventTrigger.Type.ROLLBACK;
                        break block46;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
            }
            throw this.unexpectedToken();
        }
        this.read();
        this.completeSimpleTree("event scope");
        if (this.token.tokenType == 586) {
            eventScope = this.readEventScope();
        }
        name.setSchemaIfNull(replicationEntity.getObjectName().schema);
        this.checkSchemaUpdateAuthorisation(name.schema);
        if (!alter && !ifNotExists) {
            this.store.schemaManager.checkSchemaObjectNotExists(name);
        }
        NameManager.ObjectName repDataName = null;
        NameManager.SimpleName oldRowName = null;
        NameManager.SimpleName newRowName = null;
        Table[] transitions = new Table[3];
        RangeVariable[] rangeVars = new RangeVariable[5];
        ColumnSchema typeVariable = new ColumnSchema(NameManager.newSystemObjectName("type", 10), new NumberType(-6, 1L, 0), true, false, null);
        ColumnSchema insertEnumVariable = new ColumnSchema(NameManager.newSystemObjectName("INSERT", 10), new NumberType(-6, 1L, 0), true, false, null);
        ColumnSchema deleteEnumVariable = new ColumnSchema(NameManager.newSystemObjectName("DELETE", 10), new NumberType(-6, 1L, 0), true, false, null);
        ColumnSchema updateEnumVariable = new ColumnSchema(NameManager.newSystemObjectName("UPDATE", 10), new NumberType(-6, 1L, 0), true, false, null);
        ColumnSchema truncateEnumVariable = new ColumnSchema(NameManager.newSystemObjectName("TRUNCATE", 10), new NumberType(-6, 1L, 0), true, false, null);
        HashMappedList operationFields = new HashMappedList();
        operationFields.add("type", typeVariable);
        operationFields.add("INSERT", insertEnumVariable);
        operationFields.add("DELETE", deleteEnumVariable);
        operationFields.add("UPDATE", updateEnumVariable);
        operationFields.add("TRUNCATE", truncateEnumVariable);
        RangeVariable operationRange = new RangeVariable(operationFields, NameManager.getSimpleName("operation", false), false, 2);
        operationRange.rangePosition = 3;
        rangeVars[3] = operationRange;
        boolean end = false;
        block19: while (!end) {
            this.completeSimpleTree("old data as", "new data as", "replica data as", "exception as");
            switch (this.token.tokenType) {
                case 193: {
                    this.readThisNameTokenForCompleteMode(193);
                    this.readThisTokenOrComplete(378, true, true);
                    this.readThisTokenOrComplete(10, true, true);
                    this.checkIsSimpleName();
                    oldRowName = NameManager.getSimpleName(this.token.tokenString, this.token.isDelimitedIdentifier);
                    this.read();
                    String n = oldRowName.name;
                    if (n.equals(newRowName)) {
                        throw this.unexpectedToken();
                    }
                    if (replicationCollection == null) continue block19;
                    HashMappedList targetCollectionColumnList = replicationCollection.getBaseTable().columnList;
                    RangeVariable range = new RangeVariable(targetCollectionColumnList, oldRowName, false, 2);
                    range.rangePosition = 0;
                    rangeVars[0] = range;
                    continue block19;
                }
                case 179: {
                    this.readThisNameTokenForCompleteMode(179);
                    this.readThisTokenOrComplete(378, true, true);
                    this.readThisTokenOrComplete(10, true, true);
                    this.checkIsSimpleName();
                    newRowName = NameManager.getSimpleName(this.token.tokenString, this.token.isDelimitedIdentifier);
                    this.read();
                    String n = newRowName.name;
                    if (n.equals(oldRowName)) {
                        throw this.unexpectedToken();
                    }
                    if (replicationCollection == null) continue block19;
                    HashMappedList targetCollectionColumnList = replicationCollection.getBaseTable().columnList;
                    RangeVariable range = new RangeVariable(targetCollectionColumnList, newRowName, false, 2);
                    range.rangePosition = 1;
                    rangeVars[1] = range;
                    continue block19;
                }
                case 1081: {
                    this.readThisNameTokenForCompleteMode(1081);
                    this.readThisTokenOrComplete(378, true, true);
                    this.readThisTokenOrComplete(10, true, true);
                    this.checkIsSimpleName();
                    repDataName = this.readNewSchemaObjectName(23, false);
                    Type type = this.store.schemaManager.getDomainOrDistinctType(ReplicationData.class.getSimpleName(), "SYS", false);
                    if (type == null) {
                        throw new DataspaceException("Unable to resolve ReplicationData type.");
                    }
                    ColumnSchema repDataVariable = new ColumnSchema(repDataName, type, true, false, null);
                    repDataVariable.setParameterMode((byte)1);
                    HashMappedList aliases = new HashMappedList();
                    aliases.add(repDataName.name, repDataVariable);
                    rangeVars[2] = new RangeVariable(aliases, null, false, 3);
                    continue block19;
                }
                case 397: {
                    this.readThisNameTokenForCompleteMode(397);
                    this.readThisTokenOrComplete(10, true, true);
                    NameManager.SimpleName exceptionRowName = NameManager.getSimpleName(this.token.tokenString, this.token.isDelimitedIdentifier);
                    this.read();
                    if (triggerType != ReplicationEventTrigger.Type.FAIL && triggerType != ReplicationEventTrigger.Type.ROLLBACK) {
                        throw new DataspaceException("Exception token is available only for fail and rollback triggers.");
                    }
                    ColumnSchema messageVar = new ColumnSchema(NameManager.newSystemObjectName("message", 10), new CharacterType(12, 0L), true, false, null);
                    ColumnSchema stateVar = new ColumnSchema(NameManager.newSystemObjectName("state", 10), new NumberType(4, 1L, 0), true, false, null);
                    ColumnSchema severityVar = new ColumnSchema(NameManager.newSystemObjectName("severity", 10), new CharacterType(12, 0L), true, false, null);
                    HashMappedList excFields = new HashMappedList();
                    excFields.add("message", messageVar);
                    excFields.add("state", stateVar);
                    excFields.add("severity", severityVar);
                    RangeVariable excRange = new RangeVariable(excFields, exceptionRowName, false, 2);
                    excRange.rangePosition = 4;
                    rangeVars[4] = excRange;
                    continue block19;
                }
            }
            end = true;
        }
        this.readThisTokenOrComplete(10, true, true);
        DataspaceException lastParsingException = null;
        String rpl = null;
        RplScript routine = null;
        int currentPosition = this.scanner.getPosition();
        try {
            routine = this.compileRplRoutine(name, rangeVars);
            rpl = this.scanner.sqlString.substring(currentPosition);
        }
        catch (DataspaceException error) {
            if (this.session.isProcessingLog() || this.session.isProcessingRecoveryLog()) {
                lastParsingException = error;
                rpl = this.getRplAndRewind(currentPosition);
            }
            throw error;
        }
        Expression[] arguments = new Expression[]{};
        if (repDataName != null) {
            arguments = new Expression[1];
            Type type = this.store.schemaManager.getDomainOrDistinctType(ReplicationData.class.getSimpleName(), "SYS", false);
            if (type == null) {
                throw new DataspaceException("Unable to resolve ReplicationData type.");
            }
            arguments[0] = new ExpressionValue(null, type);
        }
        StatementRplExec stat = new StatementRplExec(this.session, routine, arguments, this.compileContext);
        stat.sql = "execute replication trigger " + name.name;
        stat.setSchemaHsqlName(name.schema);
        boolean isAutoEnable = false;
        if (this.token.tokenType == 948) {
            this.read();
            isAutoEnable = true;
        }
        td = new ReplicationEventTrigger(name, triggerType, replicationEntity, routine, rangeVars, stat, eventScope);
        td.setArguments(arguments);
        if (isAutoEnable) {
            td.setAutoEnable(isAutoEnable);
        }
        if (lastParsingException != null) {
            td.getStateHolder().setSuspectState(DataspaceStateHolder.syntax, lastParsingException);
        }
        if (rpl != null) {
            td.setRpl(rpl);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{td, ifNotExists};
        return new StatementSchema(sql, alter ? 3214 : 3213, args, null, new NameManager.ObjectName[]{replicationEntity.getObjectName()});
    }

    final StatementSchema compileAlterCreateWindowTrigger(boolean alter) {
        Type type;
        NameManager.ObjectName newDataName;
        NameManager.ObjectName oldDataName;
        Collection collection;
        NameManager.ObjectName name;
        boolean ifNotExists;
        EventScope eventScope;
        WindowTriggerDefSQL td;
        block30: {
            block29: {
                td = null;
                eventScope = EventScope.INHERITED;
                ifNotExists = false;
                if (alter) {
                    this.completeSchemaObject((SchemaObject object) -> object instanceof WindowTriggerDefSQL, 9);
                    td = (WindowTriggerDefSQL)this.readSchemaObjectName(9);
                    name = td.getObjectName();
                } else {
                    ifNotExists = this.readIfNotExists(false);
                    name = this.readNewSchemaObjectName(9, true);
                    ifNotExists = this.readIfNotExists(true) || ifNotExists;
                }
                this.readThisTokenOrComplete(194, true, true);
                this.completeCollection(new CollectionFilter(CollectionType.PROCESS_QUEUE, CollectionType.AUDIT_QUEUE, CollectionType.EVENT_QUEUE, CollectionType.EVENT_TABLE));
                collection = (Collection)this.readSchemaObjectName(4);
                if (collection == null) {
                    throw new DataspaceException("Specified collection '" + this.token.tokenString + "' does not exist.");
                }
                this.checkThatRuntimeOperationIsNotInSDS(name, (alter ? "alter" : "create") + " window trigger");
                if (this.token.tokenType == 586) {
                    eventScope = this.readEventScope();
                }
                name.setSchemaIfNull(collection.getSchemaName());
                this.checkSchemaUpdateAuthorisation(name.schema);
                if (name.schema != collection.getSchemaName()) {
                    throw Error.error(5505, name.schema.name);
                }
                name.parent = collection.getBaseTable().getObjectName();
                try {
                    if (!alter) {
                        this.store.schemaManager.checkSchemaObjectNotExists(name);
                    }
                }
                catch (Exception exception) {
                    if (ifNotExists) break block29;
                    throw exception;
                }
            }
            oldDataName = null;
            newDataName = null;
            if (this.token.tokenType == 223) {
                this.read();
                if (this.token.tokenType != 193 && this.token.tokenType != 179) {
                    throw this.unexpectedToken();
                }
                while (true) {
                    String n;
                    if (this.token.tokenType == 193) {
                        this.read();
                        this.readIfThis(10);
                        oldDataName = this.readNewSchemaObjectName(23, false);
                        n = oldDataName.name;
                        if (!n.equals(newDataName)) continue;
                        throw this.unexpectedToken();
                    }
                    if (this.token.tokenType != 179) break block30;
                    this.read();
                    this.readIfThis(10);
                    newDataName = this.readNewSchemaObjectName(23, false);
                    n = newDataName.name;
                    if (n.equals(oldDataName)) break;
                }
                throw this.unexpectedToken();
            }
        }
        HashMappedList oldNewVariables = new HashMappedList();
        if (oldDataName == null) {
            oldDataName = this.store.nameManager.newObjectName("oldWindowData", false, 23);
        }
        if (newDataName == null) {
            newDataName = this.store.nameManager.newObjectName("oldWindowData", false, 23);
        }
        if (collection.getCollectionType() == CollectionType.EVENT_TABLE || collection.getCollectionType() == CollectionType.AUDIT_QUEUE) {
            type = Types.getParameterSQLType(this.session, RowSet.class);
        } else if (collection.getCollectionType() == CollectionType.EVENT_QUEUE || collection.getCollectionType() == CollectionType.PROCESS_QUEUE) {
            type = Types.getParameterSQLType(this.session, List.class);
        } else {
            throw new DataspaceException("Window trigger not supported by collection type " + String.valueOf((Object)collection.getCollectionType()) + ", collection [" + collection.getObjectName().name + "].");
        }
        CollectionWindowType windowType = null;
        if (collection instanceof EventTableCollection) {
            windowType = ((EventTableCollection)collection).getWindowType();
        } else if (collection instanceof EventQueueCollection) {
            windowType = ((EventQueueCollection)collection).getWindowType();
        }
        if (windowType == null) {
            throw new DataspaceException("Window is not enabled on collection [" + collection.getObjectName().name + "].");
        }
        ColumnSchema oldVariable = new ColumnSchema(oldDataName, type, true, false, null);
        oldVariable.setParameterMode((byte)1);
        ColumnSchema newVariable = new ColumnSchema(newDataName, type, true, false, null);
        newVariable.setParameterMode((byte)1);
        oldNewVariables.add(oldDataName.name, oldVariable);
        oldNewVariables.add(newDataName.name, newVariable);
        RangeVariable[] rangeVars = new RangeVariable[]{new RangeVariable(oldNewVariables, null, false, 3)};
        int triggerOrder = 0;
        if (this.readIfThis(198) && (triggerOrder = this.readInteger()) < 1) {
            throw new DataspaceException("Trigger order should be greater or equal to 1.");
        }
        this.readIfThis(10);
        int currentPosition = this.scanner.getPosition();
        RplScript routine = null;
        String rpl = null;
        DataspaceException lastParsingException = null;
        try {
            routine = this.compileTriggerRoutine(name, collection.getBaseTable(), rangeVars, true);
            rpl = this.scanner.sqlString.substring(currentPosition);
        }
        catch (DataspaceException error) {
            if (this.session.isProcessingLog() || this.session.isProcessingRecoveryLog()) {
                lastParsingException = error;
                rpl = this.getRplAndRewind(currentPosition);
            }
            throw error;
        }
        boolean isAutoEnable = false;
        if (this.token.tokenType == 948) {
            this.read();
            isAutoEnable = true;
        }
        td = new WindowTriggerDefSQL(name, collection, routine, eventScope, oldDataName, newDataName);
        td.setAutoEnable(isAutoEnable);
        if (lastParsingException != null) {
            td.getStateHolder().setSuspectState(DataspaceStateHolder.syntax, lastParsingException);
        }
        if (rpl != null) {
            td.setRpl(rpl);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{td, null, ifNotExists, triggerOrder};
        return new StatementSchema(sql, alter ? 3299 : 3141, args, null, new NameManager.ObjectName[]{collection.getObjectName()});
    }

    Expression readDefaultClause(Type dataType) {
        Expression e = null;
        boolean minus = false;
        if (this.token.tokenType == 186) {
            this.read();
            return new ExpressionValue(null, dataType);
        }
        if (dataType.isDateTimeType() || dataType.isIntervalType()) {
            switch (this.token.tokenType) {
                case 72: 
                case 140: 
                case 281: 
                case 282: {
                    e = this.readDateTimeIntervalLiteral();
                    if (e.dataType.typeCode != dataType.typeCode) {
                        throw this.unexpectedToken();
                    }
                    Object defaultValue = e.getValue(this.session, dataType);
                    return new ExpressionValue(defaultValue, dataType);
                }
                case 845: {
                    break;
                }
                default: {
                    e = this.XreadDateTimeValueFunctionOrNull();
                    if (e == null) break;
                    e = this.XreadModifier(e);
                    break;
                }
            }
        } else if (dataType.isNumberType()) {
            if (this.token.tokenType == 784) {
                this.read();
                minus = true;
            }
        } else if (dataType.isCharacterType()) {
            switch (this.token.tokenType) {
                case 60: 
                case 63: 
                case 64: 
                case 65: 
                case 69: 
                case 253: 
                case 277: 
                case 305: 
                case 555: {
                    FunctionSQL function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                    e = this.readSQLFunction(function);
                    break;
                }
            }
        } else if (dataType.isBooleanType()) {
            switch (this.token.tokenType) {
                case 294: {
                    this.read();
                    return Expression.EXPR_TRUE;
                }
                case 106: {
                    this.read();
                    return Expression.EXPR_FALSE;
                }
            }
        } else if (dataType.isBitType()) {
            switch (this.token.tokenType) {
                case 294: {
                    this.read();
                    return new ExpressionValue(BinaryData.singleBitOne, dataType);
                }
                case 106: {
                    this.read();
                    return new ExpressionValue(BinaryData.singleBitZero, dataType);
                }
            }
        } else if (dataType.isArrayType()) {
            e = this.readCollection(19);
            if (e.nodes.length > 0) {
                throw Error.error(5562);
            }
            e.dataType = dataType;
            return e;
        }
        if (e != null) {
            e.resolveTypes(this.session, null);
            if (dataType.typeComparisonGroup != e.getDataType().typeComparisonGroup) {
                throw Error.error(5562);
            }
            return e;
        }
        if (this.token.tokenType == 845) {
            Object value = this.token.tokenValue;
            Type valueType = this.token.dataType;
            Type convertType = dataType;
            if (dataType.typeCode == 40) {
                convertType = Type.getType(12, null, this.store.collation, dataType.precision, 0);
            } else if (dataType.typeCode == 30) {
                convertType = Type.getType(61, null, null, dataType.precision, 0);
            }
            value = convertType.convertToType(this.session, value, valueType);
            this.read();
            if (minus) {
                value = dataType.negate(value);
            }
            return new ExpressionValue(value, convertType);
        }
        throw this.unexpectedToken();
    }

    Statement compileOpenCursorStatement(StatementCompound context) {
        this.readThis(196);
        this.checkIsSimpleName();
        String tokenString = this.token.tokenString;
        this.read();
        for (int i = 0; i < context.cursors.length; ++i) {
            if (!context.cursors[i].getCursorName().name.equals(tokenString)) continue;
            return context.cursors[i];
        }
        throw Error.error(4680);
    }

    Statement compileSelectSingleRowStatement(RangeVariable[] rangeVars) {
        OrderedHashSet variableNames = new OrderedHashSet();
        QuerySpecification select = new QuerySpecification(this.compileContext);
        this.XreadSelect(select, 251);
        LongDeque colIndexList = new LongDeque();
        this.readThis(141);
        this.readTargetSpecificationList(variableNames, rangeVars, colIndexList);
        this.XreadTableExpression(select);
        select.setReturningResult();
        int[] columnMap = new int[colIndexList.size()];
        colIndexList.toArray(columnMap);
        Object[] variables = new Expression[variableNames.size()];
        variableNames.toArray(variables);
        Type[] targetTypes = new Type[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            if (((Expression)variables[i]).getColumn().getParameterMode() == 1) {
                throw Error.error(2500);
            }
            targetTypes[i] = ((Expression)variables[i]).getDataType();
        }
        select.setReturningResult();
        select.resolve(this.session, rangeVars, targetTypes);
        if (select.getColumnCount() != variables.length) {
            throw Error.error(5564, "INTO");
        }
        StatementSet statement = new StatementSet(this.session, (Expression[])variables, select, columnMap, this.compileContext);
        return statement;
    }

    final Statement compileSetStatement(RangeVariable[] rangeVars) {
        return this.compileSetStatement(rangeVars, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Statement compileSetStatement(RangeVariable[] rangeVars, boolean readSetKeyword, boolean isDeclaration) {
        int i;
        if (readSetKeyword) {
            this.read();
        }
        OrderedHashSet targetSet = new OrderedHashSet();
        HsqlArrayList exprList = new HsqlArrayList();
        LongDeque colIndexList = new LongDeque();
        this.readSetClauseList(rangeVars, targetSet, colIndexList, exprList, isDeclaration);
        if (exprList.size() == 0) {
            return null;
        }
        if (exprList.size() > 1) {
            int i2;
            if (exprList.size() != targetSet.size()) {
                throw Error.error(5546, "SET");
            }
            int[] columnMap = new int[colIndexList.size()];
            colIndexList.toArray(columnMap);
            Object[] targets = new Expression[targetSet.size()];
            targetSet.toArray(targets);
            for (int i3 = 0; i3 < targets.length; ++i3) {
                this.resolveOuterReferencesAndTypes(rangeVars, (Expression)targets[i3]);
            }
            Expression[] sources = new Expression[exprList.size()];
            exprList.toArray(sources);
            for (i2 = 0; i2 < sources.length; ++i2) {
                this.resolveOuterReferencesAndTypes(rangeVars, sources[i2]);
            }
            for (i2 = 0; i2 < targets.length; ++i2) {
                this.verifySourceTargetTypes((Expression)targets[i2], sources[i2].getDataType());
            }
            return new StatementSet(this.session, (Expression[])targets, sources, columnMap, this.compileContext);
        }
        Expression expression = (Expression)exprList.get(0);
        if (expression.getDegree() != targetSet.size()) {
            if (expression.getType() == 22 && targetSet.size() == 1) {
                Expression expr = (Expression)targetSet.get(0);
                if (!(expr.getDataType() instanceof OtherType) || ((OtherType)expr.getDataType()).getInternalClass(this.session) != RowSet.class) {
                    throw Error.error(5546, "SET");
                }
            } else {
                throw Error.error(5546, "SET");
            }
        }
        int[] columnMap = new int[colIndexList.size()];
        colIndexList.toArray(columnMap);
        Object[] targets = new Expression[targetSet.size()];
        targetSet.toArray(targets);
        for (i = 0; i < targets.length; ++i) {
            this.resolveOuterReferencesAndTypes(rangeVars, (Expression)targets[i]);
        }
        if (expression.subQuery != null && expression.subQuery.queryExpression instanceof QuerySpecification) {
            ExpressionColumn.addParentQuerySpecification((QuerySpecification)expression.subQuery.queryExpression);
        }
        try {
            this.resolveOuterReferencesAndTypes(rangeVars, expression);
        }
        finally {
            if (expression.subQuery != null && expression.subQuery.queryExpression instanceof QuerySpecification) {
                ExpressionColumn.removeParentQuerySpecificationLast();
            }
        }
        if (targets.length > 0 && ((Expression)targets[0]).getDataType() != null && expression instanceof FunctionCustom) {
            if (((FunctionCustom)expression).funcType == 162 || ((FunctionCustom)expression).funcType == 161) {
                expression.setDataType(this.session, ((Expression)targets[0]).getDataType());
            } else if (((FunctionCustom)expression).funcType == 106) {
                expression.setDataType(this.session, ((Expression)targets[0]).getDataType());
            } else if (((FunctionCustom)expression).funcType == 231) {
                expression.setDataType(this.session, ((Expression)targets[0]).getDataType());
            }
        }
        for (i = 0; i < targets.length; ++i) {
            if (((Expression)targets[i]).getDataType() instanceof FlobType) {
                ((FlobType)((Expression)targets[i]).getDataType()).setVariable(true);
                if (expression instanceof FunctionCustom && (((FunctionCustom)expression).funcType == 106 || ((FunctionCustom)expression).funcType == 231 || ((FunctionCustom)expression).funcType == 182 || ((FunctionCustom)expression).funcType == 183)) {
                    ((FlobType)((Expression)targets[i]).getDataType()).setLazy(true);
                } else if (expression.getDataType() instanceof FlobType && ((FlobType)expression.getDataType()).isVariable()) {
                    ((FlobType)((Expression)targets[i]).getDataType()).setLazy(((FlobType)expression.getDataType()).isLazy());
                } else {
                    ((FlobType)((Expression)targets[i]).getDataType()).setLazy(false);
                }
                ParserRPL.resolveFlobExpression(this.session, expression, ((Expression)targets[i]).getDataType());
            }
            this.verifySourceTargetTypes((Expression)targets[i], expression.getNodeDataType(i));
        }
        if (targets.length > 0 && ((Expression)targets[0]).getDataType() != null && expression instanceof FunctionUnitCall) {
            if (((FunctionUnitCall)expression).getEntry() instanceof SysFunctionUnit.LookupEntry) {
                if (((Expression)targets[0]).getDataType() instanceof DataspaceType) {
                    ((FunctionUnitCall)expression).dataType = new DataspaceType();
                } else if (((Expression)targets[0]).getDataType() instanceof ServiceType) {
                    ((FunctionUnitCall)expression).dataType = new ServiceType();
                    ((Expression)targets[0]).getColumn().dataType = new ServiceType((FunctionUnitCall)expression);
                } else if (((Expression)targets[0]).getDataType() instanceof RuntimeType) {
                    ((FunctionUnitCall)expression).dataType = new RuntimeType();
                } else if (((Expression)targets[0]).getDataType() instanceof ServerType) {
                    ((FunctionUnitCall)expression).dataType = new ServerType();
                } else if (((Expression)targets[0]).getDataType() instanceof DropboxType) {
                    ((FunctionUnitCall)expression).dataType = new DropboxType();
                }
            } else if (((FunctionUnitCall)expression).getEntry() instanceof SysFunctionUnit.GetEntry) {
                ((FunctionUnitCall)expression).dataType = ((Expression)targets[0]).getDataType();
            }
        }
        if (targets.length > 0 && ((Expression)targets[0]).getDataType() != null && expression instanceof FunctionCustom) {
            if (((FunctionCustom)expression).funcType == 162) {
                expression.setDataType(this.session, ((Expression)targets[0]).getDataType());
            } else if (((FunctionCustom)expression).funcType == 106) {
                expression.setDataType(this.session, ((Expression)targets[0]).getDataType());
            } else if (((FunctionCustom)expression).funcType == 231) {
                expression.setDataType(this.session, ((Expression)targets[0]).getDataType());
            }
        }
        StatementSet cs = new StatementSet(this.session, (Expression[])targets, expression, columnMap, this.compileContext);
        return cs;
    }

    final void verifySourceTargetTypes(Expression target, Type sourceType) {
        Type targetType = target.getDataType();
        if (target.getColumn().getParameterMode() == 1) {
            throw Error.error(2500);
        }
        if (!(targetType.canBeAssignedFrom(sourceType) || targetType.isArrayType() && sourceType.isArrayType() && sourceType.collectionBaseType().isObjectType() || sourceType instanceof OtherType || targetType instanceof OtherType)) {
            throw Error.error(5561, " source type: " + sourceType.getTypeDefinition() + ", target type: " + targetType.getTypeDefinition());
        }
        if (sourceType instanceof EventType && targetType instanceof EventType && ((EventType)sourceType).getEventId() != null) {
            if (((EventType)targetType).getEventId() != null && !((EventType)targetType).getEventId().equals(((EventType)sourceType).getEventId())) {
                Trace.logError(this, "Attempted to overwrite event type EventId [" + ((EventType)targetType).getEventId() + "] with [" + ((EventType)sourceType).getEventId() + "].");
            }
            ((EventType)targetType).setEventId(((EventType)sourceType).getEventId());
            if (targetType.userTypeModifier == null && ((OtherType)targetType).getInternalClass(this.session) == Object.class) {
                targetType.userTypeModifier = sourceType.userTypeModifier;
            }
        }
        if (sourceType instanceof OtherType && sourceType.userTypeModifier != null && targetType instanceof OtherType && targetType.userTypeModifier == null && ((OtherType)targetType).getInternalClass(this.session) == Object.class) {
            target.dataType = new OtherType();
            target.dataType.userTypeModifier = sourceType.userTypeModifier;
        }
        if (sourceType instanceof OtherType && sourceType.getInternalClass(this.session) != null && targetType instanceof OtherType && ((OtherType)targetType).getInternalClass(this.session) == Object.class) {
            target.dataType = new OtherType();
            ((OtherType)target.dataType).setInternalClass(this.session, sourceType.getInternalClass(this.session));
        }
        if (sourceType instanceof ArrayType && targetType instanceof ArrayType && ((ArrayType)targetType).maxCardinality != -1) {
            ((ArrayType)targetType).setMaxCardinality(((ArrayType)sourceType).maxCardinality);
        }
    }

    StatementDMQL compileTriggerSetStatement(Table table, RangeVariable[] rangeVars) {
        this.read();
        OrderedHashSet targetSet = new OrderedHashSet();
        HsqlArrayList exprList = new HsqlArrayList();
        RangeVariable[] targetRangeVars = new RangeVariable[]{rangeVars[1]};
        LongDeque colIndexList = new LongDeque();
        this.readSetClauseList(targetRangeVars, targetSet, colIndexList, exprList, false);
        int[] columnMap = new int[colIndexList.size()];
        colIndexList.toArray(columnMap);
        Object[] targets = new Expression[targetSet.size()];
        targetSet.toArray(targets);
        for (int i = 0; i < targets.length; ++i) {
            this.resolveOuterReferencesAndTypes(RangeVariable.emptyArray, (Expression)targets[i]);
        }
        Expression[] updateExpressions = new Expression[exprList.size()];
        exprList.toArray(updateExpressions);
        if (rangeVars[1] != null) {
            this.resolveUpdateExpressions(table, rangeVars, columnMap, updateExpressions, RangeVariable.emptyArray);
            StatementSet cs = new StatementSet(this.session, (Expression[])targets, table, rangeVars, columnMap, updateExpressions, this.compileContext);
            return cs;
        }
        StatementSet cs = new StatementSet(this.session, (Expression[])targets, table, rangeVars, columnMap, updateExpressions, this.compileContext);
        return cs;
    }

    StatementSchema compileAlterSpecificRoutine() {
        OrderedHashSet set;
        boolean restrict = false;
        this.readThisNameTokenForCompleteMode(117);
        this.completeSchemaObject(null, ParserDQL.CompleteSchemaObjectParams.create().withSystem(false).onlyNames(true), 25);
        RplScript routine = (RplScript)this.readSchemaObjectName(25);
        routine = routine.duplicate();
        if (this.token.tokenType == 786) {
            throw new DataspaceException("Parameters of the function could not be altered.");
        }
        if (!this.readIfThis(10)) {
            this.scanner.insertBeforeCurrentToken("AS ");
        }
        this.readRoutineCharacteristics(routine);
        restrict = this.readIfThis(485);
        if (restrict && !(set = this.store.schemaManager.getReferencesTo(routine.getSpecificName())).isEmpty()) {
            throw Error.error(5502);
        }
        if (this.token.tokenType == 567) {
            this.read();
        } else if (this.token.tokenType == 445) {
            this.read();
        }
        HashMappedList currentVariables = routine.scopeVariables;
        try {
            routine.scopeVariables = new HashMappedList();
            this.readFunctionBody(routine, 17);
        }
        catch (DataspaceException error) {
            routine.scopeVariables = currentVariables;
            throw error;
        }
        routine.resolve(this.session);
        Object[] args = new Object[]{routine};
        String sql = this.getLastPart();
        StatementSchema cs = new StatementSchema(sql, 17, args, null, this.store.schemaManager.getCatalogNameArray());
        return cs;
    }

    final StatementSchema compileCreateFunction() {
        boolean isAggregate = false;
        if (this.token.tokenType == 215 && this.session.isInteractive()) {
            throw this.unexpectedToken();
        }
        if (this.token.tokenType == 559) {
            isAggregate = true;
            this.read();
            if (this.token.tokenType == 215) {
                throw super.unexpectedToken();
            }
        }
        int routineType = this.token.tokenType == 215 ? 18 : 17;
        this.read();
        boolean ifNotExists = this.readIfNotExists(false);
        NameManager.ObjectName name = this.readNewSchemaObjectName(routineType, true);
        this.checkThatRuntimeOperationIsNotInSDS(name, "create function");
        if (FunctionSQL.listFunctions().contains(name.name)) {
            throw new DataspaceException("Failed to create user function with specified name. System function with the same name exists.");
        }
        name.setSchemaIfNull(this.session.getCurrentDataspaceName());
        RplScript routine = new RplScript(this.store, name, routineType);
        routine.setAggregate(isAggregate);
        this.readThis(786);
        if (this.token.tokenType == 772) {
            this.read();
        } else {
            while (true) {
                ColumnSchema newcolumn = this.readRoutineParameter(routine, true);
                routine.addParameter(newcolumn);
                if (this.token.tokenType != 774) break;
                this.read();
            }
            this.readThis(772);
        }
        boolean bl = ifNotExists = this.readIfNotExists(true) || ifNotExists;
        if (routineType != 18) {
            this.completeSimpleTree("returns");
            this.readThis(238);
            this.completeSimpleTree("table", "map", "queue");
            this.completeTypes(true, false);
            if (this.token.tokenType == 278) {
                this.read();
                NameManager.ObjectName tableName = NameManager.newInfoSchemaObjectName("return_table", false, 4);
                tableName.schema = SqlInvariants.MODULE_NAME;
                TableCollection collection = new TableCollection(this.store, tableName, MemoryModel.MEMORY, 12);
                Table table = collection.getBaseTable();
                this.readTableDefinition(routine, table);
                routine.setReturnCollection(collection);
            } else if (this.token.tokenType == 436) {
                int pos = super.getPosition();
                this.read();
                if (this.token.tokenType != 786) {
                    this.rewind(pos);
                    this.completeTypes(true, false);
                    type = this.readTypeDefinition(false, true);
                    routine.setReturnType(type);
                } else {
                    NameManager.ObjectName mapName = NameManager.newInfoSchemaObjectName("return_map", false, 4);
                    mapName.schema = SqlInvariants.MODULE_NAME;
                    this.readThis(786);
                    this.completeTypes(true, false);
                    Type keyType = this.readTypeDefinition(false, true);
                    this.readThis(774);
                    this.completeTypes(true, false);
                    Type valueType = this.readTypeDefinition(false, true);
                    this.readThis(772);
                    MapCollection map = new MapCollection(this.session.dataspaceStore, mapName, MemoryModel.MEMORY);
                    map.defineKeyColumn(keyType, keyType.getNameString());
                    map.defineValueColumn(valueType, valueType.getNameString());
                    map.compile(this.session, null);
                    routine.setReturnCollection(map);
                }
            } else if (this.token.tokenType == 908) {
                int pos = super.getPosition();
                this.read();
                if (this.token.tokenType != 786) {
                    this.rewind(pos);
                    this.completeTypes(true, false);
                    type = this.readTypeDefinition(false, true);
                    routine.setReturnType(type);
                } else {
                    NameManager.ObjectName queueName = NameManager.newInfoSchemaObjectName("return_queue", false, 4);
                    queueName.schema = SqlInvariants.MODULE_NAME;
                    this.readThis(786);
                    this.completeTypes(true, false);
                    Type queueObjectType = this.readTypeDefinition(false, true);
                    this.readThis(772);
                    BlockingQueueCollection queue = new BlockingQueueCollection(this.session.dataspaceStore, queueName, MemoryModel.MEMORY);
                    queue.setConstraint(queueObjectType);
                    queue.compile(this.session, null);
                    routine.setReturnCollection(queue);
                }
            } else {
                Type type = this.readTypeDefinition(false, true);
                routine.setReturnType(type);
            }
        }
        if (routine.returnCollection != null) {
            int i;
            HashSet<String> names = new HashSet<String>();
            for (i = 0; i < routine.getParameterCount(); ++i) {
                names.add(routine.getParameter((int)i).getObjectName().name);
            }
            for (i = 0; i < routine.returnCollection.getBaseTable().getColumnCount(); ++i) {
                if (names.add(routine.returnCollection.getBaseTable().getColumn((int)i).getObjectName().name)) continue;
                throw new DataspaceException("Returned table column names can not match function parameter names.");
            }
        }
        if (this.token.tokenType == 259) {
            this.read();
            NameManager.ObjectName specificName = this.readNewSchemaObjectName(25, false);
            routine.setSpecificName(specificName);
        }
        this.readRoutineCharacteristics(routine);
        if (!this.readIfThis(10)) {
            this.scanner.insertBeforeCurrentToken("AS ");
        }
        try {
            this.readFunctionBody(routine, routineType);
        }
        catch (Exception e) {
            if (this.isObjectNotFoundException(e) && this.session.sessionData.isIgnoreDependencies()) {
                int currentPosition = this.scanner.getPosition();
                String bodySql = this.getRplAndRewind(currentPosition);
                StatementCompound cs = new StatementCompound(12, null);
                cs.setSQL(bodySql);
                routine.setProcedure(cs);
                routine.getStateHolder().setSuspectState(DataspaceStateHolder.syntax, e, "Try to alter or check the function/actor or re-enable.");
            }
            throw e;
        }
        Object[] args = new Object[]{routine, ifNotExists};
        String sql = this.getLastPart();
        StatementSchema cs = new StatementSchema(sql, 14, args, null, this.store.schemaManager.getCatalogNameArray());
        return cs;
    }

    final void readTableDefinition(RplScript routine, Table table) throws DataspaceException {
        this.readThis(786);
        while (true) {
            ColumnSchema newcolumn;
            if ((newcolumn = this.readRoutineParameter(routine, false)).getObjectName() == null) {
                throw super.unexpectedToken();
            }
            table.addColumn(newcolumn);
            if (this.token.tokenType != 774) break;
            this.read();
        }
        this.readThis(772);
        table.createPrimaryKey();
    }

    final void readRoutineCharacteristics(RplScript routine) {
        OrderedIntHashSet set = new OrderedIntHashSet();
        boolean end = false;
        block10: while (!end) {
            switch (this.token.tokenType) {
                case 146: {
                    if (!set.add(146)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.read();
                    continue block10;
                }
                case 83: {
                    if (!set.add(83)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    routine.setDeterministic(true);
                    continue block10;
                }
                case 183: {
                    if (!set.add(83)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(83);
                    routine.setDeterministic(false);
                    continue block10;
                }
                case 237: {
                    if (!set.add(186) || routine.isProcedure()) {
                        throw this.unexpectedToken();
                    }
                    if (routine.isAggregate()) {
                        throw Error.error(5604, this.token.tokenString);
                    }
                    this.read();
                    this.readThis(194);
                    this.readThis(186);
                    continue block10;
                }
                case 25: {
                    if (!set.add(186) || routine.isProcedure()) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(194);
                    this.readThis(186);
                    continue block10;
                }
                case 89: {
                    if (!set.add(236) || routine.isFunction()) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(236);
                    this.readThis(510);
                    int results = this.readInteger();
                    if (results < 0 || results > 16) {
                        throw Error.error(5604, String.valueOf(results));
                    }
                    routine.setMaxDynamicResults(results);
                    continue block10;
                }
                case 179: {
                    if (routine.getObjectType() == 17 || !set.add(246)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(246);
                    this.readThis(432);
                    routine.setNewSavepointLevel(true);
                    continue block10;
                }
                case 193: {
                    if (routine.getObjectType() == 17 || !set.add(246)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(246);
                    this.readThis(432);
                    routine.setNewSavepointLevel(false);
                    throw super.unsupportedFeature("OLD");
                }
            }
            end = true;
        }
    }

    void readFunctionBody(RplScript routine, int type) {
        Statement statement = null;
        DataspaceException lastException = null;
        String rpl = null;
        int currentPosition = this.scanner.getPosition();
        try {
            statement = this.compileSQLProcedureStatementOrNull(routine, null);
            rpl = this.scanner.sqlString.substring(currentPosition);
        }
        catch (DataspaceException error) {
            if (this.session.isProcessingLog() || this.session.isProcessingRecoveryLog()) {
                lastException = error;
                rpl = this.getRplAndRewind(currentPosition);
            }
            throw error;
        }
        if (type == 17 && this.session.isInteractive()) {
            int result = this.verifyReturnStatement(statement, 0);
            if (result == -1) {
                throw new DataspaceException("Function [" + routine.getObjectName().name + "] definition does not have 'return' statement.");
            }
            if (result == 1) {
                Trace.logInfo(this, "WARNING: function [" + routine.getObjectName().name + "] possibly does not return value, please check the logic.");
            }
        }
        if (lastException != null) {
            routine.getStateHolder().setSuspectState(DataspaceStateHolder.syntax, lastException, "Try to alter or check function.");
        } else {
            routine.getStateHolder().resetSuspectState(DataspaceStateHolder.syntax);
        }
        if (rpl != null) {
            routine.setRpl(rpl);
        }
        if (lastException == null && statement != null) {
            int end = this.scanner.getPosition();
            String sql = this.scanner.sqlString.substring(currentPosition, end);
            statement.setSQL(sql);
        }
        routine.setProcedure(statement);
    }

    int verifyReturnStatement(Statement stat, int level) {
        if (stat instanceof StatementExpression && stat.type == 58) {
            return 0;
        }
        int result = -1;
        if (stat instanceof StatementCompound) {
            StatementCompound compoundStatement = (StatementCompound)stat;
            for (Statement temp : compoundStatement.getStatements()) {
                int currentResult = this.verifyReturnStatement(temp, level + 1);
                if (level == 0 && currentResult == 0) {
                    return 0;
                }
                if (currentResult < 0) continue;
                if (compoundStatement.type == 88 || compoundStatement.type == 3177 || compoundStatement.type == 86) {
                    currentResult = 1;
                    if (result < 0) {
                        result = 1;
                    }
                }
                if (result >= 0) continue;
                result = currentResult;
            }
        }
        return result;
    }

    final Object[] readLocalDeclarationList(RplScript routine, StatementCompound context) {
        RangeVariable[] rangeVariables;
        HsqlArrayList list = new HsqlArrayList();
        boolean table = false;
        boolean variableOrCondition = true;
        int cursor = 2;
        int handler = 3;
        int objectType = 0;
        RangeVariable[] rangeVariableArray = rangeVariables = context == null ? routine.getParameterRangeVariables() : context.getRangeVariables();
        while (this.token.tokenType == 77) {
            Object var = null;
            switch (objectType) {
                case 0: {
                    var = this.readLocalTableVariableDeclarationOrNull(routine);
                    if (var == null) {
                        objectType = 1;
                        break;
                    }
                    list.add(var);
                    this.readThis(791);
                    break;
                }
                case 1: {
                    var = this.readLocalVariableDeclarationOrNull(true);
                    if (var == null) {
                        objectType = 2;
                        break;
                    }
                    list.addAll((Object[])var);
                    break;
                }
                case 2: {
                    var = this.compileDeclareCursor(true, rangeVariables);
                    if (var == null) {
                        objectType = 3;
                        break;
                    }
                    list.add(var);
                    this.readThis(791);
                    break;
                }
                case 3: {
                    var = this.compileLocalHandlerDeclaration(routine, context);
                    list.add(var);
                }
            }
        }
        Object[] declarations = new Object[list.size()];
        list.toArray(declarations);
        return declarations;
    }

    Collection readLocalTableVariableDeclarationOrNull(RplScript routine) {
        int position = super.getPosition();
        this.readThis(77);
        if (this.token.tokenType == 278) {
            this.read();
            NameManager.ObjectName name = super.readNewSchemaObjectName(3, false);
            name.schema = SqlInvariants.MODULE_NAME;
            TableCollection collection = new TableCollection(this.store, name, MemoryModel.MEMORY, 12);
            Table table = collection.getBaseTable();
            this.readTableDefinition(routine, table);
            return collection;
        }
        this.rewind(position);
        return null;
    }

    ColumnSchema[] readLocalVariableDeclarationOrNull(boolean withSemicolon) {
        Type type;
        int position = super.getPosition();
        NameManager.ObjectName[] names = NameManager.ObjectName.emptyArray;
        try {
            this.readThis(77);
            if (this.isReservedKey()) {
                this.rewind(position);
                return null;
            }
            while (true) {
                names = (NameManager.ObjectName[])ArrayUtil.resizeArray(names, names.length + 1);
                names[names.length - 1] = super.readNewSchemaObjectName(23, false);
                if (this.token.tokenType != 774) break;
                this.read();
            }
            type = this.readTypeDefinition(false, true);
        }
        catch (Exception e) {
            this.rewind(position);
            return null;
        }
        Expression def = null;
        if (this.token.tokenType == 78) {
            this.read();
            def = this.readDefaultClause(type);
        }
        ColumnSchema[] variable = new ColumnSchema[names.length];
        for (int i = 0; i < names.length; ++i) {
            variable[i] = new ColumnSchema(names[i], type, true, false, def);
            variable[i].setParameterMode((byte)2);
        }
        if (withSemicolon) {
            this.readThis(791);
        } else {
            this.readIfThis(791);
        }
        return variable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NameManager.ObjectName[] readLocalVariableDeclarationAndAddJavaStyle(StatementCompound context, boolean transientVar) {
        Type type;
        int position = super.getPosition();
        NameManager.ObjectName[] names = NameManager.ObjectName.emptyArray;
        Expression[] defaults = new Expression[]{};
        HashMap<String, Expression> transientVarsInitials = new HashMap<String, Expression>();
        String tokenPrefix = this.readTokenPrefixName();
        if (tokenPrefix != null && this.store.schemaManager.findSchema(tokenPrefix) == null) {
            this.rewind(position);
            return names;
        }
        try {
            boolean originalTypeIsArray;
            String typeName = this.token.tokenString;
            try {
                this.scanner.mightExpectBracket = true;
                type = this.readTypeDefinition(false, true);
            }
            finally {
                this.scanner.mightExpectBracket = false;
            }
            if (type == null) {
                throw this.unexpectedToken();
            }
            boolean bl = originalTypeIsArray = type.isArrayType() || "byte".equalsIgnoreCase(typeName) && type.isBinaryType();
            if (this.isReservedKey()) {
                String reservedKey = this.scanner.token.tokenString;
                this.rewind(position);
                throw new DataspaceException("Identifier '" + reservedKey + "' is a reserved keyword and can't be used.");
            }
            position = this.getPosition();
            while (true) {
                try {
                    this.scanner.mightExpectBracket = true;
                    names = (NameManager.ObjectName[])ArrayUtil.resizeArray(names, names.length + 1);
                    names[names.length - 1] = super.readNewSchemaObjectName(transientVar ? 33 : 23, false);
                }
                finally {
                    this.scanner.mightExpectBracket = false;
                }
                type = this.readArrayType(type, 0, typeName, false, originalTypeIsArray);
                defaults = (Expression[])ArrayUtil.resizeArray(defaults, defaults.length + 1);
                defaults[defaults.length - 1] = this.createArrayDefaults(type);
                if (this.token.tokenType == 396) {
                    this.read();
                    if (this.token.tokenType == 251) {
                        this.XreadSubqueryBody(RangeVariable.emptyArray, 22);
                    } else {
                        this.completeSelectStatement(false, this.token.tokenType == 794);
                        Expression expression = this.XreadValueExpressionWithContext();
                        if (transientVar) {
                            transientVarsInitials.put(names[names.length - 1].name, expression);
                        }
                    }
                }
                if (this.token.tokenType == 774) {
                    this.read();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.rewind(position);
            throw e;
        }
        if (!transientVar) {
            this.rewind(position);
        }
        for (int i = 0; i < names.length; ++i) {
            ColumnSchema variable = new ColumnSchema(names[i], type, true, false, defaults[i]);
            variable.setParameterMode((byte)2);
            if (context != null) {
                if (transientVar) {
                    Object initialValue = null;
                    Expression expr = (Expression)transientVarsInitials.get(names[i].name);
                    if (expr != null) {
                        expr.resolveTypes(this.session, null);
                        initialValue = expr.getValue(this.session);
                    }
                    context.addTransientVariable(variable, initialValue);
                    continue;
                }
                context.addLocalVariable(variable);
                continue;
            }
            this.session.sessionContext.addSessionVariable(variable);
        }
        return names;
    }

    final StatementHandler compileLocalHandlerDeclaration(RplScript routine, StatementCompound context) {
        this.readThis(77);
        int handlerType = switch (this.token.tokenType) {
            case 376 -> {
                this.read();
                yield 5;
            }
            case 102 -> {
                this.read();
                yield 6;
            }
            case 297 -> {
                this.read();
                yield 7;
            }
            default -> throw this.unexpectedToken();
        };
        this.readThis(124);
        this.readThis(112);
        StatementHandler handler = new StatementHandler(handlerType);
        boolean end = false;
        boolean start = true;
        block12: while (!end) {
            int conditionType = 0;
            switch (this.token.tokenType) {
                case 774: {
                    if (start) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    start = true;
                    continue block12;
                }
                case 263: {
                    conditionType = 4;
                }
                case 262: {
                    if (conditionType == 0) {
                        conditionType = 1;
                    }
                }
                case 264: {
                    if (conditionType == 0) {
                        conditionType = 2;
                    }
                }
                case 183: {
                    if (conditionType == 0) {
                        conditionType = 3;
                    }
                    if (!start) {
                        throw this.unexpectedToken();
                    }
                    start = false;
                    this.read();
                    if (conditionType == 3) {
                        this.readThis(404);
                    } else if (conditionType == 4) {
                        String sqlState = this.parseSQLStateValue();
                        handler.addConditionState(sqlState);
                        continue block12;
                    }
                    handler.addConditionType(conditionType);
                    continue block12;
                }
            }
            if (start) {
                throw this.unexpectedToken();
            }
            end = true;
        }
        if (this.token.tokenType == 791) {
            this.read();
        } else {
            Statement e = this.compileSQLProcedureStatementOrNull(routine, context);
            if (e == null) {
                throw this.unexpectedToken();
            }
            this.readThis(791);
            handler.addStatement(e);
        }
        return handler;
    }

    String parseSQLStateValue() {
        this.readIfThis(307);
        this.checkIsValue(1);
        String sqlState = this.token.tokenString;
        if (this.token.tokenString.length() != 5) {
            throw Error.error(5607);
        }
        this.read();
        return sqlState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Statement compileCompoundStatement(RplScript routine, StatementCompound context, NameManager.ObjectName label) {
        boolean atomic = true;
        boolean openBracket = false;
        if (this.token.tokenType == 792) {
            this.readThis(792);
            openBracket = true;
        } else {
            this.readThis(17);
            if (!this.readIfThis(526)) {
                this.readIfThis(1018);
            }
        }
        StatementCompound statement = new StatementCompound(12, label);
        statement.setAtomic(true);
        statement.setRoot(routine);
        statement.setParent(context);
        StatementCompound prevStat = this.session.sessionContext.compoundStatementContext;
        this.session.sessionContext.compoundStatementContext = statement;
        try {
            Object[] declarations = this.readLocalDeclarationList(routine, context);
            statement.setLocalDeclarations(declarations);
            this.session.sessionContext.pushRoutineCollections(statement.scopeTables);
            try {
                Statement[] statements = this.compileSQLProcedureStatementList(routine, statement);
                statement.setStatements(statements);
            }
            finally {
                this.session.sessionContext.popRoutineCollections();
            }
        }
        finally {
            this.session.sessionContext.compoundStatementContext = prevStat;
        }
        if (this.lastError != null) {
            throw this.lastError;
        }
        if (openBracket) {
            this.readThis(793);
        } else {
            this.readThis(94);
            if (this.isSimpleName() && !this.isReservedKey()) {
                if (label == null) {
                    throw this.unexpectedToken();
                }
                if (!label.name.equals(this.token.tokenString)) {
                    throw Error.error(5508, this.token.tokenString);
                }
                this.read();
            }
        }
        return statement;
    }

    final Statement[] compileSQLProcedureStatementList(RplScript routine, StatementCompound context) {
        Statement stat;
        HsqlArrayList list = new HsqlArrayList();
        while ((stat = this.compileSQLProcedureStatementOrNull(routine, context)) != null) {
            while (this.token.tokenType == 791) {
                this.read();
            }
            list.add(stat);
        }
        Statement[] statements = new Statement[list.size()];
        list.toArray(statements);
        return statements;
    }

    abstract Statement compileCreate();

    abstract Statement compileDefineKGraphDefinition();

    abstract Statement compileRedefineKGraphDefinition();

    abstract Statement compileAlter();

    abstract Statement compileDrop();

    abstract Statement compileFileTableLinkUnlink(boolean var1);

    abstract Statement compileSnapshotLinkUnlink(boolean var1);

    /*
     * Exception decompiling
     */
    public Statement compileSQLProcedureStatementOrNull(RplScript routine, StatementCompound context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 7[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    final Statement compileTransientVariable(RplScript routine, StatementCompound context, boolean preserveRows) {
        SchemaObject collection = null;
        int position = super.getPosition();
        switch (this.token.tokenType) {
            case 278: {
                this.read();
                NameManager.ObjectName name = super.readNewSchemaObjectName(4, false);
                name.schema = SqlInvariants.MODULE_NAME;
                if (this.token.tokenType == 396) {
                    this.read();
                    Expression expr = this.XreadValueExpressionWithContext();
                    if (expr instanceof FunctionSQLInvoked) {
                        this.resolveOuterReferencesAndTypes(context.getRangeVariables(), expr);
                        Collection returnCollection = ((FunctionSQLInvoked)expr).routine.returnCollection;
                        collection = new TableCollection(this.store, name, MemoryModel.MEMORY, 12);
                        Table baseTable = returnCollection.getBaseTable();
                        Table newBaseTable = collection.getBaseTable();
                        for (int i = 0; i < baseTable.getColumnCount(); ++i) {
                            newBaseTable.addColumn(baseTable.getColumn(i));
                        }
                        newBaseTable.createPrimaryKey();
                        newBaseTable.persistenceId = baseTable.persistenceId;
                        if (context == null) break;
                        context.addTransientCollection((Collection)collection);
                        break;
                    }
                    throw new DataspaceException("Transient collection can only be initialized from function call which returns collection.");
                }
                collection = new TableCollection(this.store, name, MemoryModel.MEMORY, 12);
                this.readTableDefinition(routine, collection.getBaseTable());
                if (context == null) break;
                context.addTransientCollection((Collection)collection);
                break;
            }
            case 436: {
                this.read();
                NameManager.ObjectName name = super.readNewSchemaObjectName(4, false);
                name.schema = SqlInvariants.MODULE_NAME;
                this.readThis(786);
                Type keyType = this.readTypeDefinition(false, true);
                this.readThis(774);
                Type valueType = this.readTypeDefinition(false, true);
                this.readThis(772);
                collection = new MapCollection(this.session.dataspaceStore, name, MemoryModel.MEMORY);
                ((MapCollection)collection).defineKeyColumn(keyType, keyType.getNameString());
                ((MapCollection)collection).defineValueColumn(valueType, valueType.getNameString());
                if (context == null) break;
                context.addTransientCollection((Collection)collection);
                break;
            }
            case 908: {
                this.read();
                NameManager.ObjectName name = super.readNewSchemaObjectName(4, false);
                name.schema = SqlInvariants.MODULE_NAME;
                this.readThis(786);
                Type queueObjectType = this.readTypeDefinition(false, true);
                this.readThis(772);
                collection = new BlockingQueueCollection(this.session.dataspaceStore, name, MemoryModel.MEMORY);
                ((BlockingQueueCollection)collection).setConstraint(queueObjectType);
                if (context == null) break;
                context.addTransientCollection((Collection)collection);
                break;
            }
        }
        if (collection != null) {
            String currentSql = this.scanner.sqlString;
            int currentPosition = super.getPosition();
            HsqlArrayList recStat = this.recordedStatement;
            boolean isRecordingValue = this.isRecording;
            this.recordedStatement = null;
            collection.compile(this.session, null);
            collection.getBaseTable().persistenceScope = preserveRows ? 22 : 21;
            this.session.sessionContext.addSessionCollection((Collection)collection);
            if (!this.isCompleteMode()) {
                collection.compileInternalStatements(this.session);
            }
            this.reset(currentSql);
            this.rewind(currentPosition);
            this.recordedStatement = recStat;
            this.isRecording = isRecordingValue;
            return new StatementSession(3170, new Object[]{collection});
        }
        this.rewind(position);
        NameManager.ObjectName[] names = this.readLocalVariableDeclarationAndAddJavaStyle(context, true);
        if (names.length > 0) {
            return new StatementSession(1076, new Object[]{false, null});
        }
        throw this.unexpectedToken();
    }

    /*
     * Unable to fully structure code
     */
    final Statement compileTypeDefinitionMethodCallOrFunctionUnitCall(StatementCompound context) {
        block23: {
            cs = null;
            rangeVariables = null;
            rangeVariables = context != null ? context.getRangeVariables() : this.session.sessionContext.sessionVariablesRange;
            if (this.isTypeToken(true) || this.getDataspaceCollectionType() != null) {
                tokenType = this.token.tokenType;
                names = this.readLocalVariableDeclarationAndAddJavaStyle(context, false);
                if (context != null && names.length > 0) {
                    rangeVariables = context.getRangeVariables();
                }
                try {
                    currentPosition = super.getPosition();
                    cs = this.compileSetStatement(rangeVariables, false, true);
                    if (cs == null && names.length > 0) {
                        cs = new StatementSession(1076, new Object[]{false, null});
                    }
                    if (tokenType == 901 && (this.token.tokenType == 13 || this.token.tokenType == 794)) {
                        throw this.unexpectedToken();
                    }
                    if (cs != null) ** GOTO lbl35
                    this.rewind(currentPosition);
                }
                catch (Exception exception) {
                    if (names.length > 0) {
                        this.session.sessionContext.removeSessionVariables(names);
                    }
                    throw exception;
                }
            } else {
                currentPosition = super.getPosition();
                try {
                    cs = this.compileSetStatement(rangeVariables, false, false);
                    if (cs == null) {
                        this.rewind(currentPosition);
                    }
                }
                catch (DataspaceException error) {
                    this.rewind(currentPosition);
                    if (error.getErrorCode() == 2500 || error.getErrorCode() == -5561 || error.getErrorCode() == -5612) {
                        throw error;
                    }
                    if (!this.isObjectNotFoundException(error) || this.lastError != null && this.lastError.getLevel() >= error.getLevel()) break block23;
                    this.lastError = error;
                }
            }
        }
        if (cs == null && this.token.tokenType != 848 && this.token.tokenType != 94 && this.token.tokenType != 793) {
            currentPosition = super.getPosition();
            try {
                expr = this.XreadValueExpressionWithContext();
                if (expr != null) {
                    if (expr.opType == 103 && expr.nodes != null && expr.nodes.length == 1 && expr.nodes[0].opType == 2) {
                        expr.nodes[0].canBeStaticCall = 1;
                    }
                    this.resolveOuterReferencesAndTypes(rangeVariables, expr);
                    statExpr = new StatementExpression(this.session, this.compileContext, 3125, expr);
                    cs = statExpr;
                } else {
                    this.rewind(currentPosition);
                }
            }
            catch (DataspaceCompleteException ex) {
                throw ex;
            }
            catch (DataspaceException ex) {
                if (ex.getLineNumber() == -1) {
                    this.initPositions(ex);
                }
                if (this.lastError == null || this.lastError.getLevel() < ex.getLevel()) {
                    this.lastError = ex;
                }
                this.rewind(currentPosition);
            }
            catch (Exception ex) {
                if (this.lastError == null) {
                    this.lastError = new DataspaceException(ex.getMessage());
                }
                this.rewind(currentPosition);
            }
        }
        return cs;
    }

    final Statement compileReturnValue(RplScript routine, StatementCompound context) {
        Expression e = this.XreadValueExpressionOrNull();
        if (e == null) {
            this.checkIsValue();
            if (this.token.tokenValue == null) {
                e = new ExpressionValue(null, null);
            }
        }
        try {
            this.resolveOuterReferencesAndTypes(routine, context, e);
        }
        catch (DataspaceException ex) {
            if (e instanceof ExpressionColumn && context != null && context.hasTransientCollection(e.getColumnName())) {
                Collection transientCollection = context.getTransientCollection(e.getColumnName());
                QuerySpecification query = new QuerySpecification(this.session, transientCollection.getBaseTable(), this.compileContext, false);
                query.resolve(this.session);
                SubQuery sq = new SubQuery(this.store, this.compileContext.subqueryDepth, (QueryExpression)query, 23);
                e = new Expression(23, sq);
                this.resolveOuterReferencesAndTypes(routine, context, e);
                this.read();
            }
            this.initPositions(ex);
            throw ex;
        }
        if (routine.isProcedure()) {
            throw Error.error(5602);
        }
        return new StatementExpression(this.session, this.compileContext, 58, e);
    }

    final Statement compileIterate() {
        this.readThis(143);
        NameManager.ObjectName label = this.readNewSchemaObjectName(22, false);
        return new StatementSimple(102, label);
    }

    final Statement compileLeave(RplScript routine, StatementCompound context) {
        this.readThis(152);
        NameManager.ObjectName label = this.readNewSchemaObjectName(22, false);
        return new StatementSimple(89, label);
    }

    final Statement compileWhile(RplScript routine, StatementCompound context, NameManager.ObjectName label) {
        Statement[] statements;
        this.readThis(322);
        this.readThis(786);
        Expression e = this.XreadBooleanValueExpression();
        this.readThis(772);
        this.resolveOuterReferencesAndTypes(routine, context, e);
        StatementExpression condition = new StatementExpression(this.session, this.compileContext, 1201, e);
        boolean blockStatment = this.token.tokenType == 792;
        HsqlArrayList list = new HsqlArrayList();
        if (blockStatment) {
            this.readThis(792);
            statements = this.compileSQLProcedureStatementList(routine, context);
            for (int i = 0; i < statements.length; ++i) {
                list.add(statements[i]);
            }
            this.readThis(793);
        } else {
            Statement stat = this.compileSQLProcedureStatementOrNull(routine, context);
            list.add(stat);
            while (this.token.tokenType == 791) {
                this.read();
            }
        }
        statements = new Statement[list.size()];
        list.toArray(statements);
        if (label != null && this.isSimpleName() && !this.isReservedKey()) {
            if (!label.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound statement = new StatementCompound(97, label);
        statement.setStatements(statements);
        statement.setCondition(condition);
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Statement compileTryCatch(RplScript routine, StatementCompound context) {
        this.readThis(1019);
        StatementCompound statement = new StatementCompound(3126, null);
        statement.setAtomic(true);
        statement.setRoot(routine);
        statement.setParent(context);
        StatementCompound prevStat = this.session.sessionContext.compoundStatementContext;
        this.session.sessionContext.compoundStatementContext = statement;
        try {
            Object[] declarations = this.readLocalDeclarationList(routine, context);
            statement.setLocalDeclarations(declarations);
            this.session.sessionContext.pushRoutineCollections(statement.scopeTables);
            try {
                HsqlArrayList list = new HsqlArrayList();
                this.readBlockOrSingleStatement(list, routine, statement);
                if (list.size() == 0) {
                    throw this.unexpectedToken();
                }
                Statement[] tryStatements = new Statement[list.size()];
                list.toArray(tryStatements);
                statement.setStatements(tryStatements);
                boolean handlerSpecified = false;
                Statement[] catchStatements = null;
                if (this.token.tokenType == 1020) {
                    this.readThis(1020);
                    this.readThis(786);
                    handlerSpecified = true;
                    NameManager.ObjectName exceptionName = super.readNewSchemaObjectName(23, false);
                    Type exceptionType = Types.getParameterSQLType(this.session, LanguageException.class);
                    ColumnSchema exceptionVar = new ColumnSchema(exceptionName, exceptionType, true, false, null);
                    exceptionVar.setParameterMode((byte)2);
                    statement.addLocalVariable(exceptionVar);
                    statement.setExceptionName(exceptionName);
                    this.readThis(772);
                    list.clear();
                    this.readBlockOrSingleStatement(list, routine, statement);
                    if (list.size() > 0) {
                        catchStatements = new Statement[list.size()];
                        list.toArray(catchStatements);
                        statement.setCatchStatements(catchStatements);
                    }
                }
                Statement[] finallyStatements = null;
                if (this.token.tokenType == 1021) {
                    this.readThis(1021);
                    if (this.token.tokenType == 792) {
                        handlerSpecified = true;
                    }
                    list.clear();
                    this.readBlockOrSingleStatement(list, routine, statement);
                    if (list.size() > 0) {
                        finallyStatements = new Statement[list.size()];
                        list.toArray(finallyStatements);
                        statement.setFinallyStatements(finallyStatements);
                    }
                }
                if (!handlerSpecified) {
                    throw this.unexpectedToken("Invalid try statement syntax: 'catch' or 'finally' block has to be specified.");
                }
            }
            finally {
                this.session.sessionContext.popRoutineCollections();
            }
        }
        finally {
            this.session.sessionContext.compoundStatementContext = prevStat;
        }
        return statement;
    }

    final void processImportStatement(RplScript routine, StatementCompound context) {
        String className = this.token.tokenString;
        this.read();
        String alias = null;
        if (this.token.tokenType == 10) {
            this.readThis(10);
            alias = this.token.tokenString;
            this.read();
        } else {
            int index = className.lastIndexOf(46);
            alias = index > 0 ? className.substring(index + 1) : className;
        }
        if (context != null) {
            context.addImportedType(alias, className);
        }
    }

    final void readBlockOrSingleStatement(HsqlArrayList list, RplScript routine, StatementCompound context) {
        boolean blockStatement;
        boolean bl = blockStatement = this.token.tokenType == 792;
        if (blockStatement) {
            this.readThis(792);
            Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
            for (int i = 0; i < statements.length; ++i) {
                list.add(statements[i]);
            }
            this.readThis(793);
        } else {
            Statement stat = this.compileSQLProcedureStatementOrNull(routine, context);
            if (stat != null) {
                list.add(stat);
                while (this.token.tokenType == 791) {
                    this.read();
                }
            }
        }
    }

    final Statement compileRepeat(RplScript routine, StatementCompound context, NameManager.ObjectName label) {
        this.readThis(234);
        Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
        this.readThis(302);
        Expression e = this.XreadBooleanValueExpression();
        this.resolveOuterReferencesAndTypes(routine, context, e);
        StatementExpression condition = new StatementExpression(this.session, this.compileContext, 1201, e);
        this.readThis(94);
        this.readThis(234);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (label == null) {
                throw this.unexpectedToken();
            }
            if (!label.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound statement = new StatementCompound(95, label);
        statement.setStatements(statements);
        statement.setCondition(condition);
        return statement;
    }

    final Statement compileLoop(RplScript routine, StatementCompound context, NameManager.ObjectName label) {
        this.readThis(160);
        Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
        this.readThis(94);
        this.readThis(160);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (label == null) {
                throw this.unexpectedToken();
            }
            if (!label.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound result = new StatementCompound(90, label);
        result.setStatements(statements);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Statement compileFor(RplScript routine, StatementCompound context, NameManager.ObjectName label) {
        RangeVariable[] rangeVariables = context == null ? routine.getParameterRangeVariables() : context.getRangeVariables();
        this.readThis(112);
        if (this.token.tokenType == 251) {
            return this.compileForSelect(routine, context, label);
        }
        this.readThis(786);
        StatementQuery cursorStatement = null;
        Statement initStat = null;
        StatementExpression condition = null;
        ArrayList<Statement> loopStatements = new ArrayList<Statement>();
        NameManager.ObjectName loopVarName = null;
        Expression foreachExpression = null;
        int currentPosition = super.getPosition();
        Exception cursorException = null;
        try {
            cursorStatement = this.compileCursorSpecification(0, false, rangeVariables);
        }
        catch (Exception error) {
            this.rewind(currentPosition);
            cursorException = error;
            cursorStatement = null;
        }
        StatementCompound forStatement = new StatementCompound(46, label);
        forStatement.setAtomic(true);
        forStatement.setRoot(routine);
        forStatement.setParent(context);
        StatementCompound prevStat = this.session.sessionContext.compoundStatementContext;
        this.session.sessionContext.compoundStatementContext = forStatement;
        try {
            Object[] declarations = this.readLocalDeclarationList(routine, forStatement);
            forStatement.setLocalDeclarations(declarations);
            if (cursorStatement == null) {
                block25: {
                    if (this.token.tokenType != 791) {
                        try {
                            initStat = this.compileSQLProcedureStatementOrNull(routine, forStatement);
                        }
                        catch (Exception exception) {
                            if (!this.isObjectNotFoundException(cursorException)) break block25;
                            this.lastError = (DataspaceException)cursorException;
                            throw (DataspaceException)cursorException;
                        }
                    }
                }
                if (initStat != null && this.token.tokenType == 773 && forStatement.variables != null && forStatement.variables.length == 1) {
                    loopVarName = forStatement.variables[0].getObjectName();
                    this.readThis(773);
                    foreachExpression = this.XreadValueExpressionWithContext();
                    this.resolveOuterReferencesAndTypes(routine, forStatement, foreachExpression);
                } else {
                    this.readThis(791);
                    if (this.token.tokenType != 791) {
                        Expression conditionExpression = this.XreadBooleanValueExpression();
                        condition = new StatementExpression(this.session, this.compileContext, 1201, conditionExpression);
                        this.resolveOuterReferencesAndTypes(routine, forStatement, conditionExpression);
                    }
                    this.readThis(791);
                    while (this.token.tokenType != 772) {
                        Statement stat = this.compileSQLProcedureStatementOrNull(routine, forStatement);
                        if (stat == null) {
                            throw this.unexpectedToken();
                        }
                        loopStatements.add(stat);
                        if (this.token.tokenType != 774) continue;
                        this.read();
                    }
                }
            }
            this.readThis(772);
            if (cursorStatement != null) {
                forStatement.setLoopStatement(cursorStatement);
            } else if (loopVarName != null && foreachExpression != null) {
                forStatement.setForeachVarName(loopVarName);
                forStatement.setExpression(foreachExpression);
            } else {
                forStatement.setInitStat(initStat);
                forStatement.setCondition(condition);
                if (loopStatements.size() > 0) {
                    Statement[] loopStatArray = new Statement[loopStatements.size()];
                    loopStatArray = loopStatements.toArray(loopStatArray);
                    forStatement.setLoopStatements(loopStatArray);
                }
            }
            Statement[] statements = null;
            if (this.token.tokenType == 792) {
                this.readThis(792);
                statements = this.compileSQLProcedureStatementList(routine, forStatement);
                this.readThis(793);
            } else {
                Statement temp = this.compileSQLProcedureStatementOrNull(routine, forStatement);
                statements = new Statement[]{temp};
                while (this.token.tokenType == 791) {
                    this.read();
                }
            }
            if (label != null && this.isSimpleName() && !this.isReservedKey()) {
                if (!label.name.equals(this.token.tokenString)) {
                    throw Error.error(5508, this.token.tokenString);
                }
                this.read();
            }
            forStatement.setStatements(statements);
            StatementCompound statementCompound = forStatement;
            return statementCompound;
        }
        finally {
            this.session.sessionContext.compoundStatementContext = prevStat;
        }
    }

    final Statement compileForSelect(RplScript routine, StatementCompound context, NameManager.ObjectName label) {
        RangeVariable[] rangeVariables = context == null ? routine.getParameterRangeVariables() : context.getRangeVariables();
        StatementQuery cursorStatement = this.compileCursorSpecification(0, false, rangeVariables);
        this.readThis(86);
        StatementCompound forStatement = new StatementCompound(46, label);
        forStatement.setAtomic(true);
        forStatement.setRoot(routine);
        forStatement.setParent(context);
        forStatement.setLoopStatement(cursorStatement);
        Statement[] statements = this.compileSQLProcedureStatementList(routine, forStatement);
        this.readThis(94);
        this.readThis(112);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (label == null) {
                throw this.unexpectedToken();
            }
            if (!label.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        forStatement.setStatements(statements);
        return forStatement;
    }

    protected boolean isObjectNotFoundException(Exception exception) {
        return exception instanceof DataspaceException && (((DataspaceException)exception).getErrorCode() == -5501 || ((DataspaceException)exception).getErrorCode() == -4850);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Statement compileSwitch(RplScript routine, StatementCompound context, NameManager.ObjectName label) {
        this.readThis(1067);
        Expression switchExpression = null;
        ArrayList<Pair<Expression, Statement>> switchStatements = new ArrayList<Pair<Expression, Statement>>();
        StatementCompound switchStatement = new StatementCompound(3177, label);
        switchStatement.setAtomic(true);
        switchStatement.setRoot(routine);
        switchStatement.setParent(context);
        StatementCompound prevStat = this.session.sessionContext.compoundStatementContext;
        this.session.sessionContext.compoundStatementContext = switchStatement;
        try {
            Object[] declarations = this.readLocalDeclarationList(routine, context);
            switchStatement.setLocalDeclarations(declarations);
            this.readThis(786);
            switchExpression = this.XreadAllTypesCommonValueExpression(false);
            this.resolveOuterReferencesAndTypes(routine, switchStatement, switchExpression);
            switchStatement.setExpression(switchExpression);
            this.readThis(772);
            this.readThis(792);
            while (this.token.tokenType != 793) {
                this.readThis(29);
                Expression caseExp = this.XreadAllTypesCommonValueExpression(false);
                this.resolveOuterReferencesAndTypes(routine, switchStatement, caseExp);
                this.readThis(773);
                Statement stat = this.compileSQLProcedureStatementOrNull(routine, context);
                switchStatements.add(new Pair<Expression, Statement>(caseExp, stat));
                while (this.token.tokenType == 791) {
                    this.read();
                }
            }
            this.readThis(793);
            switchStatement.setSwitchStatements(switchStatements);
        }
        finally {
            this.session.sessionContext.compoundStatementContext = prevStat;
        }
        return switchStatement;
    }

    final Statement compileIf(RplScript routine, StatementCompound context) {
        Statement stat;
        int i;
        Statement[] statements;
        boolean isSingleStat;
        HsqlArrayList list = new HsqlArrayList();
        this.readThis(412);
        this.readThis(786);
        Expression e = this.XreadBooleanValueExpression();
        this.readThis(772);
        this.resolveOuterReferencesAndTypes(routine, context, e);
        StatementExpression statement = new StatementExpression(this.session, this.compileContext, 1201, e);
        list.add(statement);
        boolean bl = isSingleStat = this.token.tokenType != 792;
        if (!isSingleStat) {
            this.readThis(792);
            statements = this.compileSQLProcedureStatementList(routine, context);
            if (statements.length > 0) {
                for (i = 0; i < statements.length; ++i) {
                    list.add(statements[i]);
                }
            } else {
                list.add(new StatementExpression(this.session, this.compileContext, 3125, new ExpressionValue((Object)0, NumberType.SQL_INTEGER)));
            }
            this.readThis(793);
        } else {
            stat = this.compileSQLProcedureStatementOrNull(routine, context);
            list.add(stat);
            while (this.token.tokenType == 791) {
                this.read();
            }
        }
        while (this.token.tokenType == 93) {
            this.read();
            this.readThis(786);
            e = this.XreadBooleanValueExpression();
            this.readThis(772);
            this.resolveOuterReferencesAndTypes(routine, context, e);
            statement = new StatementExpression(this.session, this.compileContext, 1201, e);
            list.add(statement);
            boolean bl2 = isSingleStat = this.token.tokenType != 792;
            if (!isSingleStat) {
                this.readThis(792);
                statements = this.compileSQLProcedureStatementList(routine, context);
                this.readThis(793);
                if (statements.length > 0) {
                    for (i = 0; i < statements.length; ++i) {
                        list.add(statements[i]);
                    }
                    continue;
                }
                list.add(new StatementExpression(this.session, this.compileContext, 3125, new ExpressionValue((Object)0, NumberType.SQL_INTEGER)));
                continue;
            }
            stat = this.compileSQLProcedureStatementOrNull(routine, context);
            list.add(stat);
            while (this.token.tokenType == 791) {
                this.read();
            }
        }
        boolean elseFound = false;
        while (this.token.tokenType == 92) {
            this.read();
            if (this.token.tokenType == 412) {
                if (elseFound) {
                    throw this.unexpectedToken();
                }
                this.read();
                this.readThis(786);
                e = this.XreadBooleanValueExpression();
                this.readThis(772);
                this.resolveOuterReferencesAndTypes(routine, context, e);
                statement = new StatementExpression(this.session, this.compileContext, 1201, e);
                list.add(statement);
            } else {
                elseFound = true;
                e = Expression.EXPR_TRUE;
                statement = new StatementExpression(this.session, this.compileContext, 1201, e);
                list.add(statement);
            }
            boolean bl3 = isSingleStat = this.token.tokenType != 792;
            if (!isSingleStat) {
                this.readThis(792);
                Statement[] statements2 = this.compileSQLProcedureStatementList(routine, context);
                this.readThis(793);
                if (statements2.length > 0) {
                    for (int i2 = 0; i2 < statements2.length; ++i2) {
                        list.add(statements2[i2]);
                    }
                    continue;
                }
                list.add(new StatementExpression(this.session, this.compileContext, 3125, new ExpressionValue((Object)0, NumberType.SQL_INTEGER)));
                continue;
            }
            Statement stat2 = this.compileSQLProcedureStatementOrNull(routine, context);
            list.add(stat2);
            while (this.token.tokenType == 791) {
                this.read();
            }
        }
        Statement[] statements3 = new Statement[list.size()];
        list.toArray(statements3);
        StatementCompound result = new StatementCompound(88, null);
        result.setStatements(statements3);
        return result;
    }

    final Statement compileCase(RplScript routine, StatementCompound context) {
        Statement[] statements;
        HsqlArrayList list = new HsqlArrayList();
        Expression condition = null;
        this.readThis(29);
        list = this.token.tokenType == 314 ? this.readCaseWhen(routine, context) : this.readSimpleCaseWhen(routine, context);
        if (this.token.tokenType == 92) {
            this.read();
            condition = Expression.EXPR_TRUE;
            StatementExpression statement = new StatementExpression(this.session, this.compileContext, 1201, condition);
            list.add(statement);
            statements = this.compileSQLProcedureStatementList(routine, context);
            for (int i = 0; i < statements.length; ++i) {
                list.add(statements[i]);
            }
        }
        this.readThis(94);
        this.readThis(29);
        statements = new Statement[list.size()];
        list.toArray(statements);
        StatementCompound result = new StatementCompound(88, null);
        result.setStatements(statements);
        return result;
    }

    final HsqlArrayList readSimpleCaseWhen(RplScript routine, StatementCompound context) {
        HsqlArrayList list = new HsqlArrayList();
        Expression condition = null;
        Expression predicand = this.XreadRowValuePredicand();
        do {
            this.readThis(314);
            while (true) {
                Expression newCondition;
                if (predicand == (newCondition = this.XreadPredicateRightPart(predicand))) {
                    newCondition = new ExpressionLogical(predicand, this.XreadRowValuePredicand());
                }
                this.resolveOuterReferencesAndTypes(routine, context, newCondition);
                condition = condition == null ? newCondition : new ExpressionLogical(50, condition, newCondition);
                if (this.token.tokenType != 774) break;
                this.read();
            }
            StatementExpression statement = new StatementExpression(this.session, this.compileContext, 1201, condition);
            list.add(statement);
            this.readThis(280);
            Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
            for (int i = 0; i < statements.length; ++i) {
                list.add(statements[i]);
            }
        } while (this.token.tokenType == 314);
        return list;
    }

    final HsqlArrayList readCaseWhen(RplScript routine, StatementCompound context) {
        HsqlArrayList list = new HsqlArrayList();
        Expression condition = null;
        do {
            this.readThis(314);
            condition = this.XreadBooleanValueExpression();
            this.resolveOuterReferencesAndTypes(routine, context, condition);
            StatementExpression statement = new StatementExpression(this.session, this.compileContext, 1201, condition);
            list.add(statement);
            this.readThis(280);
            Statement[] statements = this.compileSQLProcedureStatementList(routine, context);
            for (int i = 0; i < statements.length; ++i) {
                list.add(statements[i]);
            }
        } while (this.token.tokenType == 314);
        return list;
    }

    final Statement compileThrowException(RplScript routine, StatementCompound context, NameManager.ObjectName label) {
        this.readThis(945);
        if (this.token.tokenType == 397) {
            this.readThis(397);
            this.readThis(263);
            String errorMessage = null;
            if (this.token.tokenType == 933) {
                this.readThis(933);
                errorMessage = this.readQuotedString();
            }
            String sqlState = this.parseSQLStateValue();
            StatementSimple cs = new StatementSimple(92, sqlState, errorMessage);
            return cs;
        }
        Expression exp = this.XreadValueExpressionOrNull();
        this.resolveOuterReferencesAndTypes(context.rangeVariables, exp);
        StatementSimple cs = new StatementSimple(92, exp);
        return cs;
    }

    final Statement compileBindEventProducer() {
        this.readThis(1029);
        this.readThis(1030);
        this.readThisNameTokenForCompleteMode(112);
        this.completeEventId(null);
        String eventId = this.token.tokenString;
        this.read();
        DataspaceSchema dataspace = this.session.dataspaceStore.schemaManager.findSchema(this.session.currentDataspace.name);
        return new StatementCommand(3130, new Object[]{dataspace, eventId});
    }

    final Statement compileRaise(RangeVariable[] rangeVars) {
        this.readThis(916);
        this.completeSimpleTree("event", "advisory", "exception", "request", "ack", "acknowledge");
        switch (this.token.tokenType) {
            case 925: {
                this.read();
                Expression raiseRequestExp = this.readRaiseRequestExpression(rangeVars);
                return new StatementCommand(3028, new Object[]{raiseRequestExp});
            }
            case 397: {
                this.readThis(397);
                Expression exp = this.XreadValueExpressionOrNull();
                this.resolveOuterReferencesAndTypes(rangeVars, exp);
                String eventId = null;
                if (this.readIfThisTokenOrComplete(194, true)) {
                    eventId = this.token.tokenString;
                    this.read();
                }
                return new StatementCommand(3027, new Object[]{eventId, exp});
            }
            case 1038: 
            case 1167: {
                Object[] params;
                Object eventOrEventId;
                this.read();
                this.completeSimpleTree("for", "on");
                if (this.token.tokenType == 112) {
                    this.read();
                    eventOrEventId = this.XreadValueExpressionOrNull();
                    this.resolveOuterReferencesAndTypes(rangeVars, (Expression)eventOrEventId);
                    params = this.readAckParameters(rangeVars, false);
                } else if (this.token.tokenType == 194) {
                    if (this.scanner.currentCharacter() == 91) {
                        this.read();
                        eventOrEventId = this.token.tokenString;
                        this.read();
                    } else {
                        this.read();
                        eventOrEventId = this.XreadValueExpressionOrNull();
                        this.resolveOuterReferencesAndTypes(rangeVars, (Expression)eventOrEventId);
                    }
                    params = this.readAckParameters(rangeVars, true);
                } else {
                    throw this.unexpectedToken();
                }
                return new StatementCommand(3289, new Object[]{eventOrEventId, params[0], params[1], params[2]});
            }
            case 586: 
            case 922: {
                this.read();
            }
        }
        Expression exp = this.XreadValueExpressionOrNull();
        this.resolveOuterReferencesAndTypes(rangeVars, exp);
        String eventId = null;
        if (this.readIfThisTokenOrComplete(194, true)) {
            eventId = this.token.tokenString;
            this.read();
        }
        EventScope eventScope = null;
        if (this.readIfThis(247)) {
            try {
                eventScope = EventScope.valueOf(this.token.tokenString.trim().toUpperCase());
                this.read();
                if (eventScope == EventScope.CLUSTER) {
                    throw new DataspaceException("Event scope CLUSTER is not supported.");
                }
            }
            catch (IllegalArgumentException ex) {
                throw this.unexpectedToken("Invalid event scope '" + this.token.tokenString + "' specified.");
            }
        }
        return new StatementCommand(3025, new Object[]{eventId, exp, eventScope});
    }

    private Object[] readAckParameters(RangeVariable[] rangeVars, boolean withEventId) {
        boolean end;
        Expression dataExp = null;
        boolean withSourceData = false;
        AcknowledgeAction acknowledgeAction = null;
        do {
            end = false;
            if (withEventId) {
                this.completeSimpleTree("with data", "action");
            } else {
                this.completeSimpleTree("with source data", "with data", "action");
            }
            switch (this.token.tokenType) {
                case 319: {
                    this.read();
                    if (withEventId) {
                        this.completeSimpleTree("data");
                    } else {
                        this.completeSimpleTree("source data", "data");
                    }
                    if (!withEventId && this.readIfThisTokenOrComplete(513, true)) {
                        this.readThisTokenOrComplete(378, true, true);
                        withSourceData = true;
                        break;
                    }
                    if (this.readIfThisTokenOrComplete(378, true)) {
                        dataExp = this.XreadValueExpressionOrNull();
                        this.resolveOuterReferencesAndTypes(rangeVars, dataExp);
                        break;
                    }
                    throw this.unexpectedToken();
                }
                case 332: {
                    this.read();
                    acknowledgeAction = this.readEnum(AcknowledgeAction.class);
                    break;
                }
                default: {
                    end = true;
                }
            }
        } while (!end);
        return Arrays.asList(new Object[]{dataExp, withSourceData, acknowledgeAction}).toArray();
    }

    Statement compileFind() {
        this.read();
        Expression findTextExp = this.readFindTextExpression();
        return new StatementCommand(3255, new Object[]{findTextExp});
    }

    final Statement compileQueueOperations() {
        switch (this.token.tokenType) {
            case 930: {
                this.readThis(930);
                this.readThis(141);
                SchemaObject collection = this.readSchemaObjectName(4);
                if (!(collection instanceof EventQueueCollection)) {
                    throw this.unexpectedToken("Event queue name should be specified.");
                }
                return new StatementCommand(3033, new Object[]{collection});
            }
            case 931: {
                this.readThis(931);
                this.readThis(115);
                SchemaObject collection = this.readSchemaObjectName(4);
                if (!(collection instanceof EventQueueCollection)) {
                    throw this.unexpectedToken("Event queue name should be specified.");
                }
                return new StatementCommand(3034, new Object[]{collection});
            }
        }
        throw this.unexpectedToken();
    }

    final StatementCommand compileTimerOperation(final int operation) {
        this.readNameTokenForCompleteMode();
        this.completeSchemaObject(new SchemaObjectFilter(){

            @Override
            public boolean filter(SchemaObject object) {
                if (object instanceof TimerObject) {
                    TimerObject timerObject = (TimerObject)object;
                    FabricTimer timer = FabricTimerManager.getInstance().getTimer(timerObject.getTimerGroup(), timerObject.getObjectName().name);
                    switch (operation) {
                        case 3075: {
                            return timer != null && timer.getState() == FabricTimerState.STARTED;
                        }
                        case 3076: {
                            return timer != null && timer.getState() == FabricTimerState.SUSPENDED;
                        }
                        case 3078: {
                            return timer == null || timer.getState() != FabricTimerState.STARTED;
                        }
                        case 3079: {
                            return timer != null;
                        }
                        case 3077: {
                            return timer != null;
                        }
                        case 3081: {
                            return timer != null;
                        }
                    }
                    return true;
                }
                return false;
            }
        }, 30);
        SchemaObject timer = this.readSchemaObjectName(30);
        return new StatementCommand(operation, new Object[]{timer});
    }

    final StatementCommand compileReplicaResumeSuspendStartStopStatement(int statementType) {
        this.readThisNameTokenForCompleteMode(1081);
        this.completeReplicationSourceNameGlobal(false);
        ReplicationEntityName replicaEntityName = this.readReplicationEntityName();
        boolean metrics = false;
        if (statementType == 3220) {
            this.completeSimpleTree(Arrays.asList(1119));
            if (this.readIfThis(1119)) {
                metrics = true;
            }
        }
        if (replicaEntityName.isLocalNode()) {
            this.store.schemaManager.getSchemaObject(replicaEntityName.getSourceOrReplicaName(), replicaEntityName.getDataspaceName(), 29);
        }
        return new StatementCommand(statementType, new Object[]{replicaEntityName, metrics});
    }

    final Statement compileRethrowException(RplScript routine, StatementCompound context, NameManager.ObjectName label) {
        String sqlState = null;
        String message = null;
        this.readThis(983);
        this.readThis(397);
        if (this.readIfThis(263)) {
            sqlState = this.parseSQLStateValue();
            if (this.readIfThis(254)) {
                this.readThis(441);
                this.readThis(396);
                message = this.readQuotedString();
            }
        }
        StatementSimple cs = new StatementSimple(91, sqlState, message);
        return cs;
    }

    final ColumnSchema readRoutineParameter(RplScript routine, boolean isParam) {
        Type typeObject;
        NameManager.ObjectName hsqlName = null;
        byte parameterMode = 1;
        boolean sqlFormatUsed = true;
        if (isParam) {
            switch (this.token.tokenType) {
                case 130: {
                    this.read();
                    break;
                }
                case 199: {
                    if (routine.getObjectType() != 18) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    parameterMode = 4;
                    break;
                }
                case 133: {
                    if (routine.getObjectType() == 18 || !routine.isAggregate()) {
                        // empty if block
                    }
                    this.read();
                    parameterMode = 2;
                    break;
                }
                default: {
                    sqlFormatUsed = false;
                }
            }
        }
        if (sqlFormatUsed || !this.isTypeToken(true)) {
            if (!this.isReservedKey()) {
                hsqlName = this.readNewDependentSchemaObjectName(routine.getObjectName(), 24);
            }
            this.completeTypes(true, false);
            typeObject = this.readTypeDefinition(false, true);
        } else {
            this.completeTypes(true, false);
            typeObject = this.readTypeDefinition(false, true);
            if (!this.isReservedKey()) {
                hsqlName = this.readNewDependentSchemaObjectName(routine.getObjectName(), 24);
            } else if (this.token.tokenString != null && this.token.tokenString.length() > 0) {
                throw this.initPositions(new DataspaceException("Unexpected reserved word '" + this.token.tokenString + "' encountered at position."));
            }
        }
        if (typeObject instanceof FlobType) {
            ((FlobType)typeObject).setLazy(true);
        }
        ColumnSchema column = new ColumnSchema(hsqlName, typeObject, true, false, null);
        if (isParam) {
            column.setParameterMode(parameterMode);
        }
        return column;
    }

    final Expression XreadAllTypesCommonValueExpressionAndResolve() {
        int pos = this.getPosition();
        try {
            Expression result = this.XreadAllTypesCommonValueExpression(false);
            if (result != null) {
                RangeVariable[] vars = null;
                vars = this.session.sessionContext.compoundStatementContext != null ? this.session.sessionContext.compoundStatementContext.getRangeVariables() : this.session.sessionContext.sessionVariablesRange;
                this.resolveOuterReferencesAndTypes(vars, result);
            }
            return result;
        }
        catch (DataspaceException error) {
            this.rewind(pos);
            throw error;
        }
    }

    final void completeCallStatement() {
        if (this.isCompleteMode()) {
            new ParserBase.PrefixDataspaceCompleter(this).completers(new FunctionSQLCompleter(), new SchemaObjectCompleter(this.session.dataspaceStore, this.session.currentDataspace.name, 17)).withRead(true).spaceFirst(true).throwException(true).complete();
        }
    }

    boolean readIfNotExists(boolean withComplete) {
        if (withComplete) {
            this.completeSimpleTree("if not exists");
            if (this.readIfThis(412)) {
                this.readThisTokenOrComplete(183, true, true);
                this.readThisTokenOrComplete(101, true, true);
                return true;
            }
            return false;
        }
        if (this.token.tokenType == 412) {
            int position = this.getPosition();
            this.read();
            if (this.token.tokenType == 183) {
                this.read();
                this.readThisTokenOrComplete(101, true, true);
                return true;
            }
            this.rewind(position);
        }
        return false;
    }

    Statement compilePrint(RplScript routine, StatementCompound context) {
        this.readThisTokenOrComplete(1155, true, true);
        this.readThisTokenOrComplete(786, true, true);
        Expression expression = this.XreadValueExpression();
        this.readThisTokenOrComplete(772, true, true);
        if (routine != null) {
            this.resolveOuterReferencesAndTypes(routine, context, expression);
        } else {
            this.resolveOuterReferencesAndTypes(this.session.sessionContext.sessionVariablesRange, expression);
        }
        return new StatementCommand(3278, new Object[]{expression});
    }

    final Statement compileExecBlock(RplScript routine, StatementCompound context) {
        ExecBlockExpression execBlockExpression = this.compileExecBlockExpression();
        if (routine != null) {
            this.resolveOuterReferencesAndTypes(routine, context, execBlockExpression);
        } else {
            this.resolveOuterReferencesAndTypes(this.session.sessionContext.sessionVariablesRange, execBlockExpression);
        }
        return new StatementCommand(3312, new Object[]{execBlockExpression});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ExecBlockExpression compileExecBlockExpression() {
        int startPosition = this.scanner.tokenPosition;
        this.readThis(1117);
        if (this.readIfThis(112)) {
            this.compileContext.isSchedulerExecBlock = true;
        }
        NameManager.ObjectName blocName = this.store.nameManager.newObjectName("exec_block", false, 32);
        if (this.token.tokenType != 792) {
            blocName = this.store.nameManager.newObjectName(this.readQuotedString(), false, 32);
        }
        try {
            int currentPosition = this.scanner.getPosition();
            RangeVariable[] rangeVars = new RangeVariable[1];
            blocName.setSchemaIfNull(this.session.currentDataspace);
            RplScript routine = this.compileRplRoutine(blocName, rangeVars);
            String rpl = this.scanner.sqlString.substring(currentPosition);
            ExecBlockExpression execBlockExpression = new ExecBlockExpression(routine, rpl);
            return execBlockExpression;
        }
        finally {
            this.compileContext.isSchedulerExecBlock = false;
        }
    }

    StatementSchema compileKGraphOperation(RangeVariable[] rangeVariables) {
        this.readThisTokenOrComplete(1202, true, true);
        this.completeSchemaObject(null, 46);
        KGraphInstanceSchemaObject kgraph = (KGraphInstanceSchemaObject)this.readSchemaObjectName(46);
        KGraphTypeSchemaObject kgraphType = kgraph.getKgraphType();
        this.completeSimpleTree("link");
        if (this.readIfThis(972)) {
            this.completeSchemaObject((SchemaObject o) -> kgraphType.getKnodes().contains(o), 43);
            SchemaObject subjectKNodeType = this.readSchemaObjectNameOrNull(43);
            Expression subjectKNodeKeyExpression = null;
            Expression subjectKNodeExpression = null;
            if (subjectKNodeType != null) {
                this.readThisTokenOrComplete(773, true, true);
                if (this.token.tokenType == 794) {
                    subjectKNodeKeyExpression = this.XreadSimpleValueExpressionPrimary();
                } else {
                    subjectKNodeKeyExpression = new ExpressionValue(this.token.tokenString, Type.STRING);
                    this.read();
                }
            } else {
                subjectKNodeExpression = this.XreadSimpleValueExpressionPrimary();
            }
            this.readThisTokenOrComplete(285, true, true);
            this.completeSchemaObject((SchemaObject o) -> kgraphType.getKnodes().contains(o), 43);
            SchemaObject objectKNodeType = this.readSchemaObjectNameOrNull(43);
            Expression objectKNodeKeyExpression = null;
            Expression objectKNodeExpression = null;
            if (objectKNodeType != null) {
                this.readThisTokenOrComplete(773, true, true);
                if (this.token.tokenType == 794) {
                    objectKNodeKeyExpression = this.XreadSimpleValueExpressionPrimary();
                } else {
                    objectKNodeKeyExpression = new ExpressionValue(this.token.tokenString, Type.STRING);
                    this.read();
                }
            } else {
                objectKNodeExpression = this.XreadSimpleValueExpressionPrimary();
            }
            this.readThisTokenOrComplete(10, true, true);
            this.completeSimpleTree(":");
            this.readThisTokenOrComplete(773, true, false);
            this.completeSchemaObject((SchemaObject o) -> kgraphType.getKlinks().contains(o) && kgraphType.getAssertions().stream().filter(a -> a.getSubjectType() == subjectKNodeType && a.getObjectType() == objectKNodeType).count() > 0L, 44);
            KLinkTypeSchemaObject klinkType = (KLinkTypeSchemaObject)this.readSchemaObjectName(44);
            Expression klinkFacetsExpression = null;
            if (this.readIfThisTokenOrComplete(786, true)) {
                klinkFacetsExpression = this.readFacetsValue(klinkType.getColumns());
                this.readThisTokenOrComplete(772, true, false);
            }
            if (subjectKNodeType != null && !kgraphType.getKnodes().contains(subjectKNodeType)) {
                throw new DataspaceException("KGraph " + NameManager.quoteNameIfNeeded(kgraphType.getObjectName().name) + " doesn't allow KNode " + NameManager.quoteNameIfNeeded(subjectKNodeType.getObjectName().name) + ".");
            }
            if (objectKNodeType != null && !kgraphType.getKnodes().contains(objectKNodeType)) {
                throw new DataspaceException("KGraph " + NameManager.quoteNameIfNeeded(kgraphType.getObjectName().name) + " doesn't allow KNode " + NameManager.quoteNameIfNeeded(objectKNodeType.getObjectName().name) + ".");
            }
            if (!kgraphType.getKlinks().contains(klinkType)) {
                throw new DataspaceException("KGraph " + NameManager.quoteNameIfNeeded(kgraphType.getObjectName().name) + " doesn't allow KLink " + NameManager.quoteNameIfNeeded(klinkType.getObjectName().name) + ".");
            }
            if (subjectKNodeType != null && objectKNodeType != null && kgraphType.getAssertions().stream().filter(a -> a.getSubjectType() == subjectKNodeType && a.getObjectType() == objectKNodeType && a.getLinkType() == klinkType).count() == 0L) {
                throw new DataspaceException("KGraph " + NameManager.quoteNameIfNeeded(kgraphType.getObjectName().name) + " doesn't allow assertion " + NameManager.quoteNameIfNeeded(subjectKNodeType.getObjectName().name) + " -> " + NameManager.quoteNameIfNeeded(klinkType.getObjectName().name) + " -> " + NameManager.quoteNameIfNeeded(objectKNodeType.getObjectName().name) + ".");
            }
            String sql = this.getLastPart();
            Object[] args = new Object[]{kgraph, subjectKNodeType, subjectKNodeKeyExpression, subjectKNodeExpression, objectKNodeType, objectKNodeKeyExpression, objectKNodeExpression, klinkType, klinkFacetsExpression};
            NameManager.ObjectName[] writeLockNames = this.store.schemaManager.catalogNameArray;
            return new StatementSchema(sql, 3338, args, null, writeLockNames);
        }
        if (this.readIfThis(1197)) {
            HsqlList unresolved;
            this.completeSchemaObject((SchemaObject o) -> kgraphType.getKnodes().contains(o), 43);
            KNodeTypeSchemaObject kNodeType = (KNodeTypeSchemaObject)this.readSchemaObjectNameOrNull(43);
            Expression kNodeKeyExpression = null;
            Expression kNodeExpression = null;
            Expression facetsExpression = null;
            if (kNodeType != null) {
                this.readThisTokenOrComplete(773, true, true);
                if (this.token.tokenType == 794) {
                    kNodeKeyExpression = this.XreadSimpleValueExpressionPrimary();
                } else {
                    kNodeKeyExpression = new ExpressionValue(this.token.tokenString, Type.STRING);
                    this.read();
                }
                this.readThis(786);
                facetsExpression = this.readFacetsValue(kNodeType.getColumns());
                this.readThis(772);
            } else {
                kNodeExpression = this.XreadSimpleValueExpressionPrimary();
            }
            if (kNodeExpression != null) {
                unresolved = kNodeExpression.resolveColumnReferences(this.session, rangeVariables, null);
                ExpressionColumn.checkColumnsResolved(unresolved);
                kNodeExpression.resolveTypes(this.session, null);
            }
            if (facetsExpression != null) {
                unresolved = facetsExpression.resolveColumnReferences(this.session, rangeVariables, null);
                ExpressionColumn.checkColumnsResolved(unresolved);
                facetsExpression.resolveTypes(this.session, null);
            }
            if (kNodeKeyExpression != null) {
                unresolved = kNodeKeyExpression.resolveColumnReferences(this.session, rangeVariables, null);
                ExpressionColumn.checkColumnsResolved(unresolved);
                kNodeKeyExpression.resolveTypes(this.session, null);
            }
            if (kNodeType != null && !kgraphType.getKnodes().contains(kNodeType)) {
                throw new DataspaceException("KGraph " + NameManager.quoteNameIfNeeded(kgraphType.getObjectName().name) + " doesn't allow KNode " + NameManager.quoteNameIfNeeded(kNodeType.getObjectName().name) + ".");
            }
            String sql = this.getLastPart();
            Object[] args = new Object[]{kgraph, kNodeType, kNodeKeyExpression, kNodeExpression, facetsExpression};
            NameManager.ObjectName[] writeLockNames = this.store.schemaManager.catalogNameArray;
            return new StatementSchema(sql, 3342, args, null, writeLockNames);
        }
        throw this.unexpectedToken();
    }

    StatementSchema compileCreateKGraphInstance() {
        NameManager.ObjectName name = this.readNewSchemaObjectName(46, false);
        name.setSchemaIfNull(this.session.getCurrentDataspaceName());
        KGraphTypeSchemaObject kgraphType = null;
        String comment = null;
        boolean ifNotExists = false;
        this.completeSimpleTree("constrained by");
        this.readThis(914);
        this.readThis(24);
        this.completeSchemaObject(null, 45);
        kgraphType = (KGraphTypeSchemaObject)this.readSchemaObjectName(45);
        while (true) {
            if (comment == null) {
                this.completeSimpleTree("comment");
            }
            if (!ifNotExists) {
                this.completeSimpleTree("if not exists");
            }
            if (this.readIfThis(412)) {
                this.readThis(183);
                this.readThis(101);
                ifNotExists = true;
                continue;
            }
            if (!this.readIfThis(575)) break;
            comment = this.readQuotedString();
        }
        KGraphInstanceSchemaObject schemaObject = new KGraphInstanceSchemaObject(name, kgraphType, comment);
        String sql = this.getLastPart();
        Object[] args = new Object[]{schemaObject, ifNotExists};
        NameManager.ObjectName[] writeLockNames = this.store.schemaManager.catalogNameArray;
        return new StatementSchema(sql, 3334, args, null, writeLockNames);
    }

    public static final class WindowTriggerSyntaxSplitter
    extends ParserBase.AbstractSyntaxSplitter {
        private String references;

        public WindowTriggerSyntaxSplitter(Session session) {
            super(session);
        }

        public WindowTriggerSyntaxSplitter(Session session, String sql) {
            super(session, sql);
        }

        @Override
        public void reset(String sql) {
            super.reset(sql);
        }

        @Override
        public boolean split() {
            int commandLength;
            String sql = this.parser.scanner.sqlString;
            boolean isCreate = true;
            if (this.parser.token.tokenType == 849) {
                this.parser.read();
            }
            int start = 0;
            int end = 0;
            start = this.parser.getPosition();
            if (this.parser.readIfThis(4)) {
                isCreate = false;
            } else {
                this.parser.readThis(55);
            }
            int n = commandLength = isCreate ? "CREATE".length() : "ALTER".length();
            if (this.parser.getPosition() > commandLength) {
                this.comment = sql.substring(0, this.parser.getPosition() - commandLength - 1);
            }
            this.parser.read();
            this.parser.read();
            this.parser.read();
            if (isCreate) {
                this.parser.readThis(194);
                this.parser.read();
            }
            end = this.parser.getPosition();
            this.signature = sql.substring(start, end);
            this.readEventScope();
            start = this.parser.getPosition();
            if (this.parser.token.tokenType == 223) {
                this.parser.read();
                boolean finished = false;
                block3: while (!finished) {
                    switch (this.parser.token.tokenType) {
                        case 179: 
                        case 193: {
                            this.parser.read();
                            this.parser.read();
                            this.parser.read();
                            continue block3;
                        }
                    }
                    finished = true;
                }
            }
            end = this.parser.getPosition();
            this.references = sql.substring(start, end);
            if (this.references.trim().length() == 0) {
                this.references = null;
            }
            if (!this.readRpl()) {
                return false;
            }
            this.readEnable();
            return true;
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public String getSignature() {
            return this.signature;
        }

        public String getReferences() {
            return this.references;
        }

        @Override
        public String getRpl() {
            return this.rpl;
        }
    }

    public static final class ReplicationModifyTriggerSyntaxSplitter
    extends ParserBase.AbstractSyntaxSplitter {
        private String references;
        private String triggerType;

        public ReplicationModifyTriggerSyntaxSplitter(Session session) {
            super(session);
        }

        public ReplicationModifyTriggerSyntaxSplitter(Session session, String sql) {
            super(session, sql);
        }

        @Override
        public void reset(String sql) {
            super.reset(sql);
        }

        @Override
        public boolean split() {
            int commandLength;
            String sql = this.parser.scanner.sqlString;
            boolean isCreate = true;
            if (this.parser.token.tokenType == 849) {
                this.parser.read();
            }
            int start = 0;
            int end = 0;
            start = this.parser.getPosition();
            if (this.parser.readIfThis(4)) {
                isCreate = false;
            } else {
                this.parser.readThis(55);
            }
            int n = commandLength = isCreate ? "CREATE".length() : "ALTER".length();
            if (this.parser.getPosition() > commandLength) {
                this.comment = sql.substring(0, this.parser.getPosition() - commandLength - 1);
            }
            this.parser.read();
            this.parser.read();
            this.parser.read();
            this.parser.read();
            this.parser.readThis(194);
            this.parser.read();
            end = this.parser.getPosition();
            this.signature = sql.substring(start, end);
            start = this.parser.getPosition();
            if (this.parser.token.tokenType == 306) {
                this.parser.read();
                this.parser.read();
                this.parser.read();
                end = this.parser.getPosition();
                this.triggerType = sql.substring(start, end);
                this.rpl = "";
                this.readEventScope();
            } else {
                this.readEventScope();
                start = this.parser.getPosition();
                boolean finished = false;
                block3: while (!finished) {
                    switch (this.parser.token.tokenType) {
                        case 179: 
                        case 193: {
                            this.parser.read();
                            this.parser.read();
                            this.parser.read();
                            this.parser.read();
                            this.parser.read();
                            continue block3;
                        }
                    }
                    finished = true;
                }
                end = this.parser.getPosition();
                this.references = sql.substring(start, end);
                if (this.references.trim().length() == 0) {
                    this.references = null;
                }
                if (!this.readRpl()) {
                    return false;
                }
            }
            this.readEnable();
            return true;
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public String getSignature() {
            return this.signature;
        }

        public String getTriggerType() {
            return this.triggerType;
        }

        public String getReferences() {
            return this.references;
        }

        @Override
        public String getRpl() {
            return this.rpl;
        }
    }

    public static final class ReplicationValidateTriggerSyntaxSplitter
    extends ParserBase.AbstractSyntaxSplitter {
        private String references;
        private String triggerType;

        public ReplicationValidateTriggerSyntaxSplitter(Session session) {
            super(session);
        }

        public ReplicationValidateTriggerSyntaxSplitter(Session session, String sql) {
            super(session, sql);
        }

        @Override
        public void reset(String sql) {
            super.reset(sql);
        }

        @Override
        public boolean split() {
            int commandLength;
            String sql = this.parser.scanner.sqlString;
            boolean isCreate = true;
            if (this.parser.token.tokenType == 849) {
                this.parser.read();
            }
            int start = 0;
            int end = 0;
            start = this.parser.getPosition();
            if (this.parser.readIfThis(4)) {
                isCreate = false;
            } else {
                this.parser.readThis(55);
            }
            int n = commandLength = isCreate ? "CREATE".length() : "ALTER".length();
            if (this.parser.getPosition() > commandLength) {
                this.comment = sql.substring(0, this.parser.getPosition() - commandLength - 1);
            }
            this.parser.read();
            this.parser.read();
            this.parser.read();
            this.parser.read();
            this.parser.readThis(194);
            this.parser.read();
            end = this.parser.getPosition();
            this.signature = sql.substring(start, end);
            start = this.parser.getPosition();
            this.parser.read();
            this.parser.read();
            end = this.parser.getPosition();
            this.triggerType = sql.substring(start, end);
            start = this.parser.getPosition();
            boolean finished = false;
            block3: while (!finished) {
                switch (this.parser.token.tokenType) {
                    case 179: 
                    case 193: {
                        this.parser.read();
                        this.parser.read();
                        this.parser.read();
                        this.parser.read();
                        continue block3;
                    }
                }
                finished = true;
            }
            end = this.parser.getPosition();
            this.references = sql.substring(start, end);
            if (this.references.trim().length() == 0) {
                this.references = null;
            }
            if (!this.readRpl()) {
                return false;
            }
            this.readEnable();
            return true;
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public String getSignature() {
            return this.signature;
        }

        public String getTriggerType() {
            return this.triggerType;
        }

        public String getReferences() {
            return this.references;
        }

        @Override
        public String getRpl() {
            return this.rpl;
        }
    }

    public static final class ReplicationEventTriggerSyntaxSplitter
    extends ParserBase.AbstractSyntaxSplitter {
        private String references;
        private String triggerType;

        public ReplicationEventTriggerSyntaxSplitter(Session session) {
            super(session);
        }

        public ReplicationEventTriggerSyntaxSplitter(Session session, String sql) {
            super(session, sql);
        }

        @Override
        public void reset(String sql) {
            super.reset(sql);
        }

        @Override
        public boolean split() {
            int commandLength;
            String sql = this.parser.scanner.sqlString;
            boolean isCreate = true;
            if (this.parser.token.tokenType == 849) {
                this.parser.read();
            }
            int start = 0;
            int end = 0;
            start = this.parser.getPosition();
            if (this.parser.readIfThis(4)) {
                isCreate = false;
            } else {
                this.parser.readThis(55);
            }
            int n = commandLength = isCreate ? "CREATE".length() : "ALTER".length();
            if (this.parser.getPosition() > commandLength) {
                this.comment = sql.substring(0, this.parser.getPosition() - commandLength - 1);
            }
            this.parser.read();
            this.parser.read();
            this.parser.read();
            this.parser.readThis(194);
            this.parser.read();
            this.parser.read();
            end = this.parser.getPosition();
            this.signature = sql.substring(start, end);
            start = this.parser.getPosition();
            if (this.parser.token.tokenType == 336) {
                this.parser.read();
                this.parser.read();
            } else if (this.parser.token.tokenType == 194) {
                this.parser.read();
                this.parser.read();
            }
            end = this.parser.getPosition();
            this.triggerType = sql.substring(start, end);
            this.readEventScope();
            start = this.parser.getPosition();
            boolean finished = false;
            block4: while (!finished) {
                switch (this.parser.token.tokenType) {
                    case 179: 
                    case 193: 
                    case 1081: {
                        this.parser.read();
                        this.parser.read();
                        this.parser.read();
                        this.parser.read();
                        continue block4;
                    }
                    case 397: {
                        this.parser.read();
                        this.parser.readThis(10);
                        this.parser.read();
                        continue block4;
                    }
                }
                finished = true;
            }
            end = this.parser.getPosition();
            this.references = sql.substring(start, end);
            if (this.references.trim().length() == 0) {
                this.references = null;
            }
            if (!this.readRpl()) {
                return false;
            }
            this.readEnable();
            return true;
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public String getSignature() {
            return this.signature;
        }

        public String getTriggerType() {
            return this.triggerType;
        }

        public String getReferences() {
            return this.references;
        }

        @Override
        public String getRpl() {
            return this.rpl;
        }
    }

    public static final class EventTriggerSyntaxSplitter
    extends ParserBase.AbstractSyntaxSplitter {
        String triggerType;
        String forEachType;
        String references;
        String whenClause;
        String order;
        private static String orderRegexp = "(?i)(order\\s*)(\\d+|first|last)([\\s\\S]*?AS[\\s\\S]*?\\{)";
        private static Pattern orderPattern = Pattern.compile(orderRegexp);

        public EventTriggerSyntaxSplitter(Session session) {
            super(session);
        }

        public EventTriggerSyntaxSplitter(Session session, String sql) {
            super(session, sql);
        }

        @Override
        public void reset(String sql) {
            super.reset(sql);
            this.eventScope = null;
            this.triggerType = null;
            this.forEachType = null;
            this.references = null;
            this.whenClause = null;
            this.order = null;
        }

        @Override
        public boolean split() {
            int commandLength;
            String sql = this.parser.scanner.sqlString;
            boolean isCreate = true;
            if (this.parser.token.tokenType == 849) {
                this.parser.read();
            }
            int start = 0;
            int end = 0;
            start = this.parser.getPosition();
            if (this.parser.readIfThis(4)) {
                isCreate = false;
            } else {
                this.parser.readThis(55);
            }
            int n = commandLength = isCreate ? "CREATE".length() : "ALTER".length();
            if (this.parser.getPosition() > commandLength) {
                this.comment = sql.substring(0, this.parser.getPosition() - commandLength - 1);
            }
            this.parser.read();
            this.parser.read();
            this.parser.read();
            this.parser.readThis(194);
            this.parser.read();
            end = this.parser.getPosition();
            this.signature = sql.substring(start, end);
            this.readEventScope();
            start = this.parser.getPosition();
            boolean insteadTrigger = false;
            switch (this.parser.token.tokenType) {
                case 422: {
                    this.parser.read();
                    this.parser.readThis(191);
                    insteadTrigger = true;
                    break;
                }
                case 194: 
                case 343: {
                    this.parser.read();
                    break;
                }
                case 336: {
                    this.parser.read();
                    if (this.parser.token.tokenType == 44) {
                        this.parser.read();
                    }
                    if (this.parser.token.tokenType != 1093) break;
                    this.parser.read();
                    break;
                }
                default: {
                    return false;
                }
            }
            block5 : switch (this.parser.token.tokenType) {
                case 79: 
                case 135: 
                case 295: 
                case 334: 
                case 378: 
                case 550: 
                case 928: 
                case 974: {
                    this.parser.read();
                    break;
                }
                case 303: {
                    this.parser.read();
                    if (this.parser.token.tokenType != 191 || !insteadTrigger) break;
                    this.parser.read();
                    while (true) {
                        this.parser.read();
                        if (!this.parser.readIfThis(774)) break block5;
                    }
                }
                default: {
                    return false;
                }
            }
            end = this.parser.getPosition();
            this.triggerType = sql.substring(start, end);
            boolean isForEachRow = true;
            if (this.parser.token.tokenType == 112) {
                start = this.parser.getPosition();
                this.parser.read();
                this.parser.readThis(90);
                if (this.parser.token.tokenType == 243) {
                    if (Boolean.FALSE.equals(isForEachRow)) {
                        return false;
                    }
                } else {
                    if (this.parser.token.tokenType == 517) {
                        return false;
                    }
                    return false;
                }
                isForEachRow = Boolean.TRUE;
                this.parser.read();
                end = this.parser.getPosition();
                this.forEachType = sql.substring(start, end);
            }
            boolean finished = false;
            start = this.parser.getPosition();
            block16: while (!finished) {
                switch (this.parser.token.tokenType) {
                    case 223: {
                        this.parser.read();
                        continue block16;
                    }
                    case 193: {
                        this.parser.read();
                        if (this.parser.token.tokenType == 907) {
                            this.parser.read();
                            this.parser.read();
                            this.parser.read();
                            continue block16;
                        }
                        this.parser.read();
                        this.parser.read();
                        this.parser.read();
                        continue block16;
                    }
                    case 179: {
                        this.parser.read();
                        if (this.parser.token.tokenType == 907) {
                            this.parser.read();
                            this.parser.read();
                            this.parser.read();
                            continue block16;
                        }
                        this.parser.read();
                        this.parser.read();
                        this.parser.read();
                        continue block16;
                    }
                    case 1054: {
                        this.parser.read();
                        this.parser.readThis(586);
                        this.parser.readThis(10);
                        this.parser.read();
                        continue block16;
                    }
                }
                finished = true;
            }
            end = this.parser.getPosition();
            this.references = sql.substring(start, end);
            if (this.references.trim().length() == 0) {
                this.references = null;
            }
            if (this.parser.token.tokenType == 314 && !insteadTrigger) {
                start = this.parser.getPosition();
                this.parser.read();
                if (!this.scanNextBlock(786, 772)) {
                    return false;
                }
                this.parser.read();
                end = this.parser.getPosition();
                this.whenClause = sql.substring(start, end);
            }
            if (this.parser.token.tokenType == 198) {
                start = this.parser.getPosition();
                this.parser.read();
                this.parser.read();
                end = this.parser.getPosition();
                this.order = sql.substring(start, end);
            }
            if (!this.readRpl()) {
                return false;
            }
            this.readEnable();
            return true;
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        public String getTriggerType() {
            return this.triggerType;
        }

        public String getForEachType() {
            return this.forEachType;
        }

        public String getReferences() {
            return this.references;
        }

        public String getWhenClause() {
            return this.whenClause;
        }

        public String getOrder() {
            return this.order;
        }

        public static synchronized String replaceOrder(String sql, String newOrder) {
            Matcher matcher = orderPattern.matcher(sql);
            StringBuffer result = new StringBuffer();
            if (matcher.find()) {
                String replacedBlock = matcher.group(1) + newOrder + matcher.group(3);
                matcher.appendReplacement(result, replacedBlock);
            }
            matcher.appendTail(result);
            return result.toString();
        }
    }

    public static final class ActorSyntaxSplitter
    extends ParserBase.AbstractSyntaxSplitter {
        String async;
        String events;
        String eventSetType;
        String window;
        String parallelWorkers;
        String depth;

        public ActorSyntaxSplitter(Session session) {
            super(session);
        }

        public ActorSyntaxSplitter(Session session, String sql) {
            super(session, sql);
        }

        @Override
        public void reset(String sql) {
            super.reset(sql);
            this.async = null;
            this.events = null;
            this.eventSetType = null;
            this.window = null;
            this.parallelWorkers = null;
        }

        @Override
        public boolean split() {
            return this.split(null);
        }

        public boolean split(Boolean async) {
            int commandLength;
            String sql = this.parser.scanner.sqlString;
            boolean isCreate = true;
            if (this.parser.token.tokenType == 849) {
                this.parser.read();
            }
            int start = 0;
            int end = 0;
            start = this.parser.getPosition();
            if (this.parser.readIfThis(4)) {
                isCreate = false;
            } else {
                this.parser.readThis(55);
            }
            int n = commandLength = isCreate ? "CREATE".length() : "ALTER".length();
            if (this.parser.getPosition() > commandLength) {
                this.comment = sql.substring(0, this.parser.getPosition() - commandLength - 1);
            }
            if (async != null && async.booleanValue() && this.parser.token.tokenType == 944) {
                end = this.parser.getPosition();
                this.signature = sql.substring(start, end);
                this.parser.readThis(944);
                start = this.parser.getPosition();
                this.parser.read();
                this.parser.read();
                if (this.parser.token.tokenType == 1015) {
                    this.parser.read();
                    this.parser.read();
                }
                end = this.parser.getPosition();
                this.signature = this.signature + sql.substring(start, end);
            } else if (async != null && !async.booleanValue() && this.parser.token.tokenType != 944) {
                end = this.parser.getPosition();
                this.signature = sql.substring(start, end).trim() + " sync ";
                start = this.parser.getPosition();
                this.parser.read();
                this.parser.read();
                if (this.parser.token.tokenType == 1015) {
                    this.parser.read();
                    this.parser.read();
                }
                end = this.parser.getPosition();
                this.signature = this.signature + sql.substring(start, end);
            } else {
                this.parser.readIfThis(944);
                this.parser.read();
                this.parser.read();
                if (this.parser.token.tokenType == 1015) {
                    this.parser.read();
                    this.parser.read();
                }
                end = this.parser.getPosition();
                this.signature = sql.substring(start, end);
            }
            if (this.parser.token.tokenType == 194) {
                start = this.parser.getPosition();
                this.parser.read();
                while (true) {
                    this.parser.read();
                    boolean finished = false;
                    boolean whenSet = false;
                    boolean aliasSet = false;
                    block14: while (!finished) {
                        switch (this.parser.token.tokenType) {
                            case 314: {
                                if (whenSet) {
                                    finished = true;
                                    continue block14;
                                }
                                this.parser.read();
                                if (!this.scanNextBlock(786, 772)) {
                                    return false;
                                }
                                this.parser.read();
                                whenSet = true;
                                continue block14;
                            }
                            case 10: {
                                if (aliasSet) {
                                    finished = true;
                                    continue block14;
                                }
                                this.parser.read();
                                this.parser.read();
                                aliasSet = true;
                                continue block14;
                            }
                        }
                        finished = true;
                    }
                    if (this.parser.token.tokenType != 774) break;
                    this.parser.read();
                }
                end = this.parser.getPosition();
                this.events = sql.substring(start, end);
            }
            if (this.parser.token.tokenType == 112) {
                start = this.parser.getPosition();
                this.parser.read();
                if (this.parser.token.tokenType == 6) {
                    this.parser.read();
                    this.parser.read();
                    end = this.parser.getPosition();
                    this.eventSetType = sql.substring(start, end);
                } else {
                    if (this.parser.token.tokenType != 586) {
                        this.parser.read();
                    }
                    this.parser.read();
                    this.parser.read();
                    end = this.parser.getPosition();
                    this.eventSetType = sql.substring(start, end);
                    switch (this.parser.token.tokenType) {
                        case 281: {
                            start = this.parser.getPosition();
                            this.parser.read();
                            this.parser.read();
                            this.parser.readLong();
                            switch (this.parser.token.tokenType) {
                                case 168: 
                                case 675: 
                                case 969: 
                                case 970: 
                                case 982: {
                                    this.parser.read();
                                }
                            }
                            end = this.parser.getPosition();
                            this.window = sql.substring(start, end);
                            break;
                        }
                        case 1032: {
                            start = this.parser.getPosition();
                            this.parser.read();
                            this.parser.read();
                            this.parser.readLong();
                            end = this.parser.getPosition();
                            this.window = sql.substring(start, end);
                        }
                    }
                }
            }
            this.readEventScope();
            if (this.parser.token.tokenType == 89 || this.parser.token.tokenType == 1045 || this.parser.token.tokenType == 986) {
                start = this.parser.getPosition();
                if (this.parser.token.tokenType != 986) {
                    try {
                        this.parser.read();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                this.parser.read();
                this.parser.read();
                this.parser.readLong();
                if (this.parser.token.tokenType == 1047) {
                    this.parser.read();
                    this.parser.read();
                    this.parser.read();
                }
                end = this.parser.getPosition();
                this.parallelWorkers = sql.substring(start, end);
            }
            if (this.parser.token.tokenType == 387) {
                start = this.parser.getPosition();
                this.parser.readThis(387);
                this.parser.readInteger();
                end = this.parser.getPosition();
                this.depth = sql.substring(start, end);
            }
            if (this.parser.token.tokenType == 10) {
                start = this.parser.getPosition();
                this.parser.read();
                if (!this.scanNextBlock(792, 793)) {
                    return false;
                }
                this.parser.read();
                end = this.parser.getPosition();
                this.rpl = sql.substring(start, end);
            }
            if (this.parser.token.tokenType == 948) {
                start = this.parser.getPosition();
                this.parser.read();
                end = this.parser.getPosition();
                this.enable = sql.substring(start, end);
            }
            return true;
        }

        public String getEvents() {
            return this.events;
        }

        public String getEventSetType() {
            return this.eventSetType;
        }

        public String getWindow() {
            return this.window;
        }

        public String getParallelWorkers() {
            return this.parallelWorkers;
        }

        public String getDepth() {
            return this.depth;
        }
    }

    public static final class FunctionCallSplitter {
        private ParserBase parser;

        public FunctionCallSplitter(Session session) {
            this.parser = new ParserBase(session, new Scanner());
        }

        public FunctionCallSplitter(Session session, String sql) {
            this(session);
            this.parser.reset(sql);
        }

        public void reset(String sql) {
            this.parser.reset(sql);
        }

        public String getFunctionName() {
            this.parser.read();
            if (!this.parser.readIfThis(25)) {
                return null;
            }
            return this.parser.token.tokenString;
        }
    }

    public static final class FunctionSyntaxSplitter
    extends ParserBase.AbstractSyntaxSplitter {
        public FunctionSyntaxSplitter(Session session) {
            super(session);
        }

        public FunctionSyntaxSplitter(Session session, String sql) {
            super(session, sql);
        }

        @Override
        public void reset(String sql) {
            super.reset(sql);
        }

        @Override
        public boolean split() {
            int commandLength;
            String sql = this.parser.scanner.sqlString;
            boolean isCreate = true;
            if (this.parser.token.tokenType == 849) {
                this.parser.read();
            }
            int start = 0;
            int end = 0;
            start = this.parser.getPosition();
            if (this.parser.readIfThis(4)) {
                isCreate = false;
            } else {
                this.parser.readThis(55);
            }
            int n = commandLength = isCreate ? "CREATE".length() : "ALTER".length();
            if (this.parser.getPosition() > commandLength) {
                this.comment = sql.substring(0, this.parser.getPosition() - commandLength - 1);
            }
            if (isCreate) {
                boolean isFunction = true;
                if (this.parser.readIfThis(215)) {
                    isFunction = false;
                }
                if (!this.scanNextBlock(786, 772)) {
                    return false;
                }
                this.parser.read();
                if (isFunction) {
                    this.parser.readThis(238);
                    if (this.parser.token.tokenType == 278 || this.parser.token.tokenType == 436 || this.parser.token.tokenType == 908) {
                        this.parser.read();
                        if (this.parser.token.tokenType == 786) {
                            if (!this.scanNextBlock(786, 772)) {
                                return false;
                            }
                            this.parser.read();
                        }
                    } else {
                        this.parser.read();
                    }
                }
                while (this.parser.token.tokenType != 10 && this.parser.token.tokenType != 848) {
                    this.parser.read();
                }
                if (this.parser.token.tokenType != 10) {
                    return false;
                }
            } else {
                this.parser.read();
                this.parser.read();
                if (this.parser.token.tokenType == 1015) {
                    this.parser.read();
                    this.parser.read();
                }
            }
            end = this.parser.getPosition();
            this.signature = sql.substring(start, end);
            start = this.parser.getPosition();
            if (this.parser.token.tokenType == 10) {
                this.parser.read();
            }
            if (this.parser.token.tokenType == 945) {
                this.rpl = "";
            } else {
                if (!this.scanNextBlock(792, 793)) {
                    return false;
                }
                this.parser.read();
                end = this.parser.getPosition();
                this.rpl = sql.substring(start, end);
            }
            return true;
        }
    }
}

