/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser;

import com.streamscape.cli.ds.CollectionType;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.DataspaceCompleteException;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.lib.LongDeque;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.parser.completion.CollectionFilter;
import com.streamscape.ds.parser.expression.ExecImmediateExpression;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.expression.ExpressionLogical;
import com.streamscape.ds.parser.expression.ExpressionOp;
import com.streamscape.ds.parser.expression.ExpressionValue;
import com.streamscape.ds.parser.expression.QueryExpression;
import com.streamscape.ds.parser.expression.QuerySpecification;
import com.streamscape.ds.parser.expression.SortAndSlice;
import com.streamscape.ds.parser.expression.SubQuery;
import com.streamscape.ds.parser.expression.UpdateDeleteStatementExpression;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.parser.statement.StatementCollectionInvoke;
import com.streamscape.ds.parser.statement.StatementCommand;
import com.streamscape.ds.parser.statement.StatementCompound;
import com.streamscape.ds.parser.statement.StatementDML;
import com.streamscape.ds.parser.statement.StatementDMQL;
import com.streamscape.ds.parser.statement.StatementDfetch;
import com.streamscape.ds.parser.statement.StatementInsert;
import com.streamscape.ds.parser.statement.StatementProcedure;
import com.streamscape.ds.parser.statement.StatementPut;
import com.streamscape.ds.parser.statement.StatementPutIntoQueue;
import com.streamscape.ds.parser.statement.StatementRplExec;
import com.streamscape.ds.parser.statement.StatementSchema;
import com.streamscape.ds.parser.statement.StatementSet;
import com.streamscape.ds.parser.statement.StatementUpdateSnapshot;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.range.RangeVariableResolver;
import com.streamscape.ds.replication.ReplicationEntityName;
import com.streamscape.ds.replication.ReplicationQueue;
import com.streamscape.ds.result.ResultProperties;
import com.streamscape.ds.schema.DataspaceSchema;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.SchemaObjectSet;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.fspace.directory.DirectoryTableCollection;
import com.streamscape.ds.schema.collection.fspace.table.FileTableCollection;
import com.streamscape.ds.schema.collection.qspace.queue.BlockingQueueCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.constraint.Constraint;
import com.streamscape.ds.schema.event.Actor;
import com.streamscape.ds.schema.procedure.FunctionCustom;
import com.streamscape.ds.schema.procedure.RoutineSchema;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableDerived;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.AbstractReplicationEventTrigger;
import com.streamscape.ds.types.FlobType;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.Type;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.utils.StringUtils;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;

public class ParserDML
extends ParserDQL {
    ParserDML(Session session, Scanner t) {
        super(session, t);
    }

    StatementDMQL compileInsertStatement(RangeVariable[] outerRanges) {
        Table baseTable;
        this.read();
        this.readThisNameTokenForCompleteMode(141);
        this.completeCollection();
        boolean overridingUser = false;
        boolean overridingSystem = false;
        boolean assignsToIdentity = false;
        RangeVariable range = this.readSimpleRangeVariable(50);
        Table table = range.getTable();
        boolean[] columnCheckList = null;
        int[] columnMap = table.getColumnMap();
        int colCount = table.getColumnCount();
        int position = this.getPosition();
        Table table2 = baseTable = table.isTriggerInsertable() ? table : table.getBaseTable();
        if (table.getTableType() != 3) {
            this.checkThatRuntimeOperationIsNotInSDS(table.getObjectName(), "insert");
        }
        switch (this.token.tokenType) {
            case 78: {
                this.read();
                this.readThis(308);
                Expression insertExpression = new Expression(25, new Expression[0]);
                insertExpression = new Expression(26, new Expression[]{insertExpression});
                columnCheckList = table.getNewColumnCheckList();
                for (int i = 0; i < table.colDefaults.length; ++i) {
                    if (table.colDefaults[i] != null || table.identityColumn == i || table.getColumn(i).isGenerated()) continue;
                    throw Error.error(5544);
                }
                StatementInsert cs = new StatementInsert(this.session, table, columnMap, insertExpression, columnCheckList, this.compileContext);
                return cs;
            }
            case 786: {
                int brackets = this.readOpenBrackets();
                if (brackets == 1) {
                    boolean isQuery = false;
                    switch (this.token.tokenType) {
                        case 251: 
                        case 278: 
                        case 319: {
                            this.rewind(position);
                            isQuery = true;
                            break;
                        }
                    }
                    if (isQuery) break;
                    if (this.isCompleteMode() && this.scanner.isAtEnd() && this.token.tokenType == 848) {
                        StringBuilder columnsBuilder = new StringBuilder();
                        for (int i : columnMap) {
                            columnsBuilder.append(table.getColumn(i).getNameString()).append(", ");
                        }
                        if (columnsBuilder.length() > 0) {
                            columnsBuilder.setLength(columnsBuilder.length() - 2);
                        }
                        columnsBuilder.append(")");
                        throw new DataspaceCompleteException(new DSLCompletion().setCompletion(new TokenSuggestion("(" + columnsBuilder.toString()).setOffset("(")));
                    }
                    OrderedHashSet columnNames = new OrderedHashSet();
                    this.readSimpleColumnNames(columnNames, range);
                    this.readThis(772);
                    colCount = columnNames.size();
                    columnMap = table.getColumnIndexes(columnNames);
                    if (this.token.tokenType != 308 && this.token.tokenType != 461) {
                        break;
                    }
                } else {
                    this.rewind(position);
                    break;
                }
            }
            case 461: {
                if (this.token.tokenType == 461) {
                    this.read();
                    if (this.token.tokenType == 305) {
                        this.read();
                        overridingUser = true;
                    } else if (this.token.tokenType == 276) {
                        this.read();
                        overridingSystem = true;
                    } else {
                        this.unexpectedToken();
                    }
                    this.readThis(307);
                    if (this.token.tokenType != 308) break;
                }
            }
            case 308: {
                this.read();
                columnCheckList = table.getColumnCheckList(columnMap);
                Expression insertExpressions = this.XreadContextuallyTypedTable(colCount);
                HsqlList unresolved = insertExpressions.resolveColumnReferences(this.session, outerRanges, null);
                ExpressionColumn.checkColumnsResolved(unresolved);
                insertExpressions.resolveTypes(this.session, null);
                ParserDML.setParameterTypes(insertExpressions, table, columnMap);
                if (table != baseTable) {
                    int[] baseColumnMap = table.getBaseTableColumnMap();
                    int[] newColumnMap = new int[columnMap.length];
                    ArrayUtil.projectRow(baseColumnMap, columnMap, newColumnMap);
                    columnMap = newColumnMap;
                }
                this.resolveFlobColumnsForInsert(insertExpressions, baseTable, columnMap);
                this.resolveReadFileFunctionDataTypeForInsert(insertExpressions, baseTable, columnMap);
                Expression[] rowList = insertExpressions.nodes;
                for (int j = 0; j < rowList.length; ++j) {
                    Expression[] rowArgs = rowList[j].nodes;
                    for (int i = 0; i < rowArgs.length; ++i) {
                        Expression e = rowArgs[i];
                        ColumnSchema column = baseTable.getColumn(columnMap[i]);
                        if (column.isIdentity()) {
                            assignsToIdentity = true;
                            if (e.getType() != 4) {
                                if (baseTable.identitySequence.isAlways() && !overridingUser && !overridingSystem) {
                                    throw Error.error(5543);
                                }
                                if (overridingUser) {
                                    rowArgs[i] = new ExpressionColumn(4);
                                }
                            }
                        } else if (!column.hasDefault()) {
                            if (column.isGenerated()) {
                                if (e.getType() != 4) {
                                    throw Error.error(5541);
                                }
                            } else if (e.getType() == 4) {
                                throw Error.error(5544);
                            }
                        }
                        if (!e.isUnresolvedParam()) continue;
                        e.setAttributesAsColumn(column, true);
                    }
                }
                if (!assignsToIdentity && (overridingUser || overridingSystem)) {
                    this.unexpectedTokenRequire("OVERRIDING");
                }
                StatementInsert cs = new StatementInsert(this.session, table, columnMap, insertExpressions, columnCheckList, this.compileContext);
                return cs;
            }
            case 251: 
            case 278: 
            case 319: {
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        columnCheckList = table.getColumnCheckList(columnMap);
        if (baseTable != null && table != baseTable) {
            int[] baseColumnMap = table.getBaseTableColumnMap();
            int[] newColumnMap = new int[columnMap.length];
            ArrayUtil.projectRow(baseColumnMap, columnMap, newColumnMap);
            columnMap = newColumnMap;
        }
        int enforcedDefaultIndex = baseTable.getIdentityColumnIndex();
        int overrideIndex = -1;
        if (enforcedDefaultIndex != -1 && ArrayUtil.find(columnMap, enforcedDefaultIndex) > -1) {
            if (baseTable.identitySequence.isAlways() && !overridingUser && !overridingSystem) {
                throw Error.error(5543);
            }
            if (overridingUser) {
                overrideIndex = enforcedDefaultIndex;
            }
        } else if (overridingUser || overridingSystem) {
            this.unexpectedTokenRequire("OVERRIDING");
        }
        Object[] types = new Type[columnMap.length];
        ArrayUtil.projectRow(baseTable.getColumnTypes(), columnMap, types);
        QueryExpression queryExpression = this.XreadQueryExpression(outerRanges);
        queryExpression.setReturningResult();
        queryExpression.resolve(this.session, outerRanges, (Type[])types);
        if (colCount != queryExpression.getColumnCount()) {
            throw Error.error(5546);
        }
        StatementInsert cs = new StatementInsert(this.session, table, columnMap, columnCheckList, queryExpression, this.compileContext, overrideIndex);
        return cs;
    }

    private void resolveFlobColumnsForInsert(Expression insertExpressions, Table baseTable, int[] columnMap) {
        for (int i = 0; i < columnMap.length; ++i) {
            ColumnSchema column = baseTable.getColumn(columnMap[i]);
            if (column.getDataType() instanceof FlobType) {
                for (Expression rowExpression : insertExpressions.nodes) {
                    ParserDML.resolveFlobExpression(this.session, rowExpression.nodes[i], column.getDataType());
                }
                continue;
            }
            if (!DirectoryTableCollection.isDataColumn(baseTable, columnMap[i])) continue;
            for (Expression rowExpression : insertExpressions.nodes) {
                if (!(rowExpression.nodes[i] instanceof FunctionCustom) || ((FunctionCustom)rowExpression.nodes[i]).funcType != 106 && ((FunctionCustom)rowExpression.nodes[i]).funcType != 231) continue;
                ParserDML.resolveFlobExpression(this.session, rowExpression.nodes[i], new FlobType());
            }
        }
    }

    private void resolveFlobColumnsForUpdate(Expression[] updateExpressions, Table baseTable, int[] columnMap) {
        for (int i = 0; i < columnMap.length; ++i) {
            ColumnSchema column = baseTable.getColumn(columnMap[i]);
            if (column.getDataType() instanceof FlobType) {
                ParserDML.resolveFlobExpression(this.session, updateExpressions[i], column.getDataType());
                continue;
            }
            if (!DirectoryTableCollection.isDataColumn(baseTable, columnMap[i]) || !(updateExpressions[i] instanceof FunctionCustom) || ((FunctionCustom)updateExpressions[i]).funcType != 106 && ((FunctionCustom)updateExpressions[i]).funcType != 231) continue;
            ParserDML.resolveFlobExpression(this.session, updateExpressions[i], new FlobType());
        }
    }

    public static void resolveFlobExpression(Session session, Expression flobExpression, Type flobType) {
        if (flobExpression.getDataType() == null && flobExpression.opType == 1 && flobExpression.valueData == null || flobExpression.getDataType() != null && flobType.canBeAssignedFrom(flobExpression.getDataType())) {
            return;
        }
        if (!(flobExpression instanceof FunctionCustom)) {
            throw Error.error(5561, "FLOB column can be initialized by readFile, linkFile or toFlob functions or variable of FLOB type with the same autotag and location.");
        }
        FunctionCustom flobFunction = (FunctionCustom)flobExpression;
        if (flobFunction.funcType != 106 && flobFunction.funcType != 231 && flobFunction.funcType != 182 && flobFunction.funcType != 183) {
            throw Error.error(5561, "FLOB column can be initialized by readFile, linkFile or toFlob functions or from variable of FLOB type with the same autotag and location.");
        }
        flobExpression.setDataType(session, flobType);
    }

    private void resolveReadFileFunctionDataTypeForInsert(Expression insertExpressions, Table baseTable, int[] columnMap) {
        for (int i = 0; i < columnMap.length; ++i) {
            for (Expression rowExpression : insertExpressions.nodes) {
                if (!(rowExpression.nodes[i] instanceof FunctionCustom) || ((FunctionCustom)rowExpression.nodes[i]).funcType != 106 && ((FunctionCustom)rowExpression.nodes[i]).funcType != 231) continue;
                ParserDML.resolveReadFileFunctionDataType(this.session, (FunctionCustom)rowExpression.nodes[i], baseTable.getColumn(columnMap[i]));
            }
        }
    }

    private void resolveReadFileFunctionDataTypeForUpdate(Expression[] updateExpressions, Table baseTable, int[] columnMap) {
        for (int i = 0; i < columnMap.length; ++i) {
            if (!(updateExpressions[i] instanceof FunctionCustom) || ((FunctionCustom)updateExpressions[i]).funcType != 106 && ((FunctionCustom)updateExpressions[i]).funcType != 231) continue;
            ParserDML.resolveReadFileFunctionDataType(this.session, (FunctionCustom)updateExpressions[i], baseTable.getColumn(columnMap[i]));
        }
    }

    public static void resolveReadFileFunctionDataType(Session session, FunctionCustom readFileFunctionExpression, ColumnSchema column) {
        if (!column.getDataType().isFlobType()) {
            readFileFunctionExpression.setDataType(session, column.getDataType());
        }
    }

    private static void setParameterTypes(Expression tableExpression, Table table, int[] columnMap) {
        for (int i = 0; i < tableExpression.nodes.length; ++i) {
            Expression[] list = tableExpression.nodes[i].nodes;
            for (int j = 0; j < list.length; ++j) {
                if (!list[j].isUnresolvedParam()) continue;
                list[j].setAttributesAsColumn(table.getColumn(columnMap[j]), true);
            }
        }
    }

    Statement compileTruncateStatement() {
        boolean isTable = false;
        boolean onCommit = false;
        boolean noCheck = false;
        boolean restartIdentity = false;
        NameManager.ObjectName objectName = null;
        RangeVariable[] rangeVariables = null;
        Table table = null;
        NameManager.ObjectName[] writeTableNames = null;
        this.read();
        this.completeSimpleTree("collection", "schema");
        if (this.token.tokenType == 278 || this.token.tokenType == 908 || this.token.tokenType == 907) {
            this.readNameTokenForCompleteMode();
            this.completeSchemaObject(null, ParserDQL.CompleteSchemaObjectParams.create().withSystem(false), 4, 3);
            rangeVariables = new RangeVariable[]{this.readSimpleRangeVariable(1205)};
            table = rangeVariables[0].getTable();
            objectName = table.getObjectName();
            isTable = true;
        } else {
            this.readThisNameTokenForCompleteMode(497);
            this.completeSchemaObject(null, ParserDQL.CompleteSchemaObjectParams.create().withSystem(false), 2);
            objectName = this.readSchemaName();
        }
        this.checkThatRuntimeOperationIsNotInSDS(objectName, "truncate");
        this.completeSimpleTree("continue identity", "restart identity");
        switch (this.token.tokenType) {
            case 376: {
                this.read();
                this.readThis(128);
                break;
            }
            case 484: {
                this.read();
                this.readThis(128);
                restartIdentity = true;
            }
        }
        if (!isTable) {
            this.checkIsThis(5);
        }
        if (this.readIfThis(194)) {
            this.readThis(44);
            onCommit = true;
            if (this.readIfThis(180)) {
                this.readThis(37);
                noCheck = true;
            }
        }
        boolean force = false;
        if (isTable) {
            if (this.readIfThis(1114)) {
                force = true;
            }
            writeTableNames = new NameManager.ObjectName[]{table.getObjectName()};
        } else {
            writeTableNames = this.session.dataspaceStore.schemaManager.getCatalogAndBaseTableNames();
        }
        if (!onCommit) {
            Object[] args = new Object[]{objectName, table, restartIdentity, noCheck, force};
            return new StatementCommand(1205, args, null, writeTableNames);
        }
        StatementDML cs = new StatementDML(this.session, table, rangeVariables, this.compileContext, restartIdentity, 1205);
        return cs;
    }

    Statement compilePurgeReplicationQueueStatement() {
        this.completeReplicationQueueName(true);
        ReplicationEntityName sourceEntityName = this.readReplicationQueueName();
        Object[] args = null;
        NameManager.ObjectName[] writeNames = new NameManager.ObjectName[]{};
        if (sourceEntityName.isLocalNode()) {
            Table table;
            try {
                String replicationQueueName = ReplicationQueue.getQueueName(sourceEntityName.getDataspaceName(), sourceEntityName.getSourceOrReplicaName());
                table = this.store.schemaManager.getTable(this.session, replicationQueueName, "RDS");
            }
            catch (DataspaceException e) {
                throw Error.error(SchemaObjectSet.getGetErrorCode(4), String.valueOf(sourceEntityName) + " replication queue");
            }
            args = new Object[]{sourceEntityName, table, false, false};
            writeNames = new NameManager.ObjectName[]{table.getObjectName()};
        } else {
            args = new Object[]{sourceEntityName};
        }
        return new StatementCommand(3281, args, null, writeNames);
    }

    Statement compilePurgeStatement() {
        boolean isTable = false;
        boolean noCheck = false;
        boolean restartIdentity = false;
        NameManager.ObjectName objectName = null;
        RangeVariable[] rangeVariables = null;
        Table table = null;
        Object writeTableNames = null;
        boolean purgeFirst = true;
        int numberOfRows = -1;
        this.read();
        if (this.checkIsReplicationQueue()) {
            return this.compilePurgeReplicationQueueStatement();
        }
        if (this.token.tokenType == 278 || this.token.tokenType == 908) {
            int collectionType = this.token.tokenType;
            this.readNameTokenForCompleteMode();
            this.completeCollection(this.token.tokenType == 908 ? new CollectionFilter(CollectionType.PROCESS_QUEUE, CollectionType.EVENT_QUEUE, CollectionType.AUDIT_QUEUE) : null);
            rangeVariables = new RangeVariable[]{this.readSimpleRangeVariable(1205)};
            table = rangeVariables[0].getTable();
            objectName = table.getObjectName();
            isTable = true;
            NameManager.ObjectName schemaName = objectName.schema;
            DataspaceSchema schema = this.store.schemaManager.findSchema(schemaName.name);
            if (collectionType == 278 && !schema.getType().equals(DataspaceType.TSPACE.name()) && !schema.getType().equals(DataspaceType.FSPACE.name())) {
                throw this.unsupportedRequest();
            }
            if (collectionType == 908 && !schema.getType().equals(DataspaceType.QSPACE.name())) {
                throw this.unsupportedRequest();
            }
        } else {
            this.readThis(497);
            objectName = this.readSchemaName();
        }
        switch (this.token.tokenType) {
            case 401: {
                purgeFirst = true;
                this.read();
                numberOfRows = this.readInteger();
                break;
            }
            case 430: {
                purgeFirst = false;
                this.read();
                numberOfRows = this.readInteger();
            }
        }
        if (!isTable) {
            this.checkIsThis(5);
        }
        StatementDML cs = new StatementDML(this.session, table, rangeVariables, this.compileContext, restartIdentity, 1205, numberOfRows, purgeFirst);
        return cs;
    }

    StatementDML compileDeleteStatement(RangeVariable[] outerRanges) {
        Table baseTable;
        Expression condition = null;
        boolean restartIdentity = false;
        this.readThis(79);
        this.readThisTokenOrComplete(115, true, true);
        this.completeCollection();
        RangeVariable[] rangeVariables = null;
        Table table = null;
        rangeVariables = new RangeVariable[]{this.readSimpleRangeVariable(19)};
        table = rangeVariables[0].getTable();
        if (table.getObjectType() != 3) {
            this.checkThatRuntimeOperationIsNotInSDS(table.getObjectName(), "delete");
        }
        if (table.isTriggerDeletable()) {
            rangeVariables[0].resetViewRageTableAsSubquery();
        }
        if (this.token.tokenType == 316) {
            this.read();
            condition = this.XreadBooleanValueExpression();
            HsqlList unresolved = condition.resolveColumnReferences(this.session, outerRanges, null);
            unresolved = Expression.resolveColumnSet(this.session, rangeVariables, rangeVariables.length, unresolved, null);
            ExpressionColumn.checkColumnsResolved(unresolved);
            condition.resolveTypes(this.session, null);
            if (condition.isUnresolvedParam()) {
                condition.dataType = Type.SQL_BOOLEAN;
            }
            if (condition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        Table table2 = baseTable = table.isTriggerDeletable() ? table : table.getBaseTable();
        if (table != baseTable) {
            QuerySpecification baseSelect = ((TableDerived)table).getQueryExpression().getMainSelect();
            RangeVariable[] newRangeVariables = (RangeVariable[])ArrayUtil.duplicateArray(baseSelect.rangeVariables);
            newRangeVariables[0] = baseSelect.rangeVariables[0].duplicate();
            Expression[] newBaseExprColumns = new Expression[baseSelect.indexLimitData];
            for (int i = 0; i < baseSelect.indexLimitData; ++i) {
                Expression e;
                newBaseExprColumns[i] = e = baseSelect.exprColumns[i].duplicate();
                e.replaceRangeVariables(baseSelect.rangeVariables, newRangeVariables);
            }
            Expression baseQueryCondition = baseSelect.queryCondition;
            if (baseQueryCondition != null) {
                baseQueryCondition = baseQueryCondition.duplicate();
                baseQueryCondition.replaceRangeVariables(rangeVariables, newRangeVariables);
            }
            if (condition != null) {
                condition = condition.replaceColumnReferences(rangeVariables[0], newBaseExprColumns);
            }
            rangeVariables = newRangeVariables;
            condition = ExpressionLogical.andExpressions(baseQueryCondition, condition);
        }
        if (condition != null) {
            rangeVariables[0].addJoinCondition(condition);
            RangeVariableResolver resolver = new RangeVariableResolver(rangeVariables, null, this.compileContext);
            resolver.processConditions(this.session);
            rangeVariables = resolver.rangeVariables;
        }
        if (table.isSnapshot()) {
            return new StatementUpdateSnapshot(this.session, table, rangeVariables, this.compileContext, restartIdentity, 19);
        }
        return new StatementDML(this.session, table, rangeVariables, this.compileContext, restartIdentity, 19);
    }

    Statement compileUpdateStatement(RangeVariable[] outerRanges) {
        Table baseTable;
        this.readNameTokenForCompleteMode();
        this.completeCollection();
        OrderedHashSet targetSet = new OrderedHashSet();
        LongDeque colIndexList = new LongDeque();
        HsqlArrayList exprList = new HsqlArrayList();
        RangeVariable[] rangeVariables = new RangeVariable[]{this.readSimpleRangeVariable(82)};
        Table table = rangeVariables[0].rangeTable;
        Table table2 = baseTable = table.isTriggerUpdatable() ? table : table.getBaseTable();
        if (table.getObjectType() != 3) {
            this.checkThatRuntimeOperationIsNotInSDS(table.getObjectName(), "update");
        }
        if (table.isTriggerUpdatable()) {
            rangeVariables[0].resetViewRageTableAsSubquery();
        }
        this.readThis(254);
        if (table.isSnapshot() && this.readIfThis(179)) {
            this.readThis(43);
            return this.compileUpdateSnapshotTableSetNewColumn(rangeVariables, outerRanges);
        }
        this.readSetClauseList(rangeVariables, targetSet, colIndexList, exprList, false);
        int[] columnMap = new int[colIndexList.size()];
        colIndexList.toArray(columnMap);
        Object[] targets = new Expression[targetSet.size()];
        targetSet.toArray(targets);
        for (int i = 0; i < targets.length; ++i) {
            this.resolveOuterReferencesAndTypes(outerRanges, (Expression)targets[i]);
        }
        boolean[] columnCheckList = table.getColumnCheckList(columnMap);
        Expression[] updateExpressions = new Expression[exprList.size()];
        exprList.toArray(updateExpressions);
        Expression condition = null;
        if (this.token.tokenType == 316) {
            this.read();
            condition = this.XreadBooleanValueExpression();
            HsqlList unresolved = condition.resolveColumnReferences(this.session, outerRanges, null);
            unresolved = Expression.resolveColumnSet(this.session, rangeVariables, rangeVariables.length, unresolved, null);
            unresolved = Expression.resolveColumnSet(this.session, this.session.sessionContext.sessionVariablesRange, this.session.sessionContext.sessionVariablesRange.length, unresolved, null);
            ExpressionColumn.checkColumnsResolved(unresolved);
            condition.resolveTypes(this.session, null);
            if (condition.isUnresolvedParam()) {
                condition.dataType = Type.SQL_BOOLEAN;
            }
            if (condition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        this.resolveUpdateExpressions(table, rangeVariables, columnMap, updateExpressions, outerRanges);
        if (table != baseTable) {
            QuerySpecification baseSelect = ((TableDerived)table).getQueryExpression().getMainSelect();
            RangeVariable[] newRangeVariables = (RangeVariable[])ArrayUtil.duplicateArray(baseSelect.rangeVariables);
            newRangeVariables[0] = baseSelect.rangeVariables[0].duplicate();
            Expression[] newBaseExprColumns = new Expression[baseSelect.indexLimitData];
            for (int i = 0; i < baseSelect.indexLimitData; ++i) {
                Expression e;
                newBaseExprColumns[i] = e = baseSelect.exprColumns[i].duplicate();
                e.replaceRangeVariables(baseSelect.rangeVariables, newRangeVariables);
            }
            Expression baseQueryCondition = baseSelect.queryCondition;
            if (baseQueryCondition != null) {
                baseQueryCondition = baseQueryCondition.duplicate();
                baseQueryCondition.replaceRangeVariables(rangeVariables, newRangeVariables);
            }
            if (condition != null) {
                condition = condition.replaceColumnReferences(rangeVariables[0], newBaseExprColumns);
            }
            for (int i = 0; i < updateExpressions.length; ++i) {
                updateExpressions[i] = updateExpressions[i].replaceColumnReferences(rangeVariables[0], newBaseExprColumns);
            }
            rangeVariables = newRangeVariables;
            condition = ExpressionLogical.andExpressions(baseQueryCondition, condition);
        }
        if (condition != null) {
            rangeVariables[0].addJoinCondition(condition);
            RangeVariableResolver resolver = new RangeVariableResolver(rangeVariables, null, this.compileContext);
            resolver.processConditions(this.session);
            rangeVariables = resolver.rangeVariables;
        }
        if (table != baseTable) {
            int[] baseColumnMap = table.getBaseTableColumnMap();
            int[] newColumnMap = new int[columnMap.length];
            ArrayUtil.projectRow(baseColumnMap, columnMap, newColumnMap);
            columnMap = newColumnMap;
            for (int i = 0; i < columnMap.length; ++i) {
                if (!baseTable.colGenerated[columnMap[i]]) continue;
                throw Error.error(5513);
            }
        }
        this.resolveFlobColumnsForUpdate(updateExpressions, baseTable, columnMap);
        this.resolveReadFileFunctionDataTypeForUpdate(updateExpressions, baseTable, columnMap);
        if (table.isSnapshot()) {
            return new StatementUpdateSnapshot(this.session, (Expression[])targets, table, rangeVariables, columnMap, updateExpressions, columnCheckList, this.compileContext, condition);
        }
        return new StatementDML(this.session, (Expression[])targets, table, rangeVariables, columnMap, updateExpressions, columnCheckList, this.compileContext);
    }

    private Statement compileUpdateSnapshotTableSetNewColumn(RangeVariable[] rangeVariables, RangeVariable[] outerRanges) {
        Table table = rangeVariables[0].rangeTable;
        int colIndex = table.getColumnCount();
        boolean isNullable = true;
        HsqlArrayList list = new HsqlArrayList();
        Constraint constraint = new Constraint(null, null, 5);
        list.add(constraint);
        this.checkIsSchemaObjectName();
        NameManager.ObjectName columnName = this.store.nameManager.newColumnHsqlName(table.getObjectName(), this.token.tokenString, this.isDelimitedIdentifier());
        if (table.findColumn(columnName.name) >= 0) {
            throw new DataspaceException("Column with name '" + columnName.name + "' already exists.");
        }
        this.read();
        this.readThis(535);
        Type type = this.readTypeDefinition(true, true);
        ColumnSchema column = new ColumnSchema(columnName, type, isNullable, false, null);
        if (this.token.tokenType == 343) {
            this.read();
            colIndex = table.getColumnIndex(this.token.tokenString);
            if (colIndex < 0) {
                throw new DataspaceException("Column with name '" + this.token.tokenString + "' doesn't exists.");
            }
            this.read();
        } else if (this.token.tokenType == 336) {
            this.read();
            colIndex = table.getColumnIndex(this.token.tokenString);
            if (colIndex < 0) {
                throw new DataspaceException("Column with name '" + this.token.tokenString + "' doesn't exists.");
            }
            ++colIndex;
            this.read();
        }
        Expression updateExpression = null;
        StatementUpdateSnapshot updateStatement = null;
        if (!this.session.isProcessingRecoveryLog() && !this.session.isProcessingLog()) {
            this.readThis(396);
            Expression[] targets = new Expression[]{new ExpressionColumn(column)};
            HsqlArrayList expressions = new HsqlArrayList();
            this.readAssignExpressions(1, expressions, targets[0], rangeVariables);
            int[] columnMap = new int[]{colIndex};
            Expression[] updateExpressions = new Expression[]{(Expression)expressions.get(0)};
            HsqlList unresolved = updateExpressions[0].resolveColumnReferences(this.session, outerRanges, null);
            unresolved = Expression.resolveColumnSet(this.session, rangeVariables, rangeVariables.length, unresolved, null);
            ExpressionColumn.checkColumnsResolved(unresolved);
            updateExpressions[0].resolveTypes(this.session, null);
            boolean[] columnCheckList = new boolean[table.columnCount + 1];
            columnCheckList[colIndex] = true;
            updateStatement = new StatementUpdateSnapshot(this.session, targets, table, rangeVariables, columnMap, updateExpressions, columnCheckList, this.compileContext, null);
            updateExpression = updateExpressions[0];
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{table, column, new Integer(colIndex), list, updateExpression, updateStatement};
        NameManager.ObjectName[] writeLockNames = this.store.schemaManager.getCatalogAndBaseTableNames(table.getObjectName());
        return new StatementSchema(sql, 3242, args, null, writeLockNames);
    }

    void resolveUpdateExpressions(Table targetTable, RangeVariable[] rangeVariables, int[] columnMap, Expression[] colExpressions, RangeVariable[] outerRanges) {
        HsqlList unresolved = null;
        int enforcedDefaultIndex = -1;
        if (targetTable.hasIdentityColumn() && targetTable.identitySequence.isAlways()) {
            enforcedDefaultIndex = targetTable.getIdentityColumnIndex();
        }
        int i = 0;
        int ix = 0;
        while (i < columnMap.length) {
            Expression expr = colExpressions[ix];
            if (targetTable.colGenerated[columnMap[i]]) {
                throw Error.error(5513);
            }
            if (expr.getType() == 25) {
                Expression[] elements = expr.nodes;
                j = 0;
                while (j < elements.length) {
                    e = elements[j];
                    if (enforcedDefaultIndex == columnMap[i] && e.getType() != 4) {
                        throw Error.error(5541);
                    }
                    if (e.isUnresolvedParam()) {
                        e.setAttributesAsColumn(targetTable.getColumn(columnMap[i]), true);
                    } else if (e.getType() == 4) {
                        if (targetTable.colDefaults[columnMap[i]] == null && targetTable.identityColumn != columnMap[i]) {
                            throw Error.error(5544);
                        }
                    } else {
                        unresolved = expr.resolveColumnReferences(this.session, outerRanges, null);
                        unresolved = Expression.resolveColumnSet(this.session, rangeVariables, rangeVariables.length, unresolved, null);
                        ExpressionColumn.checkColumnsResolved(unresolved);
                        unresolved = null;
                        e.resolveTypes(this.session, null);
                    }
                    ++j;
                    ++i;
                }
            } else if (expr.getType() == 22) {
                unresolved = expr.resolveColumnReferences(this.session, outerRanges, null);
                if ((unresolved = Expression.resolveColumnSet(this.session, rangeVariables, rangeVariables.length, unresolved, null)) != null && this.session.sessionContext.sessionVariablesRange != null) {
                    unresolved = Expression.resolveColumnSet(this.session, this.session.sessionContext.sessionVariablesRange, this.session.sessionContext.sessionVariablesRange.length, unresolved, null);
                }
                ExpressionColumn.checkColumnsResolved(unresolved);
                expr.resolveTypes(this.session, null);
                int count = expr.subQuery.queryExpression.getColumnCount();
                j = 0;
                while (j < count) {
                    if (enforcedDefaultIndex == columnMap[i]) {
                        throw Error.error(5541);
                    }
                    ++j;
                    ++i;
                }
            } else {
                e = expr;
                if (enforcedDefaultIndex == columnMap[i] && e.getType() != 4) {
                    throw Error.error(5541);
                }
                if (e.isUnresolvedParam()) {
                    e.setAttributesAsColumn(targetTable.getColumn(columnMap[i]), true);
                } else if (e.getType() == 4) {
                    if (targetTable.colDefaults[columnMap[i]] == null && targetTable.identityColumn != columnMap[i]) {
                        throw Error.error(5544);
                    }
                } else {
                    unresolved = expr.resolveColumnReferences(this.session, outerRanges, null);
                    unresolved = Expression.resolveColumnSet(this.session, rangeVariables, rangeVariables.length, unresolved, null);
                    ExpressionColumn.checkColumnsResolved(unresolved);
                    e.resolveTypes(this.session, null);
                }
                ++i;
            }
            ++ix;
        }
    }

    void readSetClauseList(RangeVariable[] rangeVars, OrderedHashSet targets, LongDeque colIndexList, HsqlArrayList expressions, boolean isDeclaration) {
        while (true) {
            int degree;
            Expression lastTarget = null;
            if (this.token.tokenType == 786) {
                this.read();
                int oldCount = targets.size();
                this.readTargetSpecificationList(targets, rangeVars, colIndexList);
                degree = targets.size() - oldCount;
                this.readThis(772);
            } else {
                Expression target = this.XreadTargetSpecification(rangeVars, colIndexList, isDeclaration);
                if (!targets.add(target)) {
                    ColumnSchema col = target.getColumn();
                    throw Error.error(5579, col.getObjectName().name);
                }
                lastTarget = target;
                degree = 1;
            }
            if (this.token.tokenType != 396) {
                if (lastTarget != null) {
                    targets.remove(lastTarget);
                    colIndexList.removeLast();
                }
                if (this.token.tokenType != 774) break;
                this.read();
                continue;
            }
            this.readThis(396);
            this.readAssignExpressions(degree, expressions, (Expression)targets.get(0), rangeVars);
            if (this.token.tokenType != 774) break;
            this.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAssignExpressions(int degree, HsqlArrayList expressions, Expression target, RangeVariable[] rangeVars) {
        int position = this.getPosition();
        int brackets = this.readOpenBrackets();
        if (this.token.tokenType == 251) {
            this.rewind(position);
            SubQuery sq = this.XreadSubqueryBody(this.session.sessionContext.sessionVariablesRange, 22);
            if (degree != sq.queryExpression.getColumnCount()) {
                if (degree == 1) {
                    if (!(target.getDataType() instanceof OtherType) || ((OtherType)target.getDataType()).getInternalClass(this.session) != RowSet.class) {
                        throw Error.error(5546);
                    }
                } else {
                    throw Error.error(5546);
                }
            }
            Expression e = new Expression(22, sq);
            expressions.add(e);
            return;
        }
        if (this.token.tokenType == 99) {
            this.read();
            expressions.add(this.compileExecImmediateExpression());
            return;
        }
        if (this.token.tokenType == 79) {
            expressions.add(new UpdateDeleteStatementExpression(this.compileDeleteStatement(rangeVars != null ? rangeVars : this.session.sessionContext.sessionVariablesRange)));
            if (brackets > 0) {
                this.readCloseBrackets(brackets);
                brackets = 0;
            }
            return;
        }
        if (this.token.tokenType == 303) {
            expressions.add(new UpdateDeleteStatementExpression(this.compileUpdateStatement(rangeVars != null ? rangeVars : this.session.sessionContext.sessionVariablesRange)));
            if (brackets > 0) {
                this.readCloseBrackets(brackets);
                brackets = 0;
            }
            return;
        }
        if (brackets > 0) {
            this.rewind(position);
        }
        if (degree > 1) {
            int rowDegree;
            this.readThis(786);
            Expression e = this.readRow();
            this.readThis(772);
            int n = rowDegree = e.getType() == 25 ? e.nodes.length : 1;
            if (degree != rowDegree) {
                throw Error.error(5546);
            }
            expressions.add(e);
        } else {
            try {
                this.inReadRow = true;
                Expression e = this.XreadValueExpressionWithContext();
                expressions.add(e);
            }
            finally {
                this.inReadRow = false;
            }
        }
    }

    void readGetClauseList(RangeVariable[] rangeVars, OrderedHashSet targets, LongDeque colIndexList, HsqlArrayList expressions) {
        while (true) {
            Expression target;
            if (!targets.add(target = this.XreadTargetSpecification(rangeVars, colIndexList, false))) {
                ColumnSchema col = target.getColumn();
                throw Error.error(5579, col.getObjectName().name);
            }
            this.readThis(396);
            switch (this.token.tokenType) {
                case 443: 
                case 495: {
                    int columnIndex = ExpressionColumn.diagnosticsList.getIndex(this.token.tokenString);
                    ExpressionColumn e = new ExpressionColumn(10, columnIndex);
                    expressions.add(e);
                    this.read();
                    break;
                }
            }
            if (this.token.tokenType != 774) break;
            this.read();
        }
    }

    StatementDfetch compileDfetchStatement(int props, RangeVariable[] outerRanges) {
        if (!this.store.txManager.isMVCC()) {
            throw new DataspaceException("dfetch operation allowed only with MVCC transaction manager.");
        }
        QueryExpression queryExpression = this.XreadQueryExpression(outerRanges);
        if (!(queryExpression instanceof QuerySpecification)) {
            throw new DataspaceException("Wrong query, expected query specification.");
        }
        QuerySpecification querySpecification = (QuerySpecification)queryExpression;
        SortAndSlice sortAndSlice = querySpecification.sortAndSlice;
        if (sortAndSlice == null || sortAndSlice == SortAndSlice.noSort) {
            sortAndSlice = new SortAndSlice();
        }
        sortAndSlice.addLimitCondition(new ExpressionOp(95, new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER), new ExpressionValue(ValuePool.INTEGER_1, Type.SQL_INTEGER)));
        querySpecification.addSortAndSlice(sortAndSlice);
        if (ResultProperties.isUpdatable(props)) {
            querySpecification.isUpdatable = true;
        }
        querySpecification.setReturningResult();
        querySpecification.resolve(this.session, outerRanges, null);
        HashSet<String> addedColumns = new HashSet<String>();
        Table baseTable = null;
        for (RangeVariable rangeVariable : querySpecification.rangeVariables) {
            if (baseTable == null) {
                baseTable = rangeVariable.getTable();
            }
            if (baseTable != rangeVariable.getTable()) {
                throw new DataspaceException("Take operation can operate with single table only.");
            }
            if (baseTable != rangeVariable.getTable().getBaseTable()) {
                throw new DataspaceException("Take operation can operate with single table only, not base table should be there.");
            }
            if (!rangeVariable.isLeftJoin && !rangeVariable.isRightJoin) continue;
            throw new DataspaceException("Joins not allowed in take operation.");
        }
        if (baseTable.hasIdentityColumn() || baseTable.hasPrimaryKey()) {
            ColumnSchema columnSchema;
            HashSet<String> columnNames = new HashSet<String>();
            for (Expression expression : querySpecification.exprColumns) {
                if (!(expression instanceof ExpressionColumn)) continue;
                columnNames.add(((ExpressionColumn)expression).column.getNameString());
            }
            if (baseTable.hasPrimaryKey()) {
                for (int index : baseTable.getPrimaryKey()) {
                    ColumnSchema primaryKey = baseTable.getColumn(index);
                    if (columnNames.contains(primaryKey.getNameString())) continue;
                    querySpecification.addSelectColumnExpression(new ExpressionColumn(primaryKey));
                    addedColumns.add(primaryKey.getNameString());
                }
            } else if (baseTable.hasIdentityColumn() && !columnNames.contains((columnSchema = baseTable.getColumn(baseTable.getIdentityColumnIndex())).getNameString())) {
                querySpecification.addSelectColumnExpression(new ExpressionColumn(columnSchema));
                addedColumns.add(columnSchema.getNameString());
            }
            if (addedColumns.size() > 0) {
                querySpecification.resolve(this.session, outerRanges, null);
            }
        } else {
            throw new DataspaceException("Specified table '" + baseTable.getObjectName().name + "' doesn't has identity column or primary key.");
        }
        if (!baseTable.isUpdatable()) {
            throw Error.error(5545);
        }
        boolean deleteRow = false;
        StatementDML updateRowStatement = null;
        long[] lArray = new long[]{-1L};
        TimeUnit[] timeUnit = new TimeUnit[]{TimeUnit.MILLISECONDS};
        if (this.token.tokenType == 786) {
            this.read();
            if (this.token.tokenType == 79) {
                this.read();
                this.readThis(243);
                deleteRow = true;
            } else if (this.token.tokenType == 303) {
                this.read();
                this.readThis(243);
                this.readThis(254);
                OrderedHashSet targetSet = new OrderedHashSet();
                LongDeque colIndexList = new LongDeque();
                HsqlArrayList exprList = new HsqlArrayList();
                this.readSetClauseList(querySpecification.rangeVariables, targetSet, colIndexList, exprList, false);
                int[] columnMap = new int[colIndexList.size()];
                colIndexList.toArray(columnMap);
                Object[] targets = new Expression[targetSet.size()];
                targetSet.toArray(targets);
                for (int i = 0; i < targets.length; ++i) {
                    this.resolveOuterReferencesAndTypes(outerRanges, (Expression)targets[i]);
                }
                boolean[] columnCheckList = querySpecification.rangeVariables[0].rangeTable.getColumnCheckList(columnMap);
                Expression[] updateExpressions = new Expression[exprList.size()];
                exprList.toArray(updateExpressions);
                this.resolveUpdateExpressions(querySpecification.rangeVariables[0].rangeTable, querySpecification.rangeVariables, columnMap, updateExpressions, outerRanges);
                updateRowStatement = new StatementDML(this.session, (Expression[])targets, querySpecification.rangeVariables[0].rangeTable, querySpecification.rangeVariables, columnMap, updateExpressions, columnCheckList, this.compileContext);
            }
            this.readThis(772);
        }
        this.readTimeoutTokens(lArray, timeUnit);
        StatementDfetch statementDfetch = new StatementDfetch(this.session, querySpecification, this.compileContext, deleteRow);
        statementDfetch.setAddedColumns(addedColumns);
        statementDfetch.setUpdateRowStatement(updateRowStatement);
        statementDfetch.setTimeout(lArray[0], timeUnit[0]);
        return statementDfetch;
    }

    StatementDMQL compileMergeStatement(RangeVariable[] outerRanges) {
        int[] insertColumnMap = null;
        int[] updateColumnMap = null;
        Object[] targets = null;
        HsqlArrayList updateList = new HsqlArrayList();
        Expression[] updateExpressions = Expression.emptyArray;
        HsqlArrayList insertList = new HsqlArrayList();
        Expression insertExpression = null;
        this.read();
        this.readThis(141);
        RangeVariable targetRange = this.readSimpleRangeVariable(128);
        Table table = targetRange.rangeTable;
        this.readThis(306);
        RangeVariable sourceRange = this.readTableOrSubquery(outerRanges);
        this.readThis(194);
        Expression mergeCondition = this.XreadBooleanValueExpression();
        if (mergeCondition.getDataType() != Type.SQL_BOOLEAN) {
            throw Error.error(5568);
        }
        RangeVariable[] fullRangeVars = new RangeVariable[]{sourceRange, targetRange};
        RangeVariable[] sourceRangeVars = new RangeVariable[]{sourceRange};
        RangeVariable[] targetRangeVars = new RangeVariable[]{targetRange};
        insertColumnMap = table.getColumnMap();
        boolean[] insertColumnCheckList = table.getNewColumnCheckList();
        OrderedHashSet updateTargetSet = new OrderedHashSet();
        OrderedHashSet insertColNames = new OrderedHashSet();
        LongDeque updateColIndexList = new LongDeque();
        this.readMergeWhen(updateColIndexList, insertColNames, updateTargetSet, insertList, updateList, targetRangeVars, sourceRange);
        if (insertList.size() > 0) {
            int colCount = insertColNames.size();
            if (colCount != 0) {
                insertColumnMap = table.getColumnIndexes(insertColNames);
                insertColumnCheckList = table.getColumnCheckList(insertColumnMap);
            }
            insertExpression = (Expression)insertList.get(0);
            ParserDML.setParameterTypes(insertExpression, table, insertColumnMap);
        }
        if (updateList.size() > 0) {
            targets = new Expression[updateTargetSet.size()];
            updateTargetSet.toArray(targets);
            for (int i = 0; i < targets.length; ++i) {
                this.resolveOuterReferencesAndTypes(outerRanges, (Expression)targets[i]);
            }
            updateExpressions = new Expression[updateList.size()];
            updateList.toArray(updateExpressions);
            updateColumnMap = new int[updateColIndexList.size()];
            updateColIndexList.toArray(updateColumnMap);
        }
        if (updateExpressions.length != 0) {
            Table baseTable = table.isTriggerUpdatable() ? table : table.getBaseTable();
            int[] baseUpdateColumnMap = updateColumnMap;
            if (table != baseTable) {
                baseUpdateColumnMap = new int[updateColumnMap.length];
                ArrayUtil.projectRow(table.getBaseTableColumnMap(), updateColumnMap, baseUpdateColumnMap);
            }
            this.resolveUpdateExpressions(table, fullRangeVars, updateColumnMap, updateExpressions, outerRanges);
        }
        HsqlList unresolved = null;
        unresolved = mergeCondition.resolveColumnReferences(this.session, fullRangeVars, null);
        unresolved = Expression.resolveColumnSet(this.session, outerRanges, outerRanges.length, unresolved, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        mergeCondition.resolveTypes(this.session, null);
        if (mergeCondition.isUnresolvedParam()) {
            mergeCondition.dataType = Type.SQL_BOOLEAN;
        }
        if (mergeCondition.getDataType() != Type.SQL_BOOLEAN) {
            throw Error.error(5568);
        }
        fullRangeVars[1].addJoinCondition(mergeCondition);
        RangeVariableResolver resolver = new RangeVariableResolver(fullRangeVars, null, this.compileContext);
        resolver.processConditions(this.session);
        fullRangeVars = resolver.rangeVariables;
        if (insertExpression != null) {
            unresolved = insertExpression.resolveColumnReferences(this.session, sourceRangeVars, null);
            unresolved = Expression.resolveColumnSet(this.session, outerRanges, outerRanges.length, unresolved, null);
            ExpressionColumn.checkColumnsResolved(unresolved);
            insertExpression.resolveTypes(this.session, null);
        }
        StatementDML cs = new StatementDML(this.session, (Expression[])targets, fullRangeVars, insertColumnMap, updateColumnMap, insertColumnCheckList, mergeCondition, insertExpression, updateExpressions, this.compileContext);
        return cs;
    }

    private void readMergeWhen(LongDeque updateColIndexList, OrderedHashSet insertColumnNames, OrderedHashSet updateTargetSet, HsqlArrayList insertExpressions, HsqlArrayList updateExpressions, RangeVariable[] targetRangeVars, RangeVariable sourceRangeVar) {
        Table table = targetRangeVars[0].rangeTable;
        int columnCount = table.getColumnCount();
        this.readThis(314);
        if (this.token.tokenType == 437) {
            if (updateExpressions.size() != 0) {
                throw Error.error(5547);
            }
            this.read();
            this.readThis(280);
            this.readThis(303);
            this.readThis(254);
            this.readSetClauseList(targetRangeVars, updateTargetSet, updateColIndexList, updateExpressions, false);
        } else if (this.token.tokenType == 183) {
            if (insertExpressions.size() != 0) {
                throw Error.error(5548);
            }
            this.read();
            this.readThis(437);
            this.readThis(280);
            this.readThis(135);
            int brackets = this.readOpenBrackets();
            if (brackets == 1) {
                this.readSimpleColumnNames(insertColumnNames, targetRangeVars[0]);
                columnCount = insertColumnNames.size();
                this.readThis(772);
                brackets = 0;
            }
            this.readThis(308);
            Expression e = this.XreadContextuallyTypedTable(columnCount);
            if (e.nodes.length != 1) {
                throw Error.error(3201, new Object[]{e.getSQL()});
            }
            insertExpressions.add(e);
        } else {
            throw this.unexpectedToken();
        }
        if (this.token.tokenType == 314) {
            this.readMergeWhen(updateColIndexList, insertColumnNames, updateTargetSet, insertExpressions, updateExpressions, targetRangeVars, sourceRangeVar);
        }
    }

    StatementDMQL compileCallStatement(RangeVariable[] outerRanges, boolean isStrictlyProcedure) {
        this.read();
        if (this.isIdentifier()) {
            int position = this.scanner.getPosition();
            String tokenPrefix = this.readTokenPrefixName();
            String tokenPrePrefix = this.readTokenPrefixName();
            this.checkValidCatalogName(tokenPrePrefix);
            RoutineSchema routineSchema = (RoutineSchema)this.store.schemaManager.findSchemaObject(this.token.tokenString, this.session.getSchemaName(tokenPrefix), 18);
            if (routineSchema != null) {
                int i;
                this.read();
                HsqlArrayList list = new HsqlArrayList();
                this.readThis(786);
                if (this.token.tokenType == 772) {
                    this.read();
                } else {
                    while (true) {
                        Expression e = this.XreadValueExpression();
                        list.add(e);
                        if (this.token.tokenType != 774) break;
                        this.read();
                    }
                    this.readThis(772);
                }
                Expression[] arguments = new Expression[list.size()];
                list.toArray(arguments);
                RplScript routine = routineSchema.getSpecificRoutine(arguments.length);
                this.compileContext.addProcedureCall(routine);
                HsqlList unresolved = null;
                for (i = 0; i < arguments.length; ++i) {
                    Expression e = arguments[i];
                    if (e.isUnresolvedParam()) {
                        e.setAttributesAsColumn(routine.getParameter(i), routine.getParameter(i).isWriteable());
                        continue;
                    }
                    byte paramMode = routine.getParameter(i).getParameterMode();
                    unresolved = arguments[i].resolveColumnReferences(this.session, outerRanges, unresolved);
                    if (paramMode == 1 || e.getType() == 6) continue;
                    throw Error.error(5603);
                }
                ExpressionColumn.checkColumnsResolved(unresolved);
                for (i = 0; i < arguments.length; ++i) {
                    arguments[i].resolveTypes(this.session, null);
                    if (routine.getParameter(i).getDataType().canBeAssignedFrom(arguments[i].getDataType())) continue;
                    throw Error.error(5561);
                }
                StatementProcedure cs = new StatementProcedure(this.session, routine, arguments, this.compileContext);
                return cs;
            }
            this.rewind(position);
        }
        if (isStrictlyProcedure) {
            throw Error.error(5501, this.token.tokenString);
        }
        Expression expression = this.XreadValueExpression();
        HsqlList unresolved = expression.resolveColumnReferences(this.session, outerRanges, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        expression.resolveTypes(this.session, null);
        StatementProcedure cs = new StatementProcedure(this.session, expression, this.compileContext);
        return cs;
    }

    StatementRplExec compileExecuteActorStatement(RangeVariable[] outerRanges, boolean isStrictlyProcedure) {
        if (this.session.isInteractive()) {
            throw this.unexpectedToken();
        }
        this.readThis(1059);
        Actor handler = (Actor)this.readSchemaObjectName(32);
        return handler.getRoutineStatement();
    }

    StatementRplExec compileExecuteReplicationTriggerStatement(RangeVariable[] outerRanges, boolean isStrictlyProcedure) {
        if (this.session.isInteractive()) {
            throw this.unexpectedToken();
        }
        this.readThis(956);
        this.readThis(291);
        AbstractReplicationEventTrigger trigger = (AbstractReplicationEventTrigger)this.readSchemaObjectName(9);
        return trigger.getRoutineStatement();
    }

    public StatementCollectionInvoke compileInvokeStatement() {
        this.read();
        if (!StringUtils.hasIdentifierFormat(this.token.tokenString)) {
            throw this.unexpectedToken();
        }
        String invokeOperation = this.token.tokenString;
        this.read();
        this.readThisTokenOrComplete(194, true, true);
        this.completeCollection();
        SchemaObject object = this.readSchemaObjectName(4);
        Object[] args = new Object[]{object, invokeOperation};
        String sql = this.getLastPart();
        return new StatementCollectionInvoke(3003, args);
    }

    StatementDMQL compilePutStatement(RangeVariable[] outerRanges) {
        this.read();
        if (this.token.tokenType == 141) {
            this.readThisNameTokenForCompleteMode(141);
            this.completeCollection(new CollectionFilter(CollectionType.MAP));
            Collection collection = this.readCollectionName();
            Table table = collection.getBaseTable();
            boolean overridingUser = false;
            boolean overridingSystem = false;
            boolean assignsToIdentity = false;
            boolean[] columnCheckList = null;
            int[] columnMap = collection.getBaseTable().getColumnMap();
            int colCount = collection.getBaseTable().getColumnCount();
            int position = this.getPosition();
            if (!(collection.getBaseTable().isInsertable() || collection.getBaseTable().isTriggerInsertable() || this.session.isProcessingLog)) {
                throw Error.error(5545);
            }
            Table baseTable = collection.getBaseTable().isTriggerInsertable() ? collection.getBaseTable() : collection.getBaseTable().getBaseTable();
            switch (this.token.tokenType) {
                case 308: {
                    this.read();
                    columnCheckList = table.getColumnCheckList(columnMap);
                    Expression insertExpressions = this.XreadContextuallyTypedTable(colCount);
                    HsqlList unresolved = insertExpressions.resolveColumnReferences(this.session, outerRanges, null);
                    ExpressionColumn.checkColumnsResolved(unresolved);
                    insertExpressions.resolveTypes(this.session, null);
                    ParserDML.setParameterTypes(insertExpressions, table, columnMap);
                    if (table != baseTable) {
                        int[] baseColumnMap = table.getBaseTableColumnMap();
                        int[] newColumnMap = new int[columnMap.length];
                        ArrayUtil.projectRow(baseColumnMap, columnMap, newColumnMap);
                        columnMap = newColumnMap;
                    }
                    Expression[] rowList = insertExpressions.nodes;
                    for (int j = 0; j < rowList.length; ++j) {
                        Expression[] rowArgs = rowList[j].nodes;
                        for (int i = 0; i < rowArgs.length; ++i) {
                            Expression e = rowArgs[i];
                            ColumnSchema column = baseTable.getColumn(columnMap[i]);
                            if (column.isIdentity()) {
                                assignsToIdentity = true;
                                if (e.getType() != 4) {
                                    if (table.identitySequence.isAlways() && !overridingUser && !overridingSystem) {
                                        throw Error.error(5543);
                                    }
                                    if (overridingUser) {
                                        rowArgs[i] = new ExpressionColumn(4);
                                    }
                                }
                            } else if (!column.hasDefault()) {
                                if (column.isGenerated()) {
                                    if (e.getType() != 4) {
                                        throw Error.error(5541);
                                    }
                                } else if (e.getType() == 4) {
                                    throw Error.error(5544);
                                }
                            }
                            if (!e.isUnresolvedParam()) continue;
                            e.setAttributesAsColumn(column, true);
                        }
                    }
                    if (!assignsToIdentity && (overridingUser || overridingSystem)) {
                        this.unexpectedTokenRequire("OVERRIDING");
                    }
                    StatementPut cs = new StatementPut(this.session, collection, table, columnMap, insertExpressions, columnCheckList, this.compileContext);
                    return cs;
                }
                case 251: 
                case 278: 
                case 319: {
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            columnCheckList = table.getColumnCheckList(columnMap);
            if (baseTable != null && table != baseTable) {
                int[] baseColumnMap = table.getBaseTableColumnMap();
                int[] newColumnMap = new int[columnMap.length];
                ArrayUtil.projectRow(baseColumnMap, columnMap, newColumnMap);
                columnMap = newColumnMap;
            }
            int enforcedDefaultIndex = table.getIdentityColumnIndex();
            int overrideIndex = -1;
            if (enforcedDefaultIndex != -1 && ArrayUtil.find(columnMap, enforcedDefaultIndex) > -1) {
                if (table.identitySequence.isAlways() && !overridingUser && !overridingSystem) {
                    throw Error.error(5543);
                }
                if (overridingUser) {
                    overrideIndex = enforcedDefaultIndex;
                }
            } else if (overridingUser || overridingSystem) {
                this.unexpectedTokenRequire("OVERRIDING");
            }
            Object[] types = new Type[columnMap.length];
            ArrayUtil.projectRow(baseTable.getColumnTypes(), columnMap, types);
            QueryExpression queryExpression = this.XreadQueryExpression(RangeVariable.emptyArray);
            queryExpression.setReturningResult();
            queryExpression.resolve(this.session, outerRanges, (Type[])types);
            if (colCount != queryExpression.getColumnCount()) {
                throw Error.error(5546);
            }
            StatementInsert cs = new StatementInsert(this.session, table, columnMap, columnCheckList, queryExpression, this.compileContext, overrideIndex);
            return cs;
        }
        Expression valueExpression = this.XreadValueExpressionWithContext();
        HsqlList unresolved = valueExpression.resolveColumnReferences(this.session, outerRanges, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        valueExpression.resolveTypes(this.session, null);
        this.readThisNameTokenForCompleteMode(141);
        this.completeCollection(new CollectionFilter(CollectionType.AUDIT_QUEUE, CollectionType.PROCESS_QUEUE, CollectionType.BLOCKING_QUEUE, CollectionType.EVENT_QUEUE));
        Collection collection = this.readCollectionName();
        if (!(collection instanceof BlockingQueueCollection)) {
            throw new DataspaceException("put <value> allowed for queues only.");
        }
        if (!(collection.getBaseTable().isInsertable() || collection.getBaseTable().isTriggerInsertable() || this.session.isProcessingLog)) {
            throw Error.error(5545);
        }
        return new StatementPutIntoQueue(this.session, (BlockingQueueCollection)collection, valueExpression, this.compileContext);
    }

    Statement compileGetDiagnosticsStatement(RangeVariable[] rangeVars) {
        int i;
        this.read();
        this.readThis(391);
        OrderedHashSet targetSet = new OrderedHashSet();
        HsqlArrayList exprList = new HsqlArrayList();
        LongDeque colIndexList = new LongDeque();
        this.readGetClauseList(rangeVars, targetSet, colIndexList, exprList);
        if (exprList.size() > 1) {
            throw Error.error(5602);
        }
        Expression expression = (Expression)exprList.get(0);
        if (expression.getDegree() != targetSet.size()) {
            throw Error.error(5546, "SET");
        }
        int[] columnMap = new int[colIndexList.size()];
        colIndexList.toArray(columnMap);
        Object[] targets = new Expression[targetSet.size()];
        targetSet.toArray(targets);
        for (i = 0; i < targets.length; ++i) {
            this.resolveOuterReferencesAndTypes(rangeVars, (Expression)targets[i]);
        }
        this.resolveOuterReferencesAndTypes(rangeVars, expression);
        for (i = 0; i < targets.length; ++i) {
            if (((Expression)targets[i]).getColumn().getParameterMode() == 1) {
                throw Error.error(2500);
            }
            if (((Expression)targets[i]).getDataType().canBeAssignedFrom(expression.getNodeDataType(i))) continue;
            throw Error.error(5561);
        }
        StatementSet cs = new StatementSet(this.session, (Expression[])targets, expression, columnMap, this.compileContext);
        return cs;
    }

    Statement compileGetStatement(RangeVariable[] outerRanges) {
        this.read();
        if (this.token.tokenType == 391) {
            return this.compileGetDiagnosticsStatement(this.session.sessionContext.sessionVariablesRange);
        }
        this.readThis(141);
        Collection collection = this.readCollectionName();
        Table table = collection.getBaseTable();
        boolean overridingUser = false;
        boolean overridingSystem = false;
        boolean assignsToIdentity = false;
        boolean[] columnCheckList = null;
        int[] columnMap = collection.getBaseTable().getColumnMap();
        int colCount = collection.getBaseTable().getColumnCount();
        int position = this.getPosition();
        if (!(collection.getBaseTable().isInsertable() || collection.getBaseTable().isTriggerInsertable() || this.session.isProcessingLog)) {
            throw Error.error(5545);
        }
        Table baseTable = collection.getBaseTable().isTriggerInsertable() ? collection.getBaseTable() : collection.getBaseTable().getBaseTable();
        switch (this.token.tokenType) {
            case 308: {
                this.read();
                columnCheckList = table.getColumnCheckList(columnMap);
                Expression insertExpressions = this.XreadContextuallyTypedTable(colCount);
                HsqlList unresolved = insertExpressions.resolveColumnReferences(this.session, outerRanges, null);
                ExpressionColumn.checkColumnsResolved(unresolved);
                insertExpressions.resolveTypes(this.session, null);
                ParserDML.setParameterTypes(insertExpressions, table, columnMap);
                if (table != baseTable) {
                    int[] baseColumnMap = table.getBaseTableColumnMap();
                    int[] newColumnMap = new int[columnMap.length];
                    ArrayUtil.projectRow(baseColumnMap, columnMap, newColumnMap);
                    columnMap = newColumnMap;
                }
                Expression[] rowList = insertExpressions.nodes;
                for (int j = 0; j < rowList.length; ++j) {
                    Expression[] rowArgs = rowList[j].nodes;
                    for (int i = 0; i < rowArgs.length; ++i) {
                        Expression e = rowArgs[i];
                        ColumnSchema column = baseTable.getColumn(columnMap[i]);
                        if (column.isIdentity()) {
                            assignsToIdentity = true;
                            if (e.getType() != 4) {
                                if (table.identitySequence.isAlways() && !overridingUser && !overridingSystem) {
                                    throw Error.error(5543);
                                }
                                if (overridingUser) {
                                    rowArgs[i] = new ExpressionColumn(4);
                                }
                            }
                        } else if (!column.hasDefault()) {
                            if (column.isGenerated()) {
                                if (e.getType() != 4) {
                                    throw Error.error(5541);
                                }
                            } else if (e.getType() == 4) {
                                throw Error.error(5544);
                            }
                        }
                        if (!e.isUnresolvedParam()) continue;
                        e.setAttributesAsColumn(column, true);
                    }
                }
                if (!assignsToIdentity && (overridingUser || overridingSystem)) {
                    this.unexpectedTokenRequire("OVERRIDING");
                }
                StatementPut cs = new StatementPut(this.session, collection, table, columnMap, insertExpressions, columnCheckList, this.compileContext);
                return cs;
            }
            case 251: 
            case 278: 
            case 319: {
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        columnCheckList = table.getColumnCheckList(columnMap);
        if (baseTable != null && table != baseTable) {
            int[] baseColumnMap = table.getBaseTableColumnMap();
            int[] newColumnMap = new int[columnMap.length];
            ArrayUtil.projectRow(baseColumnMap, columnMap, newColumnMap);
            columnMap = newColumnMap;
        }
        int enforcedDefaultIndex = table.getIdentityColumnIndex();
        int overrideIndex = -1;
        if (enforcedDefaultIndex != -1 && ArrayUtil.find(columnMap, enforcedDefaultIndex) > -1) {
            if (table.identitySequence.isAlways() && !overridingUser && !overridingSystem) {
                throw Error.error(5543);
            }
            if (overridingUser) {
                overrideIndex = enforcedDefaultIndex;
            }
        } else if (overridingUser || overridingSystem) {
            this.unexpectedTokenRequire("OVERRIDING");
        }
        Object[] types = new Type[columnMap.length];
        ArrayUtil.projectRow(baseTable.getColumnTypes(), columnMap, types);
        QueryExpression queryExpression = this.XreadQueryExpression(RangeVariable.emptyArray);
        queryExpression.setReturningResult();
        queryExpression.resolve(this.session, outerRanges, (Type[])types);
        if (colCount != queryExpression.getColumnCount()) {
            throw Error.error(5546);
        }
        StatementInsert cs = new StatementInsert(this.session, table, columnMap, columnCheckList, queryExpression, this.compileContext, overrideIndex);
        return cs;
    }

    Statement compileAlterRecoveryStatement() {
        this.readThis(954);
        Expression statementNumber = null;
        if (this.token.tokenType == 517) {
            this.read();
            statementNumber = this.XreadNumericValueExpression();
            this.resolveOuterReferencesAndTypes(this.session.sessionContext.sessionVariablesRange, statementNumber);
        }
        FileTableCollection recoveryTable = (FileTableCollection)this.session.dataspaceStore.schemaManager.findSchemaObject("RECOVERY_LOG", "SDS", 4);
        RangeVariable[] outerRanges = this.session.sessionContext.sessionVariablesRange;
        RangeVariable range = new RangeVariable(recoveryTable.getBaseTable(), null, null, null, this.compileContext);
        RangeVariable[] rangeVariables = new RangeVariable[]{range};
        Expression[] updateExpressions = new Expression[]{};
        Object[] targets = new Expression[]{};
        int[] columnMap = new int[]{};
        boolean[] columnCheckList = new boolean[]{};
        OrderedHashSet targetSet = new OrderedHashSet();
        LongDeque colIndexList = new LongDeque();
        HsqlArrayList exprList = new HsqlArrayList();
        Table table = rangeVariables[0].rangeTable;
        if (this.token.tokenType == 254) {
            this.readThis(254);
            this.readSetClauseList(rangeVariables, targetSet, colIndexList, exprList, false);
            columnMap = new int[colIndexList.size()];
            colIndexList.toArray(columnMap);
            targets = new Expression[targetSet.size()];
            targetSet.toArray(targets);
            for (int i = 0; i < targets.length; ++i) {
                this.resolveOuterReferencesAndTypes(outerRanges, (Expression)targets[i]);
            }
            columnCheckList = table.getColumnCheckList(columnMap);
            updateExpressions = new Expression[exprList.size()];
            exprList.toArray(updateExpressions);
        }
        Expression condition = null;
        if (this.token.tokenType == 316) {
            this.read();
            condition = this.XreadBooleanValueExpression();
        }
        if (statementNumber != null) {
            int columnIndex = table.findColumn("STATEMENT_ID");
            if (columnIndex == -1) {
                throw this.unexpectedToken("Recovery Log table definition is corrupted.");
            }
            ColumnSchema column = table.getColumn(columnIndex);
            ExpressionColumn statementIdColumn = new ExpressionColumn(column);
            ExpressionLogical checkForStatId = new ExpressionLogical(41, statementIdColumn, statementNumber);
            condition = condition != null ? new ExpressionLogical(49, checkForStatId, condition) : checkForStatId;
        }
        if (condition != null) {
            HsqlList unresolved = condition.resolveColumnReferences(this.session, outerRanges, null);
            unresolved = Expression.resolveColumnSet(this.session, rangeVariables, rangeVariables.length, unresolved, null);
            ExpressionColumn.checkColumnsResolved(unresolved);
            condition.resolveTypes(this.session, null);
            if (condition.isUnresolvedParam()) {
                condition.dataType = Type.SQL_BOOLEAN;
            }
            if (condition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        this.resolveUpdateExpressions(table, rangeVariables, columnMap, updateExpressions, outerRanges);
        if (condition != null) {
            rangeVariables[0].addJoinCondition(condition);
            RangeVariableResolver resolver = new RangeVariableResolver(rangeVariables, null, this.compileContext);
            resolver.processConditions(this.session);
            rangeVariables = resolver.rangeVariables;
        }
        StatementDML cs = new StatementDML(this.session, (Expression[])targets, table, rangeVariables, columnMap, updateExpressions, columnCheckList, this.compileContext);
        return cs;
    }

    Statement compileAlterPackageManifest() {
        this.readThis(1064);
        this.readThis(1065);
        String packageName = null;
        PackageType packageType = null;
        String tokenPrefix = this.readTokenPrefixName();
        if (tokenPrefix == null) {
            throw new DataspaceException("Package type is not specified.");
        }
        try {
            packageType = PackageType.valueOf(tokenPrefix);
        }
        catch (Exception error) {
            throw new DataspaceException("Invalid package type '" + tokenPrefix + "' specified.");
        }
        packageName = this.token.tokenString;
        this.read();
        boolean autoload = false;
        long sequence = -1L;
        if (this.token.tokenType == 1066) {
            this.read();
            autoload = Boolean.valueOf(this.token.tokenString.toUpperCase());
            this.read();
        }
        if (this.token.tokenType == 505) {
            this.read();
            sequence = this.readLong();
        }
        return new StatementCommand(3175, new Object[]{packageType, packageName, autoload, sequence});
    }

    final Statement compileExecImmediate(RplScript routine, StatementCompound context) {
        ExecImmediateExpression execImmediateExpression = this.compileExecImmediateExpression();
        if (routine != null) {
            this.resolveOuterReferencesAndTypes(routine, context, execImmediateExpression);
        } else {
            this.resolveOuterReferencesAndTypes(this.session.sessionContext.sessionVariablesRange, execImmediateExpression);
        }
        return new StatementCommand(43, new Object[]{execImmediateExpression});
    }

    final ExecImmediateExpression compileExecImmediateExpression() {
        int startPosition = this.scanner.tokenPosition;
        this.readThis(414);
        this.readThis(786);
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        while (true) {
            Expression e = this.XreadValueExpression();
            expressions.add(e);
            if (this.token.tokenType != 774) break;
            this.read();
        }
        this.readThis(772);
        if (expressions.size() == 0) {
            throw new DataspaceException("Should be at least one parameter.");
        }
        return new ExecImmediateExpression(expressions, this.scanner.sqlString.substring(startPosition, this.scanner.tokenPosition));
    }

    final void resolveOuterReferencesAndTypes(RplScript routine, StatementCompound context, Expression e) {
        RangeVariable[] rangeVars = routine.getParameterRangeVariables();
        if (context != null) {
            rangeVars = context.getRangeVariables();
        }
        this.resolveOuterReferencesAndTypes(rangeVars, e);
    }
}

