/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser;

import com.streamscape.ds.DataspaceCompleteException;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStore;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.IntKeyIntValueHashMap;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.parser.Token;
import com.streamscape.ds.parser.Tokens;
import com.streamscape.ds.parser.completion.TokenCompleter;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionValue;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.IntervalType;
import com.streamscape.ds.types.NumberType;
import com.streamscape.ds.types.TimeData;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.utils.StringUtils;
import com.streamscape.slex.UnsupportedRequestException;
import com.streamscape.slex.lang.PrefixTree;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import com.streamscape.tools.console.autocompletion.CompoundCompleter;
import com.streamscape.tools.console.autocompletion.PrefixTreeCompleter;
import com.streamscape.tools.lexer.BufferUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ParserBase {
    protected Scanner scanner;
    public Token token;
    protected DataspaceStore store;
    protected Session session;
    protected boolean isRecording;
    protected HsqlArrayList recordedStatement;
    private final Token dummyToken = new Token();
    public boolean isCheckOrTriggerCondition;
    public boolean isSchemaDefinition;
    protected int parsePosition;
    static final BigDecimal LONG_MAX_VALUE_INCREMENT = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(1L));
    private boolean isCompleteMode = false;
    private List<DSLCompletion> completions = new ArrayList<DSLCompletion>();
    private static final IntKeyIntValueHashMap expressionTypeMap = new IntKeyIntValueHashMap(37);

    public ParserBase(Session session, Scanner t) {
        this.scanner = t;
        this.session = session;
        this.store = session.getDataspaceStore();
        this.token = this.scanner.token;
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    public int getParsePosition() {
        return this.parsePosition;
    }

    public void setParsePosition(int parsePosition) {
        this.parsePosition = parsePosition;
    }

    public void setCompleteMode(boolean isCompleteMode) {
        this.isCompleteMode = isCompleteMode;
    }

    public boolean isCompleteMode() {
        return this.isCompleteMode;
    }

    protected void addCompletion(DSLCompletion completion) {
        if (completion != null) {
            this.completions.add(completion);
        }
    }

    protected List<DSLCompletion> getCompletions() {
        return this.completions;
    }

    protected void resetCompletions() {
        if (this.completions != null) {
            this.completions.clear();
        }
    }

    protected DSLCompletion mergeCompletions() {
        if (this.completions != null && this.completions.size() > 0) {
            DSLCompletion completion = this.completions.get(0);
            for (int i = 1; i < this.completions.size(); ++i) {
                completion = CompoundCompleter.mergeCompletions("", completion, this.completions.get(i));
            }
            return completion;
        }
        return null;
    }

    public void reset(String sql) {
        this.scanner.reset(sql);
        this.parsePosition = 0;
        this.isCheckOrTriggerCondition = false;
        this.isSchemaDefinition = false;
        this.isRecording = false;
        this.recordedStatement = null;
        this.completions.clear();
    }

    public int getPosition() {
        return this.scanner.getTokenPosition();
    }

    void rewind(int position) {
        if (position == this.scanner.getTokenPosition()) {
            return;
        }
        this.scanner.position(position);
        if (this.isRecording) {
            int i;
            for (i = this.recordedStatement.size() - 1; i >= 0; --i) {
                Token token = (Token)this.recordedStatement.get(i);
                if (token.position < position) break;
            }
            this.recordedStatement.setSize(i + 1);
        }
        this.token.reset();
        this.read();
    }

    String getLastPart() {
        return this.scanner.getPart(this.parsePosition, this.scanner.getTokenPosition());
    }

    String getLastPart(int position) {
        return this.scanner.getPart(position, this.scanner.getTokenPosition());
    }

    String getLastPartAndCurrent(int position) {
        return this.scanner.getPart(position, this.scanner.getPosition());
    }

    String getRemainingPart() {
        return this.scanner.getPart(this.scanner.getTokenPosition());
    }

    String getRemainingPart(int endPosition) {
        return this.scanner.getPart(this.scanner.getTokenPosition(), endPosition);
    }

    String getStatement(int startPosition, short[] startTokens) {
        while (this.token.tokenType != 791 && this.token.tokenType != 848 && ArrayUtil.find(startTokens, this.token.tokenType) == -1) {
            this.read();
        }
        return this.scanner.getPart(startPosition, this.scanner.getTokenPosition());
    }

    String getStatementForRoutine(int startPosition, short[] startTokens) {
        int tokenIndex = 0;
        int semiIndex = -1;
        int semiPosition = -1;
        while (true) {
            if (this.token.tokenType == 791) {
                semiPosition = this.scanner.getTokenPosition();
                semiIndex = tokenIndex;
            } else {
                if (this.token.tokenType == 848) {
                    if (semiIndex <= 0 || semiIndex != tokenIndex - 1) break;
                    this.rewind(semiPosition);
                    break;
                }
                if (ArrayUtil.find(startTokens, this.token.tokenType) != -1) break;
            }
            this.read();
            ++tokenIndex;
        }
        return this.scanner.getPart(startPosition, this.scanner.getTokenPosition());
    }

    public void startRecording() {
        this.recordedStatement = new HsqlArrayList();
        Token t = this.token.duplicate();
        t.position = this.scanner.tokenPosition;
        this.recordedStatement.add(t);
        this.isRecording = true;
    }

    Token getRecordedToken() {
        if (this.isRecording) {
            return (Token)this.recordedStatement.get(this.recordedStatement.size() - 1);
        }
        return this.dummyToken;
    }

    public Token[] getRecordedStatement() {
        this.isRecording = false;
        this.recordedStatement.remove(this.recordedStatement.size() - 1);
        Token[] tokens = new Token[this.recordedStatement.size()];
        this.recordedStatement.toArray(tokens);
        return tokens;
    }

    public void readMightExpectBracket() {
        try {
            this.scanner.mightExpectBracket = true;
            this.read();
        }
        finally {
            this.scanner.mightExpectBracket = false;
        }
    }

    public void read() {
        this.scanner.scanNext();
        ParserBase.checkMalformedToken(this.token);
        if (this.isRecording) {
            Token dup = this.token.duplicate();
            dup.position = this.scanner.getTokenPosition();
            this.recordedStatement.add(dup);
        }
    }

    public static void checkMalformedToken(Token token) {
        if (token.isMalformed) {
            int errorCode = -1;
            String addition = null;
            switch (token.tokenType) {
                case 856: {
                    errorCode = 5587;
                    break;
                }
                case 855: {
                    errorCode = 5588;
                    break;
                }
                case 857: {
                    errorCode = 5586;
                    break;
                }
                case 853: {
                    errorCode = 5584;
                    break;
                }
                case -1: {
                    errorCode = 5582;
                    addition = "[" + token.tokenString + "]";
                    break;
                }
                case 854: {
                    errorCode = 5585;
                    break;
                }
                case 858: {
                    errorCode = 5589;
                    break;
                }
                case 859: {
                    errorCode = 5583;
                }
            }
            if (addition != null) {
                throw Error.error(errorCode, addition);
            }
            throw Error.error(errorCode);
        }
    }

    String readTokenPrefixName() {
        return this.readTokenPrefixName(".");
    }

    String readTokenPrefixName(String delimiter) {
        String prefix = null;
        if (this.scanner.scanSpecialIdentifier(delimiter)) {
            prefix = this.token.tokenString;
            this.read();
            this.removeRecordedPrefix();
        }
        return prefix;
    }

    Token.TokenPrefix readTokenPrefix() {
        Token.TokenPrefix prefix = null;
        if (this.scanner.scanSpecialIdentifier(".")) {
            prefix = new Token.TokenPrefix(this.token.tokenString, this.token.isDelimiter);
            prefix.prefix = this.token.tokenString;
            prefix.isDelimited = this.token.isDelimiter;
            this.read();
            this.removeRecordedPrefix();
        }
        return prefix;
    }

    private void removeRecordedPrefix() {
        if (this.isRecording && this.token.tokenString != null && this.token.tokenString.length() > 0 && this.recordedStatement.size() > 2) {
            this.recordedStatement.remove(this.recordedStatement.size() - 2);
        }
    }

    void readThisTokenWithDots() {
        StringBuilder builder = new StringBuilder();
        String firstPrefix = this.token.tokenString;
        String prefix = null;
        while ((prefix = this.readTokenPrefixName()) != null) {
            builder.insert(0, prefix);
            builder.insert(0, ".");
        }
        if (builder.length() > 0) {
            builder.insert(0, firstPrefix);
            this.token.tokenString = builder.toString();
        }
    }

    EventScope readEventScope() {
        this.readThis(586);
        this.readThisTokenOrComplete(247, true, true);
        this.completeSimpleTreeStrings(Arrays.asList(EventScope.values()).stream().filter(e -> e != EventScope.CLUSTER).map(e -> e.toString().toLowerCase()).collect(Collectors.toList()));
        try {
            EventScope eventScope = this.token.tokenType == 78 ? EventScope.INHERITED : EventScope.valueOf(this.token.tokenString.trim().toUpperCase());
            this.read();
            this.resetCompletions();
            if (eventScope == EventScope.CLUSTER) {
                throw new DataspaceException("Event scope CLUSTER is not supported.");
            }
            return eventScope;
        }
        catch (IllegalArgumentException ex) {
            throw this.unexpectedToken("Invalid event scope '" + this.token.tokenString + "' specified.");
        }
    }

    protected String readSimpleIdentifier() {
        if (!StringUtils.hasIdentifierFormat(this.token.tokenString)) {
            throw this.unexpectedToken();
        }
        return this.token.tokenString;
    }

    boolean isNextCharacterDot() {
        return this.scanner.currentCharacter() == 46;
    }

    boolean isNextCharacterOpenBracket() {
        return this.scanner.currentCharacter() == 40;
    }

    boolean isReservedKey() {
        return this.scanner.token.isReservedIdentifier;
    }

    boolean isCoreReservedKey() {
        return this.scanner.token.isCoreReservedIdentifier;
    }

    boolean isNonReservedIdentifier() {
        return !this.scanner.token.isReservedIdentifier && (this.scanner.token.isUndelimitedIdentifier || this.scanner.token.isDelimitedIdentifier);
    }

    void checkIsNonReservedIdentifier() {
        if (!this.isNonReservedIdentifier()) {
            throw this.unexpectedToken();
        }
    }

    boolean isNonCoreReservedIdentifier() {
        return !this.scanner.token.isCoreReservedIdentifier && (this.scanner.token.isUndelimitedIdentifier || this.scanner.token.isDelimitedIdentifier);
    }

    void checkIsNonCoreReservedIdentifier() {
        if (!this.isNonCoreReservedIdentifier()) {
            throw this.unexpectedToken();
        }
    }

    boolean isIdentifier() {
        return this.scanner.token.isUndelimitedIdentifier || this.scanner.token.isDelimitedIdentifier;
    }

    void checkIsIdentifier() {
        if (!this.isIdentifier()) {
            throw this.unexpectedToken();
        }
    }

    boolean isDelimitedIdentifier() {
        return this.scanner.token.isDelimitedIdentifier;
    }

    void checkIsDelimitedIdentifier() {
        if (this.token.tokenType != 847) {
            throw Error.error(5569);
        }
    }

    void checkIsNotQuoted() {
        if (this.token.tokenType == 847) {
            throw this.unexpectedToken();
        }
    }

    void checkIsValue() {
        if (this.token.tokenType != 845) {
            throw this.unexpectedToken();
        }
    }

    void checkIsValue(int dataTypeCode) {
        if (this.token.tokenType != 845 || this.token.dataType.typeCode != dataTypeCode) {
            throw this.unexpectedToken();
        }
    }

    void checkIsThis(int type) {
        if (this.token.tokenType != type) {
            String required = Tokens.getKeyword(type);
            throw this.unexpectedTokenRequire(required);
        }
    }

    boolean isUndelimitedSimpleName() {
        return this.token.isUndelimitedIdentifier && !this.isNextCharacterDot();
    }

    boolean isDelimitedSimpleName() {
        return this.token.isDelimitedIdentifier && !this.isNextCharacterDot();
    }

    boolean isSimpleName() {
        return this.isNonCoreReservedIdentifier() && !this.isNextCharacterDot();
    }

    void checkIsSimpleName() {
        if (!this.isSimpleName()) {
            throw this.unexpectedToken();
        }
    }

    void readUnquotedIdentifier(String ident) {
        this.checkIsSimpleName();
        if (!this.token.tokenString.equals(ident)) {
            throw this.unexpectedToken();
        }
        this.read();
    }

    String readQuotedString() {
        this.checkIsValue();
        if (this.token.dataType.typeCode != 1) {
            throw Error.error(5563);
        }
        String value = this.token.tokenString;
        this.read();
        return value;
    }

    String readQuotedPath() {
        return BufferUtils.unslashPath(this.readQuotedString());
    }

    String readQuotedFileTablePath() {
        int pos;
        Object value = this.readQuotedString();
        if (value != null && (pos = ((String)value).indexOf(";")) > 0) {
            value = BufferUtils.unslashPath(((String)value).substring(0, pos)) + ((String)value).substring(pos);
        }
        return value;
    }

    void readThis(int tokenId) {
        if (this.token.tokenType != tokenId) {
            throw this.unexpectedTokenRequire(Tokens.getKeyword(tokenId));
        }
        this.read();
    }

    public boolean readIfThis(int tokenId) {
        if (this.token.tokenType == tokenId) {
            this.read();
            return true;
        }
        return false;
    }

    Integer readIntegerOrStringObject() {
        if (this.token.dataType != null && this.token.dataType.typeCode == 1) {
            try {
                return Integer.valueOf(this.readQuotedString());
            }
            catch (Exception exception) {
                throw Error.error(5563);
            }
        }
        return this.readIntegerObject();
    }

    Integer readIntegerObject() {
        int value = this.readInteger();
        return ValuePool.getInt(value);
    }

    boolean readBoolean() {
        if (this.readIfThis(294)) {
            return true;
        }
        this.readThis(106);
        return false;
    }

    public int readInteger() {
        boolean minus = false;
        if (this.token.tokenType == 784) {
            minus = true;
            this.read();
        }
        this.checkIsValue();
        if (minus && this.token.dataType.typeCode == 25 && ((Number)this.token.tokenValue).longValue() == 0x80000000L) {
            this.read();
            return Integer.MIN_VALUE;
        }
        if (this.token.dataType.typeCode != 4) {
            throw Error.error(5563);
        }
        int val = ((Number)this.token.tokenValue).intValue();
        if (minus) {
            val = -val;
        }
        this.read();
        return val;
    }

    final List<String> readCommaSeparatedColumnList() {
        ArrayList<String> result = new ArrayList<String>();
        this.readThisTokenOrComplete(786, true, true);
        while (this.token.tokenType != 772 && this.token.tokenType != 848) {
            result.add(this.token.tokenString);
            this.read();
            this.completeSimpleTree(774, 772);
            if (this.token.tokenType != 774) break;
            this.readThis(774);
        }
        this.readThis(772);
        return result;
    }

    void completeSimpleTree(String ... items) {
        this.completeSimpleTreeStrings(Arrays.asList(items));
    }

    void completeSimpleTree(Integer ... items) {
        this.completeSimpleTree(Arrays.asList(items));
    }

    void completeSimpleTree(List<Integer> items) {
        this.completeSimpleTreeStrings(items.stream().map(item -> Tokens.getKeyword(item).toLowerCase()).collect(Collectors.toList()));
    }

    void completeSimpleTreeStrings(Collection<String> items) {
        new PrefixDataspaceCompleter().completers(prefix -> {
            PrefixTree<Object> prefixTree = new PrefixTree<Object>();
            prefixTree.setTrimDefinitions(false);
            for (String item : items) {
                prefixTree.add(item, new Object());
            }
            return new PrefixTreeCompleter(prefixTree).completeDsl(prefix);
        }).throwException(false).spaceFirst(false).withRead(false).complete();
    }

    public long readLong() {
        boolean minus = false;
        if (this.token.tokenType == 784) {
            minus = true;
            this.read();
        }
        this.checkIsValue();
        if (minus && this.token.dataType.typeCode == 2 && LONG_MAX_VALUE_INCREMENT.equals(this.token.tokenValue)) {
            this.read();
            return Long.MIN_VALUE;
        }
        if (this.token.dataType.typeCode != 4 && this.token.dataType.typeCode != 25) {
            throw Error.error(5563);
        }
        long val = ((Number)this.token.tokenValue).longValue();
        if (minus) {
            val = -val;
        }
        this.read();
        return val;
    }

    Expression readDateTimeIntervalLiteral() {
        int pos = this.getPosition();
        switch (this.token.tokenType) {
            case 72: {
                this.read();
                if (this.token.tokenType != 845 || this.token.dataType.typeCode != 1) break;
                String s = this.token.tokenString;
                this.read();
                TimestampData date = this.scanner.newDate(s);
                return new ExpressionValue(date, Type.SQL_DATE);
            }
            case 281: {
                this.read();
                if (this.token.tokenType != 845 || this.token.dataType.typeCode != 1) break;
                String s = this.token.tokenString;
                this.read();
                TimeData value = this.scanner.newTime(s);
                Type dataType = this.scanner.dateTimeType;
                return new ExpressionValue(value, dataType);
            }
            case 282: {
                this.read();
                if (this.token.tokenType != 845 || this.token.dataType.typeCode != 1) break;
                String s = this.token.tokenString;
                this.read();
                TimestampData date = this.scanner.newTimestamp(s);
                Type dataType = this.scanner.dateTimeType;
                return new ExpressionValue(date, dataType);
            }
            case 140: {
                boolean minus = false;
                this.read();
                if (this.token.tokenType == 784) {
                    this.read();
                    minus = true;
                } else if (this.token.tokenType == 787) {
                    this.read();
                }
                if (this.token.tokenType != 845 || this.token.dataType.typeCode != 1 && this.token.dataType.typeCode != 4) break;
                String s = this.token.tokenString;
                this.read();
                IntervalType dataType = this.readIntervalType(false);
                Object interval = this.scanner.newInterval(s, dataType);
                dataType = (IntervalType)this.scanner.dateTimeType;
                if (minus) {
                    interval = dataType.negate(interval);
                }
                return new ExpressionValue(interval, dataType);
            }
            default: {
                throw Error.runtimeError(201, "ParserBase");
            }
        }
        this.rewind(pos);
        return null;
    }

    IntervalType readIntervalType(boolean maxPrecisionDefault) {
        int endToken;
        int precision = maxPrecisionDefault ? 9 : -1;
        int scale = -1;
        int typeToken = this.token.tokenType;
        if (typeToken == 168) {
            typeToken = 169;
        }
        if (typeToken == 970) {
            typeToken = 250;
        }
        int startToken = endToken = typeToken;
        this.read();
        if (this.token.tokenType == 786) {
            this.read();
            precision = this.readInteger();
            if (precision <= 0) {
                throw Error.error(5592);
            }
            if (this.token.tokenType == 774) {
                if (startToken != 250) {
                    throw this.unexpectedToken();
                }
                this.read();
                scale = this.readInteger();
                if (scale < 0) {
                    throw Error.error(5592);
                }
            }
            this.readThis(772);
        }
        if (this.token.tokenType == 285) {
            this.read();
            endToken = this.token.tokenType;
            this.read();
        }
        if (this.token.tokenType == 786) {
            if (endToken != 250 || endToken == startToken) {
                throw this.unexpectedToken();
            }
            this.read();
            scale = this.readInteger();
            if (scale < 0) {
                throw Error.error(5592);
            }
            this.readThis(772);
        }
        int startIndex = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, startToken);
        int endIndex = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, endToken);
        return IntervalType.getIntervalType(startIndex, endIndex, precision, scale);
    }

    static int getExpressionType(int tokenT) {
        int type = expressionTypeMap.get(tokenT, -1);
        if (type == -1) {
            throw Error.runtimeError(201, "ParserBase");
        }
        return type;
    }

    DataspaceException unexpectedToken(String tokenS) {
        return this.initPositions(Error.parseError(5581, tokenS + ", position " + this.scanner.currentPosition, this.scanner.calculateLineNumber()));
    }

    DataspaceException unexpectedTokenRequire(String ... required) {
        String requiredJoined = Arrays.stream(required).collect(Collectors.joining("/")).toLowerCase();
        if (this.token.tokenType == 848) {
            return this.initPositions(Error.parseError(5590, 1, this.scanner.calculateLineNumber(), new Object[]{"", requiredJoined}));
        }
        String tokenS = this.token.charsetSchema != null ? this.token.charsetSchema : (this.token.charsetName != null ? this.token.charsetName : this.token.tokenString);
        return this.initPositions(Error.parseError(5581, 1, this.scanner.calculateLineNumber(), new Object[]{tokenS + ", position " + this.scanner.currentPosition, requiredJoined}));
    }

    public DataspaceException unexpectedToken() {
        if (this.token.tokenType == 848) {
            return this.initPositions(Error.parseError(5590, ", position " + this.scanner.currentPosition, this.scanner.calculateLineNumber()));
        }
        String tokenS = this.token.charsetSchema != null ? this.token.charsetSchema : (this.token.charsetName != null ? this.token.charsetName : this.token.tokenString);
        return this.initPositions(Error.parseError(5581, tokenS + ", position " + this.scanner.currentPosition, this.scanner.calculateLineNumber()));
    }

    DataspaceException tooManyIdentifiers(String token) {
        return this.initPositions(Error.parseError(5551, token, this.scanner.calculateLineNumber()));
    }

    public DataspaceException unsupportedRequest() {
        return new DataspaceException(new UnsupportedRequestException(), true);
    }

    DataspaceException initPositions(DataspaceException exception) {
        return this.initPositions(exception, this.scanner.tokenPosition > 0 ? this.scanner.tokenPosition : this.scanner.currentPosition);
    }

    DataspaceException initPositions(DataspaceException exception, int position) {
        BufferUtils.setLineAndPositions(exception, this.scanner.sqlString, position);
        return exception;
    }

    List<String> readVariableSpathList() {
        if (!this.isNextCharacterDot()) {
            return null;
        }
        ArrayList<String> spath = new ArrayList<String>();
        while (this.isNextCharacterDot()) {
            int position = this.scanner.tokenPosition;
            this.read();
            this.readThis(1015);
            if (this.token.isUndelimitedIdentifier || this.token.isDelimitedIdentifier) {
                spath.add(this.token.tokenString);
                continue;
            }
            if (this.token.tokenType == 848) {
                this.rewind(position);
                break;
            }
            this.unexpectedToken();
        }
        return spath;
    }

    boolean isSpathForCompletion(List<String> spath) {
        return spath != null && (spath.size() == 0 && this.isNextCharacterDot() || spath.size() == 1 && this.scanner.isAtEnd());
    }

    String getPrefixFromSpath(List<String> spath) {
        return spath.size() >= 1 ? spath.get(spath.size() - 1) : "";
    }

    String buildStringSpath(List<String> spath) {
        if (spath == null || spath.size() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String s : spath) {
            builder.append("/").append(s);
        }
        return builder.toString();
    }

    public DataspaceException unsupportedFeature() {
        return Error.error(1551, this.token.tokenString);
    }

    DataspaceException unsupportedFeature(String string) {
        return Error.error(1551, string);
    }

    public Number convertToNumber(String s, NumberType type) {
        return this.scanner.convertToNumber(s, type);
    }

    protected void readNameTokenForCompleteMode() {
        int position = this.getPosition();
        try {
            this.read();
        }
        catch (Exception exception) {
            if (this.isCompleteMode()) {
                try {
                    this.scanner.mightExpectBracket = true;
                    this.scanner.isForCompletion = true;
                    this.rewind(position);
                    this.read();
                }
                finally {
                    this.scanner.isForCompletion = false;
                    this.scanner.mightExpectBracket = false;
                }
            }
            throw exception;
        }
    }

    protected boolean readIfThisNameTokenForCompleteMode(int tokenId) {
        if (this.token.tokenType != tokenId) {
            return false;
        }
        this.readNameTokenForCompleteMode();
        return true;
    }

    protected void readThisNameTokenForCompleteMode(int tokenId) {
        if (this.token.tokenType != tokenId) {
            throw this.unexpectedTokenRequire(Tokens.getKeyword(tokenId));
        }
        this.readNameTokenForCompleteMode();
    }

    protected void readThisTokenOrComplete(int tokenId, boolean withNextReadForComplete, boolean withSpaceAtTheEnd) {
        if (this.isCompleteMode()) {
            String tokenString = Tokens.getKeyword(tokenId).toLowerCase();
            if (this.token.tokenType == 848 || this.token.tokenType != tokenId && this.scanner.isAtEnd() && this.scanner.isAtEndWithoutSpaces()) {
                this.completeThisToken(tokenString, withSpaceAtTheEnd);
                throw new DataspaceCompleteException();
            }
            if (this.token.tokenType != tokenId) {
                throw this.unexpectedTokenRequire(Tokens.getKeyword(tokenId));
            }
            this.resetCompletions();
            if (withNextReadForComplete) {
                this.readNameTokenForCompleteMode();
            } else {
                this.read();
            }
        } else {
            this.readThis(tokenId);
        }
    }

    protected boolean readIfThisTokenOrComplete(int tokenId, boolean withSpaceAtTheEnd) {
        if (!this.readIfThis(tokenId)) {
            this.completeThisToken(Tokens.getKeyword(tokenId).toLowerCase(), true);
            return false;
        }
        return true;
    }

    protected void completeThisToken(String completeToToken, boolean withSpaceAtTheEnd) {
        if (this.isCompleteMode()) {
            String prefix = this.readPrefixWithBrackets(false, false);
            if (prefix == null) {
                return;
            }
            if (withSpaceAtTheEnd) {
                completeToToken = (String)completeToToken + " ";
            }
            if (prefix.length() == 0 && this.scanner.isAtEndWithoutSpaces()) {
                completeToToken = " " + (String)completeToToken;
            }
            this.addCompletion(new TokenCompleter((String)completeToToken).complete(prefix));
        }
    }

    NameManager.ObjectName readNewUserIdentifier() {
        this.checkIsSimpleName();
        String tokenS = this.token.tokenString;
        boolean isQuoted = this.isDelimitedIdentifier();
        NameManager.ObjectName name = this.store.nameManager.newObjectName(tokenS, isQuoted, 12);
        this.read();
        return name;
    }

    final boolean processTrueOrFalse() {
        if (this.isNextCharacterDot()) {
            throw this.unexpectedToken();
        }
        if (this.token.tokenType == 294) {
            this.read();
            return true;
        }
        if (this.token.tokenType == 106) {
            this.read();
            return false;
        }
        throw this.unexpectedToken();
    }

    final Boolean processTrueOrFalseObject() {
        return this.processTrueOrFalse();
    }

    final Boolean readAndCompleteBoolean() {
        this.completeSimpleTree("true", "false");
        if (this.token.dataType != null && this.token.dataType.typeCode == 1) {
            try {
                return Boolean.valueOf(this.readQuotedString().toLowerCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.processTrueOrFalseObject();
    }

    final String readPassword() {
        String tokenS = this.token.tokenString;
        this.read();
        return tokenS;
    }

    protected String readPrefixWithBrackets(boolean withRead, boolean readComplex) {
        Object prefix = withRead ? "" : this.token.tokenString;
        int position = this.getPosition();
        if (!this.scanner.isAtEnd()) {
            if (withRead) {
                this.readMightExpectBracket();
            }
            if (this.token.tokenType == 781) {
                this.scanner.scanIdentifierForCompletion(']');
                prefix = this.token.tokenString;
            } else if (readComplex && this.scanner.currentPosition < this.scanner.sqlString.length() && this.scanner.sqlString.charAt(this.scanner.currentPosition) == '.') {
                if (withRead) {
                    prefix = (String)prefix + this.token.tokenString;
                }
                prefix = (String)prefix + ".";
                this.readNameTokenForCompleteMode();
                if (!this.scanner.isAtEnd()) {
                    this.readNameTokenForCompleteMode();
                    if (this.token.tokenType == 781) {
                        this.scanner.scanIdentifierForCompletion(']');
                        prefix = (String)prefix + this.token.tokenString;
                    } else {
                        prefix = this.token.isDelimitedIdentifier ? (String)prefix + "[" + this.token.tokenString + "]" : (String)prefix + this.token.tokenString;
                        if (!this.scanner.isAtEndWithoutSpaces()) {
                            this.rewind(position);
                            return null;
                        }
                    }
                }
            } else {
                prefix = (String)prefix + this.token.tokenString;
            }
            if (!this.scanner.isAtEnd()) {
                this.rewind(position);
                return null;
            }
        }
        return prefix;
    }

    public PrefixDataspaceCompleter newPrefixDataspaceCompleter() {
        return new PrefixDataspaceCompleter();
    }

    protected <T extends Enum<T>> T readEnum(Class<T> clazz) {
        this.completeSimpleTreeStrings(Arrays.stream((Enum[])clazz.getEnumConstants()).map(e -> e.toString().toLowerCase()).collect(Collectors.toList()));
        String enumItemName = this.token.tokenString;
        this.read();
        try {
            return Enum.valueOf(clazz, enumItemName.toUpperCase());
        }
        catch (Throwable e2) {
            throw new DataspaceException("Wrong parameter value: " + enumItemName);
        }
    }

    static {
        expressionTypeMap.put(396, 41);
        expressionTypeMap.put(779, 43);
        expressionTypeMap.put(782, 44);
        expressionTypeMap.put(780, 42);
        expressionTypeMap.put(783, 45);
        expressionTypeMap.put(785, 46);
        expressionTypeMap.put(796, 117);
        expressionTypeMap.put(797, 118);
        expressionTypeMap.put(52, 71);
        expressionTypeMap.put(163, 74);
        expressionTypeMap.put(168, 73);
        expressionTypeMap.put(274, 72);
        expressionTypeMap.put(16, 75);
        expressionTypeMap.put(97, 76);
        expressionTypeMap.put(6, 77);
        expressionTypeMap.put(258, 77);
        expressionTypeMap.put(269, 78);
        expressionTypeMap.put(270, 79);
        expressionTypeMap.put(309, 80);
        expressionTypeMap.put(310, 81);
        expressionTypeMap.put(9, 82);
        expressionTypeMap.put(682, 83);
        expressionTypeMap.put(605, 85);
        expressionTypeMap.put(1165, 119);
    }

    protected class PrefixDataspaceCompleter {
        private PrefixCompleter[] completers;
        private boolean withRead = false;
        private boolean spaceFirst = true;
        private boolean throwException = true;

        PrefixDataspaceCompleter() {
        }

        PrefixDataspaceCompleter completers(PrefixCompleter ... completers) {
            this.completers = completers;
            return this;
        }

        PrefixDataspaceCompleter withRead(boolean withRead) {
            this.withRead = withRead;
            return this;
        }

        PrefixDataspaceCompleter spaceFirst(boolean spaceFirst) {
            this.spaceFirst = spaceFirst;
            return this;
        }

        PrefixDataspaceCompleter throwException(boolean throwException) {
            this.throwException = throwException;
            return this;
        }

        void complete() {
            if (ParserBase.this.isCompleteMode()) {
                int startPosition = ParserBase.this.getPosition();
                String prefix = ParserBase.this.readPrefixWithBrackets(this.withRead, true);
                if (prefix == null) {
                    return;
                }
                if (this.spaceFirst && prefix.length() == 0 && ParserBase.this.scanner.isAtEndWithoutSpaces()) {
                    ParserBase.this.addCompletion(new DSLCompletion().setCompletion(new TokenSuggestion(" ")));
                } else if (prefix.length() == 0 || ParserBase.this.scanner.isAtEndWithoutSpaces()) {
                    for (PrefixCompleter completer : this.completers) {
                        if (completer == null) continue;
                        ParserBase.this.addCompletion(completer.complete(prefix));
                    }
                }
                ParserBase.this.rewind(startPosition);
                if (this.throwException && ParserBase.this.completions.size() > 0) {
                    throw new DataspaceCompleteException();
                }
            }
        }
    }

    public static abstract class AbstractSyntaxSplitter {
        protected ParserBase parser;
        protected String comment;
        protected String signature;
        protected String rpl;
        protected String enable;
        protected String eventScope;

        public AbstractSyntaxSplitter(Session session) {
            this.parser = new ParserBase(session, new Scanner());
        }

        public AbstractSyntaxSplitter(Session session, String sql) {
            this(session);
            this.reset(sql);
        }

        public void reset(String sql) {
            this.parser.reset(sql);
            this.comment = null;
            this.signature = null;
            this.rpl = null;
            this.enable = null;
        }

        public abstract boolean split();

        protected void readEventScope() {
            if (this.parser.token.tokenType == 586) {
                int start = this.parser.getPosition();
                this.parser.readThis(586);
                this.parser.readThis(247);
                this.parser.read();
                int end = this.parser.getPosition();
                this.eventScope = this.parser.scanner.sqlString.substring(start, end);
            }
        }

        protected boolean scanNextBlock(int start, int end) {
            while (this.parser.token.tokenType != start && this.parser.token.tokenType != 848) {
                this.parser.read();
            }
            if (this.parser.token.tokenType != start) {
                return false;
            }
            while (this.parser.token.tokenType != end && this.parser.token.tokenType != 848) {
                this.parser.read();
                if (this.parser.token.tokenType != start) continue;
                if (!this.scanNextBlock(start, end)) {
                    return false;
                }
                this.parser.read();
            }
            return this.parser.token.tokenType == end;
        }

        protected boolean readRpl() {
            if (this.parser.token.tokenType == 10) {
                int start = this.parser.getPosition();
                this.parser.read();
                if (!this.scanNextBlock(792, 793)) {
                    return false;
                }
                this.parser.read();
                int end = this.parser.getPosition();
                this.rpl = this.parser.scanner.sqlString.substring(start, end);
                return true;
            }
            return false;
        }

        protected void readEnable() {
            if (this.parser.token.tokenType == 948) {
                int start = this.parser.getPosition();
                this.parser.read();
                int end = this.parser.getPosition();
                this.enable = this.parser.scanner.sqlString.substring(start, end);
            }
        }

        public String getEnable() {
            return this.enable;
        }

        public String getComment() {
            return this.comment;
        }

        public String getSignature() {
            return this.signature;
        }

        public String getEventScope() {
            return this.eventScope;
        }

        public String getSignature(boolean create) {
            int pos;
            if (this.signature != null && (pos = this.signature.toLowerCase().indexOf("alter")) != -1) {
                return (pos > 0 ? this.signature.substring(0, pos) : "") + "create" + this.signature.substring(pos + "alter".length());
            }
            return this.signature;
        }

        public String getRpl() {
            return this.rpl;
        }
    }
}

