/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.parser;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.parser.ParserBase;
import com.streamscape.ds.parser.ParserRPL;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.schema.procedure.RplScript;
import com.streamscape.ds.session.Session;

public class FunctionCreatorWithAlter {
    public static String getFunctionCreateSql(Session session, RplScript routine) {
        Object currentRpl = session.dataspaceStore.schemaManager.loadObjectDefinition(session, routine);
        if (currentRpl == null) {
            currentRpl = routine.getSQL();
        } else {
            ParserRPL.FunctionSyntaxSplitter splitter = new ParserRPL.FunctionSyntaxSplitter(session);
            splitter.reset((String)currentRpl);
            if (splitter.split()) {
                String currentComment = splitter.getComment();
                String currentSignature = splitter.getSignature();
                if (!currentSignature.toLowerCase().trim().startsWith("create")) {
                    currentRpl = currentComment + routine.getSQL();
                }
            }
        }
        return currentRpl;
    }

    public static Result createFunctionDeclaration(Session session, String createSql, String routineName) {
        int nameStart;
        ParserRPL.FunctionSyntaxSplitter splitter = new ParserRPL.FunctionSyntaxSplitter(session);
        splitter.reset(createSql);
        if (!splitter.split()) {
            throw new DataspaceException("Failed to split current function SQL from SYSLDEF.");
        }
        String currentComment = splitter.getComment();
        String currentSignature = splitter.getSignature();
        Object sqlDeclaration = currentComment + currentSignature;
        ParserBase parser = new ParserBase(session, new Scanner());
        parser.reset(currentSignature);
        parser.read();
        parser.readIfThis(55);
        parser.readIfThis(559);
        if (!parser.readIfThis(117) && !parser.readIfThis(215)) {
            throw new DataspaceException("Invalid signature: " + currentSignature);
        }
        int dataspaceNameStart = nameStart = parser.getPosition();
        parser.readMightExpectBracket();
        if (parser.readIfThis(1015)) {
            nameStart = parser.getPosition();
            parser.readMightExpectBracket();
        }
        int nameEnd = parser.getPosition();
        if (routineName == null) {
            routineName = currentSignature.substring(nameStart, nameEnd).trim();
        }
        sqlDeclaration = currentComment + currentSignature.substring(0, dataspaceNameStart) + routineName + currentSignature.substring(nameEnd);
        sqlDeclaration = ((String)sqlDeclaration).trim();
        Result result = session.executeDirectStatement((String)(sqlDeclaration = (String)sqlDeclaration + " throw exception sqlstate '45000'"));
        if (result.isError() && result.getException() != null) {
            Trace.logError(FunctionCreatorWithAlter.class, "Unable to create function declaration for function " + routineName + ": " + (String)sqlDeclaration + ". " + result.getException().getMessage());
        }
        return result;
    }

    public static Result alterFunction(Session session, String createSql, String routineName) {
        String alterSql;
        Result result;
        ParserRPL.FunctionSyntaxSplitter splitter = new ParserRPL.FunctionSyntaxSplitter(session);
        splitter.reset(createSql);
        if (!splitter.split()) {
            throw new DataspaceException("Failed to split current function SQL from SYSLDEF.");
        }
        if (routineName == null) {
            int nameStart;
            String currentSignature = splitter.getSignature();
            ParserBase parser = new ParserBase(session, new Scanner());
            parser.reset(currentSignature);
            parser.read();
            parser.readIfThis(55);
            parser.readIfThis(559);
            if (!parser.readIfThis(117) && !parser.readIfThis(215)) {
                throw new DataspaceException("Invalid signature: " + currentSignature);
            }
            int dataspaceNameStart = nameStart = parser.getPosition();
            parser.readMightExpectBracket();
            if (parser.readIfThis(1015)) {
                nameStart = parser.getPosition();
                parser.readMightExpectBracket();
            }
            int nameEnd = parser.getPosition();
            routineName = currentSignature.substring(nameStart, nameEnd).trim();
        }
        if ((result = session.executeDirectStatement(alterSql = "alter function " + routineName + " " + splitter.getRpl())).isError() && result.getException() != null) {
            Trace.logError(FunctionCreatorWithAlter.class, "Unable to alter function " + routineName + ": " + alterSql + ". " + result.getException().getMessage());
        }
        return result;
    }

    public static String removeDataspaceNameFromCreateSignature(Session session, String signature) {
        if (signature != null) {
            int nameStart;
            ParserBase parser = new ParserBase(session, new Scanner());
            parser.reset(signature);
            parser.read();
            parser.readIfThis(55);
            parser.readIfThis(559);
            if (!parser.readIfThis(117) && !parser.readIfThis(215)) {
                return signature;
            }
            int dataspaceNameStart = nameStart = parser.getPosition();
            parser.readMightExpectBracket();
            if (parser.readIfThis(1015)) {
                nameStart = parser.getPosition();
                parser.readMightExpectBracket();
            }
            int nameEnd = parser.getPosition();
            String routineName = signature.substring(nameStart, nameEnd).trim();
            return signature.substring(0, dataspaceNameStart) + routineName + signature.substring(nameEnd);
        }
        return signature;
    }
}

