/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.navigator;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.navigator.RowIterator;
import com.streamscape.ds.navigator.RowSetNavigatorData;
import com.streamscape.ds.parser.expression.QueryExpression;
import com.streamscape.ds.parser.expression.QuerySpecification;
import com.streamscape.ds.parser.expression.SortAndSlice;
import com.streamscape.ds.persist.PersistentStore;
import com.streamscape.ds.persist.index.Index;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.table.TableBase;
import com.streamscape.ds.session.Session;
import java.io.IOException;

public class RowSetNavigatorDataTable
extends RowSetNavigatorData {
    final Session session;
    public TableBase table;
    public PersistentStore store;
    RowIterator iterator;
    Row currentRow;
    boolean isClosed;
    int visibleColumnCount;
    boolean isAggregate;
    boolean isSimpleAggregate;
    Object[] simpleAggregateData;
    Object[] tempRowData;
    boolean reindexTable;
    private Index mainIndex;
    private Index fullIndex;
    private Index orderIndex;
    private Index groupIndex;
    private Index idIndex;

    public RowSetNavigatorDataTable(Session session, QuerySpecification select) {
        super(session);
        this.session = session;
        this.rangePosition = select.resultRangePosition;
        this.visibleColumnCount = select.indexLimitVisible;
        this.table = select.resultTable.duplicate();
        this.table.store = this.store = session.sessionData.getNewResultRowStore(this.table, !select.isAggregated);
        this.isAggregate = select.isAggregated;
        this.isSimpleAggregate = select.isAggregated && !select.isGrouped;
        this.reindexTable = select.isGrouped;
        this.mainIndex = select.mainIndex;
        this.fullIndex = select.fullIndex;
        this.orderIndex = select.orderIndex;
        this.groupIndex = select.groupIndex;
        this.idIndex = select.idIndex;
        this.tempRowData = new Object[1];
    }

    public RowSetNavigatorDataTable(Session session, QuerySpecification select, RowSetNavigatorData navigator) {
        this(session, select);
        navigator.reset();
        while (navigator.hasNext()) {
            this.add(navigator.getNext());
        }
    }

    public RowSetNavigatorDataTable(Session session, QueryExpression queryExpression) {
        super(session);
        this.session = session;
        this.table = queryExpression.resultTable.duplicate();
        this.visibleColumnCount = this.table.getColumnCount();
        this.table.store = this.store = session.sessionData.getNewResultRowStore(this.table, true);
        this.mainIndex = queryExpression.mainIndex;
        this.fullIndex = queryExpression.fullIndex;
    }

    public RowSetNavigatorDataTable(Session session, TableBase table) {
        super(session);
        this.session = session;
        this.table = table;
        this.visibleColumnCount = table.getColumnCount();
        this.store = table.getRowStore(session);
        this.mainIndex = table.getPrimaryIndex();
        this.fullIndex = table.getFullIndex();
        this.size = this.mainIndex.size(session, this.store);
        this.reset();
    }

    @Override
    public void sortFull(Session session) {
        if (this.reindexTable) {
            this.store.indexRows(session);
        }
        this.mainIndex = this.fullIndex;
        this.reset();
    }

    @Override
    public void sortOrder(Session session) {
        if (this.orderIndex != null) {
            if (this.reindexTable) {
                this.store.indexRows(session);
            }
            this.mainIndex = this.orderIndex;
            this.reset();
        }
    }

    @Override
    public void sortOrderUnion(Session session, SortAndSlice sortAndSlice) {
        if (sortAndSlice.index != null) {
            this.mainIndex = sortAndSlice.index;
            this.reset();
        }
    }

    @Override
    public void add(Object[] data) {
        try {
            Row row = (Row)this.store.getNewCachedObject(this.session, data, false);
            this.store.indexRow(null, row);
            ++this.size;
        }
        catch (DataspaceException dataspaceException) {
            // empty catch block
        }
    }

    @Override
    void addAdjusted(Object[] data, int[] columnMap) {
        try {
            if (columnMap == null) {
                data = (Object[])ArrayUtil.resizeArrayIfDifferent(data, this.visibleColumnCount);
            } else {
                Object[] newData = new Object[this.visibleColumnCount];
                ArrayUtil.projectRow(data, columnMap, newData);
                data = newData;
            }
            this.add(data);
        }
        catch (DataspaceException dataspaceException) {
            // empty catch block
        }
    }

    @Override
    public void update(Object[] oldData, Object[] newData) {
        if (this.isSimpleAggregate) {
            return;
        }
        RowIterator it = this.groupIndex.findFirstRow(this.session, this.store, oldData);
        if (it.hasNext()) {
            Row row = it.getNextRow();
            it.remove();
            it.release();
            --this.size;
            this.add(newData);
        }
    }

    @Override
    public boolean absolute(int position) {
        return super.absolute(position);
    }

    @Override
    public Object[] getCurrent() {
        return this.currentRow.getData();
    }

    @Override
    public Row getCurrentRow() {
        return this.currentRow;
    }

    @Override
    public boolean next() {
        boolean result = super.next();
        this.currentRow = this.iterator.getNextRow();
        return result;
    }

    @Override
    public void remove() {
        if (this.currentRow != null) {
            this.iterator.remove();
            this.currentRow = null;
            --this.currentPos;
            --this.size;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.iterator = this.mainIndex.firstRow(this.store);
    }

    @Override
    public void release() {
        if (this.isClosed) {
            return;
        }
        this.iterator.release();
        this.store.release();
        this.isClosed = true;
    }

    @Override
    public void clear() {
        this.table.clearAllData(this.store);
        this.size = 0;
        this.reset();
    }

    @Override
    public boolean isMemory() {
        return this.store.isMemory();
    }

    @Override
    public void read(RowInputInterface in, ResultMetaData meta) throws IOException {
    }

    @Override
    public void write(RowOutputInterface out, ResultMetaData meta) throws IOException {
        this.reset();
        out.writeLong(this.id);
        out.writeInt(this.size);
        out.writeInt(0);
        out.writeInt(this.size);
        while (this.hasNext()) {
            Object[] data = this.getNext();
            out.writeData(meta.getExtendedColumnCount(), meta.columnTypes, data, null, null);
        }
        this.reset();
    }

    public Object[] getData(Long rowId) {
        this.tempRowData[0] = rowId;
        RowIterator it = this.idIndex.findFirstRow(this.session, this.store, this.tempRowData, this.idIndex.getDefaultColumnMap());
        return it.getNext();
    }

    @Override
    public void copy(RowSetNavigatorData other, int[] rightColumnIndexes) {
        while (other.hasNext()) {
            Object[] currentData = other.getNext();
            this.addAdjusted(currentData, rightColumnIndexes);
        }
        other.release();
    }

    @Override
    public void union(Session session, RowSetNavigatorData other) {
        this.removeDuplicates(session);
        this.reset();
        while (other.hasNext()) {
            Object[] currentData = other.getNext();
            RowIterator it = this.findFirstRow(currentData);
            if (it.hasNext()) continue;
            currentData = (Object[])ArrayUtil.resizeArrayIfDifferent(currentData, this.table.getColumnCount());
            this.add(currentData);
        }
        other.release();
    }

    @Override
    public void intersect(Session session, RowSetNavigatorData other) {
        this.removeDuplicates(session);
        this.reset();
        other.sortFull(session);
        while (this.hasNext()) {
            Object[] currentData = this.getNext();
            boolean hasRow = other.containsRow(currentData);
            if (hasRow) continue;
            this.remove();
        }
        other.release();
    }

    @Override
    public void intersectAll(Session session, RowSetNavigatorData other) {
        Object[] compareData = null;
        Row otherRow = null;
        Object[] otherData = null;
        this.sortFull(session);
        this.reset();
        other.sortFull(session);
        RowIterator it = this.fullIndex.emptyIterator();
        while (this.hasNext()) {
            boolean newGroup;
            Object[] currentData = this.getNext();
            boolean bl = newGroup = compareData == null || this.fullIndex.compareRowNonUnique(session, currentData, compareData, this.fullIndex.getColumnCount()) != 0;
            if (newGroup) {
                compareData = currentData;
                it = other.findFirstRow(currentData);
            }
            Object[] objectArray = otherData = (otherRow = it.getNextRow()) == null ? null : otherRow.getData();
            if (otherData != null && this.fullIndex.compareRowNonUnique(session, currentData, otherData, this.fullIndex.getColumnCount()) == 0) continue;
            this.remove();
        }
        other.release();
    }

    @Override
    public void except(Session session, RowSetNavigatorData other) {
        this.removeDuplicates(session);
        this.reset();
        other.sortFull(session);
        while (this.hasNext()) {
            Object[] currentData = this.getNext();
            boolean hasRow = other.containsRow(currentData);
            if (!hasRow) continue;
            this.remove();
        }
        other.release();
    }

    @Override
    public void exceptAll(Session session, RowSetNavigatorData other) {
        Object[] compareData = null;
        Row otherRow = null;
        Object[] otherData = null;
        this.sortFull(session);
        this.reset();
        other.sortFull(session);
        RowIterator it = this.fullIndex.emptyIterator();
        while (this.hasNext()) {
            boolean newGroup;
            Object[] currentData = this.getNext();
            boolean bl = newGroup = compareData == null || this.fullIndex.compareRowNonUnique(session, currentData, compareData, this.fullIndex.getColumnCount()) != 0;
            if (newGroup) {
                compareData = currentData;
                it = other.findFirstRow(currentData);
            }
            if ((otherData = (otherRow = it.getNextRow()) == null ? null : otherRow.getData()) == null || this.fullIndex.compareRowNonUnique(session, currentData, otherData, this.fullIndex.getColumnCount()) != 0) continue;
            this.remove();
        }
        other.release();
    }

    @Override
    public boolean hasUniqueNotNullRows(Session session) {
        this.sortFull(session);
        this.reset();
        Object[] lastRowData = null;
        while (this.hasNext()) {
            Object[] currentData = this.getNext();
            if (this.hasNull(currentData)) continue;
            if (lastRowData != null && this.fullIndex.compareRow(session, lastRowData, currentData) == 0) {
                return false;
            }
            lastRowData = currentData;
        }
        return true;
    }

    @Override
    public void removeDuplicates(Session session) {
        this.sortFull(session);
        this.reset();
        Object[] lastRowData = null;
        while (this.next()) {
            Object[] currentData = this.getCurrent();
            if (lastRowData != null && this.fullIndex.compareRow(session, lastRowData, currentData) == 0) {
                this.remove();
                continue;
            }
            lastRowData = currentData;
        }
    }

    @Override
    public void trim(int limitstart, int limitcount) {
        int i;
        if (this.size == 0) {
            return;
        }
        if (limitstart >= this.size) {
            this.clear();
            return;
        }
        if (limitstart != 0) {
            this.reset();
            for (i = 0; i < limitstart; ++i) {
                this.next();
                this.remove();
            }
        }
        if (limitcount == 0 || limitcount >= this.size) {
            return;
        }
        this.reset();
        for (i = 0; i < limitcount; ++i) {
            this.next();
        }
        while (this.hasNext()) {
            this.next();
            this.remove();
        }
    }

    @Override
    boolean hasNull(Object[] data) {
        for (int i = 0; i < this.visibleColumnCount; ++i) {
            if (data[i] != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] getGroupData(Object[] data) {
        if (this.isSimpleAggregate) {
            if (this.simpleAggregateData == null) {
                this.simpleAggregateData = data;
                return null;
            }
            return this.simpleAggregateData;
        }
        RowIterator it = this.groupIndex.findFirstRow(this.session, this.store, data);
        if (it.hasNext()) {
            Row row = it.getNextRow();
            if (this.isAggregate) {
                row.setChanged(true);
            }
            return row.getData();
        }
        return null;
    }

    @Override
    boolean containsRow(Object[] data) {
        RowIterator it = this.mainIndex.findFirstRow(this.session, this.store, data);
        boolean result = it.hasNext();
        it.release();
        return result;
    }

    @Override
    RowIterator findFirstRow(Object[] data) {
        return this.mainIndex.findFirstRow(this.session, this.store, data);
    }
}

