/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.navigator;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.lib.OrderedLongKeyHashMap;
import com.streamscape.ds.navigator.RowSetNavigatorDataChange;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;
import java.io.IOException;

public class RowSetNavigatorDataChangeMemory
implements RowSetNavigatorDataChange {
    public static RowSetNavigatorDataChangeMemory emptyRowSet = new RowSetNavigatorDataChangeMemory(null);
    int size;
    int currentPos = -1;
    OrderedLongKeyHashMap list;
    Session session;

    public RowSetNavigatorDataChangeMemory(Session session) {
        this.session = session;
        this.list = new OrderedLongKeyHashMap(64, true);
    }

    @Override
    public void release() {
        this.beforeFirst();
        this.list.clear();
        this.size = 0;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getRowPosition() {
        return this.currentPos;
    }

    @Override
    public boolean next() {
        if (this.currentPos < this.size - 1) {
            ++this.currentPos;
            return true;
        }
        this.currentPos = this.size - 1;
        return false;
    }

    @Override
    public boolean beforeFirst() {
        this.currentPos = -1;
        return true;
    }

    @Override
    public Row getCurrentRow() {
        return (Row)this.list.getValueByIndex(this.currentPos);
    }

    @Override
    public Object[] getCurrentChangedData() {
        return (Object[])this.list.getSecondValueByIndex(this.currentPos);
    }

    @Override
    public int[] getCurrentChangedColumns() {
        return (int[])this.list.getThirdValueByIndex(this.currentPos);
    }

    @Override
    public void write(RowOutputInterface out, ResultMetaData meta) throws IOException {
    }

    @Override
    public void read(RowInputInterface in, ResultMetaData meta) throws IOException {
    }

    @Override
    public void endMainDataSet() {
    }

    @Override
    public boolean addRow(Row row) {
        int lookup = this.list.getLookup(row.getId());
        if (lookup == -1) {
            this.list.put(row.getId(), row, null);
            ++this.size;
            return true;
        }
        if (this.list.getSecondValueByIndex(lookup) != null) {
            if (this.session.dataspaceStore.sqlEnforceTDCD) {
                throw Error.error(3900);
            }
            this.list.setSecondValueByIndex(lookup, null);
            this.list.setThirdValueByIndex(lookup, null);
            return true;
        }
        return false;
    }

    public Object[] addRow(Row row, Object[] data, int[] columnMap) {
        this.list.put(this.size, row, data);
        this.list.setThirdValueByIndex(this.size, columnMap);
        ++this.size;
        return data;
    }

    @Override
    public Object[] addRow(Session session, Row row, Object[] data, Type[] types, int[] columnMap) {
        long rowId = row.getId();
        int lookup = this.list.getLookup(rowId);
        if (lookup == -1) {
            this.list.put(rowId, row, data);
            this.list.setThirdValueByIndex(this.size, columnMap);
            ++this.size;
            return data;
        }
        Object[] rowData = ((Row)this.list.getFirstByLookup(lookup)).getData();
        Object[] currentData = (Object[])this.list.getSecondValueByIndex(lookup);
        if (currentData == null) {
            if (session.dataspaceStore.sqlEnforceTDCD) {
                throw Error.error(3900);
            }
            return null;
        }
        for (int i = 0; i < columnMap.length; ++i) {
            int j = columnMap[i];
            if (types[j].compare(session, data[j], currentData[j]) == 0) continue;
            if (types[j].compare(session, rowData[j], currentData[j]) != 0) {
                if (!session.dataspaceStore.sqlEnforceTDCU) continue;
                throw Error.error(3900);
            }
            currentData[j] = data[j];
        }
        int[] currentMap = (int[])this.list.getThirdValueByIndex(lookup);
        currentMap = ArrayUtil.union(currentMap, columnMap);
        this.list.setThirdValueByIndex(lookup, currentMap);
        return currentData;
    }

    @Override
    public boolean containsDeletedRow(Row row) {
        int lookup = this.list.getLookup(row.getId());
        if (lookup == -1) {
            return false;
        }
        Object[] currentData = (Object[])this.list.getSecondValueByIndex(lookup);
        return currentData == null;
    }
}

