/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.navigator;

import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowInputInterface;
import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.navigator.RangeIterator;
import com.streamscape.ds.persist.row.Row;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.session.SessionInterface;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public abstract class RowSetNavigator
implements RangeIterator {
    SessionInterface session;
    long id;
    int size;
    int mode;
    boolean isIterator;
    int currentPos = -1;
    int rangePosition;
    private Set<Integer> rejectedRows = new HashSet<Integer>();

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public abstract Object[] getCurrent();

    @Override
    public Object getCurrent(int i) {
        Object[] current = this.getCurrent();
        if (current == null) {
            return null;
        }
        return current[i];
    }

    @Override
    public void setCurrent(Object[] data) {
    }

    public long getRowid() {
        return 0L;
    }

    @Override
    public Object getRowidObject() {
        return null;
    }

    @Override
    public abstract Row getCurrentRow();

    public abstract void add(Object[] var1);

    public abstract boolean addRow(Row var1);

    @Override
    public abstract void remove();

    @Override
    public void reset() {
        this.currentPos = -1;
    }

    public abstract void clear();

    @Override
    public abstract void release();

    public void setSession(SessionInterface session) {
        this.session = session;
    }

    public SessionInterface getSession() {
        return this.session;
    }

    public int getSize() {
        return this.size - this.rejectedRows.size();
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Object[] getNext() {
        return this.next() ? this.getCurrent() : null;
    }

    @Override
    public boolean next() {
        if (this.hasNext()) {
            ++this.currentPos;
            return true;
        }
        if (this.size != 0) {
            this.currentPos = this.size;
        }
        return false;
    }

    @Override
    public boolean hasNext() {
        while (this.currentPos < this.size - 1 && this.rejectedRows.contains(this.currentPos + 1)) {
            ++this.currentPos;
        }
        return this.currentPos < this.size - 1;
    }

    @Override
    public Row getNextRow() {
        throw Error.runtimeError(201, "RowSetNavigator");
    }

    @Override
    public boolean setRowColumns(boolean[] columns) {
        throw Error.runtimeError(201, "RowSetNavigator");
    }

    @Override
    public long getRowId() {
        throw Error.runtimeError(201, "RowSetNavigator");
    }

    public boolean beforeFirst() {
        this.reset();
        this.currentPos = -1;
        return true;
    }

    public boolean afterLast() {
        if (this.size == 0) {
            return false;
        }
        this.reset();
        this.currentPos = this.size;
        return true;
    }

    public boolean first() {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() {
        if (this.size == 0) {
            return false;
        }
        if (this.isAfterLast()) {
            this.beforeFirst();
        }
        while (this.hasNext()) {
            this.next();
        }
        return true;
    }

    public int getRowNumber() {
        return this.currentPos;
    }

    public boolean absolute(int position) {
        if (position < 0) {
            position += this.size;
        }
        if (position < 0) {
            this.beforeFirst();
            return false;
        }
        if (position >= this.size) {
            this.afterLast();
            return false;
        }
        if (this.size == 0) {
            return false;
        }
        if (position < this.currentPos) {
            this.beforeFirst();
        }
        while (position > this.currentPos) {
            this.next();
        }
        return true;
    }

    public boolean relative(int rows) {
        int position = this.currentPos + rows;
        if (position < 0) {
            this.beforeFirst();
            return false;
        }
        return this.absolute(position);
    }

    public boolean previous() {
        return this.relative(-1);
    }

    public boolean isFirst() {
        return this.size > 0 && this.currentPos == 0;
    }

    public boolean isLast() {
        return this.size > 0 && this.currentPos == this.size - 1;
    }

    @Override
    public boolean isBeforeFirst() {
        return this.size > 0 && this.currentPos == -1;
    }

    public boolean isAfterLast() {
        return this.size > 0 && this.currentPos == this.size;
    }

    public void writeSimple(RowOutputInterface out, ResultMetaData meta) throws IOException {
        throw Error.runtimeError(201, "RowSetNavigator");
    }

    public void readSimple(RowInputInterface in, ResultMetaData meta) throws IOException {
        throw Error.runtimeError(201, "RowSetNavigator");
    }

    public abstract void write(RowOutputInterface var1, ResultMetaData var2) throws IOException;

    public abstract void read(RowInputInterface var1, ResultMetaData var2) throws IOException;

    public boolean isMemory() {
        return true;
    }

    @Override
    public int getRangePosition() {
        return this.rangePosition;
    }

    public void markCurrentRowAsRejected() {
        this.rejectedRows.add(this.currentPos);
    }

    public void resetRejectedRows() {
        this.rejectedRows.clear();
    }
}

