/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.mf;

import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.mf.DataspaceContainerContext;
import com.streamscape.ds.mf.SLSessionDataDataspaceSessionWrapper;
import com.streamscape.ds.session.Session;
import com.streamscape.sdo.excp.DatabaseSQLException;
import com.streamscape.sef.security.ComponentOwner;
import com.streamscape.sef.security.User;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFContext;
import com.streamscape.slex.SLSessionData;

public class DataspaceMFSession
extends AbstractMFSession {
    protected transient Session session = null;
    protected transient MFContext context = null;

    public DataspaceMFSession(String name, String componentName, ComponentOwner owner, boolean isRouted, AbstractDataspace dataspace, String slSessionName, String resourceName) {
        super(name, componentName, owner, isRouted, slSessionName, resourceName);
        this.session = dataspace.createSession((User)owner);
        this.session.setMFSession(this);
        this.session.setInteractive(true);
        this.session.setComponentName(componentName);
        this.session.setSLSessionName(slSessionName);
        this.session.setSLResourceName(resourceName);
    }

    public void beginTran() throws DatabaseSQLException {
        this.session.startTransaction();
    }

    public void commitTran() throws DatabaseSQLException {
        this.session.commit(false);
    }

    public void rollbackTran() throws DatabaseSQLException {
        this.session.rollback(false);
    }

    public void setAutocommit(boolean autocommit) throws DatabaseSQLException {
        this.session.setAutoCommit(autocommit);
    }

    @Override
    public MFContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(MFContext context) {
        if (context instanceof DataspaceContainerContext) {
            this.context = context;
        } else if (context == null) {
            this.context = null;
        }
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public void setSLSessionData(SLSessionData slSessionData) {
        this.session.setFetchSize(slSessionData.getFetchSize());
        this.session.setTransferBufferSize(slSessionData.getTransferBufferSize());
        this.session.setSLFileSessionContext(slSessionData.getSLFileSessionContext());
        super.setSLSessionData(new SLSessionDataDataspaceSessionWrapper(slSessionData, this.session));
        this.session.setSLSessionData(this.getSLSessionData());
    }

    public boolean isVirtualServer() {
        return this.session != null && this.session.serverContext != null;
    }
}

