/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.mf;

import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.info.HelpRegistry;
import com.streamscape.ds.mf.DataspaceAccessorProxy;
import com.streamscape.ds.mf.DataspaceDSLProvider;
import com.streamscape.ds.mf.DataspaceHelpSLResponse;
import com.streamscape.ds.mf.DataspaceMFSession;
import com.streamscape.ds.mf.DataspaceSLOperation;
import com.streamscape.ds.mf.operation.SQLStatement;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultPseudo;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.RowSetFactoryForDSResult;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.HelpSLResponse;
import com.streamscape.sdo.operation.Operation;
import com.streamscape.sdo.operation.PseudoSLResponse;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.slex.AbstractDSLProvider;
import com.streamscape.slex.AbstractLexiconProcessor;
import com.streamscape.slex.DSLProvider;
import com.streamscape.slex.HelpOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SemanticLexiconProcessor;
import com.streamscape.slex.UnsupportedRequestException;
import com.streamscape.slex.lang.PrefixTree;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.system.SystemDSLProvider;
import com.streamscape.slex.system.SystemHelpOperation;
import com.streamscape.tools.console.autocompletion.CompoundCompleter;
import com.streamscape.tools.console.autocompletion.PrefixTreeCompleter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DataspaceLexiconProcessor
implements SemanticLexiconProcessor {
    public static final String DATASPACE_OPERATIONS_TABLE = "DATASPACE_OPERATIONS";
    private RuntimeContext context;
    SystemDSLProvider systemProvider;
    DataspaceDSLProvider dataspaceProvider;
    AbstractDataspace dataspace;
    static List<DataspaceSLOperation> allOperations = new ArrayList<DataspaceSLOperation>();
    static Map<String, Map<String, DataspaceSLOperation>> operationsByDataspaceType;
    static Map<String, PrefixTree<DataspaceSLOperation>> prefixTreeByDataspaceType;
    static Map<String, CompoundCompleter> completerByDataspaceType;
    static Map<String, Set<String>> operationsByTag;
    static CompoundCompleter completerForRuntime;
    private CompoundCompleter completer = new CompoundCompleter();

    private static void addToOperationsMap(HelpRegistry.HelpEntry entry, DataspaceSLOperation operation, String scopeName) {
        Map<String, DataspaceSLOperation> operationsMap = operationsByDataspaceType.get(scopeName);
        operationsMap.put(operation.getName(), operation);
        if (entry.getAlias() != null) {
            operationsMap.put(operation.getAlias(), operation);
        }
    }

    static void addTag(String tag, DataspaceSLOperation operation) {
        operationsByTag.computeIfAbsent(tag, k -> new TreeSet()).add(operation.getName());
    }

    private static void addPrefixTreeAndCompleterForOperationsOfType(String type) {
        Collection<DataspaceSLOperation> operations = operationsByDataspaceType.get(type).values();
        PrefixTree<DataspaceSLOperation> prefixTree = DataspaceLexiconProcessor.buildPrefixTreeForOperations(operations);
        CompoundCompleter completer = DataspaceLexiconProcessor.buildCompleterForOperationsPrefixTree(prefixTree);
        prefixTreeByDataspaceType.put(type, prefixTree);
        completerByDataspaceType.put(type, completer);
    }

    private static PrefixTree<DataspaceSLOperation> buildPrefixTreeForOperations(Collection<DataspaceSLOperation> operations) {
        PrefixTree<DataspaceSLOperation> prefixTree = new PrefixTree<DataspaceSLOperation>();
        for (DataspaceSLOperation operation : operations) {
            prefixTree.add(operation.getName(), operation);
            if (operation.getAlias() == null) continue;
            prefixTree.add(operation.getAlias(), operation);
        }
        return prefixTree;
    }

    private static CompoundCompleter buildCompleterForOperationsPrefixTree(PrefixTree<DataspaceSLOperation> prefixTree) {
        CompoundCompleter completer = new CompoundCompleter();
        completer.addCompleter(new PrefixTreeCompleter<DataspaceSLOperation>(prefixTree).setSuggestionGroup(SuggestionGroup.DATASPACE_OPERATION));
        return completer;
    }

    static List<DataspaceSLOperation> getOperations() {
        return new ArrayList<DataspaceSLOperation>(allOperations);
    }

    public DataspaceLexiconProcessor(AbstractDataspace dataspace, RuntimeContext context) {
        this.context = context;
        this.dataspace = dataspace;
        this.systemProvider = this.createSystemProvider();
        this.systemProvider.activate(this);
        this.dataspaceProvider = new DataspaceDSLProvider(dataspace);
        this.dataspaceProvider.activate(dataspace);
        this.completer.addCompleter(this.systemProvider);
        this.completer.addCompleter(this.dataspaceProvider);
        this.completer.addCompleter(completerByDataspaceType.get(dataspace.getDataspaceType().name()));
        this.completer.addCompleter(completerByDataspaceType.get("ALL"));
        this.dataspaceProvider.loadTags();
    }

    @Override
    public Set<String> listOperations(MFSession session, String pattern) {
        return this.doListOperations(session, pattern, true);
    }

    @Override
    public Set<String> listVisibleOperations(MFSession session, String pattern) {
        return this.doListOperations(session, pattern, false);
    }

    @Override
    public Set<String> listOperationsByTag(String tag, MFSession session) {
        if (tag.equals("default")) {
            return this.doListOperations(session, null, true);
        }
        Set<String> result = DataspaceLexiconProcessor.doListOperationsByTag(tag);
        result.addAll(this.dataspaceProvider.listOperationsByTag(tag, session));
        return result;
    }

    private static Set<String> doListOperationsByTag(String tag) {
        Set<String> result = operationsByTag.get(tag);
        return result == null ? new TreeSet<String>() : new TreeSet<String>(result);
    }

    @Override
    public Set<String> listTags(MFSession session) {
        TreeSet<String> result = new TreeSet<String>(operationsByTag.keySet());
        result.addAll(this.dataspaceProvider.listTags(session));
        result.add("default");
        return result;
    }

    private Set<String> doListOperations(MFSession session, String pattern, boolean needsAll) {
        TreeSet<String> operations = new TreeSet<String>();
        this.fillOperations(operations, session, pattern, needsAll, this.dataspace.getType());
        this.fillOperations(operations, session, pattern, needsAll, "ALL");
        operations.addAll(this.dataspaceProvider.listOperations(pattern));
        return operations;
    }

    private void fillOperations(Set<String> operations, MFSession session, String pattern, boolean needsAll, String contextType) {
        if (pattern != null) {
            pattern = pattern.toLowerCase();
        }
        for (DataspaceSLOperation operation : operationsByDataspaceType.get(contextType).values()) {
            if (!needsAll && !operation.isVisible(session) || pattern != null && !operation.getName().contains(pattern)) continue;
            operations.add(operation.getName());
        }
    }

    public String getSyntax(String operationName, MFSession session) {
        Operation<?> operation = this.getOperation(AbstractDSLProvider.trimOperation(operationName), session);
        return operation != null ? operation.getSyntax(session) : null;
    }

    public String getAlias(String operationName, MFSession session) {
        Operation<?> operation = this.getOperation(AbstractDSLProvider.trimOperation(operationName), session);
        return operation != null ? operation.getAlias() : null;
    }

    public String getDescription(String operationName, MFSession session) {
        Operation<?> operation = this.getOperation(AbstractDSLProvider.trimOperation(operationName), session);
        return operation != null ? operation.getDescription(session) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SLResponse invoke(String operation, MFSession session, long timeout) throws Exception {
        MFSession mFSession = session;
        synchronized (mFSession) {
            SLResponse sLResponse;
            SLStatement stat = this.systemProvider.parse(operation, session);
            if (stat != null) {
                return this.systemProvider.invoke(stat, session, timeout);
            }
            stat = this.dataspaceProvider.parse(operation, session);
            if (stat != null) {
                return this.dataspaceProvider.invoke(stat, session, timeout);
            }
            Session sqlSession = ((DataspaceMFSession)session).getSession();
            long requestTimeout = sqlSession.getRequestTimeout();
            try {
                sqlSession.setRequestTimeout(timeout);
                Result result = sqlSession.executeDirectStatement(operation);
                sLResponse = DataspaceLexiconProcessor.buildResponse(sqlSession, result, session);
                sqlSession.setRequestTimeout(requestTimeout);
            }
            catch (Throwable throwable) {
                sqlSession.setRequestTimeout(requestTimeout);
                throw throwable;
            }
            return sLResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SLResponse invoke(SLStatement operation, MFSession session, long timeout) throws Exception {
        MFSession mFSession = session;
        synchronized (mFSession) {
            SLResponse response = this.systemProvider.invoke(operation, session, timeout);
            if (response.isOK()) {
                return response;
            }
            response = this.dataspaceProvider.invoke(operation, session, timeout);
            if (response.isOK()) {
                return response;
            }
            if (operation instanceof SQLStatement) {
                Session sqlSession = ((DataspaceMFSession)session).getSession();
                Result result = sqlSession.executeDirectStatement(((SQLStatement)operation).getSQL());
                return DataspaceLexiconProcessor.buildResponse(sqlSession, result, session);
            }
            if (operation instanceof HelpOperation.Definition) {
                return SystemHelpOperation.getHelpNotAvailableResponse(((HelpOperation.Definition)operation).getOperationName());
            }
            return new SLResponse("Unexpected query.", false);
        }
    }

    public static SLResponse buildResponse(Session session, Result result, MFSession mfSession) throws Exception {
        if (result.isError()) {
            if (result.getException().getCause() instanceof UnsupportedRequestException) {
                return new SLResponse(result.getException().getCause());
            }
            if (result.getException().getCause() instanceof FabricEventSourceException) {
                return new SLResponse(result.getException().getCause());
            }
            return new SLResponse("ERROR: " + result.getException().getFullErrorMessage() + "\n\n" + result.getException().getLineAndPositionMessage(), result.getException());
        }
        if (result instanceof ResultPseudo) {
            return new PseudoSLResponse();
        }
        List<RowSet> results = ((RowSetFactoryForDSResult)((RowSetFactoryForDSResult)new RowSetFactoryForDSResult().setWithBlobs(false)).setNotation(mfSession.getSLSessionData().getDataObjectNotation())).createRowSets(session, result);
        if (results.size() > 0) {
            return DataspaceAccessorProxy.createResponse(mfSession, results.get(results.size() - 1));
        }
        return new SLResponse();
    }

    @Override
    public void registerProvider(DSLProvider<?> provider) {
    }

    @Override
    public void registerProvider(DSLProvider<?> provider, String contextType) {
    }

    @Override
    public Operation<?> getOperation(String operation) {
        return this.getOperation(operation, null);
    }

    @Override
    public Operation<?> getVisibleOperation(String operation, MFSession session) {
        Operation<?> operationDefinition = this.getOperation(operation, session);
        if (operationDefinition != null && operationDefinition.isVisible(session)) {
            return operationDefinition;
        }
        return null;
    }

    public Operation<?> getOperation(String operation, MFSession session) {
        DataspaceSLOperation operationDefinition = operationsByDataspaceType.get(this.dataspace.getType()).get(AbstractDSLProvider.trimOperation(operation));
        if (operationDefinition == null) {
            operationDefinition = operationsByDataspaceType.get("ALL").get(AbstractDSLProvider.trimOperation(operation));
        }
        if (operationDefinition == null) {
            return this.dataspaceProvider.getVisibleOperation(operation, session);
        }
        return operationDefinition;
    }

    @Override
    public DSLCompletion completeDsl(String command, MFSession session) {
        DSLCompletion completion = this.completer.completeDsl(command, (Object object) -> {
            if (object instanceof Operation && ((Operation)object).isVisible(session)) {
                if (object instanceof DataspaceSLOperation) {
                    List<DataspaceType> scopes = ((DataspaceSLOperation)object).getDataspaceScope();
                    return scopes == null || scopes.contains((Object)this.dataspace.getDataspaceType());
                }
                return true;
            }
            return false;
        });
        Session sqlSession = ((DataspaceMFSession)session).getSession();
        completion = CompoundCompleter.mergeCompletions(command, completion, sqlSession.complete(command));
        return AbstractLexiconProcessor.completeRuntimeDsl(command, session, this.context.getLexiconProcessor(), completion);
    }

    public static DataspaceSLOperation lookupOperationForRuntimeByQuery(String query, MFSession session, boolean moreSuitable) {
        DataspaceSLOperation operation;
        PrefixTree.Node<DataspaceSLOperation> node = null;
        for (DataspaceType type : DataspaceType.values()) {
            PrefixTree.Node<DataspaceSLOperation> node2 = node = moreSuitable ? prefixTreeByDataspaceType.get(type.name()).lookupMoreSuitableDataNode(query) : prefixTreeByDataspaceType.get(type.name()).lookupDataNode(query);
            if (node != null && node.getData().isVisible(session)) break;
        }
        if (node == null) {
            PrefixTree.Node<DataspaceSLOperation> node3 = node = moreSuitable ? prefixTreeByDataspaceType.get("ALL").lookupMoreSuitableDataNode(query) : prefixTreeByDataspaceType.get("ALL").lookupDataNode(query);
        }
        if (node != null && (operation = (DataspaceSLOperation)node.getData()).isVisible(session)) {
            return operation;
        }
        return null;
    }

    public static DSLCompletion completeDslForRuntime(String command, MFSession session) {
        return completerForRuntime.completeDsl(command, (Object object) -> object instanceof Operation && ((Operation)object).isVisible(session) && ((DataspaceSLOperation)object).isAvailableInRuntime());
    }

    public static Set<String> listRuntimeOperations(String pattern, MFSession session) {
        TreeSet<String> result = new TreeSet<String>();
        allOperations.stream().filter(operation -> operation.isAvailableInRuntime() && (pattern == null || operation.getName().contains(pattern))).filter(operation -> session == null || operation.isVisible(session)).forEach(operation -> {
            result.add(operation.getName());
            if (operation.getAlias() != null) {
                result.add(operation.getAlias());
            }
        });
        return result;
    }

    public static Set<String> listRuntimeOperationsByTag(String tag, MFSession session) {
        Set<String> result = DataspaceLexiconProcessor.doListOperationsByTag(tag);
        Set<String> runtimeOperations = DataspaceLexiconProcessor.listRuntimeOperations(null, session);
        result.removeIf(operation -> !runtimeOperations.contains(operation));
        return result;
    }

    public static Set<String> listRuntimeOperationTags() {
        TreeSet<String> result = new TreeSet<String>();
        for (DataspaceSLOperation operation : DataspaceLexiconProcessor.getOperations()) {
            if (!operation.isAvailableInRuntime() || operation.getTags(null) == null) continue;
            result.addAll(operation.getTags(null));
        }
        return result;
    }

    @Override
    public Operation<?> getForeignOperation(String operationName, MFSession session) {
        return this.context.getLexiconProcessor().getExportableOperation(operationName, session);
    }

    @Override
    public Set<String> listForeignOperations(MFSession session, String pattern) {
        return this.context.getLexiconProcessor().listExportableOperations(session, pattern);
    }

    @Override
    public Set<String> listForeignOperationsByTag(String tag, MFSession session) {
        return this.context.getLexiconProcessor().listExportableOperationsByTag(tag, session);
    }

    @Override
    public Set<String> listForeignTags(MFSession session) {
        return this.context.getLexiconProcessor().listExportableTags(session);
    }

    @Override
    public Operation<?> getExportableOperation(String operationName, MFSession session) {
        return DataspaceLexiconProcessor.lookupOperationForRuntimeByQuery(operationName, session, false);
    }

    @Override
    public Set<String> listExportableOperations(MFSession session, String pattern) {
        return DataspaceLexiconProcessor.listRuntimeOperations(pattern, session);
    }

    @Override
    public Set<String> listExportableOperationsByTag(String tag, MFSession session) {
        return DataspaceLexiconProcessor.listRuntimeOperationsByTag(tag, session);
    }

    @Override
    public Set<String> listExportableTags(MFSession session) {
        return DataspaceLexiconProcessor.listRuntimeOperationTags();
    }

    @Override
    public boolean isNativeContext(MFSession session) {
        return session instanceof DataspaceMFSession;
    }

    protected SystemDSLProvider createSystemProvider() {
        return new SystemDSLProvider(this, this){

            @Override
            protected SystemHelpOperation createHelpOperation() {
                return new DataspaceSystemHelpOperation(this);
            }

            class DataspaceSystemHelpOperation
            extends SystemHelpOperation {
                DataspaceSystemHelpOperation(1 this$1) {
                }

                @Override
                protected HelpSLResponse createSLResponse(Set<String> contextOperations) {
                    return new DataspaceHelpSLResponse(contextOperations);
                }

                @Override
                protected HelpSLResponse createSLResponse(Set<String> contextOperations, Set<String> foreignOperations) {
                    return new DataspaceHelpSLResponse(contextOperations, foreignOperations);
                }

                @Override
                protected HelpSLResponse createSLResponse(Set<String> contextOperations, Set<String> foreignOperations, Set<String> sessionOperations) {
                    return new DataspaceHelpSLResponse(contextOperations, foreignOperations, sessionOperations);
                }
            }
        };
    }

    static {
        operationsByTag = new HashMap<String, Set<String>>();
        operationsByDataspaceType = new HashMap<String, Map<String, DataspaceSLOperation>>();
        operationsByDataspaceType.put(DataspaceType.TSPACE.name(), new HashMap());
        operationsByDataspaceType.put(DataspaceType.QSPACE.name(), new HashMap());
        operationsByDataspaceType.put(DataspaceType.FSPACE.name(), new HashMap());
        operationsByDataspaceType.put(DataspaceType.CSPACE.name(), new HashMap());
        operationsByDataspaceType.put(DataspaceType.HSPACE.name(), new HashMap());
        operationsByDataspaceType.put(DataspaceType.USPACE.name(), new HashMap());
        operationsByDataspaceType.put("ALL", new HashMap());
        for (HelpRegistry.HelpEntry helpEntry : HelpRegistry.entries) {
            DataspaceSLOperation operation = new DataspaceSLOperation(helpEntry.getName(), helpEntry.getAlias(), helpEntry.getDesc(), helpEntry.getSyntax(), helpEntry.getExamples(), helpEntry.getTags(), helpEntry.getInitialVersion(), helpEntry.getStatus(), helpEntry.isAdmin(), helpEntry.getScope(), helpEntry.isAvailableInRuntime(), helpEntry.getOperationVisibleChecker());
            allOperations.add(operation);
            if (helpEntry.getScope() != null) {
                for (DataspaceType scope : helpEntry.getScope()) {
                    DataspaceLexiconProcessor.addToOperationsMap(helpEntry, operation, scope.name());
                }
            } else {
                DataspaceLexiconProcessor.addToOperationsMap(helpEntry, operation, "ALL");
            }
            Set<String> tags = operation.getTags(null);
            if (tags == null) continue;
            for (String tag : tags) {
                DataspaceLexiconProcessor.addTag(tag, operation);
            }
        }
        completerByDataspaceType = new HashMap<String, CompoundCompleter>();
        prefixTreeByDataspaceType = new HashMap<String, PrefixTree<DataspaceSLOperation>>();
        for (HelpRegistry.HelpEntry helpEntry : DataspaceType.values()) {
            DataspaceLexiconProcessor.addPrefixTreeAndCompleterForOperationsOfType(((Enum)((Object)helpEntry)).name());
        }
        DataspaceLexiconProcessor.addPrefixTreeAndCompleterForOperationsOfType("ALL");
        completerForRuntime = new CompoundCompleter();
        for (PrefixTree prefixTree : prefixTreeByDataspaceType.values()) {
            completerForRuntime.addCompleter(new PrefixTreeCompleter(prefixTree).setSuggestionGroup(SuggestionGroup.DATASPACE_OPERATION));
        }
    }
}

