/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.mf;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionFactory;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.cli.ds.DataCollection;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceWriteMessage;
import com.streamscape.ds.ServerConnection;
import com.streamscape.ds.jdbc.JDBCArray;
import com.streamscape.ds.jdbc.JDBCConnection;
import com.streamscape.ds.mf.DataspaceContainerContext;
import com.streamscape.ds.mf.DataspaceLexiconProcessor;
import com.streamscape.ds.mf.DataspaceMFSession;
import com.streamscape.ds.mf.RuntimeOperationException;
import com.streamscape.ds.mf.SLDataspaceCall;
import com.streamscape.ds.parser.ParserCommand;
import com.streamscape.ds.parser.ParserRPL;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExternalExecutionExpression;
import com.streamscape.ds.parser.statement.StatementCollectionQuery;
import com.streamscape.ds.rights.UserWrapper;
import com.streamscape.ds.schema.server.NoSqlServerObject;
import com.streamscape.ds.schema.server.VirtualServerObject;
import com.streamscape.ds.session.Session;
import com.streamscape.omf.java.Utils;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.operation.HelpSLResponse;
import com.streamscape.sdo.operation.PseudoSLResponse;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetClient;
import com.streamscape.sdo.rowset.RowSetClientFactory;
import com.streamscape.sdo.rowset.RowSetClientResultSetImpl;
import com.streamscape.sef.EventTriggerCompileException;
import com.streamscape.sef.EventTriggerState;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.IllegalTriggerStateException;
import com.streamscape.sef.dataspace.DataspaceComponentException;
import com.streamscape.sef.dii.AccessibleObject;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.dii.AccessibleObjectsCache;
import com.streamscape.sef.dispatcher.AbstractAccessorProxy;
import com.streamscape.sef.enums.ComponentState;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.factory.connection.external.ExecutionStatement;
import com.streamscape.sef.factory.connection.external.ExternalParserContext;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.sef.security.ComponentOwner;
import com.streamscape.sef.security.User;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SLSessionData;
import com.streamscape.slex.SemanticLexiconProcessor;
import com.streamscape.slex.file.SLFileSessionContext;
import com.streamscape.slex.lang.HelpDSLOperation;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.tools.lexer.BufferUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class DataspaceAccessorProxy
extends AbstractAccessorProxy
implements AccessibleObject {
    private final DataspaceMFSession session;
    private AbstractDataspace dataspace;
    private AccessibleObjectsCache cache = new AccessibleObjectsCache();
    private ServerConnection serverConnection;
    private int downloadableBlobSize = -1;

    public DataspaceAccessorProxy(String sessionName, String componentName, ComponentOwner owner, boolean isRouted, AbstractDataspace dataspace, String slSessionName, SLSessionData slSessionData) throws FabricRequestException {
        super(dataspace.getLexiconProcessor());
        UserWrapper grantee = dataspace.getStore().getUserManager().get((User)owner);
        try {
            grantee.checkAccessDataspace(dataspace);
        }
        catch (DataspaceException exception) {
            throw new FabricRequestException(exception);
        }
        if (dataspace.getState() != ComponentState.STARTED && !grantee.isAdmin() && !dataspace.getOwner().getObjectName().equals(grantee.getObjectName())) {
            throw new FabricRequestException(new DataspaceException("When dataspace is OFFLINE only admin and dataspace owner can connect to this dataspace."));
        }
        this.dataspace = dataspace;
        this.session = new DataspaceMFSession(sessionName, componentName, owner, isRouted, dataspace, slSessionName, dataspace.getFullName());
        this.session.setSLSessionData(slSessionData);
        this.session.setContext(new DataspaceContainerContext(dataspace));
        this.cache.putAccessibleObject(0L, this);
        if (slSessionName == null) {
            this.session.getSLSessionData().setFetchSize(0);
        }
    }

    @Override
    protected ImmutableEventDatagram invokeOtherRequest(ImmutableEventDatagram request) throws FabricRequestException {
        if (request.getEventId().equals("e.sys.sl.DataspaceCall")) {
            try {
                SLDataspaceCall slDataspaceCall = (SLDataspaceCall)((OpaqueEvent)request).getData();
                return DataspaceAccessorProxy.createResponseEvent(this.executeInterruptableRequest(slDataspaceCall.toString(), this.getMFSession(), slDataspaceCall.timeout, () -> this.processCall(slDataspaceCall)));
            }
            catch (Exception exception) {
                this.logError(exception);
                throw new FabricRequestException(exception);
            }
        }
        if (request.getEventId().equals("e.sys.dataspace.write")) {
            try {
                if (this.serverConnection == null) {
                    this.serverConnection = new ServerConnection(this.session.getSession());
                }
                return this.serverConnection.processDataspaceWriteMessage((DataspaceWriteMessage)((OpaqueEvent)request).getData());
            }
            catch (Exception exception) {
                this.logError(exception);
                throw new FabricRequestException(exception);
            }
        }
        return super.invokeOtherRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SLResponse processCall(SLDataspaceCall call) {
        AccessibleObject object = this.cache.getAccessibleObject(call.objectId());
        if (object != null) {
            if (call.method.equals("interruptTransaction")) {
                this.interruptTransaction(this.session.getSession());
                return new SLResponse();
            }
            try {
                DataspaceMFSession dataspaceMFSession = this.session;
                synchronized (dataspaceMFSession) {
                    if (!(object instanceof RowSetClient)) {
                        int paramsArraySize = call.params().length;
                        Object[] params = new Object[paramsArraySize + 1];
                        params[0] = this.session.getSession();
                        System.arraycopy(call.params(), 0, params, 1, paramsArraySize);
                        call.params = params;
                    }
                    this.cache.resolveArgumentAccessibleObject(call);
                    Method method = this.cache.resolveMethod(call, object);
                    if (method == null && call.method().equals("executeQuery")) {
                        method = DataspaceAccessorProxy.class.getMethod("executeQuery", Session.class, String.class, Object[].class);
                    }
                    if (method == null && call.method().equals("callFunction")) {
                        method = DataspaceAccessorProxy.class.getMethod("callFunction", Session.class, String.class, Object[].class);
                    }
                    if (method == null) {
                        return new SLResponse("Unknown method '" + call.method() + "' specified.", false);
                    }
                    Object result = this.cache.invoke(call, method, false);
                    if (this.session.getSession().isAutoCommit()) {
                        this.session.getSession().commit(false);
                    }
                    SLResponse response = new SLResponse();
                    response.setObject(result);
                    return response;
                }
            }
            catch (Exception exception) {
                if (this.session.getSession().isAutoCommit()) {
                    this.session.getSession().rollback(false);
                }
                return new SLResponse(exception);
            }
        }
        return new SLResponse("Unable to find callable object.", false);
    }

    public Object executeQuery(Session session, String query, Object ... params) throws Exception {
        return this.executeQueryInternal(session, false, query, params);
    }

    private Object executeQueryInternal(Session session, boolean isSlangQuery, String query, Object ... params) throws Exception {
        Object object;
        if (session.serverContext != null && !this.isUseVirtualServerCommand(query)) {
            SLResponse response = this.executeStatementInServerContext(session, query, this.getMFSession(), isSlangQuery, session.getRequestTimeout());
            if (response.isOK()) {
                return response.getRowSet();
            }
            if (response.getException() != null) {
                throw new DataspaceException(response.getException());
            }
            if (response.getText() != null) {
                throw new DataspaceException(response.getText());
            }
            throw new DataspaceException("Failed to execute server query.");
        }
        JDBCConnection jdbcConnection = new JDBCConnection(session);
        Statement statement = null;
        try {
            boolean isCall;
            String trimQuery = query.trim();
            boolean bl = isCall = trimQuery.length() > 4 && trimQuery.substring(0, 4).equalsIgnoreCase("call");
            if (isCall || params != null && params.length > 0) {
                statement = isCall ? jdbcConnection.prepareCall(query, 1004, 1007) : jdbcConnection.prepareStatement(query, 1004, 1007);
                if (session.getFetchSize() >= 0) {
                    statement.setFetchSize(session.getFetchSize());
                }
                for (int i = 0; params != null && i < params.length; ++i) {
                    ((PreparedStatement)statement).setObject(i + 1, params[i]);
                }
                ((PreparedStatement)statement).execute();
            } else {
                statement = DataspaceAccessorProxy.createStatementAndExecute(jdbcConnection, query, session.getFetchSize());
            }
            if (this.isPseudoResult(statement)) {
                PseudoSLResponse i = new PseudoSLResponse();
                return i;
            }
            Object result = ((RowSetClientFactory)((RowSetClientFactory)((RowSetClientFactory)((RowSetClientFactory)new RowSetClientFactory().setFetchSize(session.getFetchSize())).setBlobSize(this.downloadableBlobSize)).setWithBlobs(!isSlangQuery)).setNotation(this.session.getSLSessionData().getDataObjectNotation())).createRowSetClientResponse(statement, query);
            if (result instanceof RowSetClientResultSetImpl) {
                ((RowSetClientResultSetImpl)result).addCloseableObject(statement);
                statement = null;
            }
            object = result;
        }
        catch (SQLException error) {
            throw new DataspaceComponentException(2000, "Unable to execute dataspace query. Cause: " + error.getMessage(), error);
        }
        finally {
            session.resetStatementFetchSize();
            session.resetStatementSLFileSessionContext();
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
        return object;
    }

    private boolean isUseVirtualServerCommand(String command) {
        return BufferUtils.normalizeCommand(command).toLowerCase().startsWith("use server");
    }

    private boolean isPseudoResult(Statement statement) {
        try {
            return statement.getUpdateCount() == -2;
        }
        catch (Exception e) {
            return false;
        }
    }

    private SLResponse executeStatementInServerContext(Session session, Object query, MFSession mfSession, boolean isSlangQuery, long requestTimeout) throws Exception {
        if (session.serverContext == null) {
            throw new DataspaceException("Server context is not set.");
        }
        SemanticLexiconProcessor serverLexiconProcessor = session.serverContext.getLexiconProcessor();
        if (serverLexiconProcessor == null) {
            throw new DataspaceException("This server does not support internal commands.");
        }
        if (query instanceof String) {
            if ("use ..".equals(BufferUtils.normalizeCommand((String)query).toLowerCase())) {
                session.serverContext = null;
                return new SLResponse();
            }
            if (NoSqlServerObject.NoSqlServerType.DYNAMODB.name().equalsIgnoreCase(session.serverContext.getServerType())) {
                ParserCommand parserCommand = new ParserCommand(session, new Scanner((String)query));
                ExternalParserContext<Expression> externalParserContext = parserCommand.createExternalParserContext(0);
                ExecutionStatement executionStatement = session.serverContext.getExternalParser().parse((String)query, externalParserContext);
                Object result = executionStatement.execute(new ExternalExecutionExpression.ExternalExecutionContextImpl(session, session.serverContext), String.class);
                if (result instanceof String) {
                    return new SLResponse((String)result);
                }
                return new SLResponse(HTTPUtils.getJsonSerializerForRest().withPrettyPrint(true).serialize(result));
            }
            return serverLexiconProcessor.invoke((String)query, mfSession, requestTimeout);
        }
        if (query instanceof SLStatement) {
            return serverLexiconProcessor.invoke((SLStatement)query, mfSession, requestTimeout);
        }
        throw new DataspaceException("Invalid query type '" + String.valueOf(query.getClass()) + "'.");
    }

    public static Statement createStatementAndExecute(Connection connection, String query, int fetchSize) throws SQLException {
        if (VirtualServerObject.isSybaseSpCall(connection, query)) {
            Statement statement = connection.createStatement();
            statement.executeQuery(query);
            return statement;
        }
        Statement statement = connection.createStatement(1004, 1007);
        if (fetchSize >= 0) {
            statement.setFetchSize(fetchSize);
        }
        statement.execute(query);
        return statement;
    }

    public Object callFunction(Session session, String query, Object ... params) throws Exception {
        ParserRPL.FunctionCallSplitter splitter = new ParserRPL.FunctionCallSplitter(session, query);
        String functionName = splitter.getFunctionName();
        if (functionName != null) {
            Statement statement = null;
            Statement callableStatement = null;
            try {
                JDBCConnection jdbcConnection = new JDBCConnection(session);
                statement = jdbcConnection.createStatement();
                statement.execute("describe function " + functionName + " parameters");
                ResultSet resultSet = statement.getResultSet();
                boolean returnsObject = true;
                while (resultSet.next()) {
                    String type;
                    if (!resultSet.getString(1).equalsIgnoreCase("RETURNS") || !(type = resultSet.getString(2)).equals("TABLE") && (!type.startsWith("TABLE(") || !type.endsWith(")"))) continue;
                    returnsObject = false;
                    break;
                }
                if (returnsObject) {
                    callableStatement = jdbcConnection.prepareCall(query, 1004, 1007);
                    if (session.getFetchSize() >= 0) {
                        callableStatement.setFetchSize(session.getFetchSize());
                    }
                    for (int i = 0; params != null && i < params.length; ++i) {
                        callableStatement.setObject(i + 1, params[i]);
                    }
                    callableStatement.execute();
                    resultSet = callableStatement.getResultSet();
                    if (resultSet == null) {
                        while (callableStatement.getMoreResults()) {
                            resultSet = callableStatement.getResultSet();
                        }
                    }
                    Object result = null;
                    if (resultSet != null) {
                        if (resultSet.getMetaData().getColumnCount() == 1) {
                            int rowsRead = 0;
                            while (resultSet.next()) {
                                ArrayList tmp = resultSet.getObject(1);
                                if (tmp instanceof JDBCArray) {
                                    tmp = ((JDBCArray)((Object)tmp)).getArray();
                                }
                                if (rowsRead > 0) {
                                    if (rowsRead == 1) {
                                        ArrayList newResult = new ArrayList();
                                        newResult.add(result);
                                        result = newResult;
                                    }
                                    ((List)result).add(tmp);
                                } else {
                                    result = tmp;
                                }
                                ++rowsRead;
                            }
                        } else {
                            result = ((RowSetClientFactory)((RowSetClientFactory)((RowSetClientFactory)new RowSetClientFactory().setFetchSize(session.getFetchSize())).setBlobSize(this.downloadableBlobSize)).setWithBlobs(true)).createRowSetClientResponse(statement, query);
                            if (result instanceof RowSetClientResultSetImpl) {
                                ((RowSetClientResultSetImpl)result).addCloseableObject(callableStatement);
                                callableStatement = null;
                            }
                        }
                    }
                    ArrayList arrayList = result;
                    return arrayList;
                }
            }
            catch (Exception exception) {
                throw new DataspaceComponentException(2000, "Unable to execute dataspace query. Cause: " + exception.getMessage(), exception);
            }
            finally {
                session.resetStatementFetchSize();
                session.resetStatementSLFileSessionContext();
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
                if (callableStatement != null) {
                    try {
                        callableStatement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return this.executeQuery(session, query, params);
    }

    public void interruptTransaction(Session session) {
        session.interruptCurrentProcessing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ImmutableEventDatagram invokeSLStatementRequest(SLStatement statement, MFSession session, long timeout) throws Exception {
        MFSession mFSession = session;
        synchronized (mFSession) {
            if (this.session.session.serverContext != null) {
                return DataspaceAccessorProxy.createResponseEvent(this.executeStatementInServerContext(this.session.session, statement, session, true, timeout));
            }
        }
        return DataspaceAccessorProxy.createResponseEvent(this.lexiconProcessorHolder.getSemanticLexiconProcessor().invoke(statement, session, timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ImmutableEventDatagram invokeDSLCompletionRequest(String command, MFSession session) throws Exception {
        Object lexiconProcessor = this.lexiconProcessorHolder.getSemanticLexiconProcessor();
        MFSession mFSession = session;
        synchronized (mFSession) {
            if (this.session.session.serverContext != null && !this.isUseVirtualServerCommand(command)) {
                lexiconProcessor = this.session.session.serverContext.getLexiconProcessor();
            }
        }
        DSLCompletion completion = lexiconProcessor.completeDsl(command, session);
        SLResponse response = new SLResponse();
        response.setObject(completion != null ? completion.sort() : null);
        return DataspaceAccessorProxy.createResponseEvent(response);
    }

    @Override
    protected void doInvokeInterruptRequest(String command, MFSession session) {
        this.session.session.interruptCurrentProcessing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ImmutableEventDatagram invokeTextRequest(String statement, MFSession session, long timeout) throws Exception {
        if (this.session.getSession().getFetchSize() <= 0) {
            return super.invokeTextRequest(statement, session, timeout);
        }
        MFSession mFSession = session;
        synchronized (mFSession) {
            if (this.session.session.serverContext != null) {
                return DataspaceAccessorProxy.createResponseEvent(this.executeStatementInServerContext(this.session.session, statement, session, true, timeout));
            }
            DataspaceLexiconProcessor dataspaceLexiconProcessor = (DataspaceLexiconProcessor)this.lexiconProcessorHolder.getSemanticLexiconProcessor();
            SLStatement stat = dataspaceLexiconProcessor.systemProvider.parse(statement, session);
            if (stat != null) {
                return DataspaceAccessorProxy.createResponseEvent(dataspaceLexiconProcessor.systemProvider.invoke(stat, session, timeout));
            }
            stat = dataspaceLexiconProcessor.dataspaceProvider.parse(statement, session);
            if (stat != null) {
                return DataspaceAccessorProxy.createResponseEvent(dataspaceLexiconProcessor.dataspaceProvider.invoke(stat, session, timeout));
            }
        }
        mFSession = session;
        synchronized (mFSession) {
            SLResponse response;
            long requestTimeout = this.session.session.getRequestTimeout();
            try {
                this.session.session.setRequestTimeout(timeout);
                Object result = this.executeQueryInternal(this.session.session, true, statement, new Object[0]);
                result = this.cache.putAndConvertToProxy(result);
                if (result instanceof RowSet) {
                    response = DataspaceAccessorProxy.createResponse(session, (RowSet)result);
                } else if (result instanceof SQLWarning) {
                    response = new SLResponse("WARNING: " + ((SQLWarning)result).getMessage());
                } else if (result instanceof PseudoSLResponse) {
                    response = new PseudoSLResponse();
                } else {
                    response = new SLResponse();
                    response.setObject(result);
                    if (result == null && statement != null && statement.trim().toLowerCase().startsWith("print") && statement.trim().endsWith(")")) {
                        response.setObject("");
                    }
                }
            }
            catch (Exception exception) {
                RuntimeOperationException operationException = Utils.getCause(exception, RuntimeOperationException.class);
                response = operationException != null ? operationException.response : new SLResponse(exception);
            }
            finally {
                this.session.session.setRequestTimeout(requestTimeout);
            }
            return DataspaceAccessorProxy.createResponseEvent(response);
        }
    }

    static SLResponse createResponse(MFSession session, RowSet result) throws Exception {
        StatementCollectionQuery statement;
        if (DataspaceAccessorProxy.isFromSlangTool(session) && result.getParserStatement() instanceof StatementCollectionQuery && ((statement = (StatementCollectionQuery)result.getParserStatement()).getType() == 3158 || statement.getType() == 3095 || statement.getType() == 3052)) {
            Object param;
            Object object = param = statement.getType() == 3095 ? statement.getParameter(2) : statement.getParameter(1);
            if (param instanceof Integer && ((Integer)param == 1159 || (Integer)param == 634)) {
                String description;
                String string = description = result.getRowCount() > 0 ? (String)result.getRowAt(1).getColumn(1) : null;
                if (description == null || description.isEmpty()) {
                    return new HelpSLResponse("Documentation not found.", null, null);
                }
                StringBuilder builder = new StringBuilder();
                builder.append(result.getRowMetaData().getColumnName(1)).append(":\n\n");
                HelpDSLOperation.printWithIndention(builder, "", description, null);
                return new HelpSLResponse(null, builder.toString(), null);
            }
        }
        return new SLResponse(result);
    }

    private static boolean isFromSlangTool(MFSession session) {
        return session != null && session.isFromSlangTool();
    }

    @Override
    protected MFSession getMFSession() {
        return this.session;
    }

    @Override
    public void close() {
        this.cache.clearAndCloseAll();
        this.session.getSession().close();
    }

    @Override
    protected void logError(Throwable exception) {
        Trace.logException(this, exception, true);
        this.dataspace.logError("Processing of DSL statement failed. " + exception.getMessage());
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        return null;
    }

    public long getSessionId(Session session) {
        return session.getId();
    }

    public boolean getAutoCommit(Session session) {
        return session.isAutoCommit();
    }

    public void setAutoCommit(Session session, boolean autoCommit) {
        session.setAutoCommit(autoCommit);
    }

    public boolean isReadOnly(Session session) {
        return session.isReadOnly();
    }

    public void setReadOnly(Session session, boolean readOnly) {
        session.setReadOnly(readOnly);
    }

    public int getSessionState(Session session) {
        return 0;
    }

    public void commit(Session session) {
        session.commit(false);
    }

    public void rollback(Session session) {
        session.rollback(false);
    }

    public int getTransactionIsolation(Session session) {
        return session.getIsolation();
    }

    public void setTransactionIsolation(Session session, Integer level) {
        session.setIsolation(level);
    }

    public List<String> listSinkEvents(Session session) {
        return null;
    }

    public boolean hasSinkEvents() {
        return false;
    }

    public List<String> listActionableEvents(Session session) {
        return this.dataspace.listActionableEvents(session);
    }

    public boolean hasActionableEvents(Session session) {
        return false;
    }

    public boolean existsActionableEvent(Session session, String eventId) {
        return this.dataspace.existsActionableEvent(session, eventId);
    }

    public void enable(Session session, String triggerName) {
        this.dataspace.enable(session, triggerName);
    }

    public void disable(Session session, String triggerName) {
        this.dataspace.disable(session, triggerName);
    }

    public void removeEventTrigger(String triggerName) throws ServiceConfigurationException, IllegalTriggerStateException {
    }

    public EventTriggerDefinition getEventTriggerDefinition(Session session, String triggerName) throws ServiceConfigurationException {
        return this.dataspace.getEventTriggerDefinition(triggerName);
    }

    public void setEventTriggerDefinition(String triggerName, EventTriggerDefinition trigger) throws ServiceConfigurationException {
    }

    public void removeAllEventTriggers() throws ServiceConfigurationException, IllegalTriggerStateException {
    }

    public void compile(Session session, String triggerName) throws EventTriggerCompileException, IllegalTriggerStateException {
    }

    public List<String> listEventTriggers(Session session) {
        return this.dataspace.listEventTriggers(session);
    }

    public List<EventTriggerDefinition> getEventTriggerDefinitions(Session session) {
        return this.dataspace.getEventTriggerDefinitions(session);
    }

    public boolean hasEventTriggers(Session session) {
        return false;
    }

    public boolean existsEventTrigger(Session session, String triggerName) {
        return false;
    }

    public boolean isClosed(Session session) throws DataspaceException {
        return false;
    }

    public String getLastError(Session session, String triggerName) {
        return null;
    }

    public EventTriggerState getTriggerState(Session session, String triggerName) {
        return null;
    }

    public CollectionFactory createCollectionFactory(Session session, CollectionType type) throws DataspaceComponentException {
        return this.dataspace.createCollectionFactory(session, type);
    }

    public void storeCollectionFactory(Session session, String name, CollectionFactory factory) throws DataspaceComponentException {
        this.dataspace.storeCollectionFactory(session, name, factory);
    }

    public void dropCollectionFactory(Session session, String name) throws DataspaceComponentException {
        this.dataspace.dropCollectionFactory(session, name);
    }

    public CollectionFactory lookupCollectionFactory(Session session, String name) throws DataspaceComponentException {
        return this.dataspace.lookupCollectionFactory(session, name);
    }

    public List<String> listCollections(Session session) throws DataspaceComponentException {
        return this.dataspace.listCollections(session);
    }

    public DataCollection lookupCollection(Session session, String name) throws DataspaceComponentException {
        return this.dataspace.lookupCollection(name);
    }

    public void dropCollection(Session session, String name) throws DataspaceComponentException {
        this.dataspace.dropCollection(session, name);
    }

    public void eraseFromObjectCache(Session session, Long oid) {
        this.cache.removeAccessibleObject(oid);
    }

    public int getFetchSize(Session session) {
        return session.getFetchSize();
    }

    public void setFetchSize(Session session, int fetchSize) {
        session.setFetchSize(fetchSize);
    }

    public void setRequestTimeout(Session session, long requestTimeout) {
        session.setRequestTimeout(requestTimeout);
    }

    public SLFileSessionContext getSessionContext(Session session) {
        return session.getSLFileSessionContext();
    }

    public void setSessionContext(Session session, SLFileSessionContext sessionContext) {
        session.setSLFileSessionContext(sessionContext);
    }

    public int getTransferBufferSize(Session session) {
        return session.getTransferBufferSize();
    }

    public void setTransferBufferSize(Session session, int transferBufferSize) {
        session.setTransferBufferSize(transferBufferSize);
    }

    public void setDownloadableBlobSize(Session session, int downloadableBlobSize) throws DataspaceComponentException {
        this.downloadableBlobSize = downloadableBlobSize;
    }

    public int getDownloadableBlobSize(Session session) throws DataspaceComponentException {
        return this.downloadableBlobSize;
    }
}

