/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.lib.tar;

import com.streamscape.ds.lib.tar.RB;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class TarFileOutputStream {
    public static boolean debug = Boolean.getBoolean("DEBUG");
    protected int blocksPerRecord;
    protected long bytesWritten = 0L;
    private OutputStream writeStream;
    private File targetFile;
    private File writeFile;
    public byte[] writeBuffer;
    public static final byte[] ZERO_BLOCK = new byte[512];

    public TarFileOutputStream(File targetFile) throws IOException {
        this(targetFile, 0);
    }

    public TarFileOutputStream(File targetFile, int compressionType) throws IOException {
        this(targetFile, compressionType, 20);
    }

    public TarFileOutputStream(File targetFile, int compressionType, int blocksPerRecord) throws IOException {
        this.blocksPerRecord = blocksPerRecord;
        this.targetFile = targetFile;
        this.writeFile = new File(targetFile.getParentFile(), targetFile.getName() + "-partial");
        if (this.writeFile.exists()) {
            throw new IOException(RB.move_work_file.getString(this.writeFile.getAbsolutePath()));
        }
        if (targetFile.exists() && !targetFile.canWrite()) {
            throw new IOException(RB.cant_overwrite.getString(targetFile.getAbsolutePath()));
        }
        File parentDir = targetFile.getAbsoluteFile().getParentFile();
        if (parentDir.exists() && parentDir.isDirectory()) {
            if (!parentDir.canWrite()) {
                throw new IOException(RB.cant_write_dir.getString(parentDir.getAbsolutePath()));
            }
        } else {
            throw new IOException(RB.no_parent_dir.getString(parentDir.getAbsolutePath()));
        }
        this.writeBuffer = new byte[blocksPerRecord * 512];
        switch (compressionType) {
            case 0: {
                this.writeStream = new FileOutputStream(this.writeFile);
                break;
            }
            case 1: {
                this.writeStream = new GZIPOutputStream((OutputStream)new FileOutputStream(this.writeFile), this.writeBuffer.length);
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.compression_unknown.getString(compressionType));
            }
        }
        this.writeFile.setExecutable(false, true);
        this.writeFile.setExecutable(false, false);
        this.writeFile.setReadable(false, false);
        this.writeFile.setReadable(true, true);
        this.writeFile.setWritable(false, false);
        this.writeFile.setWritable(true, true);
    }

    public void write(byte[] byteArray, int byteCount) throws IOException {
        this.writeStream.write(byteArray, 0, byteCount);
        this.bytesWritten += (long)byteCount;
    }

    public void write(int byteCount) throws IOException {
        this.write(this.writeBuffer, byteCount);
    }

    public void writeBlock(byte[] block) throws IOException {
        if (block.length != 512) {
            throw new IllegalArgumentException(RB.bad_block_write_len.getString(block.length));
        }
        this.write(block, block.length);
    }

    public void writePadBlocks(int blockCount) throws IOException {
        for (int i = 0; i < blockCount; ++i) {
            this.write(ZERO_BLOCK, ZERO_BLOCK.length);
        }
    }

    public void writePadBlock() throws IOException {
        this.writePadBlocks(1);
    }

    public int bytesLeftInBlock() {
        int modulus = (int)(this.bytesWritten % 512L);
        if (modulus == 0) {
            return 0;
        }
        return 512 - modulus;
    }

    public void assertAtBlockBoundary() {
        if (this.bytesLeftInBlock() != 0) {
            throw new IllegalArgumentException(RB.illegal_block_boundary.getString(Long.toString(this.bytesWritten)));
        }
    }

    public void padCurrentBlock() throws IOException {
        int padBytes = this.bytesLeftInBlock();
        if (padBytes == 0) {
            return;
        }
        this.write(ZERO_BLOCK, padBytes);
        this.assertAtBlockBoundary();
    }

    public void flush() throws IOException {
        this.writeStream.flush();
    }

    public void close() throws IOException {
        if (this.writeStream == null) {
            return;
        }
        try {
            this.writeStream.close();
            if (!this.writeFile.delete()) {
                throw new IOException(RB.workfile_delete_fail.getString(this.writeFile.getAbsolutePath()));
            }
        }
        finally {
            this.writeStream = null;
        }
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public void finish() throws IOException {
        try {
            long finalBlock = this.bytesWritten / 512L + 2L;
            if (finalBlock % (long)this.blocksPerRecord != 0L) {
                finalBlock = (finalBlock / (long)this.blocksPerRecord + 1L) * (long)this.blocksPerRecord;
            }
            int finalPadBlocks = (int)(finalBlock - this.bytesWritten / 512L);
            if (debug) {
                System.out.println(RB.pad_block_write.getString(finalPadBlocks));
            }
            this.writePadBlocks(finalPadBlocks);
        }
        catch (IOException ioe) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ioe;
        }
        this.writeStream.close();
        this.writeFile.renameTo(this.targetFile);
    }

    public static interface Compression {
        public static final int NO_COMPRESSION = 0;
        public static final int GZIP_COMPRESSION = 1;
        public static final int DEFAULT_COMPRESSION = 0;
        public static final int DEFAULT_BLOCKS_PER_RECORD = 20;
    }
}

