/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.lib.tar;

import com.streamscape.ds.lib.InputStreamInterface;
import com.streamscape.ds.lib.tar.RB;
import com.streamscape.ds.lib.tar.TarGenerator;
import com.streamscape.ds.lib.tar.TarMalformatException;
import com.streamscape.ds.lib.tar.TarReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;

public class DbBackup {
    protected File dbDir;
    protected File archiveFile;
    protected String instanceName;
    protected boolean overWrite = false;
    protected boolean abortUponModify = true;
    File[] componentFiles;
    InputStreamInterface[] componentStreams;
    boolean[] existList;
    boolean[] ignoreList;

    public static void main(String[] sa) throws IOException, TarMalformatException {
        block13: {
            try {
                if (sa.length < 1) {
                    System.out.println(RB.DbBackup_syntax.getString(DbBackup.class.getName()));
                    System.out.println();
                    System.out.println(RB.listing_format.getString());
                    System.exit(0);
                }
                if (sa[0].equals("--save")) {
                    boolean overWrite = sa.length > 1 && sa[1].equals("--overwrite");
                    if (sa.length != (overWrite ? 4 : 3)) {
                        throw new IllegalArgumentException();
                    }
                    DbBackup backup = new DbBackup(new File(sa[sa.length - 2]), sa[sa.length - 1]);
                    backup.setOverWrite(overWrite);
                    backup.write();
                    break block13;
                }
                if (sa[0].equals("--list")) {
                    if (sa.length < 2) {
                        throw new IllegalArgumentException();
                    }
                    String[] patternStrings = null;
                    if (sa.length > 2) {
                        patternStrings = new String[sa.length - 2];
                        for (int i = 2; i < sa.length; ++i) {
                            patternStrings[i - 2] = sa[i];
                        }
                    }
                    new TarReader(new File(sa[1]), 0, patternStrings, new Integer(DbBackup.generateBufferBlockValue(new File(sa[1]))), null).read();
                    break block13;
                }
                if (sa[0].equals("--extract")) {
                    int firstPatInd;
                    boolean overWrite = sa.length > 1 && sa[1].equals("--overwrite");
                    int n = firstPatInd = overWrite ? 4 : 3;
                    if (sa.length < firstPatInd) {
                        throw new IllegalArgumentException();
                    }
                    String[] patternStrings = null;
                    if (sa.length > firstPatInd) {
                        patternStrings = new String[sa.length - firstPatInd];
                        for (int i = firstPatInd; i < sa.length; ++i) {
                            patternStrings[i - firstPatInd] = sa[i];
                        }
                    }
                    File tarFile = new File(sa[overWrite ? 2 : 1]);
                    int tarReaderMode = overWrite ? 2 : 1;
                    new TarReader(tarFile, tarReaderMode, patternStrings, new Integer(DbBackup.generateBufferBlockValue(tarFile)), new File(sa[firstPatInd - 1])).read();
                    break block13;
                }
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException iae) {
                System.out.println(RB.DbBackup_syntaxerr.getString(DbBackup.class.getName()));
                System.exit(2);
            }
        }
    }

    public DbBackup(File archiveFile, String dbPath) {
        this.archiveFile = archiveFile;
        File dbPathFile = new File(dbPath);
        this.dbDir = dbPathFile.getAbsoluteFile().getParentFile();
        this.instanceName = dbPathFile.getName();
        this.componentFiles = new File[]{new File(this.dbDir, this.instanceName + ".log"), new File(this.dbDir, this.instanceName + ".dat"), new File(this.dbDir, this.instanceName + ".backup"), new File(this.dbDir, this.instanceName + ".rcv"), new File(this.dbDir, this.instanceName + ".lobs")};
        this.componentStreams = new InputStreamInterface[this.componentFiles.length];
        this.existList = new boolean[this.componentFiles.length];
        this.ignoreList = new boolean[this.componentFiles.length];
    }

    public DbBackup(File archiveFile, String dbPath, boolean script) {
        this.archiveFile = archiveFile;
        File dbPathFile = new File(dbPath);
        this.dbDir = dbPathFile.getAbsoluteFile().getParentFile();
        this.instanceName = dbPathFile.getName();
        this.componentFiles = new File[]{new File(this.dbDir, this.instanceName + ".log")};
        this.componentStreams = new InputStreamInterface[this.componentFiles.length];
        this.existList = new boolean[this.componentFiles.length];
        this.ignoreList = new boolean[this.componentFiles.length];
        this.abortUponModify = false;
    }

    public void setStream(String fileExtension, InputStreamInterface is) {
        for (int i = 0; i < this.componentFiles.length; ++i) {
            if (!this.componentFiles[i].getName().endsWith(fileExtension)) continue;
            this.componentStreams[i] = is;
            break;
        }
    }

    public void setFileIgnore(String fileExtension) {
        for (int i = 0; i < this.componentFiles.length; ++i) {
            if (!this.componentFiles[i].getName().endsWith(fileExtension)) continue;
            this.ignoreList[i] = true;
            break;
        }
    }

    public void setOverWrite(boolean overWrite) {
        this.overWrite = overWrite;
    }

    public void setAbortUponModify(boolean abortUponModify) {
        this.abortUponModify = abortUponModify;
    }

    public boolean getOverWrite() {
        return this.overWrite;
    }

    public boolean getAbortUponModify() {
        return this.abortUponModify;
    }

    public void write() throws IOException, TarMalformatException {
        long startTime = new Date().getTime();
        this.checkEssentialFiles();
        TarGenerator generator = new TarGenerator(this.archiveFile, this.overWrite, new Integer(DbBackup.generateBufferBlockValue(this.componentFiles)));
        for (int i = 0; i < this.componentFiles.length; ++i) {
            boolean exists;
            boolean bl = exists = this.componentStreams[i] != null || this.componentFiles[i].exists();
            if (!exists || this.ignoreList[i]) continue;
            if (this.componentStreams[i] == null) {
                generator.queueEntry(this.componentFiles[i].getName(), this.componentFiles[i]);
                this.existList[i] = true;
                continue;
            }
            generator.queueEntry(this.componentFiles[i].getName(), this.componentStreams[i]);
        }
        generator.write();
        this.checkFilesNotChanged(startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void checkEssentialFiles() throws FileNotFoundException, IllegalStateException {
        String modifiedString;
        Properties p;
        block22: {
            if (!this.componentFiles[0].getName().endsWith(".properties")) {
                return;
            }
            for (int i = 0; i < 2; ++i) {
                boolean exists;
                boolean bl = exists = this.componentStreams[i] != null || this.componentFiles[i].exists();
                if (exists) continue;
                throw new FileNotFoundException(RB.file_missing.getString(this.componentFiles[i].getAbsolutePath()));
            }
            if (!this.abortUponModify) {
                return;
            }
            p = new Properties();
            FileInputStream fis = null;
            try {
                File propertiesFile2 = this.componentFiles[0];
                fis = new FileInputStream(propertiesFile2);
                p.load(fis);
            }
            catch (IOException propertiesFile2) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    break block22;
                }
                catch (IOException propertiesFile2) {
                    break block22;
                }
                finally {
                    fis = null;
                }
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        fis = null;
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        fis = null;
                        throw throwable;
                    }
                }
                catch (Throwable throwable2) {
                    fis = null;
                    throw throwable2;
                }
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException propertiesFile2) {
            }
            finally {
                fis = null;
            }
        }
        if ((modifiedString = p.getProperty("modified")) == null) return;
        if (!modifiedString.equalsIgnoreCase("yes")) {
            if (!modifiedString.equalsIgnoreCase("true")) return;
        }
        throw new IllegalStateException(RB.modified_property.getString(modifiedString));
    }

    void checkFilesNotChanged(long startTime) throws FileNotFoundException {
        if (!this.abortUponModify) {
            return;
        }
        try {
            for (int i = 0; i < this.componentFiles.length; ++i) {
                if (this.componentFiles[i].exists()) {
                    if (!this.existList[i]) {
                        throw new FileNotFoundException(RB.file_disappeared.getString(this.componentFiles[i].getAbsolutePath()));
                    }
                    if (this.componentFiles[i].lastModified() <= startTime) continue;
                    throw new FileNotFoundException(RB.file_changed.getString(this.componentFiles[i].getAbsolutePath()));
                }
                if (!this.existList[i]) continue;
                throw new FileNotFoundException(RB.file_appeared.getString(this.componentFiles[i].getAbsolutePath()));
            }
        }
        catch (IllegalStateException ise) {
            if (!this.archiveFile.delete()) {
                System.out.println(RB.cleanup_rmfail.getString(this.archiveFile.getAbsolutePath()));
            }
            throw ise;
        }
    }

    protected static int generateBufferBlockValue(File[] files) {
        long maxFileSize = 0L;
        for (int i = 0; i < files.length; ++i) {
            if (files[i] == null || files[i].length() <= maxFileSize) continue;
            maxFileSize = files[i].length();
        }
        int idealBlocks = (int)(maxFileSize / 5120L);
        if (idealBlocks < 1) {
            return 1;
        }
        if (idealBlocks > 40960) {
            return 40960;
        }
        return idealBlocks;
    }

    protected static int generateBufferBlockValue(File file) {
        return DbBackup.generateBufferBlockValue(new File[]{file});
    }
}

