/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.lib.store;

import com.streamscape.ds.lib.store.ValuePoolHashMap;
import com.streamscape.ds.types.TimestampData;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ValuePool {
    private static ValuePoolHashMap intPool;
    private static ValuePoolHashMap longPool;
    private static ValuePoolHashMap doublePool;
    private static ValuePoolHashMap bigdecimalPool;
    private static ValuePoolHashMap bigintegerPool;
    private static ValuePoolHashMap stringPool;
    private static ValuePoolHashMap datePool;
    private static final int SPACE_STRING_SIZE = 50;
    private static final int DEFAULT_VALUE_POOL_SIZE = 8192;
    private static final int[] defaultPoolLookupSize;
    private static final int POOLS_COUNT;
    private static final int defaultSizeFactor = 2;
    private static final int defaultMaxStringLength = 16;
    private static ValuePoolHashMap[] poolList;
    private static int maxStringLength;
    static boolean usePool;
    public static final Integer INTEGER_0;
    public static final Integer INTEGER_1;
    public static final Integer INTEGER_2;
    public static final Integer INTEGER_MAX;
    public static final BigDecimal BIG_DECIMAL_0;
    public static final BigDecimal BIG_DECIMAL_1;
    public static final String[] emptyStringArray;
    public static final Object[] emptyObjectArray;
    public static final int[] emptyIntArray;
    public static String spaceString;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initPool() {
        int[] sizeArray = defaultPoolLookupSize;
        int sizeFactor = 2;
        Class<ValuePool> clazz = ValuePool.class;
        synchronized (ValuePool.class) {
            poolList = new ValuePoolHashMap[POOLS_COUNT];
            for (int i = 0; i < POOLS_COUNT; ++i) {
                int size = sizeArray[i];
                ValuePool.poolList[i] = new ValuePoolHashMap(size, size * sizeFactor, 2);
            }
            intPool = poolList[0];
            longPool = poolList[1];
            doublePool = poolList[2];
            bigdecimalPool = poolList[3];
            bigintegerPool = poolList[4];
            stringPool = poolList[5];
            datePool = poolList[6];
            char[] c = new char[50];
            for (int i = 0; i < 50; ++i) {
                c[i] = 32;
            }
            spaceString = new String(c);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static int getMaxStringLength() {
        return maxStringLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void resetPool(int[] sizeArray, int sizeFactor) {
        if (!usePool) return;
        Class<ValuePool> clazz = ValuePool.class;
        synchronized (ValuePool.class) {
            for (int i = 0; i < POOLS_COUNT; ++i) {
                poolList[i].clear();
                poolList[i].resetCapacity(sizeArray[i] * sizeFactor, 2);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void resetPool() {
        if (!usePool) return;
        Class<ValuePool> clazz = ValuePool.class;
        synchronized (ValuePool.class) {
            ValuePool.resetPool(defaultPoolLookupSize, 2);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void clearPool() {
        if (!usePool) return;
        Class<ValuePool> clazz = ValuePool.class;
        synchronized (ValuePool.class) {
            for (int i = 0; i < POOLS_COUNT; ++i) {
                poolList[i].clear();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getInt(int val) {
        if (usePool) {
            ValuePoolHashMap valuePoolHashMap = intPool;
            synchronized (valuePoolHashMap) {
                return intPool.getOrAddInteger(val);
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getLong(long val) {
        if (usePool) {
            ValuePoolHashMap valuePoolHashMap = longPool;
            synchronized (valuePoolHashMap) {
                return longPool.getOrAddLong(val);
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Double getDouble(long val) {
        if (usePool) {
            ValuePoolHashMap valuePoolHashMap = doublePool;
            synchronized (valuePoolHashMap) {
                return doublePool.getOrAddDouble(val);
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(String val) {
        if (usePool) {
            if (val == null || val.length() > maxStringLength) {
                return val;
            }
            ValuePoolHashMap valuePoolHashMap = stringPool;
            synchronized (valuePoolHashMap) {
                return stringPool.getOrAddString(val);
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimestampData getDate(long val) {
        if (usePool) {
            ValuePoolHashMap valuePoolHashMap = datePool;
            synchronized (valuePoolHashMap) {
                return datePool.getOrAddDate(val);
            }
        }
        return new TimestampData(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal getBigDecimal(BigDecimal val) {
        if (usePool) {
            if (val == null) {
                return val;
            }
            ValuePoolHashMap valuePoolHashMap = bigdecimalPool;
            synchronized (valuePoolHashMap) {
                return (BigDecimal)bigdecimalPool.getOrAddObject(val);
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigInteger getBigInteger(BigInteger val) {
        if (usePool) {
            if (val == null) {
                return val;
            }
            ValuePoolHashMap valuePoolHashMap = bigintegerPool;
            synchronized (valuePoolHashMap) {
                return (BigInteger)bigintegerPool.getOrAddObject(val);
            }
        }
        return val;
    }

    public static Boolean getBoolean(boolean b) {
        return b ? Boolean.TRUE : Boolean.FALSE;
    }

    static {
        defaultPoolLookupSize = new int[]{8192, 8192, 8192, 8192, 8192, 8192, 8192};
        POOLS_COUNT = defaultPoolLookupSize.length;
        maxStringLength = 16;
        usePool = true;
        usePool = true;
        if (usePool) {
            ValuePool.initPool();
        }
        INTEGER_0 = ValuePool.getInt(0);
        INTEGER_1 = ValuePool.getInt(1);
        INTEGER_2 = ValuePool.getInt(2);
        INTEGER_MAX = ValuePool.getInt(Integer.MAX_VALUE);
        BIG_DECIMAL_0 = ValuePool.getBigDecimal(new BigDecimal(0.0));
        BIG_DECIMAL_1 = ValuePool.getBigDecimal(new BigDecimal(1.0));
        emptyStringArray = new String[0];
        emptyObjectArray = new Object[0];
        emptyIntArray = new int[0];
    }
}

