/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.lib;

public class StopWatch {
    private long startTime;
    private long lastStart;
    private long total;
    int running = 0;

    public StopWatch() {
        this(true);
    }

    public StopWatch(boolean start) {
        if (start) {
            this.start();
        }
    }

    public long elapsedTime() {
        if (this.running > 0) {
            return this.total + System.currentTimeMillis() - this.startTime;
        }
        return this.total;
    }

    public long currentElapsedTime() {
        if (this.running > 0) {
            return System.currentTimeMillis() - this.startTime;
        }
        return 0L;
    }

    public void zero() {
        this.total = 0L;
        this.running = 0;
        this.start();
    }

    public void start() {
        if (this.running == 0) {
            this.startTime = System.currentTimeMillis();
        }
        ++this.running;
    }

    public void stop() {
        --this.running;
        if (this.running == 0) {
            this.total += System.currentTimeMillis() - this.startTime;
        }
    }

    public void mark() {
        this.stop();
        this.start();
    }

    public String elapsedTimeToMessage(String prefix) {
        return prefix + " in " + this.elapsedTime() + " ms.";
    }

    public String currentElapsedTimeToMessage(String prefix) {
        return prefix + " in " + this.currentElapsedTime() + " ms.";
    }

    public String toString() {
        return super.toString() + "[running=" + this.running + ", startTime=" + this.startTime + ", total=" + this.total + "]";
    }
}

