/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.lib;

import com.streamscape.ds.lib.Collection;
import com.streamscape.ds.lib.HashMap;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.Set;
import com.streamscape.ds.lib.store.BaseHashMap;
import java.util.Objects;

public class MultiValueHashMap
extends BaseHashMap {
    Set keySet;
    Collection values;
    Iterator valueIterator;

    public MultiValueHashMap() {
        this(8);
    }

    public MultiValueHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 3, 3, false);
        this.multiValueTable = new boolean[this.objectValueTable.length];
    }

    public Iterator get(Object key) {
        int hash = key.hashCode();
        return super.getValuesIterator(key, hash);
    }

    public Object put(Object key, Object value) {
        return super.addOrRemoveMultiVal(0L, 0L, key, value, false, false);
    }

    public Object remove(Object key) {
        return super.addOrRemoveMultiVal(0L, 0L, key, null, true, false);
    }

    public Object remove(Object key, Object value) {
        return super.addOrRemoveMultiVal(0L, 0L, key, value, false, true);
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    public void putAll(HashMap t) {
        Iterator it = t.keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            this.put(key, t.get(key));
        }
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    public static void main(String[] args) {
        MultiValueHashMap map = new MultiValueHashMap();
        Integer i1 = 1;
        Integer i2 = 2;
        Integer i3 = 3;
        map.put(i1, i2);
        map.put(i1, i3);
        System.out.println("size: " + map.size());
        System.out.println("before values for " + i1);
        Iterator iterator = map.get(i1);
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
        System.out.println("before keys");
        iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
        map.remove(i1, i2);
        System.out.println("size: " + map.size());
        System.out.println("after values for " + i1);
        iterator = map.get(i1);
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
        System.out.println("after keys");
        iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    class KeySet
    implements Set {
        KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new BaseHashMap.MultiValueKeyIterator();
        }

        @Override
        public int size() {
            return MultiValueHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return MultiValueHashMap.this.containsKey(o);
        }

        @Override
        public Object get(Object key) {
            throw new RuntimeException();
        }

        @Override
        public boolean add(Object value) {
            throw new RuntimeException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new RuntimeException();
        }

        @Override
        public boolean remove(Object o) {
            int oldSize = this.size();
            MultiValueHashMap.this.remove(o);
            return this.size() != oldSize;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            MultiValueHashMap.this.clear();
        }
    }

    class Values
    implements Collection {
        Values() {
        }

        @Override
        public Iterator iterator() {
            MultiValueHashMap multiValueHashMap = MultiValueHashMap.this;
            Objects.requireNonNull(multiValueHashMap);
            return multiValueHashMap.new BaseHashMap.BaseHashIterator(false);
        }

        @Override
        public int size() {
            return MultiValueHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            throw new RuntimeException();
        }

        @Override
        public boolean add(Object value) {
            throw new RuntimeException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new RuntimeException();
        }

        @Override
        public boolean remove(Object o) {
            throw new RuntimeException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            MultiValueHashMap.this.clear();
        }
    }
}

