/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.lib;

import com.streamscape.ds.lib.Collection;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.Set;
import com.streamscape.ds.lib.store.BaseHashMap;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LongKeyHashMap
extends BaseHashMap {
    Set keySet;
    Collection values;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();

    public LongKeyHashMap() {
        this(16);
    }

    public LongKeyHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 2, 3, false);
    }

    public Lock getWriteLock() {
        return this.writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(long key) {
        try {
            this.readLock.lock();
            int lookup = this.getLookup(key);
            if (lookup != -1) {
                Object object = this.objectValueTable[lookup];
                return object;
            }
            Object var4_4 = null;
            return var4_4;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(long key, Object value) {
        try {
            this.writeLock.lock();
            Object object = super.addOrRemove(key, 0L, null, value, false);
            return object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        try {
            this.readLock.lock();
            boolean bl = super.containsValue(value);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(long key) {
        try {
            this.writeLock.lock();
            Object object = super.addOrRemove(key, 0L, null, null, true);
            return object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(long key) {
        try {
            this.readLock.lock();
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        try {
            this.readLock.lock();
            Object[] array = new Object[this.size()];
            int i = 0;
            BaseHashMap.BaseHashIterator it = new BaseHashMap.BaseHashIterator(false);
            while (it.hasNext()) {
                array[i++] = it.next();
            }
            Object[] objectArray = array;
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getOrderedMatchCount(int[] array) {
        int i;
        try {
            this.readLock.lock();
            for (i = 0; i < array.length; ++i) {
                if (super.containsKey(array[i])) continue;
                break;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return i;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    class KeySet
    implements Set {
        KeySet() {
        }

        @Override
        public Iterator iterator() {
            LongKeyHashMap longKeyHashMap = LongKeyHashMap.this;
            Objects.requireNonNull(longKeyHashMap);
            return longKeyHashMap.new BaseHashMap.BaseHashIterator(true);
        }

        @Override
        public int size() {
            return LongKeyHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            throw new RuntimeException();
        }

        @Override
        public Object get(Object key) {
            throw new RuntimeException();
        }

        @Override
        public boolean add(Object value) {
            throw new RuntimeException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new RuntimeException();
        }

        @Override
        public boolean remove(Object o) {
            throw new RuntimeException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            LongKeyHashMap.this.clear();
        }
    }

    class Values
    implements Collection {
        Values() {
        }

        @Override
        public Iterator iterator() {
            LongKeyHashMap longKeyHashMap = LongKeyHashMap.this;
            Objects.requireNonNull(longKeyHashMap);
            return longKeyHashMap.new BaseHashMap.BaseHashIterator(false);
        }

        @Override
        public int size() {
            return LongKeyHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            throw new RuntimeException();
        }

        @Override
        public boolean add(Object value) {
            throw new RuntimeException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new RuntimeException();
        }

        @Override
        public boolean remove(Object o) {
            throw new RuntimeException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            LongKeyHashMap.this.clear();
        }
    }
}

