/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.lib;

import com.streamscape.ds.lib.HsqlByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class LineReader {
    boolean finished = false;
    boolean wasCR = false;
    boolean wasEOL = false;
    HsqlByteArrayOutputStream baOS = new HsqlByteArrayOutputStream(1024);
    final InputStream stream;
    final Charset charset;
    final String charsetName;

    public LineReader(InputStream stream, String charsetName) {
        this.stream = stream;
        this.charsetName = charsetName;
        this.charset = Charset.forName(charsetName);
    }

    public String readLine() throws IOException {
        if (this.finished) {
            return null;
        }
        block4: while (true) {
            int c;
            if ((c = this.stream.read()) == -1) {
                this.finished = true;
                if (this.baOS.size() != 0) break;
                return null;
            }
            switch (c) {
                case 13: {
                    this.wasCR = true;
                    break block4;
                }
                case 10: {
                    if (!this.wasCR) break block4;
                    this.wasCR = false;
                    continue block4;
                }
                default: {
                    this.baOS.write(c);
                    this.wasCR = false;
                    continue block4;
                }
            }
            break;
        }
        String string = new String(this.baOS.getBuffer(), 0, this.baOS.size(), this.charsetName);
        this.baOS.reset();
        return string;
    }

    public void close() throws IOException {
        this.stream.close();
    }
}

