/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.lib;

import com.streamscape.ds.lib.Collection;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.Set;
import com.streamscape.ds.lib.store.BaseHashMap;
import java.util.NoSuchElementException;
import java.util.Objects;

public class IntValueHashMap
extends BaseHashMap {
    Set keySet;
    private Collection values;

    public IntValueHashMap() {
        this(8);
    }

    public IntValueHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 3, 1, false);
    }

    public int get(Object key) throws NoSuchElementException {
        if (key == null) {
            throw new NoSuchElementException();
        }
        int hash = key.hashCode();
        int lookup = this.getLookup(key, hash);
        if (lookup != -1) {
            return this.intValueTable[lookup];
        }
        throw new NoSuchElementException();
    }

    public int get(Object key, int defaultValue) {
        if (key == null) {
            throw new NoSuchElementException();
        }
        int hash = key.hashCode();
        int lookup = this.getLookup(key, hash);
        if (lookup != -1) {
            return this.intValueTable[lookup];
        }
        return defaultValue;
    }

    public boolean get(Object key, int[] value) {
        if (key == null) {
            throw new NoSuchElementException();
        }
        int hash = key.hashCode();
        int lookup = this.getLookup(key, hash);
        if (lookup != -1) {
            value[0] = this.intValueTable[lookup];
            return true;
        }
        return false;
    }

    public Object getKey(int value) {
        BaseHashMap.BaseHashIterator it = new BaseHashMap.BaseHashIterator(false);
        while (it.hasNext()) {
            int i = it.nextInt();
            if (i != value) continue;
            return this.objectKeyTable[it.getLookup()];
        }
        return null;
    }

    public boolean put(Object key, int value) {
        if (key == null) {
            throw new NoSuchElementException();
        }
        int oldSize = this.size();
        super.addOrRemove(0L, value, key, null, false);
        return oldSize != this.size();
    }

    public boolean remove(Object key) {
        int oldSize = this.size();
        super.addOrRemove(0L, 0L, key, null, true);
        return oldSize != this.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    public boolean containsValue(int value) {
        throw new RuntimeException();
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    public void putAll(IntValueHashMap t) {
        Iterator it = t.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            this.put(key, t.get(key));
        }
    }

    class KeySet
    implements Set {
        KeySet() {
        }

        @Override
        public Iterator iterator() {
            IntValueHashMap intValueHashMap = IntValueHashMap.this;
            Objects.requireNonNull(intValueHashMap);
            return intValueHashMap.new BaseHashMap.BaseHashIterator(true);
        }

        @Override
        public int size() {
            return IntValueHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return IntValueHashMap.this.containsKey(o);
        }

        @Override
        public Object get(Object key) {
            int lookup = IntValueHashMap.this.getLookup(key, key.hashCode());
            if (lookup < 0) {
                return null;
            }
            return IntValueHashMap.this.objectKeyTable[lookup];
        }

        @Override
        public boolean add(Object value) {
            throw new RuntimeException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new RuntimeException();
        }

        @Override
        public boolean remove(Object o) {
            int oldSize = this.size();
            IntValueHashMap.this.remove(o);
            return this.size() != oldSize;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            IntValueHashMap.this.clear();
        }
    }

    class Values
    implements Collection {
        Values() {
        }

        @Override
        public Iterator iterator() {
            IntValueHashMap intValueHashMap = IntValueHashMap.this;
            Objects.requireNonNull(intValueHashMap);
            return intValueHashMap.new BaseHashMap.BaseHashIterator(false);
        }

        @Override
        public int size() {
            return IntValueHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            throw new RuntimeException();
        }

        @Override
        public boolean add(Object value) {
            throw new RuntimeException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new RuntimeException();
        }

        @Override
        public boolean remove(Object o) {
            throw new RuntimeException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            IntValueHashMap.this.clear();
        }
    }
}

