/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.lib;

import com.streamscape.ds.lib.HsqlByteArrayInputStream;
import com.streamscape.ds.lib.HsqlByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;

public class InOutUtil {
    public static final int DEFAULT_COPY_BUFFER_SIZE = 8192;
    public static final long DEFAULT_COPY_AMOUNT = Long.MAX_VALUE;

    public static int readLine(InputStream in, OutputStream out) throws IOException {
        int b;
        int count = 0;
        while ((b = in.read()) != -1) {
            ++count;
            out.write(b);
            if (b != 10) continue;
            break;
        }
        return count;
    }

    public static byte[] serialize(Serializable s) throws IOException {
        HsqlByteArrayOutputStream bo = new HsqlByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(bo);
        os.writeObject(s);
        return bo.toByteArray();
    }

    public static Serializable deserialize(byte[] ba) throws IOException, ClassNotFoundException {
        HsqlByteArrayInputStream bi = new HsqlByteArrayInputStream(ba);
        ObjectInputStream is = new ObjectInputStream(bi);
        return (Serializable)is.readObject();
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return InOutUtil.copy(inputStream, outputStream, Long.MAX_VALUE, 8192);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, long amount) throws IOException {
        return InOutUtil.copy(inputStream, outputStream, amount, 8192);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, long amount, int bufferSize) throws IOException {
        int bytesRead;
        int maxBytesToRead = (int)Math.min((long)bufferSize, amount);
        byte[] buffer = new byte[maxBytesToRead];
        long bytesCopied = 0L;
        while (bytesCopied < amount && -1 != (bytesRead = inputStream.read(buffer, 0, maxBytesToRead))) {
            outputStream.write(buffer, 0, bytesRead);
            bytesCopied = (long)bytesRead > Long.MAX_VALUE - bytesCopied ? Long.MAX_VALUE : (bytesCopied += (long)bytesRead);
            if (bytesCopied >= amount) {
                return bytesCopied;
            }
            maxBytesToRead = (int)Math.min((long)bufferSize, amount - bytesCopied);
        }
        return bytesCopied;
    }

    public static long copy(Reader reader, Writer writer) throws IOException {
        return InOutUtil.copy(reader, writer, Long.MAX_VALUE, 8192);
    }

    public static long copy(Reader reader, Writer writer, long amount) throws IOException {
        return InOutUtil.copy(reader, writer, amount, 8192);
    }

    public static long copy(Reader reader, Writer writer, long amount, int bufferSize) throws IOException {
        int charsRead;
        int maxCharsToRead = (int)Math.min((long)bufferSize, amount);
        char[] buffer = new char[maxCharsToRead];
        long charsCopied = 0L;
        while (charsCopied < amount && -1 != (charsRead = reader.read(buffer, 0, maxCharsToRead))) {
            writer.write(buffer, 0, charsRead);
            charsCopied = (long)charsRead > Long.MAX_VALUE - charsCopied ? Long.MAX_VALUE : (charsCopied += (long)charsRead);
            if (charsCopied >= amount) {
                return charsCopied;
            }
            maxCharsToRead = (int)Math.min((long)bufferSize, amount - charsCopied);
        }
        return charsCopied;
    }
}

