/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.lib;

import com.streamscape.ds.lib.BaseList;
import com.streamscape.ds.lib.HsqlList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;

public class HsqlDeque
extends BaseList
implements HsqlList {
    private Object[] list = new Object[10];
    private int firstindex = 0;
    private int endindex = 0;
    private static final int DEFAULT_INITIAL_CAPACITY = 10;

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Object getFirst() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.firstindex];
    }

    public Object getLast() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.endindex - 1];
    }

    @Override
    public Object get(int i) throws IndexOutOfBoundsException {
        int index = this.getInternalIndex(i);
        return this.list[index];
    }

    @Override
    public void add(int i, Object o) throws IndexOutOfBoundsException {
        if (i == this.elementCount) {
            this.add(o);
            return;
        }
        this.resetCapacity();
        int index = this.getInternalIndex(i);
        if (index < this.endindex && this.endindex < this.list.length) {
            System.arraycopy(this.list, index, this.list, index + 1, this.endindex - index);
            ++this.endindex;
        } else {
            System.arraycopy(this.list, this.firstindex, this.list, this.firstindex - 1, index - this.firstindex);
            --this.firstindex;
        }
        this.list[index] = o;
        ++this.elementCount;
    }

    @Override
    public Object set(int i, Object o) throws IndexOutOfBoundsException {
        int index = this.getInternalIndex(i);
        Object result = this.list[index];
        this.list[index] = o;
        return result;
    }

    public Object removeFirst() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        Object o = this.list[this.firstindex];
        this.list[this.firstindex] = null;
        ++this.firstindex;
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.firstindex == this.list.length) {
            this.firstindex = 0;
        }
        return o;
    }

    public Object removeLast() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        --this.endindex;
        Object o = this.list[this.endindex];
        this.list[this.endindex] = null;
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.endindex == 0) {
            this.endindex = this.list.length;
        }
        return o;
    }

    @Override
    public boolean add(Object o) {
        this.resetCapacity();
        if (this.endindex == this.list.length) {
            this.endindex = 0;
        }
        this.list[this.endindex] = o;
        ++this.elementCount;
        ++this.endindex;
        return true;
    }

    public boolean addLast(Object o) {
        return this.add(o);
    }

    public boolean addFirst(Object o) {
        this.resetCapacity();
        --this.firstindex;
        if (this.firstindex < 0) {
            this.firstindex = this.list.length - 1;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        this.list[this.firstindex] = o;
        ++this.elementCount;
        return true;
    }

    @Override
    public void clear() {
        if (this.elementCount == 0) {
            return;
        }
        this.elementCount = 0;
        this.endindex = 0;
        this.firstindex = 0;
        for (int i = 0; i < this.list.length; ++i) {
            this.list[i] = null;
        }
    }

    @Override
    public int indexOf(Object value) {
        for (int i = 0; i < this.elementCount; ++i) {
            int index = this.firstindex + i;
            if (index >= this.list.length) {
                index -= this.list.length;
            }
            if (this.list[index] == value) {
                return i;
            }
            if (value == null || !value.equals(this.list[index])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object remove(int index) {
        int target = this.getInternalIndex(index);
        Object value = this.list[target];
        if (target == this.firstindex) {
            this.list[this.firstindex] = null;
            ++this.firstindex;
            if (this.firstindex == this.list.length) {
                this.firstindex = 0;
            }
        } else if (target > this.firstindex) {
            System.arraycopy(this.list, this.firstindex, this.list, this.firstindex + 1, target - this.firstindex);
            this.list[this.firstindex] = null;
            ++this.firstindex;
            if (this.firstindex == this.list.length) {
                this.firstindex = 0;
            }
        } else {
            System.arraycopy(this.list, target + 1, this.list, target, this.endindex - target - 1);
            --this.endindex;
            this.list[this.endindex] = null;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        }
        return value;
    }

    private int getInternalIndex(int i) throws IndexOutOfBoundsException {
        if (i < 0 || i >= this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        int index = this.firstindex + i;
        if (index >= this.list.length) {
            index -= this.list.length;
        }
        return index;
    }

    private void resetCapacity() {
        if (this.elementCount < this.list.length) {
            return;
        }
        Object[] newList = new Object[this.list.length * 2];
        System.arraycopy(this.list, this.firstindex, newList, this.firstindex, this.list.length - this.firstindex);
        if (this.endindex <= this.firstindex) {
            System.arraycopy(this.list, 0, newList, this.list.length, this.endindex);
            this.endindex = this.list.length + this.endindex;
        }
        this.list = newList;
    }

    public void toArray(Object[] array) {
        int tempCount = this.list.length - this.firstindex;
        if (tempCount > this.elementCount) {
            tempCount = this.elementCount;
        }
        System.arraycopy(this.list, this.firstindex, array, 0, tempCount);
        if (this.endindex <= this.firstindex) {
            System.arraycopy(this.list, 0, array, tempCount, this.endindex);
            this.endindex = this.list.length + this.endindex;
        }
    }

    public List<Object> toList() {
        Object[] a = new Object[this.size()];
        this.toArray(a);
        return Arrays.asList(a);
    }
}

