/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.lib;

import com.streamscape.ds.lib.Collection;
import com.streamscape.ds.lib.Iterator;
import com.streamscape.ds.lib.Set;
import com.streamscape.ds.lib.store.BaseHashMap;

public class HashSet
extends BaseHashMap
implements Set {
    public HashSet() {
        this(8);
    }

    public HashSet(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 3, 0, false);
    }

    @Override
    public boolean contains(Object key) {
        return super.containsKey(key);
    }

    public boolean containsAll(Collection col) {
        Iterator it = col.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object get(Object key) {
        int lookup = this.getLookup(key, key.hashCode());
        if (lookup < 0) {
            return null;
        }
        return this.objectKeyTable[lookup];
    }

    @Override
    public boolean add(Object key) {
        int oldSize = this.size();
        super.addOrRemove(0L, 0L, key, null, false);
        return oldSize != this.size();
    }

    @Override
    public boolean addAll(Collection c) {
        boolean changed = false;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            changed |= this.add(it.next());
        }
        return changed;
    }

    public boolean addAll(Object[] keys) {
        boolean changed = false;
        for (int i = 0; i < keys.length; ++i) {
            changed |= this.add(keys[i]);
        }
        return changed;
    }

    public boolean addAll(Object[] keys, int start, int limit) {
        boolean changed = false;
        for (int i = start; i < keys.length && i < limit; ++i) {
            changed |= this.add(keys[i]);
        }
        return changed;
    }

    @Override
    public boolean remove(Object key) {
        int oldSize = this.size();
        return super.removeObject(key, false) != null;
    }

    public boolean removeAll(Collection c) {
        Iterator it = c.iterator();
        boolean result = true;
        while (it.hasNext()) {
            result &= this.remove(it.next());
        }
        return result;
    }

    public boolean removeAll(Object[] keys) {
        boolean result = true;
        for (int i = 0; i < keys.length; ++i) {
            result &= this.remove(keys[i]);
        }
        return result;
    }

    public Object[] toArray(Object[] a) {
        if (a == null || a.length < this.size()) {
            a = new Object[this.size()];
        }
        Iterator it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            a[i] = it.next();
            ++i;
        }
        return a;
    }

    @Override
    public Iterator iterator() {
        return new BaseHashMap.BaseHashIterator(true);
    }

    public String toString() {
        Iterator it = this.iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(", ");
            } else {
                sb.append('[');
            }
            sb.append(it.next());
        }
        return sb.toString() + "]";
    }
}

