/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.lib;

import com.streamscape.ds.lib.FileAccess;
import com.streamscape.ds.lib.HsqlArrayList;
import com.streamscape.ds.lib.StringUtil;
import com.streamscape.ds.lib.java.JavaSystem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Random;
import org.apache.tika.Tika;

public class FileUtil
implements FileAccess {
    private static FileUtil fileUtil = new FileUtil();
    private static FileAccessRes fileAccessRes = new FileAccessRes();
    public final boolean fsIsIgnoreCase = new File("A").equals(new File("a"));
    public final boolean fsNormalizesPosixSeparator = new File("/").getPath().endsWith(File.separator);
    final Random random = new Random(System.currentTimeMillis());

    FileUtil() {
    }

    public static FileUtil getFileUtil() {
        return fileUtil;
    }

    public static FileAccess getFileAccess(boolean isResource) {
        return isResource ? fileAccessRes : fileUtil;
    }

    @Override
    public boolean isStreamElement(String elementName) {
        return new File(elementName).exists();
    }

    @Override
    public InputStream openInputStreamElement(String streamName) throws IOException {
        try {
            return new FileInputStream(new File(streamName));
        }
        catch (Throwable e) {
            throw JavaSystem.toIOException(e);
        }
    }

    @Override
    public void createParentDirs(String filename) {
        this.makeParentDirectories(new File(filename));
    }

    @Override
    public void removeElement(String filename) {
        if (this.isStreamElement(filename)) {
            this.delete(filename);
        }
    }

    @Override
    public void renameElement(String oldName, String newName) {
        this.renameWithOverwrite(oldName, newName);
    }

    @Override
    public OutputStream openOutputStreamElement(String streamName) throws IOException {
        return new FileOutputStream(new File(streamName));
    }

    @Override
    public OutputStream openOutputStreamElement(String streamName, boolean append) throws IOException {
        return new FileOutputStream(new File(streamName), append);
    }

    public boolean delete(String filename) {
        return new File(filename).delete();
    }

    public void deleteOnExit(File f) {
        JavaSystem.deleteOnExit(f);
    }

    public boolean exists(String filename) {
        return new File(filename).exists();
    }

    public boolean exists(String fileName, boolean resource, Class cla) {
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        return resource ? null != cla.getResource(fileName) : FileUtil.getFileUtil().exists(fileName);
    }

    private boolean renameWithOverwrite(String oldname, String newname) {
        File file = new File(oldname);
        this.delete(newname);
        boolean renamed = file.renameTo(new File(newname));
        if (renamed) {
            return true;
        }
        System.gc();
        this.delete(newname);
        if (this.exists(newname)) {
            new File(newname).renameTo(new File(FileUtil.newDiscardFileName(newname)));
        }
        return file.renameTo(new File(newname));
    }

    public String absolutePath(String path) {
        return new File(path).getAbsolutePath();
    }

    public File canonicalFile(File f) throws IOException {
        return new File(f.getCanonicalPath());
    }

    public File canonicalFile(String path) throws IOException {
        return new File(new File(path).getCanonicalPath());
    }

    public String canonicalPath(File f) throws IOException {
        return f.getCanonicalPath();
    }

    public String canonicalPath(String path) throws IOException {
        return new File(path).getCanonicalPath();
    }

    public String canonicalOrAbsolutePath(String path) {
        try {
            return this.canonicalPath(path);
        }
        catch (Exception e) {
            return this.absolutePath(path);
        }
    }

    public void makeParentDirectories(File f) {
        String parent = f.getParent();
        if (parent != null) {
            new File(parent).mkdirs();
        } else {
            parent = f.getPath();
            int index = parent.lastIndexOf(47);
            if (index > 0) {
                parent = parent.substring(0, index);
                new File(parent).mkdirs();
            }
        }
    }

    public static String makeDirectories(String path) {
        try {
            File file = new File(path);
            file.mkdirs();
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public FileAccess.FileSync getFileSync(OutputStream os) throws IOException {
        return new FileSync((FileOutputStream)os);
    }

    public static boolean deleteOrRenameDatabaseFiles(String path) {
        int i;
        DatabaseFilenameFilter filter = new DatabaseFilenameFilter(path);
        File[] fileList = filter.getExistingFileListInDirectory();
        for (int i2 = 0; i2 < fileList.length; ++i2) {
            fileList[i2].delete();
        }
        File tempDir = new File(filter.canonicalFile.getPath() + ".tmp");
        if (tempDir.isDirectory()) {
            File[] tempList = tempDir.listFiles();
            for (int i3 = 0; i3 < tempList.length; ++i3) {
                tempList[i3].delete();
            }
            tempDir.delete();
        }
        if ((fileList = filter.getExistingMainFileSetList()).length == 0) {
            return true;
        }
        System.gc();
        for (i = 0; i < fileList.length; ++i) {
            fileList[i].delete();
        }
        fileList = filter.getExistingMainFileSetList();
        for (i = 0; i < fileList.length; ++i) {
            fileList[i].renameTo(new File(FileUtil.newDiscardFileName(fileList[i].getPath())));
        }
        return true;
    }

    public static File[] getDatabaseFileList(String path) {
        DatabaseFilenameFilter filter = new DatabaseFilenameFilter(path);
        return filter.getExistingFileListInDirectory();
    }

    public static String newDiscardFileName(String filename) {
        String timestamp = StringUtil.toPaddedString(Integer.toHexString((int)System.currentTimeMillis()), 8, '0', true);
        String discardName = filename + "." + timestamp + ".v";
        return discardName;
    }

    public static String detectMimeType(String fileName) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]));){
            String string = new Tika().detect((InputStream)bis);
            return string;
        }
    }

    public static String detectMimeType(byte[] bts) throws IOException {
        return new Tika().detect(bts);
    }

    public static boolean endsWithFileSeparator(String path) {
        return path.endsWith(File.separator) || path.endsWith("/");
    }

    public static class FileAccessRes
    implements FileAccess {
        @Override
        public boolean isStreamElement(String fileName) {
            URL url = null;
            try {
                ClassLoader cl;
                url = this.getClass().getResource(fileName);
                if (url == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
                    url = cl.getResource(fileName);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return url != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputStream openInputStreamElement(String fileName) throws IOException {
            InputStream fis = null;
            try {
                ClassLoader cl;
                fis = this.getClass().getResourceAsStream(fileName);
                if (fis == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
                    fis = cl.getResourceAsStream(fileName);
                }
            }
            catch (Throwable throwable) {
                if (fis == null) {
                    throw new FileNotFoundException(fileName);
                }
            }
            finally {
                if (fis == null) {
                    throw new FileNotFoundException(fileName);
                }
            }
            return fis;
        }

        @Override
        public void createParentDirs(String filename) {
        }

        @Override
        public void removeElement(String filename) {
        }

        @Override
        public void renameElement(String oldName, String newName) {
        }

        @Override
        public OutputStream openOutputStreamElement(String streamName) throws IOException {
            throw new IOException();
        }

        @Override
        public OutputStream openOutputStreamElement(String streamName, boolean append) throws IOException {
            throw new IOException();
        }

        @Override
        public FileAccess.FileSync getFileSync(OutputStream os) throws IOException {
            throw new IOException();
        }
    }

    public static class FileSync
    implements FileAccess.FileSync {
        FileDescriptor outDescriptor;

        FileSync(FileOutputStream os) throws IOException {
            this.outDescriptor = os.getFD();
        }

        @Override
        public void sync() throws IOException {
            this.outDescriptor.sync();
        }
    }

    static class DatabaseFilenameFilter
    implements FilenameFilter {
        String[] suffixes = new String[]{".backup", ".log", ".data", ".rcv", ".lck", ".lobs", ".sql.log", ".app.log"};
        private String dbName;
        private File parent;
        private File canonicalFile;

        DatabaseFilenameFilter(String dbName) {
            this.dbName = dbName;
            this.canonicalFile = new File(dbName);
            try {
                this.canonicalFile = this.canonicalFile.getCanonicalFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.parent = this.canonicalFile.getParentFile();
        }

        public File[] getCompleteMainFileSetList() {
            File[] fileList = new File[this.suffixes.length];
            for (int i = 0; i < this.suffixes.length; ++i) {
                fileList[i] = new File(this.canonicalFile.getPath() + this.suffixes[i]);
            }
            return fileList;
        }

        public File[] getExistingMainFileSetList() {
            File[] fileList = this.getCompleteMainFileSetList();
            HsqlArrayList list = new HsqlArrayList();
            for (int i = 0; i < fileList.length; ++i) {
                if (!fileList[i].exists()) continue;
                list.add(fileList[i]);
            }
            fileList = new File[list.size()];
            list.toArray(fileList);
            return fileList;
        }

        public File[] getExistingFileListInDirectory() {
            File[] list = this.parent.listFiles(this);
            return list == null ? new File[]{} : list;
        }

        @Override
        public boolean accept(File dir, String name) {
            if (this.parent.equals(dir) && name.indexOf(this.dbName) == 0) {
                String suffix = name.substring(this.dbName.length());
                for (int i = 0; i < this.suffixes.length; ++i) {
                    if (suffix.equals(this.suffixes[i])) {
                        return true;
                    }
                    if (!suffix.startsWith(this.suffixes[i])) continue;
                    if (suffix.length() == this.suffixes[i].length()) {
                        return true;
                    }
                    if (!(name.endsWith(".new") ? suffix.length() == this.suffixes[i].length() + 4 : name.endsWith(".old") && suffix.length() == this.suffixes[i].length() + 9 + 4)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

