/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.lib;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.lib.ArrayUtil;
import com.streamscape.ds.session.Session;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class DataspaceDateTime {
    public static final Locale defaultLocale = Locale.UK;
    public static final Calendar tempCalGMT = new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale);
    public static final String sqlDatePattern = "yyyy-MM-dd";
    public static final String sqlTimePattern = "HH:mm:ss";
    public static final String javaDatePattern = "yyyy-MM-dd HH:mm:ss";
    public static final String sqlTimestampSysPattern = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String serializerMillisFormat = "millis";
    public static final String serializerJavaDateISOFormat = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String serializerSqlTimestampISOFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    static final SimpleDateFormat sqlDateSimpleFormatGMT = new SimpleDateFormat("yyyy-MM-dd");
    static final SimpleDateFormat sqlTimeSimpleFormatGMT = new SimpleDateFormat("HH:mm:ss");
    static final SimpleDateFormat javaDateSimpleFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    static final SimpleDateFormat sqlDateSimpleFormat = new SimpleDateFormat("yyyy-MM-dd");
    static final SimpleDateFormat sqlTimeSimpleFormat = new SimpleDateFormat("HH:mm:ss");
    static final SimpleDateFormat sqlTimestampSysSimpleFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    static final SimpleDateFormat sqlTimestampSysSimpleFormatGMT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static TimeZone timezone;
    private static Calendar calendar;
    private static final char[][] dateTokens;
    private static final String[] javaDateTokens;
    private static final int[] sqlIntervalCodes;
    private static final char e = '\uffff';
    static Pattern validateFormatMMPattern;

    public static synchronized Calendar getCalendar() {
        if (calendar == null) {
            if (timezone == null) {
                timezone = TimeZone.getDefault();
            }
            calendar = new GregorianCalendar(timezone);
        }
        return calendar;
    }

    public static synchronized TimeZone getTimezone() {
        if (timezone == null) {
            timezone = TimeZone.getDefault();
        }
        return timezone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setTimezone(TimeZone timezone) {
        if (timezone == null) {
            DataspaceDateTime.timezone = null;
        } else {
            if (DataspaceDateTime.timezone != null) {
                throw new RuntimeException("DataspaceDateTime.timezone already set.");
            }
            DataspaceDateTime.timezone = timezone;
            calendar = null;
            SimpleDateFormat simpleDateFormat = sqlTimestampSysSimpleFormat;
            synchronized (simpleDateFormat) {
                sqlTimestampSysSimpleFormat.setTimeZone(timezone);
            }
            simpleDateFormat = sqlDateSimpleFormat;
            synchronized (simpleDateFormat) {
                sqlDateSimpleFormat.setTimeZone(timezone);
            }
            simpleDateFormat = sqlTimeSimpleFormat;
            synchronized (simpleDateFormat) {
                TimeZone timezone1 = TimeZone.getTimeZone("GMT");
                timezone1.setRawOffset(timezone.getOffset(0L));
                sqlTimeSimpleFormat.setTimeZone(timezone1);
            }
            simpleDateFormat = javaDateSimpleFormat;
            synchronized (simpleDateFormat) {
                javaDateSimpleFormat.setTimeZone(timezone);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getSqlDateMilliseconds(String s) {
        try {
            SimpleDateFormat simpleDateFormat = sqlDateSimpleFormatGMT;
            synchronized (simpleDateFormat) {
                return sqlDateSimpleFormatGMT.parse(s).getTime();
            }
        }
        catch (Exception e) {
            throw Error.error(3407);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSqlDateStringGMT(long milliseconds) {
        SimpleDateFormat simpleDateFormat = sqlDateSimpleFormatGMT;
        synchronized (simpleDateFormat) {
            return sqlDateSimpleFormatGMT.format(new Date(milliseconds));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSqlTimeStringGMT(long milliseconds) {
        SimpleDateFormat simpleDateFormat = sqlTimeSimpleFormatGMT;
        synchronized (simpleDateFormat) {
            return sqlTimeSimpleFormatGMT.format(new Time(milliseconds));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getSqlTimestampMillisecondsGMT(String s) {
        try {
            SimpleDateFormat simpleDateFormat = sqlTimestampSysSimpleFormatGMT;
            synchronized (simpleDateFormat) {
                return sqlTimestampSysSimpleFormatGMT.parse(s).getTime();
            }
        }
        catch (Exception e) {
            throw Error.error(3407);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getSqlTimestampStringGMT(StringBuffer sb, long milliseconds, int nanos, int scale) {
        SimpleDateFormat simpleDateFormat = sqlTimestampSysSimpleFormatGMT;
        synchronized (simpleDateFormat) {
            sb.append(sqlTimestampSysSimpleFormatGMT.format(new Date(milliseconds)));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getSqlTimestampMilliseconds(String s, String timezone) {
        SimpleDateFormat simpleDateFormat = sqlTimestampSysSimpleFormat;
        synchronized (simpleDateFormat) {
            TimeZone oldTimeZone = sqlTimestampSysSimpleFormat.getTimeZone();
            try {
                if (timezone != null) {
                    sqlTimestampSysSimpleFormat.setTimeZone(TimeZone.getTimeZone(timezone));
                }
                long l = sqlTimestampSysSimpleFormat.parse(s).getTime();
                return l;
            }
            catch (Exception e) {
                throw Error.error(3407);
            }
            finally {
                sqlTimestampSysSimpleFormat.setTimeZone(oldTimeZone);
            }
        }
    }

    public static String getSqlTimestampString(Timestamp timestamp) {
        return DataspaceDateTime.getSqlTimestampString(timestamp, null);
    }

    public static String getSqlTimestampString(Timestamp timestamp, TimeZone timezone) {
        return DataspaceDateTime.getSqlTimestampString(timestamp.getTime(), timezone);
    }

    public static String getSqlTimestampString(long timestamp, TimeZone timezone) {
        return DataspaceDateTime.getSqlTimestampString(timestamp, timezone != null ? timezone.getOffset(timestamp) : -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSqlTimestampString(long timestamp, int timezoneOffset) {
        SimpleDateFormat simpleDateFormat = sqlTimestampSysSimpleFormat;
        synchronized (simpleDateFormat) {
            String string;
            TimeZone timezoneTemp = sqlTimestampSysSimpleFormat.getTimeZone();
            try {
                if (timezoneOffset != -1) {
                    TimeZone timezone = TimeZone.getTimeZone("GMT");
                    timezone.setRawOffset(timezoneOffset);
                    sqlTimestampSysSimpleFormat.setTimeZone(timezone);
                }
                string = sqlTimestampSysSimpleFormat.format(timestamp);
            }
            catch (Throwable throwable) {
                sqlTimestampSysSimpleFormat.setTimeZone(timezoneTemp);
                throw throwable;
            }
            sqlTimestampSysSimpleFormat.setTimeZone(timezoneTemp);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSystemTimestampString() {
        SimpleDateFormat simpleDateFormat = sqlTimestampSysSimpleFormat;
        synchronized (simpleDateFormat) {
            return DataspaceDateTime.getSqlTimestampString(System.currentTimeMillis(), -1);
        }
    }

    public static String getSqlTimeString(long time, TimeZone timezone) {
        return DataspaceDateTime.getSqlTimeString(time, timezone != null ? timezone.getOffset(0L) : -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSqlTimeString(long time, int timezoneOffset) {
        SimpleDateFormat simpleDateFormat = sqlTimeSimpleFormat;
        synchronized (simpleDateFormat) {
            String string;
            TimeZone timezoneTemp = sqlTimeSimpleFormat.getTimeZone();
            try {
                if (timezoneOffset != -1) {
                    TimeZone timezone = TimeZone.getTimeZone("GMT");
                    timezone.setRawOffset(timezoneOffset);
                    sqlTimeSimpleFormat.setTimeZone(timezone);
                }
                string = sqlTimeSimpleFormat.format(time);
            }
            catch (Throwable throwable) {
                sqlTimeSimpleFormat.setTimeZone(timezoneTemp);
                throw throwable;
            }
            sqlTimeSimpleFormat.setTimeZone(timezoneTemp);
            return string;
        }
    }

    public static String getSqlDateString(long time, TimeZone timezone) {
        return DataspaceDateTime.getSqlDateString(time, timezone != null ? timezone.getOffset(time) : -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSqlDateString(long time, int timezoneOffset) {
        SimpleDateFormat simpleDateFormat = sqlDateSimpleFormat;
        synchronized (simpleDateFormat) {
            String string;
            TimeZone timezoneTemp = sqlDateSimpleFormat.getTimeZone();
            try {
                if (timezoneOffset != -1) {
                    TimeZone timezone = TimeZone.getTimeZone("GMT");
                    timezone.setRawOffset(timezoneOffset);
                    sqlDateSimpleFormat.setTimeZone(timezone);
                }
                string = sqlDateSimpleFormat.format(time);
            }
            catch (Throwable throwable) {
                sqlDateSimpleFormat.setTimeZone(timezoneTemp);
                throw throwable;
            }
            sqlDateSimpleFormat.setTimeZone(timezoneTemp);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getJavaDateMilliseconds(String date, String timezone) throws ParseException {
        SimpleDateFormat simpleDateFormat = javaDateSimpleFormat;
        synchronized (simpleDateFormat) {
            long l;
            TimeZone oldTimeZone = javaDateSimpleFormat.getTimeZone();
            try {
                if (timezone != null) {
                    javaDateSimpleFormat.setTimeZone(TimeZone.getTimeZone(timezone));
                }
                l = javaDateSimpleFormat.parse(date).getTime();
            }
            catch (Throwable throwable) {
                javaDateSimpleFormat.setTimeZone(oldTimeZone);
                throw throwable;
            }
            javaDateSimpleFormat.setTimeZone(oldTimeZone);
            return l;
        }
    }

    public static String getJavaDateTimeString(Date date) {
        return DataspaceDateTime.getJavaDateTimeString(date, null);
    }

    public static String getJavaDateTimeString(Date date, TimeZone timezone) {
        return DataspaceDateTime.getJavaDateTimeString(date, timezone != null ? (long)timezone.getOffset(date.getTime()) : -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJavaDateTimeString(Date date, long timezoneOffset) {
        SimpleDateFormat simpleDateFormat = javaDateSimpleFormat;
        synchronized (simpleDateFormat) {
            String string;
            TimeZone timezoneTemp = javaDateSimpleFormat.getTimeZone();
            try {
                if (timezoneOffset != -1L) {
                    TimeZone timezone = TimeZone.getTimeZone("GMT");
                    timezone.setRawOffset((int)timezoneOffset);
                    javaDateSimpleFormat.setTimeZone(timezone);
                }
                string = javaDateSimpleFormat.format(date);
            }
            catch (Throwable throwable) {
                javaDateSimpleFormat.setTimeZone(timezoneTemp);
                throw throwable;
            }
            javaDateSimpleFormat.setTimeZone(timezoneTemp);
            return string;
        }
    }

    public static void resetToDate(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    public static void resetToTime(Calendar cal) {
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(14, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertMillisToCalendar(Calendar calendar, long millis) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.clear();
            Calendar calendar3 = tempCalGMT;
            synchronized (calendar3) {
                tempCalGMT.setTimeInMillis(millis);
                calendar.set(tempCalGMT.get(1), tempCalGMT.get(2), tempCalGMT.get(5), tempCalGMT.get(11), tempCalGMT.get(12), tempCalGMT.get(13));
                calendar.set(14, tempCalGMT.get(14));
                return calendar.getTimeInMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertMillisFromCalendar(Calendar calendar, long millis) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            Calendar calendar3 = tempCalGMT;
            synchronized (calendar3) {
                tempCalGMT.clear();
                calendar.setTimeInMillis(millis);
                tempCalGMT.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
                tempCalGMT.set(14, calendar.get(14));
                return tempCalGMT.getTimeInMillis();
            }
        }
    }

    public static void setTimeInMillis(Calendar cal, long millis) {
        cal.setTimeInMillis(millis);
    }

    public static long getTimeInMillis(Calendar cal) {
        return cal.getTimeInMillis();
    }

    public static long convertToNormalisedTime(long t) {
        return DataspaceDateTime.convertToNormalisedTime(t, tempCalGMT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertToNormalisedTime(long t, Calendar cal) {
        Calendar calendar = cal;
        synchronized (calendar) {
            DataspaceDateTime.setTimeInMillis(cal, t);
            DataspaceDateTime.resetToTime(cal);
            return DataspaceDateTime.getTimeInMillis(cal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertToNormalisedDate(long t, Calendar cal) {
        Calendar calendar = cal;
        synchronized (calendar) {
            DataspaceDateTime.setTimeInMillis(cal, t);
            DataspaceDateTime.resetToDate(cal);
            return DataspaceDateTime.getTimeInMillis(cal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedTime(long t) {
        Calendar cal;
        Calendar calendar = cal = tempCalGMT;
        synchronized (calendar) {
            DataspaceDateTime.setTimeInMillis(cal, t);
            DataspaceDateTime.resetToTime(cal);
            return DataspaceDateTime.getTimeInMillis(cal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedTime(Calendar cal, long t) {
        Calendar calendar = cal;
        synchronized (calendar) {
            DataspaceDateTime.setTimeInMillis(cal, t);
            DataspaceDateTime.resetToTime(cal);
            return DataspaceDateTime.getTimeInMillis(cal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedDate(long d) {
        Calendar calendar = tempCalGMT;
        synchronized (calendar) {
            DataspaceDateTime.setTimeInMillis(tempCalGMT, d);
            DataspaceDateTime.resetToDate(tempCalGMT);
            return DataspaceDateTime.getTimeInMillis(tempCalGMT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedDate(Calendar cal, long d) {
        Calendar calendar = cal;
        synchronized (calendar) {
            DataspaceDateTime.setTimeInMillis(cal, d);
            DataspaceDateTime.resetToDate(cal);
            return DataspaceDateTime.getTimeInMillis(cal);
        }
    }

    public static int getZoneMillis(Calendar cal, long millis) {
        return cal.getTimeZone().getOffset(millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDateTimePart(long m, int part) {
        Calendar calendar = tempCalGMT;
        synchronized (calendar) {
            tempCalGMT.setTimeInMillis(m);
            return tempCalGMT.get(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTruncatedPart(long m, int part) {
        Calendar calendar = tempCalGMT;
        synchronized (calendar) {
            tempCalGMT.setTimeInMillis(m);
            switch (part) {
                case 262: {
                    int year = tempCalGMT.get(1);
                    int week = tempCalGMT.get(3);
                    tempCalGMT.clear();
                    tempCalGMT.set(1, year);
                    tempCalGMT.set(3, week);
                    break;
                }
                default: {
                    DataspaceDateTime.zeroFromPart(tempCalGMT, part);
                }
            }
            return tempCalGMT.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getRoundedPart(long m, int part) {
        Calendar calendar = tempCalGMT;
        synchronized (calendar) {
            tempCalGMT.setTimeInMillis(m);
            switch (part) {
                case 101: {
                    if (tempCalGMT.get(2) <= 6) break;
                    tempCalGMT.add(1, 1);
                    break;
                }
                case 102: {
                    if (tempCalGMT.get(5) <= 15) break;
                    tempCalGMT.add(2, 1);
                    break;
                }
                case 103: {
                    if (tempCalGMT.get(11) <= 11) break;
                    tempCalGMT.add(5, 1);
                    break;
                }
                case 104: {
                    if (tempCalGMT.get(12) <= 29) break;
                    tempCalGMT.add(11, 1);
                    break;
                }
                case 105: {
                    if (tempCalGMT.get(13) <= 29) break;
                    tempCalGMT.add(12, 1);
                    break;
                }
                case 106: {
                    if (tempCalGMT.get(14) <= 499) break;
                    tempCalGMT.add(13, 1);
                    break;
                }
                case 262: {
                    int year = tempCalGMT.get(1);
                    int week = tempCalGMT.get(3);
                    int day = tempCalGMT.get(7);
                    if (day > 3) {
                        ++week;
                    }
                    tempCalGMT.clear();
                    tempCalGMT.set(1, year);
                    tempCalGMT.set(3, week);
                    return tempCalGMT.getTimeInMillis();
                }
            }
            DataspaceDateTime.zeroFromPart(tempCalGMT, part);
            return tempCalGMT.getTimeInMillis();
        }
    }

    static void zeroFromPart(Calendar cal, int part) {
        switch (part) {
            case 101: {
                cal.set(2, 0);
            }
            case 102: {
                cal.set(5, 1);
            }
            case 103: {
                cal.set(11, 0);
            }
            case 104: {
                cal.set(12, 0);
            }
            case 105: {
                cal.set(13, 0);
            }
            case 106: {
                cal.set(14, 0);
            }
        }
    }

    public static Date toDate(String string, String pattern, SimpleDateFormat format) {
        Date date;
        String javaPattern = DataspaceDateTime.toJavaDatePattern(pattern);
        int matchIndex = javaPattern.indexOf("*IY");
        if (matchIndex >= 0) {
            throw Error.error(3472);
        }
        matchIndex = javaPattern.indexOf("*WW");
        if (matchIndex >= 0) {
            throw Error.error(3472);
        }
        matchIndex = javaPattern.indexOf("*W");
        if (matchIndex >= 0) {
            throw Error.error(3472);
        }
        try {
            format.applyPattern(javaPattern);
            date = format.parse(string);
        }
        catch (Exception e) {
            throw Error.error(3407, e.toString());
        }
        return date;
    }

    public static String toFormattedDate(Date date, String pattern, SimpleDateFormat format) {
        int matchLength;
        Calendar cal;
        String javaPattern = DataspaceDateTime.toJavaDatePattern(pattern);
        try {
            format.applyPattern(javaPattern);
        }
        catch (Exception e) {
            throw Error.error(3472);
        }
        String result = format.format(date);
        int matchIndex = result.indexOf("*IY");
        if (matchIndex >= 0) {
            cal = format.getCalendar();
            matchLength = 3;
            int temp = result.indexOf("*IYYY");
            if (temp >= 0) {
                matchLength = 5;
                matchIndex = temp;
            }
            int year = cal.get(1);
            int weekOfYear = cal.get(3);
            if (weekOfYear == 1 && cal.get(6) > 360) {
                ++year;
            }
            String yearString = String.valueOf(year);
            if (matchLength == 3) {
                yearString = yearString.substring(yearString.length() - 2);
            }
            StringBuilder sb = new StringBuilder(result);
            sb.replace(matchIndex, matchIndex + matchLength, yearString);
            result = sb.toString();
        }
        if ((matchIndex = result.indexOf("*WW")) >= 0) {
            cal = format.getCalendar();
            matchLength = 3;
            int dayOfYear = cal.get(6);
            int weekOfYear = (dayOfYear - 1) / 7 + 1;
            StringBuilder sb = new StringBuilder(result);
            sb.replace(matchIndex, matchIndex + matchLength, String.valueOf(weekOfYear));
            result = sb.toString();
        }
        if ((matchIndex = result.indexOf("*W")) >= 0) {
            cal = format.getCalendar();
            matchLength = 2;
            int dayOfMonth = cal.get(5);
            int weekOfMonth = (dayOfMonth - 1) / 7 + 1;
            StringBuilder sb = new StringBuilder(result);
            sb.replace(matchIndex, matchIndex + matchLength, String.valueOf(weekOfMonth));
            result = sb.toString();
        }
        return result;
    }

    public static String toJavaDatePattern(String format) {
        if (validateFormatMMPattern.matcher(format).matches()) {
            throw new DataspaceException("Invalid mask MM (month) specified after HH (hours) in SQL Datetime format " + format);
        }
        int len = format.length();
        StringBuffer sb = new StringBuffer(len);
        Tokenizer tokenizer = new Tokenizer();
        for (int i = 0; i <= len; ++i) {
            char ch;
            char c = ch = i == len ? (char)'\uffff' : (char)format.charAt(i);
            if (tokenizer.isInQuotes()) {
                if (tokenizer.isQuoteChar(ch)) {
                    ch = '\'';
                } else if (ch == '\'') {
                    sb.append(ch);
                }
                sb.append(ch);
                continue;
            }
            if (tokenizer.next(ch, i)) continue;
            if (tokenizer.consumed) {
                int index = tokenizer.getLastMatch();
                sb.append(javaDateTokens[index]);
                i = tokenizer.matchOffset;
            } else if (tokenizer.isQuoteChar(ch)) {
                ch = '\'';
                sb.append(ch);
            } else if (tokenizer.isLiteral(ch)) {
                sb.append(ch);
            } else if (ch != '\uffff') {
                throw Error.error(3407, format.substring(i));
            }
            tokenizer.reset();
        }
        if (tokenizer.isInQuotes()) {
            throw Error.error(3407);
        }
        return sb.toString();
    }

    public static int toStandardIntervalPart(String format) {
        int len = format.length();
        Tokenizer tokenizer = new Tokenizer();
        for (int i = 0; i <= len; ++i) {
            char ch;
            char c = ch = i == len ? (char)'\uffff' : (char)format.charAt(i);
            if (tokenizer.next(ch, i)) continue;
            int index = tokenizer.getLastMatch();
            if (index >= 0) {
                return sqlIntervalCodes[index];
            }
            return -1;
        }
        return -1;
    }

    public static Object formatTimeZoneOffset(String timezone) {
        return DataspaceDateTime.formatTimeZoneOffset(TimeZone.getTimeZone(timezone));
    }

    public static Object formatTimeZoneOffset(TimeZone timezone) {
        return DataspaceDateTime.formatTimeZoneOffset(timezone.getOffset(System.currentTimeMillis()) / 1000);
    }

    public static Object formatTimeZoneOffset(int offsetSecondsTotal) {
        Object offset = offsetSecondsTotal >= 0 ? "+" : "-";
        offsetSecondsTotal = Math.abs(offsetSecondsTotal);
        int offsetHours = offsetSecondsTotal / 60 / 60;
        int offsetMinutes = (offsetSecondsTotal - offsetHours * 60 * 60) / 60;
        int offsetSeconds = offsetSecondsTotal - offsetHours * 60 * 60 - offsetMinutes * 60;
        offset = (String)offset + String.format("%02d", offsetHours);
        offset = (String)offset + ":" + String.format("%02d", offsetMinutes);
        if (offsetSeconds > 0) {
            offset = (String)offset + ":" + String.format("%02d", offsetSeconds);
        }
        return offset;
    }

    public static String formatTimestamp(Session session, long time) {
        return DataspaceDateTime.getSqlTimestampString(time, session.getTimeZone());
    }

    public static String formatTimestampForResultSet(Session session, long time) {
        return time == 0L ? "n/a" : DataspaceDateTime.getSqlTimestampString(time, session != null ? session.getTimeZone() : null);
    }

    public static String trimMills(String timestamp) {
        if (timestamp != null && timestamp.length() > 4 && timestamp.charAt(timestamp.length() - 4) == '.') {
            timestamp = timestamp.substring(0, timestamp.length() - 4);
        }
        return timestamp;
    }

    static {
        tempCalGMT.setLenient(false);
        sqlDateSimpleFormatGMT.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
        sqlDateSimpleFormatGMT.setLenient(false);
        sqlTimeSimpleFormatGMT.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
        sqlTimeSimpleFormatGMT.setLenient(false);
        sqlTimestampSysSimpleFormatGMT.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
        javaDateSimpleFormat.setCalendar(new GregorianCalendar(TimeZone.getDefault(), defaultLocale));
        sqlDateSimpleFormat.setCalendar(new GregorianCalendar(TimeZone.getDefault(), defaultLocale));
        sqlTimeSimpleFormat.setCalendar(new GregorianCalendar(TimeZone.getDefault(), defaultLocale));
        sqlTimestampSysSimpleFormat.setCalendar(new GregorianCalendar(TimeZone.getDefault(), defaultLocale));
        dateTokens = new char[][]{{'R', 'R', 'R', 'R'}, {'I', 'Y', 'Y', 'Y'}, {'Y', 'Y', 'Y', 'Y'}, {'I', 'Y'}, {'Y', 'Y'}, {'B', 'C'}, {'B', '.', 'C', '.'}, {'A', 'D'}, {'A', '.', 'D', '.'}, {'M', 'O', 'N'}, {'M', 'O', 'N', 'T', 'H'}, {'M', 'M'}, {'D', 'A', 'Y'}, {'D', 'Y'}, {'W', 'W'}, {'I', 'W'}, {'D', 'D'}, {'D', 'D', 'D'}, {'W'}, {'H', 'H', '2', '4'}, {'H', 'H', '1', '2'}, {'H', 'H'}, {'M', 'I'}, {'S', 'S'}, {'A', 'M'}, {'P', 'M'}, {'A', '.', 'M', '.'}, {'P', '.', 'M', '.'}, {'F', 'F'}};
        javaDateTokens = new String[]{"yyyy", "'*IYYY'", "yyyy", "'*IY'", "yy", "G", "G", "G", "G", "MMM", "MMMMM", "MM", "EEEE", "EE", "'*WW'", "w", "dd", "D", "'*W'", "HH", "KK", "hh", "mm", "ss", "aaa", "aaa", "aaa", "aaa", "S"};
        sqlIntervalCodes = new int[]{-1, -1, 101, -1, 101, -1, -1, -1, -1, 102, 102, 102, 103, 103, 262, -1, 103, 103, 262, 104, -1, 104, 105, 106, -1, -1, -1, -1, -1};
        validateFormatMMPattern = Pattern.compile(".*HH\\d{0,2}[:\\-\\s\\.,|_]*MM.*$");
    }

    static class Tokenizer {
        private int lastMatched;
        private int matchOffset;
        private int offset;
        private long state;
        private boolean consumed;
        private boolean isInQuotes;
        private boolean matched;
        private final char quoteChar = (char)34;
        private final char[] literalChars = defaultLiterals;
        private static char[] defaultLiterals = new char[]{' ', ',', '-', '.', '/', ':', ';'};
        char[][] tokens = dateTokens;

        public Tokenizer() {
            this.reset();
        }

        public void reset() {
            this.lastMatched = -1;
            this.offset = -1;
            this.state = 0L;
            this.consumed = false;
            this.matched = false;
        }

        public int length() {
            return this.offset;
        }

        public int getLastMatch() {
            return this.lastMatched;
        }

        public boolean isConsumed() {
            return this.consumed;
        }

        public boolean wasMatched() {
            return this.matched;
        }

        public boolean isInQuotes() {
            return this.isInQuotes;
        }

        public boolean isQuoteChar(char ch) {
            if (this.quoteChar == ch) {
                this.isInQuotes = !this.isInQuotes;
                return true;
            }
            return false;
        }

        public boolean isLiteral(char ch) {
            return ArrayUtil.isInSortedArray(ch, this.literalChars);
        }

        private boolean isZeroBit(int bit) {
            return (this.state & 1L << bit) == 0L;
        }

        private void setBit(int bit) {
            this.state |= 1L << bit;
        }

        public boolean next(char ch, int position) {
            int index = ++this.offset;
            int len = this.offset + 1;
            int left = 0;
            this.matched = false;
            int i = this.tokens.length;
            while (--i >= 0) {
                if (!this.isZeroBit(i)) continue;
                if (this.tokens[i][index] == ch) {
                    if (this.tokens[i].length == len) {
                        this.setBit(i);
                        this.lastMatched = i;
                        this.consumed = true;
                        this.matched = true;
                        this.matchOffset = position;
                        continue;
                    }
                    ++left;
                    continue;
                }
                this.setBit(i);
            }
            return left > 0;
        }
    }
}

