/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.lib;

import com.streamscape.Trace;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class CountUpDownLatch {
    volatile CountDownLatch latch = new CountDownLatch(0);
    volatile int count;

    public void await() throws InterruptedException {
        this.latch.await();
    }

    public boolean await(long timeout) throws InterruptedException {
        return this.latch.await(timeout, TimeUnit.MILLISECONDS);
    }

    public synchronized void countDown() {
        if (this.count == 0) {
            Trace.logError(this, "An attempt to reset unlocked session latch was made.");
        } else {
            --this.count;
            if (this.count == 0) {
                this.latch.countDown();
            }
        }
    }

    public synchronized int getCount() {
        return this.count;
    }

    public synchronized void countUp() {
        this.countUp(1);
    }

    public synchronized void countUp(int count) {
        if (this.latch.getCount() == 0L) {
            this.latch = new CountDownLatch(1);
        }
        this.count += count;
    }

    public synchronized void setCount(int count) {
        if (count == 0) {
            if (this.latch.getCount() != 0L) {
                this.latch.countDown();
            }
        } else if (this.latch.getCount() == 0L) {
            this.latch = new CountDownLatch(1);
        }
        this.count = count;
    }
}

