/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.lib;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public class CharArrayWriter {
    protected char[] buffer;
    protected int count;

    public CharArrayWriter(int size) {
        this.buffer = new char[size];
    }

    public CharArrayWriter(char[] buffer) {
        this.buffer = buffer;
    }

    public CharArrayWriter(Reader reader, int length) throws IOException {
        this.buffer = new char[length];
        int left = length;
        while (left > 0) {
            int read = reader.read(this.buffer, this.count, left);
            if (read == -1) {
                if (left <= 0) break;
                reader.close();
                throw new EOFException();
            }
            left -= read;
            this.count += read;
        }
    }

    public CharArrayWriter(Reader reader) throws IOException {
        int read;
        this.buffer = new char[128];
        while ((read = reader.read(this.buffer, this.count, this.buffer.length - this.count)) != -1) {
            this.count += read;
            if (this.count != this.buffer.length) continue;
            this.ensureRoom(this.count * 2);
        }
    }

    public void write(int c) {
        if (this.count == this.buffer.length) {
            this.ensureRoom(this.count + 1);
        }
        this.buffer[this.count++] = (char)c;
    }

    public int write(Reader reader, int length) throws IOException {
        int read;
        int left = length;
        while (left > 0 && (read = reader.read(this.buffer, this.count, left)) != -1) {
            left -= read;
            this.count += read;
        }
        return length - left;
    }

    void ensureRoom(int size) {
        int newSize;
        if (size <= this.buffer.length) {
            return;
        }
        for (newSize = this.buffer.length; newSize < size; newSize *= 2) {
        }
        char[] newBuffer = new char[newSize];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.count);
        this.buffer = newBuffer;
    }

    public void write(String str, int off, int len) {
        this.ensureRoom(this.count + len);
        str.getChars(off, off + len, this.buffer, this.count);
        this.count += len;
    }

    public void reset() {
        this.count = 0;
    }

    public void reset(char[] buffer) {
        this.count = 0;
        this.buffer = buffer;
    }

    public char[] toCharArray() {
        char[] newBuffer = new char[this.count];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.count);
        return newBuffer;
    }

    public char[] getBuffer() {
        return this.buffer;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buffer, 0, this.count);
    }
}

