/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.lib;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class BasicTextJdkLogFormatter
extends Formatter {
    protected boolean withTime = true;
    public static String LS = System.getProperty("line.separator");
    protected SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public BasicTextJdkLogFormatter(boolean withTime) {
        this.withTime = withTime;
    }

    public BasicTextJdkLogFormatter() {
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        if (this.withTime) {
            sb.append(this.sdf.format(new Date(record.getMillis())) + "  ");
        }
        sb.append(String.valueOf(record.getLevel()) + "  " + this.formatMessage(record));
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            record.getThrown().printStackTrace(new PrintWriter(sw));
            sb.append(LS + String.valueOf(sw));
        }
        return sb.toString() + LS;
    }
}

