/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.jdbc.pool;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.jdbc.JDBCConnection;
import com.streamscape.ds.jdbc.pool.JDBCXADataSource;
import com.streamscape.ds.session.SessionInterface;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class JDBCXAResource
implements XAResource {
    private JDBCConnection connection;
    private boolean originalAutoCommitMode;
    static int XA_STATE_INITIAL = 0;
    static int XA_STATE_STARTED = 1;
    static int XA_STATE_ENDED = 2;
    static int XA_STATE_PREPARED = 3;
    static int XA_STATE_DISPOSED = 4;
    int state = XA_STATE_INITIAL;
    private JDBCXADataSource xaDataSource;
    Xid xid = null;

    public boolean withinGlobalTransaction() {
        return this.state == XA_STATE_STARTED;
    }

    private void validateXid(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException("Null Xid");
        }
        if (this.xid == null) {
            throw new XAException("There is no live transaction for this XAResource");
        }
        if (!xid.equals(this.xid)) {
            throw new XAException("Given Xid is not that associated with this XAResource object");
        }
    }

    public JDBCXAResource(JDBCXADataSource xaDataSource, JDBCConnection connection) {
        this.connection = connection;
        this.xaDataSource = xaDataSource;
    }

    JDBCXADataSource getXADataSource() {
        return this.xaDataSource;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        JDBCXAResource resource = this.xaDataSource.getResource(xid);
        if (resource == null) {
            throw new XAException("The XADataSource has no such Xid:  " + String.valueOf(xid));
        }
        resource.commitThis(onePhase);
    }

    public void commitThis(boolean onePhase) throws XAException {
        if (onePhase && this.state == XA_STATE_PREPARED) {
            throw new XAException("Transaction is in a 2-phase state when 1-phase is requested");
        }
        if (!onePhase && this.state != XA_STATE_PREPARED) {
            throw new XAException("Attempt to do a 2-phase commit when transaction is not prepared");
        }
        try {
            this.connection.commit();
        }
        catch (SQLException se) {
            throw new XAException(se.toString());
        }
        this.dispose();
    }

    private void dispose() {
        this.state = XA_STATE_DISPOSED;
        this.xaDataSource.removeResource(this.xid);
        this.xid = null;
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        this.validateXid(xid);
        if (this.state != XA_STATE_STARTED) {
            throw new XAException("Invalid XAResource state");
        }
        if (flags == 0x4000000) {
            // empty if block
        }
        this.state = XA_STATE_ENDED;
        try {
            this.connection.setAutoCommit(this.originalAutoCommitMode);
        }
        catch (SQLException se) {
            throw new XAException(se.toString());
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.validateXid(xid);
        if (this.state != XA_STATE_PREPARED) {
            throw new XAException("Attempted to forget a XAResource that is not in a heuristically completed state");
        }
        this.dispose();
        this.state = XA_STATE_INITIAL;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        throw new XAException("Transaction timeouts not implemented yet");
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        if (!(xares instanceof JDBCXAResource)) {
            return false;
        }
        return this.xaDataSource == ((JDBCXAResource)xares).getXADataSource();
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        JDBCXAResource resource = this.xaDataSource.getResource(xid);
        if (resource == null) {
            throw new XAException("The XADataSource has no such Xid:  " + String.valueOf(xid));
        }
        return resource.prepareThis();
    }

    public int prepareThis() throws XAException {
        if (this.state != XA_STATE_ENDED) {
            throw new XAException("Invalid XAResource state");
        }
        try {
            ((SessionInterface)((Object)this.connection)).prepareCommit();
        }
        catch (DataspaceException e) {
            this.state = XA_STATE_PREPARED;
            throw new XAException(e.getMessage());
        }
        this.state = XA_STATE_PREPARED;
        return 0;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.xaDataSource.getPreparedXids();
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        JDBCXAResource resource = this.xaDataSource.getResource(xid);
        if (resource == null) {
            throw new XAException("The XADataSource has no such Xid in prepared state:  " + String.valueOf(xid));
        }
        resource.rollbackThis();
    }

    public void rollbackThis() throws XAException {
        if (this.state != XA_STATE_PREPARED) {
            throw new XAException("Invalid XAResource state");
        }
        try {
            this.connection.rollback();
        }
        catch (SQLException se) {
            throw new XAException(se.toString());
        }
        this.dispose();
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        throw new XAException("Transaction timeouts not implemented yet");
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (this.state != XA_STATE_INITIAL && this.state != XA_STATE_DISPOSED) {
            throw new XAException("Invalid XAResource state");
        }
        if (this.xaDataSource == null) {
            throw new XAException("JDBCXAResource has not been associated with a XADataSource");
        }
        if (xid == null) {
            throw new XAException("Null Xid");
        }
        try {
            this.originalAutoCommitMode = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
        }
        catch (SQLException se) {
            throw new XAException(se.toString());
        }
        this.xid = xid;
        this.state = XA_STATE_STARTED;
        this.xaDataSource.addResource(this.xid, this);
    }

    JDBCConnection getConnection() {
        return this.connection;
    }

    void setConnection(JDBCConnection userConnection) {
        this.connection = userConnection;
    }
}

