/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.jdbc.pool;

import com.streamscape.ds.jdbc.JDBCConnection;
import com.streamscape.ds.jdbc.pool.JDBCPooledConnection;
import com.streamscape.ds.jdbc.pool.JDBCXAConnectionWrapper;
import com.streamscape.ds.jdbc.pool.JDBCXADataSource;
import com.streamscape.ds.jdbc.pool.JDBCXAResource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class JDBCXAConnection
extends JDBCPooledConnection
implements XAConnection {
    JDBCXAResource xaResource;

    public JDBCXAConnection(JDBCXADataSource dataSource, JDBCConnection connection) {
        super(connection);
        this.xaResource = new JDBCXAResource(dataSource, connection);
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        return this.xaResource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isInUse) {
            throw new SQLException("Connection in use");
        }
        this.isInUse = true;
        return new JDBCXAConnectionWrapper(this.xaResource, this.connection);
    }

    @Override
    public void close() throws SQLException {
        super.close();
    }
}

