/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.jdbc.pool;

import com.streamscape.ds.jdbc.JDBCCommonDataSource;
import com.streamscape.ds.jdbc.JDBCConnection;
import com.streamscape.ds.jdbc.JDBCDriver;
import com.streamscape.ds.jdbc.pool.JDBCPooledConnection;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class JDBCPooledDataSource
extends JDBCCommonDataSource
implements ConnectionPoolDataSource,
Serializable,
Referenceable,
CommonDataSource {
    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        JDBCConnection connection = (JDBCConnection)JDBCDriver.getConnection(this.url, this.connectionProps);
        return new JDBCPooledConnection(connection);
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        Properties props = new Properties();
        props.setProperty("user", user);
        props.setProperty("password", password);
        JDBCConnection connection = (JDBCConnection)JDBCDriver.getConnection(this.url, props);
        return new JDBCPooledConnection(connection);
    }

    @Override
    public Reference getReference() throws NamingException {
        String cname = "org.streamscape.ds.jdbc.JDBCDataSourceFactory";
        Reference ref = new Reference(this.getClass().getName(), cname, null);
        ref.add(new StringRefAddr("database", this.getDatabase()));
        ref.add(new StringRefAddr("user", this.getUser()));
        ref.add(new StringRefAddr("password", this.password));
        ref.add(new StringRefAddr("loginTimeout", Integer.toString(this.loginTimeout)));
        return ref;
    }
}

