/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.jdbc;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.result.Result;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLWarning;

public class Util {
    static final void throwError(DataspaceException e) throws SQLException {
        throw Util.sqlException(e.getMessage(), e.getSQLState(), e.getErrorCode(), e);
    }

    static final void throwError(Result r) throws SQLException {
        throw Util.sqlException(r.getMainString(), r.getSubString(), r.getErrorCode(), r.getException());
    }

    public static final SQLException sqlException(DataspaceException e) {
        return Util.sqlException(e.getMessage(), e.getSQLState(), e.getErrorCode(), e);
    }

    public static final SQLException sqlException(DataspaceException e, Throwable cause) {
        return Util.sqlException(e.getMessage(), e.getSQLState(), e.getErrorCode(), cause);
    }

    public static final SQLException sqlException(int id) {
        return Util.sqlException(Error.error(id));
    }

    public static final SQLException sqlExceptionSQL(int id) {
        return Util.sqlException(Error.error(id));
    }

    public static final SQLException sqlException(int id, String message) {
        return Util.sqlException(Error.error(id, message));
    }

    public static final SQLException sqlException(int id, String message, Throwable cause) {
        return Util.sqlException(Error.error(id, message), cause);
    }

    public static final SQLException sqlException(int id, int add) {
        return Util.sqlException(Error.error(id, add));
    }

    static final SQLException sqlException(int id, int subId, Object[] add) {
        return Util.sqlException(Error.error(null, id, subId, add));
    }

    static final SQLException notSupported() {
        DataspaceException e = Error.error(1500);
        return new SQLFeatureNotSupportedException(e.getMessage(), e.getSQLState(), -1500);
    }

    static SQLException notUpdatableColumn() {
        return Util.sqlException(2500);
    }

    public static SQLException nullArgument() {
        return Util.sqlException(423);
    }

    static SQLException nullArgument(String name) {
        return Util.sqlException(423, name + ": null");
    }

    public static SQLException invalidArgument() {
        return Util.sqlException(423);
    }

    public static SQLException invalidArgument(String name) {
        return Util.sqlException(423, name);
    }

    public static SQLException outOfRangeArgument() {
        return Util.sqlException(423);
    }

    public static SQLException outOfRangeArgument(String name) {
        return Util.sqlException(423, name);
    }

    public static SQLException connectionClosedException() {
        return Util.sqlException(1303);
    }

    public static SQLWarning sqlWarning(Result r) {
        return new SQLWarning(r.getMainString(), r.getSubString(), r.getErrorCode());
    }

    public static SQLException sqlException(Throwable t) {
        return new SQLNonTransientConnectionException(t);
    }

    public static SQLException sqlException(Result r) {
        return Util.sqlException(r.getMainString(), r.getSubString(), r.getErrorCode(), r.getException());
    }

    public static final SQLException sqlException(String msg, String sqlstate, int code, Throwable cause) {
        if (sqlstate.startsWith("08")) {
            if (!sqlstate.endsWith("3")) {
                return new SQLTransientConnectionException(msg, sqlstate, code, cause);
            }
            return new SQLNonTransientConnectionException(msg, sqlstate, code, cause);
        }
        if (sqlstate.startsWith("22")) {
            return new SQLDataException(msg, sqlstate, code, cause);
        }
        if (sqlstate.startsWith("23")) {
            return new SQLIntegrityConstraintViolationException(msg, sqlstate, code, cause);
        }
        if (sqlstate.startsWith("28")) {
            return new SQLInvalidAuthorizationSpecException(msg, sqlstate, code, cause);
        }
        if (sqlstate.startsWith("42") || sqlstate.startsWith("37") || sqlstate.startsWith("2A")) {
            return new SQLSyntaxErrorException(msg, sqlstate, code, cause);
        }
        if (sqlstate.startsWith("40")) {
            return new SQLTransactionRollbackException(msg, sqlstate, code, cause);
        }
        if (sqlstate.startsWith("0A")) {
            return new SQLFeatureNotSupportedException(msg, sqlstate, code, cause);
        }
        return new SQLException(msg, sqlstate, code, cause);
    }
}

