/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.jdbc;

import com.streamscape.ds.jdbc.JDBCConnection;
import com.streamscape.ds.jdbc.Util;
import java.sql.SQLException;
import java.sql.Savepoint;

public class JDBCSavepoint
implements Savepoint {
    int id;
    String name;
    JDBCConnection connection;

    public JDBCSavepoint(String name, JDBCConnection conn) throws SQLException {
        if (name == null) {
            throw Util.nullArgument("name");
        }
        if (conn == null) {
            throw Util.nullArgument("conn");
        }
        this.name = name;
        this.id = -1;
        this.connection = conn;
    }

    JDBCSavepoint(JDBCConnection conn) throws SQLException {
        if (conn == null) {
            throw Util.nullArgument("conn");
        }
        this.id = conn.getSavepointID();
        this.name = "SYSTEM_SAVEPOINT_" + this.id;
        this.connection = conn;
    }

    @Override
    public int getSavepointId() throws SQLException {
        if (this.id != -1) {
            return this.id;
        }
        throw Util.notSupported();
    }

    @Override
    public String getSavepointName() throws SQLException {
        if (this.id == -1) {
            return this.name;
        }
        throw Util.notSupported();
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + "]";
    }
}

