/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.jdbc;

import com.streamscape.ds.jdbc.Util;
import com.streamscape.ds.lib.StringConverter;
import java.io.IOException;
import java.sql.RowId;
import java.sql.SQLException;
import java.util.Arrays;

public final class JDBCRowId
implements RowId {
    private int hash;
    private final byte[] id;

    public JDBCRowId(byte[] id) throws SQLException {
        if (id == null) {
            throw Util.nullArgument("id");
        }
        this.id = id;
    }

    public JDBCRowId(RowId id) throws SQLException {
        this(id.getBytes());
    }

    public JDBCRowId(String hex) throws SQLException {
        if (hex == null) {
            throw Util.nullArgument("hex");
        }
        try {
            this.id = StringConverter.hexStringToByteArray(hex);
        }
        catch (IOException e) {
            throw Util.sqlException(423, "hex: " + String.valueOf(e));
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof JDBCRowId && Arrays.equals(this.id, ((JDBCRowId)obj).id);
    }

    @Override
    public byte[] getBytes() {
        return (byte[])this.id.clone();
    }

    @Override
    public String toString() {
        return StringConverter.byteArrayToHexString(this.id);
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Arrays.hashCode(this.id);
        }
        return this.hash;
    }

    Object id() {
        return this.id;
    }
}

