/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.jdbc;

import com.streamscape.ds.NameManager;
import com.streamscape.ds.jdbc.JDBCColumnMetaData;
import com.streamscape.ds.jdbc.JDBCConnection;
import com.streamscape.ds.jdbc.Util;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.column.ColumnBase;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.types.CharacterType;
import com.streamscape.ds.types.DateTimeType;
import com.streamscape.ds.types.IntervalType;
import com.streamscape.ds.types.Type;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class JDBCResultSetMetaData
implements ResultSetMetaData {
    private ResultMetaData resultMetaData;
    private boolean useColumnName;
    private boolean translateTTIType;
    private int columnCount;

    @Override
    public int getColumnCount() throws SQLException {
        return this.resultMetaData.getColumnCount();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.checkColumn(column);
        return this.resultMetaData.columns[--column].isIdentity();
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        this.checkColumn(column);
        Type type = this.translateType(this.resultMetaData.columnTypes[--column]);
        if (type.isCharacterType()) {
            return !((CharacterType)type).isCaseInsensitive();
        }
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        this.checkColumn(column);
        return this.resultMetaData.columns != null ? this.resultMetaData.columns[--column].isSearchable() : false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        this.checkColumn(column);
        Type type = this.translateType(this.resultMetaData.columnTypes[--column]);
        return (type.typeCode == 3 || type.typeCode == 2) && type.scale > 0;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.checkColumn(column);
        return this.resultMetaData.columns != null ? (int)this.resultMetaData.columns[--column].getNullability() : 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        this.checkColumn(column);
        Type type = this.translateType(this.resultMetaData.columnTypes[--column]);
        return type.isNumberType();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        this.checkColumn(column);
        Type type = this.translateType(this.resultMetaData.columnTypes[--column]);
        return type.displaySize();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        this.checkColumn(column--);
        String label = null;
        if (this.resultMetaData.columnLabels != null) {
            label = this.resultMetaData.columnLabels[column];
        }
        if ((label == null || label.length() == 0) && this.resultMetaData.columns != null) {
            label = this.resultMetaData.columns[column].getNameString();
        }
        return label;
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        String label;
        this.checkColumn(column--);
        if (this.useColumnName) {
            String name = null;
            if (this.resultMetaData.columns != null) {
                name = this.resultMetaData.columns[column].getNameString();
            }
            if (name != null && name.length() > 0) {
                return name;
            }
        }
        return (label = this.resultMetaData.columnLabels[column]) == null && this.resultMetaData.columns != null ? this.resultMetaData.columns[column].getNameString() : label;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        NameManager.ObjectName columnObjectName;
        this.checkColumn(column);
        String name = null;
        ColumnBase columnBase = this.resultMetaData.columns[--column];
        if (columnBase instanceof ColumnSchema && (columnObjectName = ((ColumnSchema)columnBase).getObjectName()) != null && columnObjectName.parent != null && columnObjectName.parent.schema != null) {
            name = columnObjectName.parent.schema.getNameString();
        }
        if (name == null) {
            name = this.resultMetaData.columns[column].getSchemaNameString();
        }
        return name == null ? "" : name;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        this.checkColumn(column);
        Type type = this.translateType(this.resultMetaData.columnTypes[--column]);
        return type.getJDBCPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        this.checkColumn(column);
        Type type = this.translateType(this.resultMetaData.columnTypes[--column]);
        return type.getJDBCScale();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this.checkColumn(column);
        String name = this.resultMetaData.columns[--column].getTableNameString();
        return name == null ? "" : name;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.checkColumn(column);
        String name = this.resultMetaData.columns[--column].getCatalogNameString();
        return name == null ? "" : name;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        this.checkColumn(column);
        Type type = this.translateType(this.resultMetaData.columnTypes[--column]);
        return type.getJDBCTypeCode();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        this.checkColumn(column);
        Type type = this.translateType(this.resultMetaData.columnTypes[--column]);
        return type.getNameString();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.checkColumn(column);
        return !this.resultMetaData.columns[--column].isWriteable();
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        this.checkColumn(column);
        return this.resultMetaData.colIndexes != null && this.resultMetaData.colIndexes[--column] > -1;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.checkColumn(column);
        return this.resultMetaData.colIndexes != null && this.resultMetaData.colIndexes[--column] > -1;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        this.checkColumn(column);
        Type type = this.translateType(this.resultMetaData.columnTypes[--column]);
        return type.getJDBCClassName();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw Util.invalidArgument("iface: " + String.valueOf(iface));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    public Type getType(int column) throws SQLException {
        this.checkColumn(column);
        return this.translateType(this.resultMetaData.columnTypes[--column]);
    }

    JDBCResultSetMetaData(ResultMetaData meta, boolean isUpdatable, boolean isInsertable, JDBCConnection conn) throws SQLException {
        this.init(meta, conn);
    }

    void init(ResultMetaData meta, JDBCConnection conn) throws SQLException {
        this.resultMetaData = meta;
        this.columnCount = this.resultMetaData.getColumnCount();
        this.useColumnName = true;
        if (conn == null) {
            return;
        }
        if (conn.connProperties != null) {
            this.useColumnName = conn.connProperties.isPropertyTrue("getColumnName", true);
        }
        if (conn.clientProperties != null) {
            this.translateTTIType = conn.clientProperties.isPropertyTrue("jdbc.translate_tti_types");
        }
    }

    private void checkColumn(int column) throws SQLException {
        if (column < 1 || column > this.columnCount) {
            throw Util.sqlException(421, String.valueOf(column));
        }
    }

    private Type translateType(Type type) {
        if (this.translateTTIType) {
            if (type.isIntervalType()) {
                type = ((IntervalType)type).getCharacterType();
            } else if (type.isDateTimeTypeWithZone()) {
                type = ((DateTimeType)type).getDateTimeTypeWithoutZone();
            }
        }
        return type;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        if (this.columnCount == 0) {
            sb.append("[columnCount=0]");
            return sb.toString();
        }
        sb.append('[');
        for (int i = 0; i < this.columnCount; ++i) {
            JDBCColumnMetaData meta = this.getColumnMetaData(i + 1);
            sb.append('\n');
            sb.append("   column_");
            sb.append(i + 1);
            sb.append('=');
            sb.append(meta);
            if (i + 1 >= this.columnCount) continue;
            sb.append(',');
            sb.append(' ');
        }
        sb.append('\n');
        sb.append(']');
        return sb.toString();
    }

    JDBCColumnMetaData getColumnMetaData(int i) {
        JDBCColumnMetaData meta = new JDBCColumnMetaData();
        try {
            meta.catalogName = this.getCatalogName(i);
            meta.columnClassName = this.getColumnClassName(i);
            meta.columnDisplaySize = this.getColumnDisplaySize(i);
            meta.columnLabel = this.getColumnLabel(i);
            meta.columnName = this.getColumnName(i);
            meta.columnType = this.getColumnType(i);
            meta.isAutoIncrement = this.isAutoIncrement(i);
            meta.isCaseSensitive = this.isCaseSensitive(i);
            meta.isCurrency = this.isCurrency(i);
            meta.isDefinitelyWritable = this.isDefinitelyWritable(i);
            meta.isNullable = this.isNullable(i);
            meta.isReadOnly = this.isReadOnly(i);
            meta.isSearchable = this.isSearchable(i);
            meta.isSigned = this.isSigned(i);
            meta.isWritable = this.isWritable(i);
            meta.precision = this.getPrecision(i);
            meta.scale = this.getScale(i);
            meta.schemaName = this.getSchemaName(i);
            meta.tableName = this.getTableName(i);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return meta;
    }
}

