/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.jdbc;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.jdbc.JDBCArray;
import com.streamscape.ds.jdbc.JDBCBlob;
import com.streamscape.ds.jdbc.JDBCBlobClient;
import com.streamscape.ds.jdbc.JDBCClob;
import com.streamscape.ds.jdbc.JDBCClobClient;
import com.streamscape.ds.jdbc.JDBCConnection;
import com.streamscape.ds.jdbc.JDBCNClob;
import com.streamscape.ds.jdbc.JDBCPreparedStatement;
import com.streamscape.ds.jdbc.JDBCResultSetMetaData;
import com.streamscape.ds.jdbc.JDBCSQLXML;
import com.streamscape.ds.jdbc.JDBCStatementBase;
import com.streamscape.ds.jdbc.Util;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.lib.IntValueHashMap;
import com.streamscape.ds.lib.StringInputStream;
import com.streamscape.ds.navigator.RowSetNavigator;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.result.ResultProperties;
import com.streamscape.ds.schema.column.ColumnBase;
import com.streamscape.ds.session.SessionInterface;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.ClobData;
import com.streamscape.ds.types.DateTimeType;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.IntervalType;
import com.streamscape.ds.types.OtherTypeWrapper;
import com.streamscape.ds.types.TimeData;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.ds.types.Type;
import com.streamscape.sdo.utils.SDOUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class JDBCResultSet
implements ResultSet {
    private RowSetNavigator navigator;
    protected ResultMetaData resultMetaData;
    private boolean translateTTIType;
    int columnCount;
    private boolean wasNullValue;
    private ResultSetMetaData resultSetMetaData;
    private IntValueHashMap columnMap;
    private SQLWarning rootWarning;
    JDBCStatementBase statement;
    SessionInterface session;
    JDBCConnection connection;
    boolean isScrollable;
    boolean isReadOnly;
    boolean isUpdatable;
    boolean isInsertable;
    int rsProperties;
    int fetchSize;
    boolean autoClose;
    public Result result;
    public static final int FETCH_FORWARD = 1000;
    public static final int FETCH_REVERSE = 1001;
    public static final int FETCH_UNKNOWN = 1002;
    public static final int TYPE_FORWARD_ONLY = 1003;
    public static final int TYPE_SCROLL_INSENSITIVE = 1004;
    public static final int TYPE_SCROLL_SENSITIVE = 1005;
    public static final int CONCUR_READ_ONLY = 1007;
    public static final int CONCUR_UPDATABLE = 1008;
    public static final int HOLD_CURSORS_OVER_COMMIT = 1;
    public static final int CLOSE_CURSORS_AT_COMMIT = 2;
    JDBCPreparedStatement preparedStatement;
    boolean isRowUpdated;
    boolean isOnInsertRow;
    int currentUpdateRowNumber;

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
        return this.navigator.next();
    }

    @Override
    public void close() throws SQLException {
        if (this.navigator == null) {
            return;
        }
        this.navigator.release();
        this.navigator = null;
        if (this.autoClose && this.statement != null) {
            this.statement.close();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.wasNullValue;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkColumn(columnIndex);
        Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
        if (sourceType.typeCode == 40) {
            ClobData x = (ClobData)this.getColumnInType(columnIndex, sourceType);
            if (x == null) {
                return null;
            }
            long length = x.length(this.session);
            if (length > Integer.MAX_VALUE) {
                Util.throwError(Error.error(5561));
            }
            return x.getSubString(this.session, 0L, (int)length);
        }
        if (sourceType.typeCode == 1119) {
            FlobData x = (FlobData)this.getColumnInType(columnIndex, sourceType);
            if (x == null) {
                return null;
            }
            long length = x.length(this.session);
            if (length > Integer.MAX_VALUE) {
                Util.throwError(Error.error(5561));
            }
            return x.getClobAdapter().getSubString(this.session, 0L, (int)length);
        }
        return (String)this.getColumnInType(columnIndex, Type.SQL_VARCHAR);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, Type.SQL_BOOLEAN);
        return o == null ? false : (Boolean)o;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, Type.TINYINT);
        return o == null ? (byte)0 : ((Number)o).byteValue();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, Type.SQL_SMALLINT);
        return o == null ? (short)0 : ((Number)o).shortValue();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, Type.SQL_INTEGER);
        return o == null ? 0 : ((Number)o).intValue();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, Type.SQL_BIGINT);
        return o == null ? 0L : ((Number)o).longValue();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, Type.SQL_DOUBLE);
        return o == null ? 0.0f : ((Number)o).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, Type.SQL_DOUBLE);
        return o == null ? 0.0 : ((Number)o).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        if (scale < 0) {
            throw Util.outOfRangeArgument();
        }
        BigDecimal bd = this.getBigDecimal(columnIndex);
        if (bd != null) {
            bd = bd.setScale(scale, 1);
        }
        return bd;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkColumn(columnIndex);
        Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
        if (sourceType.typeCode == 30) {
            BlobData x = (BlobData)this.getColumnInType(columnIndex, sourceType);
            if (x == null) {
                return null;
            }
            long length = x.length(this.session);
            if (length > Integer.MAX_VALUE) {
                Util.throwError(Error.error(5561));
            }
            return x.getBytes(this.session, 0L, (int)length);
        }
        if (sourceType.typeCode == 1119) {
            FlobData x = (FlobData)this.getColumnInType(columnIndex, sourceType);
            if (x == null) {
                return null;
            }
            long length = x.length(this.session);
            if (length > Integer.MAX_VALUE) {
                Util.throwError(Error.error(5561));
            }
            return x.getBlobAdapter().getBytes(this.session, 0L, (int)length);
        }
        Object x = this.getColumnInType(columnIndex, Type.SQL_VARBINARY);
        if (x == null) {
            return null;
        }
        if (x instanceof BinaryData) {
            return ((BinaryData)x).getBytes();
        }
        return (byte[])x;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        Object t = this.getColumnInType(columnIndex, Type.SQL_DATE);
        if (t == null) {
            return null;
        }
        return (Date)Type.SQL_DATE.convertSQLToJava(this.session, t);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Object t = this.getColumnInType(columnIndex, Type.SQL_TIME);
        if (t == null) {
            return null;
        }
        return (Time)Type.SQL_TIME.convertSQLToJava(this.session, t);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object t = this.getColumnInType(columnIndex, Type.SQL_TIMESTAMP);
        if (t == null) {
            return null;
        }
        return (Timestamp)Type.SQL_TIMESTAMP.convertSQLToJava(this.session, t);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(s.getBytes("US-ASCII"));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        return new StringInputStream(s);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkColumn(columnIndex);
        Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
        Object o = this.getColumnInType(columnIndex, sourceType);
        if (o == null) {
            return null;
        }
        if (o instanceof BinaryData) {
            return new ByteArrayInputStream(this.getBytes(columnIndex));
        }
        if (o instanceof BlobData) {
            return ((BlobData)o).getBinaryStream(this.session);
        }
        if (o instanceof FlobData) {
            return ((FlobData)o).getBlobAdapter().getBinaryStream(this.session);
        }
        if (o instanceof Blob) {
            return ((Blob)o).getBinaryStream();
        }
        throw Util.sqlException(5561);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.rootWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return "";
        }
        return this.result.getMainString();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.resultSetMetaData == null) {
            this.resultSetMetaData = new JDBCResultSetMetaData(this.resultMetaData, this.isUpdatable, this.isInsertable, this.connection);
        }
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkColumn(columnIndex);
        Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
        switch (sourceType.typeCode) {
            case 50: {
                return this.getArray(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: 
            case 94: {
                return this.getTime(columnIndex);
            }
            case 93: 
            case 95: {
                return this.getTimestamp(columnIndex);
            }
            case 60: 
            case 61: {
                return this.getBytes(columnIndex);
            }
            case 14: {
                boolean b = this.getBoolean(columnIndex);
                return this.wasNull() ? null : (b ? Boolean.TRUE : Boolean.FALSE);
            }
            case 40: {
                return this.getClob(columnIndex);
            }
            case 30: 
            case 1119: {
                return this.getBlob(columnIndex);
            }
            case 1111: 
            case 1113: 
            case 1122: 
            case 1123: 
            case 2000: {
                Object o = this.getColumnInType(columnIndex, sourceType);
                if (o == null) {
                    return null;
                }
                try {
                    Object result = OtherTypeWrapper.unwrap(o);
                    try {
                        return SDOUtils.clone(result);
                    }
                    catch (Throwable error) {
                        return result;
                    }
                }
                catch (DataspaceException e) {
                    throw Util.sqlException(e);
                }
            }
        }
        Object value = this.getColumnInType(columnIndex, sourceType);
        if (value == null) {
            return value;
        }
        if (sourceType.typeCode == -6) {
            return ((Number)value).byteValue();
        }
        if (sourceType.typeCode == 5) {
            return ((Number)value).shortValue();
        }
        if (sourceType.typeCode == 6) {
            return Float.valueOf(((Number)value).floatValue());
        }
        return value;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        int columnIndex;
        this.checkClosed();
        if (columnLabel == null) {
            throw Util.nullArgument();
        }
        if (this.columnMap != null && (columnIndex = this.columnMap.get((Object)columnLabel, -1)) != -1) {
            return columnIndex;
        }
        String[] colLabels = this.resultMetaData.columnLabels;
        columnIndex = -1;
        for (int i = 0; i < this.columnCount; ++i) {
            if (!columnLabel.equalsIgnoreCase(colLabels[i])) continue;
            columnIndex = i;
            break;
        }
        ColumnBase[] columns = this.resultMetaData.columns;
        if (columnIndex < 0) {
            for (int i = 0; i < this.columnCount; ++i) {
                if (!columnLabel.equalsIgnoreCase(columns[i].getNameString())) continue;
                columnIndex = i;
                break;
            }
        }
        if (columnIndex < 0) {
            int position = columnLabel.indexOf(46);
            if (position < 0) {
                throw Util.sqlException(421, columnLabel);
            }
            for (int i = 0; i < this.columnCount; ++i) {
                String match;
                String tabName = columns[i].getTableNameString();
                if (tabName == null || tabName.length() == 0) continue;
                String colName = columns[i].getNameString();
                if (columnLabel.equalsIgnoreCase(tabName + "." + colName)) {
                    columnIndex = i;
                    break;
                }
                String schemName = columns[i].getSchemaNameString();
                if (schemName == null || schemName.length() == 0 || !columnLabel.equalsIgnoreCase(match = new StringBuffer(schemName).append('.').append(tabName).append('.').append(colName).toString())) continue;
                columnIndex = i;
                break;
            }
        }
        if (columnIndex < 0) {
            throw Util.sqlException(421, columnLabel);
        }
        ++columnIndex;
        if (this.columnMap == null) {
            this.columnMap = new IntValueHashMap();
        }
        this.columnMap.put(columnLabel, columnIndex);
        return columnIndex;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkColumn(columnIndex);
        Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
        Object o = this.getColumnInType(columnIndex, sourceType);
        if (o == null) {
            return null;
        }
        if (o instanceof ClobData) {
            return ((ClobData)o).getCharacterStream(this.session);
        }
        if (o instanceof FlobData) {
            return ((FlobData)o).getClobAdapter().getCharacterStream(this.session);
        }
        if (o instanceof Clob) {
            return ((Clob)o).getCharacterStream();
        }
        if (o instanceof String) {
            return new StringReader((String)o);
        }
        throw Util.sqlException(5561);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkColumn(columnIndex);
        Type targetType = this.resultMetaData.columnTypes[columnIndex - 1];
        switch (targetType.typeCode) {
            case 2: 
            case 3: {
                break;
            }
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                targetType = Type.SQL_DECIMAL;
                break;
            }
            default: {
                targetType = Type.SQL_DECIMAL_DEFAULT;
            }
        }
        return (BigDecimal)this.getColumnInType(columnIndex, targetType);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw Util.sqlExceptionSQL(3604);
        }
        this.navigator.beforeFirst();
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw Util.sqlExceptionSQL(3604);
        }
        this.navigator.afterLast();
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw Util.sqlExceptionSQL(3604);
        }
        return this.navigator.first();
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw Util.sqlExceptionSQL(3604);
        }
        return this.navigator.last();
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        if (this.navigator.isAfterLast()) {
            return 0;
        }
        return this.navigator.getRowNumber() + 1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw Util.sqlExceptionSQL(3604);
        }
        if (row > 0) {
            --row;
        } else if (row == 0) {
            return this.navigator.beforeFirst();
        }
        return this.navigator.absolute(row);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw Util.sqlExceptionSQL(3604);
        }
        return this.navigator.relative(rows);
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw Util.sqlExceptionSQL(3604);
        }
        this.rootWarning = null;
        return this.navigator.previous();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        switch (direction) {
            case 1000: {
                break;
            }
            case 1001: {
                this.checkNotForwardOnly();
                break;
            }
            case 1002: {
                this.checkNotForwardOnly();
                break;
            }
            default: {
                throw Util.notSupported();
            }
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw Util.outOfRangeArgument();
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCScrollability(this.rsProperties);
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCConcurrency(this.rsProperties);
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return this.isRowUpdated;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, null);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        Boolean value = x ? Boolean.TRUE : Boolean.FALSE;
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, value);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setIntParameter(columnIndex, x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setIntParameter(columnIndex, x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setIntParameter(columnIndex, x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setLongParameter(columnIndex, x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        Double value = new Double(x);
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, value);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        Double value = new Double(x);
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, value);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setObject(columnIndex, x, 0, scaleOrLength);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.updateNull(this.findColumn(columnLabel));
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.updateShort(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.updateInt(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.updateLong(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.updateString(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), x, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), x);
    }

    @Override
    public void insertRow() throws SQLException {
        this.performInsert();
    }

    @Override
    public void updateRow() throws SQLException {
        this.performUpdate();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.performDelete();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.clearUpdates();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.clearUpdates();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.startInsert();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.endInsert();
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return (Statement)((Object)this.statement);
    }

    public Object getObject(int columnIndex, Map map) throws SQLException {
        return this.getObject(columnIndex);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkColumn(columnIndex);
        Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
        Object o = this.getColumnInType(columnIndex, sourceType);
        if (o == null) {
            return null;
        }
        if (o instanceof BinaryData) {
            return new JDBCBlob(this.getBytes(columnIndex));
        }
        if (o instanceof BlobData || o instanceof FlobData) {
            o = o instanceof BlobData ? o : ((FlobData)o).getBlobAdapter();
            JDBCBlobClient blob = new JDBCBlobClient(this.session, (BlobData)o);
            if (this.isUpdatable && this.resultMetaData.colIndexes[columnIndex - 1] > 0 && this.resultMetaData.columns[columnIndex - 1].isWriteable()) {
                blob.setWritable(this, columnIndex - 1);
            }
            return blob;
        }
        if (o instanceof Blob) {
            return (Blob)o;
        }
        throw Util.sqlException(5561);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.checkColumn(columnIndex);
        Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
        Object o = this.getColumnInType(columnIndex, sourceType);
        if (o == null) {
            return null;
        }
        if (o instanceof ClobData || o instanceof FlobData) {
            o = o instanceof ClobData ? o : ((FlobData)o).getClobAdapter();
            JDBCClobClient clob = new JDBCClobClient(this.session, (ClobData)o);
            if (this.isUpdatable && this.resultMetaData.colIndexes[columnIndex - 1] > 0 && this.resultMetaData.columns[columnIndex - 1].isWriteable()) {
                clob.setWritable(this, columnIndex - 1);
            }
            return clob;
        }
        if (o instanceof Clob) {
            return (Clob)o;
        }
        if (o instanceof String) {
            return new JDBCClob((String)o);
        }
        throw Util.sqlException(5561);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.checkColumn(columnIndex);
        Type type = this.resultMetaData.columnTypes[columnIndex - 1];
        Object[] data = (Object[])this.getCurrent()[columnIndex - 1];
        if (!type.isArrayType()) {
            throw Util.sqlException(5561);
        }
        if (this.trackNull(data)) {
            return null;
        }
        return new JDBCArray(data, type.collectionBaseType(), type, this.connection);
    }

    public Object getObject(String columnLabel, Map map) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), map);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.getRef(this.findColumn(columnLabel));
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        TimestampData t = (TimestampData)this.getColumnInType(columnIndex, Type.SQL_DATE);
        if (t == null) {
            return null;
        }
        long millis = t.getMilliseconds();
        if (cal != null) {
            millis = DataspaceDateTime.convertMillisToCalendar(cal, millis);
        }
        return new Date(millis);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        TimeData t = (TimeData)this.getColumnInType(columnIndex, Type.SQL_TIME);
        if (t == null) {
            return null;
        }
        long millis = DateTimeType.normaliseTime(t.getSeconds()) * 1000;
        if (!this.resultMetaData.columnTypes[--columnIndex].isDateTimeTypeWithZone()) {
            Calendar calendar = cal == null ? this.session.getCalendar() : cal;
            millis = DataspaceDateTime.convertMillisToCalendar(calendar, millis);
            millis = DataspaceDateTime.getNormalisedTime(millis);
        }
        return new Time(millis);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        TimestampData t = (TimestampData)this.getColumnInType(columnIndex, Type.SQL_TIMESTAMP);
        if (t == null) {
            return null;
        }
        long millis = t.getMilliseconds();
        if (!this.resultMetaData.columnTypes[--columnIndex].isDateTimeTypeWithZone()) {
            Calendar calendar;
            Calendar calendar2 = calendar = cal == null ? this.session.getCalendar() : cal;
            if (cal != null) {
                millis = DataspaceDateTime.convertMillisToCalendar(calendar, millis);
            }
        }
        Timestamp ts = new Timestamp(millis);
        ts.setNanos(t.getNanos());
        return ts;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setBlobParameter(columnIndex, x);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.updateBlob(columnIndex, x);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setClobParameter(columnIndex, x);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.updateClob(columnIndex, x);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.updateArray(columnIndex, x);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCHoldability(this.rsProperties);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.navigator == null;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.updateString(columnIndex, nString);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.updateString(columnLabel, nString);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.updateClob(columnIndex, (Clob)nClob);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.updateClob(columnLabel, (Clob)nClob);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        return s == null ? null : new JDBCNClob(s);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.checkColumn(columnIndex);
        int type = this.resultMetaData.columnTypes[columnIndex - 1].typeCode;
        return switch (type) {
            case 137 -> {
                Object object = this.getObject(columnIndex);
                if (object == null) {
                    yield null;
                }
                if (object instanceof SQLXML) {
                    yield (SQLXML)object;
                }
                throw Util.notSupported();
            }
            case 40 -> {
                Clob clob = this.getClob(columnIndex);
                if (clob == null) {
                    yield null;
                }
                yield new JDBCSQLXML(clob.getCharacterStream());
            }
            case 1, 12, 100 -> {
                Reader reader = this.getCharacterStream(columnIndex);
                if (reader == null) {
                    yield null;
                }
                yield new JDBCSQLXML(reader);
            }
            case -9, -8 -> {
                Reader nreader = this.getNCharacterStream(columnIndex);
                if (nreader == null) {
                    yield null;
                }
                yield new JDBCSQLXML(nreader);
            }
            case 30 -> {
                Blob blob = this.getBlob(columnIndex);
                if (blob == null) {
                    yield null;
                }
                yield new JDBCSQLXML(blob.getBinaryStream());
            }
            case 60, 61 -> {
                InputStream inputStream = this.getBinaryStream(columnIndex);
                if (inputStream == null) {
                    yield null;
                }
                yield new JDBCSQLXML(inputStream);
            }
            case 1111, 1113, 2000 -> {
                Object data = this.getObject(columnIndex);
                if (data == null) {
                    yield null;
                }
                if (data instanceof SQLXML) {
                    yield (SQLXML)data;
                }
                if (data instanceof String) {
                    yield new JDBCSQLXML((String)data);
                }
                if (data instanceof byte[]) {
                    yield new JDBCSQLXML((byte[])data);
                }
                if (data instanceof Blob) {
                    Blob blob = (Blob)data;
                    yield new JDBCSQLXML(blob.getBinaryStream());
                }
                if (data instanceof Clob) {
                    Clob clob = (Clob)data;
                    yield new JDBCSQLXML(clob.getCharacterStream());
                }
                throw Util.notSupported();
            }
            default -> throw Util.notSupported();
        };
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setSQLXML(columnIndex, xmlObject);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.updateSQLXML(this.findColumn(columnLabel), xmlObject);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, reader, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setBlob(columnIndex, inputStream, length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setBlob(columnIndex, inputStream, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, reader);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, reader);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setAsciiStream(columnIndex, x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setBinaryStream(columnIndex, x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setAsciiStream(columnIndex, x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setBinaryStream(columnIndex, x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, reader);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setBlob(columnIndex, inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setBlob(columnIndex, inputStream);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw Util.invalidArgument("iface: " + String.valueOf(iface));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return (T)this.getObject(columnIndex);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    protected Object[] getCurrent() throws SQLException {
        RowSetNavigator lnavigator = this.navigator;
        if (lnavigator == null) {
            throw Util.sqlException(3601);
        }
        if (lnavigator.isEmpty()) {
            throw Util.sqlException(3603, 70);
        }
        if (lnavigator.isBeforeFirst()) {
            throw Util.sqlException(3603, 71);
        }
        if (lnavigator.isAfterLast()) {
            throw Util.sqlException(3603, 72);
        }
        Object[] data = lnavigator.getCurrent();
        if (data == null) {
            throw Util.sqlException(3601);
        }
        return data;
    }

    private void checkClosed() throws SQLException {
        if (this.navigator == null) {
            throw Util.sqlException(3601);
        }
    }

    protected void checkColumn(int columnIndex) throws SQLException {
        if (this.navigator == null) {
            throw Util.sqlException(3601);
        }
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw Util.sqlException(421, String.valueOf(columnIndex));
        }
    }

    protected boolean trackNull(Object o) {
        this.wasNullValue = o == null;
        return this.wasNullValue;
    }

    private Object getColumnInType(int columnIndex, Type targetType) throws SQLException {
        Object[] rowData = this.getCurrent();
        this.checkColumn(columnIndex);
        Type sourceType = this.resultMetaData.columnTypes[--columnIndex];
        Object value = rowData[columnIndex];
        if (this.trackNull(value)) {
            return null;
        }
        if (this.translateTTIType && targetType.isIntervalType()) {
            targetType = ((IntervalType)targetType).getCharacterType();
        }
        if (sourceType.typeCode != targetType.typeCode) {
            try {
                value = targetType.convertToTypeJDBC(this.session, value, sourceType);
            }
            catch (Exception e) {
                String stringValue = value instanceof Number || value instanceof String ? value.toString() : "instance of " + value.getClass().getName();
                String msg = "from SQL type " + sourceType.getNameString() + " to " + targetType.getJDBCClassName() + ", value: " + stringValue;
                Util.throwError(Error.error(5561, msg));
            }
        }
        return value;
    }

    private void checkNotForwardOnly() throws SQLException {
        if (!this.isScrollable) {
            throw Util.notSupported();
        }
    }

    private void checkUpdatable() throws SQLException {
        this.checkClosed();
        if (!this.isUpdatable) {
            throw Util.notUpdatableColumn();
        }
    }

    private void checkUpdatable(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumn(columnIndex);
        if (!this.isUpdatable) {
            throw Util.notUpdatableColumn();
        }
        if (this.resultMetaData.colIndexes[--columnIndex] == -1) {
            throw Util.notUpdatableColumn();
        }
        if (!this.resultMetaData.columns[columnIndex].isWriteable()) {
            throw Util.notUpdatableColumn();
        }
    }

    void startUpdate(int columnIndex) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (this.currentUpdateRowNumber != this.navigator.getRowNumber()) {
            this.preparedStatement.clearParameters();
        }
        this.currentUpdateRowNumber = this.navigator.getRowNumber();
        this.isRowUpdated = true;
    }

    private void clearUpdates() throws SQLException {
        this.checkUpdatable();
        this.preparedStatement.clearParameters();
        this.isRowUpdated = false;
    }

    private void startInsert() throws SQLException {
        this.checkUpdatable();
        this.isOnInsertRow = true;
    }

    private void endInsert() throws SQLException {
        this.checkUpdatable();
        this.preparedStatement.clearParameters();
        this.isOnInsertRow = false;
    }

    private void performUpdate() throws SQLException {
        this.preparedStatement.parameterValues[this.columnCount] = this.getCurrent()[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            boolean set = this.preparedStatement.parameterSet[i] != null;
            this.preparedStatement.resultOut.metaData.columnTypes[i] = set ? this.preparedStatement.parameterTypes[i] : Type.SQL_ALL_TYPES;
        }
        this.preparedStatement.resultOut.setActionType(81);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
        this.isRowUpdated = false;
    }

    private void performInsert() throws SQLException {
        this.checkUpdatable();
        for (int i = 0; i < this.columnCount; ++i) {
            boolean set;
            boolean bl = set = this.preparedStatement.parameterSet[i] != null;
            if (!set) {
                throw Util.sqlException(3606);
            }
            this.preparedStatement.resultOut.metaData.columnTypes[i] = this.preparedStatement.parameterTypes[i];
        }
        this.preparedStatement.resultOut.setActionType(50);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
    }

    private void performDelete() throws SQLException {
        this.checkUpdatable();
        this.preparedStatement.parameterValues[this.columnCount] = this.getCurrent()[this.columnCount];
        this.preparedStatement.resultOut.metaData.columnTypes[this.columnCount] = this.resultMetaData.columnTypes[this.columnCount];
        this.preparedStatement.resultOut.setActionType(18);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
    }

    public RowSetNavigator getNavigator() {
        return this.navigator;
    }

    void setNavigator(RowSetNavigator navigator) {
        this.navigator = navigator;
    }

    public JDBCResultSet(JDBCConnection conn, JDBCStatementBase s, Result r, ResultMetaData metaData) throws SQLException {
        this.session = conn == null ? null : conn.sessionProxy;
        this.statement = s;
        this.result = r;
        this.connection = conn;
        this.rsProperties = r.rsProperties;
        this.navigator = r.getNavigator();
        this.resultMetaData = metaData;
        this.columnCount = this.resultMetaData.getColumnCount();
        this.isScrollable = ResultProperties.isScrollable(this.rsProperties);
        if (ResultProperties.isUpdatable(this.rsProperties)) {
            this.isUpdatable = true;
            this.isInsertable = true;
            for (int i = 0; i < metaData.colIndexes.length; ++i) {
                if (metaData.colIndexes[i] >= 0) continue;
                this.isInsertable = false;
                break;
            }
            this.preparedStatement = new JDBCPreparedStatement(s.connection, this.result);
        }
        if (conn != null && conn.clientProperties != null) {
            this.translateTTIType = conn.clientProperties.isPropertyTrue("jdbc.translate_tti_types");
        }
    }

    public JDBCResultSet(JDBCConnection conn, Result r, ResultMetaData metaData) {
        this.session = conn == null ? null : conn.sessionProxy;
        this.result = r;
        this.connection = conn;
        this.rsProperties = 0;
        this.navigator = r.getNavigator();
        this.resultMetaData = metaData;
        this.columnCount = this.resultMetaData.getColumnCount();
        if (conn != null && conn.clientProperties != null) {
            this.translateTTIType = conn.clientProperties.isPropertyTrue("jdbc.translate_tti_types");
        }
    }

    public static JDBCResultSet newJDBCResultSet(Result r, ResultMetaData metaData) {
        return new JDBCResultSetBasic(r, metaData);
    }

    static class JDBCResultSetBasic
    extends JDBCResultSet {
        JDBCResultSetBasic(Result r, ResultMetaData metaData) {
            super(null, r, metaData);
        }

        @Override
        protected Object getColumnInType(int columnIndex, Type targetType) throws SQLException {
            Object[] rowData = this.getCurrent();
            this.checkColumn(columnIndex);
            Type sourceType = this.resultMetaData.columnTypes[--columnIndex];
            Object value = rowData[columnIndex];
            if (this.trackNull(value)) {
                return null;
            }
            if (sourceType.typeCode != targetType.typeCode) {
                Util.throwError(Error.error(5561));
            }
            return value;
        }

        @Override
        public Date getDate(int columnIndex) throws SQLException {
            return (Date)this.getColumnInType(columnIndex, Type.SQL_DATE);
        }

        @Override
        public Time getTime(int columnIndex) throws SQLException {
            return (Time)this.getColumnInType(columnIndex, Type.SQL_DATE);
        }

        @Override
        public Timestamp getTimestamp(int columnIndex) throws SQLException {
            return (Timestamp)this.getColumnInType(columnIndex, Type.SQL_DATE);
        }

        @Override
        public InputStream getBinaryStream(int columnIndex) throws SQLException {
            throw Util.notSupported();
        }

        @Override
        public Reader getCharacterStream(int columnIndex) throws SQLException {
            throw Util.notSupported();
        }

        @Override
        public Blob getBlob(int columnIndex) throws SQLException {
            this.checkColumn(columnIndex);
            Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
            Object o = this.getColumnInType(columnIndex, sourceType);
            if (o == null) {
                return null;
            }
            if (o instanceof Blob) {
                return (Blob)o;
            }
            if (o instanceof byte[]) {
                return new JDBCBlob((byte[])o);
            }
            throw Util.sqlException(5561);
        }

        @Override
        public Clob getClob(int columnIndex) throws SQLException {
            this.checkColumn(columnIndex);
            Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
            Object o = this.getColumnInType(columnIndex, sourceType);
            if (o == null) {
                return null;
            }
            if (o instanceof Clob) {
                return (Clob)o;
            }
            if (o instanceof String) {
                return new JDBCClob((String)o);
            }
            throw Util.sqlException(5561);
        }

        @Override
        public Time getTime(int columnIndex, Calendar cal) throws SQLException {
            throw Util.notSupported();
        }

        @Override
        public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
            throw Util.notSupported();
        }
    }
}

