/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.jdbc;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.jdbc.JDBCDriver;
import com.streamscape.ds.persist.BaseStoreProperties;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.sef.container.ContainerLogger;
import com.streamscape.sef.trace.TraceConfigurator;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;

public class JDBCDriverContext {
    public static synchronized void initialize(BaseStoreProperties props) throws Exception {
        String connType = props.getProperty("connection_type");
        if (connType.equals("runtime:")) {
            String startUpDir = props.getProperty("runtimeWorkingDir");
            String deploymentCtx = props.getProperty("ddx");
            if (RuntimeState.isActive()) {
                String currentWorkingDir = System.getProperty("streamscape.runtime.startup.dir");
                if (startUpDir != null && startUpDir.length() > 0) {
                    if (startUpDir.length() > 0 && !JDBCDriverContext.compareFolderPaths(currentWorkingDir, startUpDir)) {
                        throw new SQLException("Runtime Context already initialized in '" + currentWorkingDir + "' working dir.");
                    }
                } else {
                    String database = System.getProperty("streamscape.runtime.startup.dir") + File.separatorChar + ".dscache" + File.separatorChar + "dtspace";
                    if (database.startsWith("~")) {
                        String userHome = System.getProperty("user.home");
                        database = userHome + database.substring(1);
                    }
                    if (database.length() == 0) {
                        throw new SQLException("Dataspace is not set.");
                    }
                    props.setProperty("database", database);
                }
                if (deploymentCtx != null) {
                    String currentDdx;
                    String string = currentDdx = System.getProperty("streamscape.runtime.deployment.dir") != null ? System.getProperty("streamscape.runtime.deployment.dir") : ".";
                    if (!JDBCDriverContext.compareFolderPaths(currentDdx, deploymentCtx)) {
                        throw new SQLException("Runtime Context already initialized and uses DDX from '" + currentDdx + "' dir.");
                    }
                }
            } else {
                if (startUpDir == null || startUpDir.length() == 0) {
                    throw new SQLException("Initialization failed. Runtime Context working dir is not specified.");
                }
                JDBCDriverContext.initRuntime(props, startUpDir, deploymentCtx);
            }
        }
    }

    private static boolean compareFolderPaths(String path1, String path2) throws IOException {
        File file1 = new File(path1);
        File file2 = new File(path2);
        return file1.getCanonicalPath().equals(file2.getCanonicalPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initRuntime(BaseStoreProperties props, String startUpDir, String deploymentCtx) throws UtilitiesException {
        boolean ifExist;
        String dsCacheLocation = startUpDir + File.separatorChar + ".dscache";
        boolean bl = ifExist = props.isPropertyExist(props.getProperty("exist")) && Boolean.parseBoolean(props.getProperty("exist"));
        if (!(!ifExist || FileIOUtils.fileAvailable(startUpDir) && FileIOUtils.fileAvailable(startUpDir + File.separatorChar + ".tfcache"))) {
            throw new UtilitiesException("Specified runtime dir '" + startUpDir + "' does not exist. Initialization failed.");
        }
        if (!FileIOUtils.fileAvailable(dsCacheLocation)) {
            FileIOUtils.newFileDir(dsCacheLocation);
        }
        System.setProperty("streamscape.runtime.startup.dir", startUpDir);
        if (deploymentCtx != null) {
            System.setProperty("streamscape.runtime.deployment.dir", deploymentCtx);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JDBCDriver.class.getClassLoader());
            RuntimeContext ctx = RuntimeContext.getInstance();
            DataspaceStoreManager.setRuntimeContext(ctx);
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    public static void initTraces(BaseStoreProperties props) {
        String traceLevel = props.getProperty("traceLevel");
        String traceConfig = props.getProperty("traceConfig");
        if (traceLevel != null || traceConfig != null) {
            String defaultTraceLogFile = "./streamscapejdbcdriver.log";
            String traceLogFile = props.getProperty("traceLogFile");
            if (traceLogFile == null) {
                traceLogFile = defaultTraceLogFile;
            }
            boolean redirectSystemOut = false;
            try {
                redirectSystemOut = props.isPropertyExist("redirectSystemOut") && Boolean.parseBoolean(props.getProperty("redirectSystemOut"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                TraceConfigurator.getInstance().enableLog(new ContainerLogger(traceLogFile, defaultTraceLogFile, true));
                Trace.setLogger("*", TraceConfigurator.getInstance().getLogger());
                if (redirectSystemOut) {
                    ((ContainerLogger)TraceConfigurator.getInstance().getLogger()).redirectSystemOutput();
                }
                if (traceLevel != null) {
                    Trace.Level level = Trace.Level.ERROR;
                    if (traceLevel.equalsIgnoreCase("debug")) {
                        level = Trace.Level.DEBUG;
                    } else if (traceLevel.equalsIgnoreCase("info")) {
                        level = Trace.Level.INFO;
                    }
                    if (props.getProperty("remote_protocol_type").equalsIgnoreCase("tlp")) {
                        Trace.disable("com.streamscape.cli.http.*");
                        Trace.disable("com.streamscape.lib.http.*");
                    }
                    Trace.disable("com.streamscape.sef.network.http.*");
                    Trace.enable("*", level);
                } else if (traceConfig != null) {
                    Trace.setConfigurationFile(traceConfig);
                }
            }
            catch (Exception exception) {
                System.err.println("Failed to initialize traces. Cause: " + exception.getMessage());
            }
        }
    }
}

