/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.jdbc;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.ds.DataspaceURL;
import com.streamscape.ds.DataspaceUrlProperties;
import com.streamscape.ds.jdbc.JDBCConnection;
import com.streamscape.ds.jdbc.JDBCDriverContext;
import com.streamscape.ds.jdbc.Util;
import com.streamscape.ds.persist.BaseStoreProperties;
import com.streamscape.ds.persist.DataspaceStoreProperties;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Logger;

public class JDBCDriver
implements Driver {
    protected static boolean isTracesInitialized = false;
    public static JDBCDriver driverInstance;
    public final ThreadLocal<JDBCConnection> threadConnection = new ThreadLocal();

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url.regionMatches(true, 0, "jdbc:default:connection", 0, "jdbc:default:connection".length())) {
            return this.threadConnection.get();
        }
        return JDBCDriver.getConnection(url, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(String url, Properties info) throws SQLException {
        try {
            String loginTimeoutProperty;
            final BaseStoreProperties props = DataspaceURL.parseURL(url, true, false);
            if (props == null) {
                throw Util.invalidArgument();
            }
            if (props.isEmpty()) {
                return null;
            }
            JDBCDriverContext.initTraces(props);
            JDBCDriverContext.initialize(props);
            long timeout = 0L;
            if (info != null && info.containsKey("loginTimeout") && (loginTimeoutProperty = info.getProperty("loginTimeout")) != null && (loginTimeoutProperty = loginTimeoutProperty.trim()).length() > 0) {
                try {
                    timeout = Integer.parseInt(loginTimeoutProperty);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            props.addProperties(info);
            if (timeout == 0L) {
                timeout = DriverManager.getLoginTimeout();
            }
            if (timeout == 0L || DataspaceURL.isInProcessDatabaseType(props)) {
                return new JDBCConnection(props);
            }
            final JDBCConnection[] conn = new JDBCConnection[1];
            final SQLException[] ex = new SQLException[1];
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        conn[0] = new JDBCConnection(props);
                    }
                    catch (SQLException se) {
                        ex[0] = se;
                    }
                }
            };
            t.start();
            try {
                t.join(1000L * timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                t.stop();
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    t.setContextClassLoader(null);
                }
                catch (Throwable throwable) {}
            }
            if (ex[0] != null) {
                throw ex[0];
            }
            if (conn[0] != null) {
                return conn[0];
            }
            throw Util.sqlException(1351);
        }
        catch (Exception exception) {
            Trace.logError(JDBCDriver.class, "JDBCDriver get connection failed.");
            Trace.logException(JDBCDriver.class, exception, true);
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw new SQLException(exception);
        }
    }

    public Connection connect(DataspaceAccessor accessor, TimeZone timezone) throws SQLException {
        return this.connect(accessor, timezone, new Properties());
    }

    public Connection connect(DataspaceAccessor accessor, String properties) throws SQLException {
        return this.connect(accessor, TimeZone.getDefault(), BaseStoreProperties.delimitedArgPairsToProps(properties, "=", ";", null).getProperties());
    }

    public Connection connect(DataspaceAccessor accessor, TimeZone timezone, Properties properties) throws SQLException {
        return new JDBCConnection(accessor, timezone, new BaseStoreProperties(properties));
    }

    @Override
    public boolean acceptsURL(String url) {
        if (url == null) {
            return false;
        }
        if (url.regionMatches(true, 0, "jdbc:streamscape:dataspace:", 0, "jdbc:streamscape:dataspace:".length())) {
            return true;
        }
        if (url.regionMatches(true, 0, "http:streamscape:dataspace:", 0, "http:streamscape:dataspace:".length())) {
            return true;
        }
        if (url.regionMatches(true, 0, "https:streamscape:dataspace:", 0, "https:streamscape:dataspace:".length())) {
            return true;
        }
        return url.regionMatches(true, 0, "jdbc:default:connection", 0, "jdbc:default:connection".length());
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        if (!this.acceptsURL(url)) {
            return new DriverPropertyInfo[0];
        }
        if (info == null) {
            info = new Properties();
        }
        return DataspaceUrlProperties.getProperties(info);
    }

    @Override
    public int getMajorVersion() {
        return DataspaceStoreProperties.MAJOR;
    }

    @Override
    public int getMinorVersion() {
        return DataspaceStoreProperties.MINOR;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw (SQLFeatureNotSupportedException)Util.notSupported();
    }

    static {
        try {
            driverInstance = new JDBCDriver();
            DriverManager.registerDriver(driverInstance);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

