/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.jdbc;

import com.streamscape.ds.jdbc.JDBCCommonDataSource;
import com.streamscape.ds.jdbc.JDBCDriver;
import com.streamscape.ds.jdbc.Util;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class JDBCDataSource
extends JDBCCommonDataSource
implements DataSource,
Serializable,
Referenceable,
Wrapper {
    @Override
    public Connection getConnection() throws SQLException {
        if (this.url == null) {
            throw Util.nullArgument("url");
        }
        if (this.connectionProps == null) {
            if (this.user == null) {
                throw Util.invalidArgument("user");
            }
            if (this.password == null) {
                throw Util.invalidArgument("password");
            }
            return this.getConnection(this.user, this.password);
        }
        if (this.connectionProps == null) {
            return this.getConnection(this.url, new Properties());
        }
        return this.getConnection(this.url, this.connectionProps);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (username == null) {
            throw Util.invalidArgument("user");
        }
        if (password == null) {
            throw Util.invalidArgument("password");
        }
        Properties props = new Properties();
        props.setProperty("user", username);
        props.setProperty("password", password);
        props.setProperty("loginTimeout", Integer.toString(this.loginTimeout));
        return this.getConnection(this.url, props);
    }

    private Connection getConnection(String url, Properties props) throws SQLException {
        if (!((String)url).startsWith("jdbc:streamscape:")) {
            url = "jdbc:streamscape:" + (String)url;
        }
        return JDBCDriver.getConnection((String)url, props);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw Util.invalidArgument("iface: " + String.valueOf(iface));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public Reference getReference() throws NamingException {
        String cname = "com.streamscape.ds.jdbc.JDBCDataSourceFactory";
        Reference ref = new Reference(this.getClass().getName(), cname, null);
        ref.add(new StringRefAddr("database", this.getDatabase()));
        ref.add(new StringRefAddr("user", this.getUser()));
        ref.add(new StringRefAddr("password", this.password));
        ref.add(new StringRefAddr("loginTimeout", Integer.toString(this.loginTimeout)));
        return ref;
    }
}

