/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.jdbc;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.DataspaceURL;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.jdbc.ClientConnection;
import com.streamscape.ds.jdbc.JDBCArray;
import com.streamscape.ds.jdbc.JDBCBlob;
import com.streamscape.ds.jdbc.JDBCCallableStatement;
import com.streamscape.ds.jdbc.JDBCClob;
import com.streamscape.ds.jdbc.JDBCConnectionEventListener;
import com.streamscape.ds.jdbc.JDBCDatabaseMetaData;
import com.streamscape.ds.jdbc.JDBCNClob;
import com.streamscape.ds.jdbc.JDBCPreparedStatement;
import com.streamscape.ds.jdbc.JDBCSQLXML;
import com.streamscape.ds.jdbc.JDBCSavepoint;
import com.streamscape.ds.jdbc.JDBCStatement;
import com.streamscape.ds.jdbc.Util;
import com.streamscape.ds.lib.StringUtil;
import com.streamscape.ds.persist.BaseStoreProperties;
import com.streamscape.ds.result.ResultProperties;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionInterface;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.security.User;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.Executor;

public class JDBCConnection
implements Connection {
    int rsHoldability = 1;
    BaseStoreProperties connProperties;
    BaseStoreProperties clientProperties;
    SessionInterface sessionProxy;
    boolean isInternal;
    protected boolean isNetConn;
    boolean isClosed;
    private SQLWarning rootWarning;
    private final Object rootWarning_mutex = new Object();
    private int savepointIDSequence;
    int incarnation;
    boolean isPooled;
    JDBCConnectionEventListener poolEventListener;
    static int connectionsCounter = 0;
    private boolean isEmbeddedConnection = false;

    @Override
    public synchronized Statement createStatement() throws SQLException {
        this.checkClosed();
        int props = ResultProperties.getValueForJDBC(1003, 1007, this.rsHoldability);
        JDBCStatement stmt = new JDBCStatement(this, props);
        return stmt;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, sql, 1003, 1007, this.rsHoldability, 2, null, null);
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        this.checkClosed();
        try {
            JDBCCallableStatement stmt = new JDBCCallableStatement(this, sql, 1003, 1007, this.rsHoldability);
            return stmt;
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        return JDBCConnection.escapeSQL(sql);
    }

    public static String escapeSQL(String sql) throws SQLException {
        if (sql == null || sql.length() == 0 || sql.indexOf(123) == -1) {
            return sql;
        }
        boolean changed = false;
        int state = 0;
        int len = sql.length();
        int nest = 0;
        StringBuffer sb = null;
        boolean outside_all = false;
        boolean outside_escape_inside_single_quotes = true;
        int outside_escape_inside_double_quotes = 2;
        int inside_escape = 3;
        int inside_escape_inside_single_quotes = 4;
        int inside_escape_inside_double_quotes = 5;
        int tail = 0;
        block6: for (int i = 0; i < len; ++i) {
            char c = sql.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '\'') {
                        state = 1;
                        continue block6;
                    }
                    if (c == '\"') {
                        state = 2;
                        continue block6;
                    }
                    if (c != '{') continue block6;
                    if (sb == null) {
                        sb = new StringBuffer(sql.length());
                    }
                    sb.append(sql.substring(tail, i));
                    int ii = JDBCConnection.onStartEscapeSequence(sql, sb, i);
                    if (ii == -1) continue block6;
                    tail = i = ii;
                    changed = true;
                    ++nest;
                    state = 3;
                    continue block6;
                }
                case 1: 
                case 4: {
                    if (c != '\'') continue block6;
                    --state;
                    continue block6;
                }
                case 2: 
                case 5: {
                    if (c != '\"') continue block6;
                    state -= 2;
                    continue block6;
                }
                case 3: {
                    if (c == '\'') {
                        state = 4;
                        continue block6;
                    }
                    if (c == '\"') {
                        state = 5;
                        continue block6;
                    }
                    if (c == '}') {
                        sb.append(sql.substring(tail, i));
                        sb.append(' ');
                        tail = ++i;
                        changed = true;
                        state = --nest == 0 ? 0 : 3;
                        continue block6;
                    }
                    if (c != '{') continue block6;
                    sb.append(sql.substring(tail, i));
                    int ii = JDBCConnection.onStartEscapeSequence(sql, sb, i);
                    if (ii == -1) {
                        throw Util.sqlException(Error.error(425, sql.substring(i)));
                    }
                    tail = i = ii;
                    changed = true;
                    ++nest;
                    state = 3;
                }
            }
        }
        if (!changed) {
            return sql;
        }
        sb.append(sql.substring(tail, sql.length()));
        return sb.toString();
    }

    @Override
    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setAutoCommit(autoCommit);
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.isAutoCommit();
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized void commit() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.commit(false);
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.rollback(false);
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isInternal || this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.rootWarning = null;
        this.connProperties = null;
        if (this.isPooled) {
            if (this.poolEventListener != null) {
                this.poolEventListener.connectionClosed();
                this.poolEventListener = null;
            }
        } else if (this.sessionProxy != null) {
            this.sessionProxy.close();
            this.sessionProxy = null;
        }
        if (this.isEmbeddedConnection && this.decrementCounter()) {
            RuntimeContext.getInstance().unload();
        }
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new JDBCDatabaseMetaData(this);
    }

    @Override
    public synchronized void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setReadOnlyDefault(readOnly);
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.isReadOnlyDefault();
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setAttribute(3, catalog);
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized String getCatalog() throws SQLException {
        this.checkClosed();
        try {
            return (String)this.sessionProxy.getAttribute(3);
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        switch (level) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw Util.invalidArgument("Invalid transaction level " + level + ", should be 1,2,4 or 8.");
            }
        }
        try {
            this.sessionProxy.setIsolationDefault(level);
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.getIsolation();
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.rootWarning;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
    }

    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        int props = ResultProperties.getValueForJDBC(resultSetType, resultSetConcurrency, this.rsHoldability);
        return new JDBCStatement(this, props);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, sql, resultSetType, resultSetConcurrency, this.rsHoldability, 2, null, null);
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCCallableStatement(this, sql, resultSetType, resultSetConcurrency, this.rsHoldability);
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkClosed();
        return new HashMap();
    }

    @Override
    public synchronized void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        throw Util.notSupported();
    }

    @Override
    public synchronized void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        switch (holdability) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw Util.invalidArgument();
            }
        }
        this.rsHoldability = holdability;
    }

    @Override
    public synchronized int getHoldability() throws SQLException {
        this.checkClosed();
        return this.rsHoldability;
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw Util.sqlException(4821);
        }
        JDBCSavepoint savepoint = new JDBCSavepoint(this);
        try {
            this.sessionProxy.savepoint(savepoint.name);
        }
        catch (DataspaceException e) {
            Util.throwError(e);
        }
        return savepoint;
    }

    @Override
    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw Util.sqlException(4821);
        }
        if (name == null) {
            throw Util.nullArgument();
        }
        if (name.startsWith("SYSTEM_SAVEPOINT_")) {
            throw Util.invalidArgument();
        }
        try {
            this.sessionProxy.savepoint(name);
        }
        catch (DataspaceException e) {
            Util.throwError(e);
        }
        return new JDBCSavepoint(name, this);
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            throw Util.nullArgument();
        }
        if (!(savepoint instanceof JDBCSavepoint)) {
            String msg = Error.getMessage(4821);
            throw Util.invalidArgument(msg);
        }
        JDBCSavepoint sp = (JDBCSavepoint)savepoint;
        if (sp.name == null) {
            String msg = Error.getMessage(4821);
            throw Util.invalidArgument(msg);
        }
        if (this != sp.connection) {
            String msg = Error.getMessage(4821);
            throw Util.invalidArgument(msg);
        }
        if (this.getAutoCommit()) {
            sp.name = null;
            sp.connection = null;
            throw Util.sqlException(4821);
        }
        try {
            this.sessionProxy.rollbackToSavepoint(sp.name);
            sp.connection = null;
            sp.name = null;
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            throw Util.nullArgument();
        }
        if (!(savepoint instanceof JDBCSavepoint)) {
            String msg = Error.getMessage(4821);
            throw Util.invalidArgument(msg);
        }
        JDBCSavepoint sp = (JDBCSavepoint)savepoint;
        if (sp.name == null) {
            String msg = Error.getMessage(4821);
            throw Util.invalidArgument(msg);
        }
        if (this != sp.connection) {
            String msg = Error.getMessage(4821);
            throw Util.invalidArgument(msg);
        }
        if (this.getAutoCommit()) {
            sp.name = null;
            sp.connection = null;
            throw Util.sqlException(4821);
        }
        try {
            this.sessionProxy.releaseSavepoint(sp.name);
            sp.connection = null;
            sp.name = null;
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        int props = ResultProperties.getValueForJDBC(resultSetType, resultSetConcurrency, resultSetHoldability);
        return new JDBCStatement(this, props);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, 2, null, null);
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCCallableStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        try {
            if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
                throw Util.invalidArgument("autoGeneratedKeys");
            }
            return new JDBCPreparedStatement(this, sql, 1003, 1007, this.rsHoldability, autoGeneratedKeys, null, null);
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, sql, 1003, 1007, this.rsHoldability, 21, columnIndexes, null);
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, sql, 1003, 1007, this.rsHoldability, 11, null, columnNames);
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        return new JDBCClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        return new JDBCBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        return new JDBCNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        return new JDBCSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw Util.outOfRangeArgument("timeout: " + timeout);
        }
        if (this.isInternal) {
            return true;
        }
        if (!this.isNetConn) {
            return !this.isClosed();
        }
        if (this.isClosed()) {
            return false;
        }
        final boolean[] flag = new boolean[]{true};
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    JDBCConnection.this.getMetaData().getDatabaseMajorVersion();
                }
                catch (Throwable e) {
                    flag[0] = false;
                }
            }
        };
        if (timeout > 60) {
            timeout = 60;
        }
        timeout *= 1000;
        try {
            t.start();
            long start = System.currentTimeMillis();
            t.join(timeout);
            try {
                t.setContextClassLoader(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (timeout == 0) {
                return flag[0];
            }
            return flag[0] && System.currentTimeMillis() - start < (long)timeout;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        SQLClientInfoException ex = new SQLClientInfoException();
        ex.initCause(Util.notSupported());
        throw ex;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (!this.isClosed && (properties == null || properties.isEmpty())) {
            return;
        }
        SQLClientInfoException ex = new SQLClientInfoException();
        if (this.isClosed) {
            ex.initCause(Util.connectionClosedException());
        } else {
            ex.initCause(Util.notSupported());
        }
        throw ex;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        if (typeName == null) {
            throw Util.nullArgument();
        }
        int typeCode = Type.getTypeCode(typeName = typeName.toUpperCase());
        if (typeCode < 0) {
            throw Util.invalidArgument(typeName);
        }
        Type type = Type.getDefaultType(typeCode);
        if (type.isArrayType() || type.isLobType() || type.isRowType()) {
            throw Util.invalidArgument(typeName);
        }
        Object[] newData = new Object[elements.length];
        try {
            for (int i = 0; i < elements.length; ++i) {
                Object o = type.convertJavaToSQL(this.sessionProxy, elements[i]);
                newData[i] = type.convertToTypeLimits(this.sessionProxy, o);
            }
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
        return new JDBCArray(newData, type, this);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkClosed();
        throw Util.notSupported();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkClosed();
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw Util.invalidArgument("iface: " + String.valueOf(iface));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkClosed();
        if (schema == null) {
            Util.nullArgument("schema");
        } else if (schema.length() == 0) {
            Util.invalidArgument("Zero-length schema");
        } else {
            new JDBCDatabaseMetaData(this).setConnectionDefaultSchema(schema);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return new JDBCDatabaseMetaData(this).getConnectionDefaultSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw Util.nullArgument("executor");
        }
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkClosed();
        throw Util.notSupported();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    JDBCConnection(BaseStoreProperties props) throws SQLException {
        String user = props.getProperty("user");
        String password = props.getProperty("password");
        String connType = props.getProperty("connection_type");
        String path = props.getProperty("path");
        String dataspaceType = null;
        String dataspaceName = null;
        if (props.getProperty("dataspace") != null) {
            List<String> typename = StringUtils.split(props.getProperty("dataspace"), '.');
            if (typename.size() != 2) {
                throw new SQLException("Invalid dataspace '" + props.getProperty("dataspace") + "' specified. Should be in format <DataspaceType>.<DataspaceName>.");
            }
            dataspaceType = typename.get(0);
            dataspaceName = typename.get(1);
        }
        if (user == null) {
            user = "SA";
        }
        if (password == null) {
            password = "";
        }
        TimeZone timeZone = TimeZone.getDefault();
        try {
            if (DataspaceURL.isInProcessDatabaseType(connType)) {
                this.sessionProxy = DataspaceStoreManager.newSession(connType, path, user, password, props, timeZone);
                ((Session)this.sessionProxy).setInteractive(true);
            } else if (connType == "//") {
                if (dataspaceName == null) {
                    throw new SQLException("Dataspace name not specified.");
                }
                this.sessionProxy = new ClientConnection(path, dataspaceType, dataspaceName, user, password, timeZone, props);
                this.isNetConn = true;
            } else {
                throw Util.invalidArgument(connType);
            }
            this.sessionProxy.setJDBCConnection(this);
            this.connProperties = props;
            this.clientProperties = this.sessionProxy.getClientProperties();
            if (dataspaceName != null && this.sessionProxy instanceof Session) {
                ((Session)this.sessionProxy).setDataspace(dataspaceName);
            }
        }
        catch (Exception e) {
            this.closeFully();
            throw Util.sqlException(e);
        }
        boolean bl = this.isEmbeddedConnection = connType == "runtime:";
        if (this.isEmbeddedConnection) {
            this.incrementCounter();
        }
    }

    JDBCConnection(DataspaceAccessor accessor, TimeZone timeZone, BaseStoreProperties props) throws SQLException {
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        this.sessionProxy = new ClientConnection(accessor, timeZone, props);
        this.isNetConn = true;
        this.sessionProxy.setJDBCConnection(this);
        this.connProperties = props;
        this.clientProperties = this.sessionProxy.getClientProperties();
        this.isEmbeddedConnection = false;
    }

    public JDBCConnection(BaseStoreProperties props, String connType, String path, String initialDataspace, User user) throws SQLException {
        this.sessionProxy = DataspaceStoreManager.newSession(connType, path, user, props);
        this.sessionProxy.setJDBCConnection(this);
        this.connProperties = props;
        this.clientProperties = this.sessionProxy.getClientProperties();
        ((Session)this.sessionProxy).setDataspace(initialDataspace);
        this.isEmbeddedConnection = false;
    }

    public JDBCConnection(SessionInterface c) {
        this.isInternal = true;
        this.sessionProxy = c;
    }

    public JDBCConnection(JDBCConnection c, JDBCConnectionEventListener eventListener) {
        this.sessionProxy = c.sessionProxy;
        this.connProperties = c.connProperties;
        this.clientProperties = c.clientProperties;
        this.isPooled = true;
        this.poolEventListener = eventListener;
        this.incrementCounter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementCounter() {
        Class<JDBCConnection> clazz = JDBCConnection.class;
        synchronized (JDBCConnection.class) {
            ++connectionsCounter;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean decrementCounter() {
        Class<JDBCConnection> clazz = JDBCConnection.class;
        synchronized (JDBCConnection.class) {
            boolean bl = --connectionsCounter == 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return bl;
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    synchronized int getSavepointID() {
        return this.savepointIDSequence++;
    }

    synchronized String getURL() throws SQLException {
        this.checkClosed();
        return this.isInternal ? this.sessionProxy.getInternalConnectionURL() : this.connProperties.getProperty("url");
    }

    synchronized void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw Util.connectionClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWarning(SQLWarning w) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            if (this.rootWarning == null) {
                this.rootWarning = w;
            } else {
                this.rootWarning.setNextWarning(w);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWarnings(SQLWarning w) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            this.rootWarning = w;
        }
    }

    public void reset() throws SQLException {
        try {
            ++this.incarnation;
            this.sessionProxy.resetSession();
        }
        catch (DataspaceException e) {
            throw Util.sqlException(1305, e.getMessage(), e);
        }
    }

    public void closeFully() {
        Trace.logDebug(this, "Closing JDBC connection... " + this.toString());
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.sessionProxy != null) {
                this.sessionProxy.close();
                this.sessionProxy = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public SessionInterface getSession() {
        return this.sessionProxy;
    }

    private static int onStartEscapeSequence(String sql, StringBuffer sb, int i) throws SQLException {
        sb.append(' ');
        ++i;
        i = StringUtil.skipSpaces(sql, i);
        if (sql.regionMatches(true, i, "fn ", 0, 3) || sql.regionMatches(true, i, "oj ", 0, 3)) {
            i += 2;
        } else if (sql.regionMatches(true, i, "ts ", 0, 3)) {
            sb.append("TIMESTAMP");
            i += 2;
        } else if (sql.regionMatches(true, i, "d ", 0, 2)) {
            sb.append("DATE");
            ++i;
        } else if (sql.regionMatches(true, i, "t ", 0, 2)) {
            sb.append("TIME");
            ++i;
        } else if (sql.regionMatches(true, i, "call ", 0, 5)) {
            sb.append("CALL");
            i += 4;
        } else if (sql.regionMatches(true, i, "?= call ", 0, 8)) {
            sb.append("CALL");
            i += 7;
        } else if (sql.regionMatches(true, i, "? = call ", 0, 8)) {
            sb.append("CALL");
            i += 8;
        } else if (sql.regionMatches(true, i, "escape ", 0, 7)) {
            i += 6;
        } else {
            --i;
            return -1;
        }
        return i;
    }
}

