/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.jdbc;

import com.streamscape.ds.jdbc.JDBCBlobFile;
import com.streamscape.ds.jdbc.JDBCClob;
import com.streamscape.ds.jdbc.Util;
import com.streamscape.ds.lib.FileUtil;
import com.streamscape.ds.lib.InOutUtil;
import com.streamscape.ds.lib.KMPSearchAlgorithm;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class JDBCClobFile
implements Clob {
    public static final String TEMP_FILE_PREFIX = "hsql_jdbc_clob_file_";
    public static final String TEMP_FILE_SUFFIX = ".tmp";
    private final File m_file;
    private boolean m_closed;
    private boolean m_deleteOnFree;
    private String m_encoding;
    private Charset m_charset;
    private CharsetEncoder m_encoder;
    private boolean m_fixedWidthCharset;
    private int m_maxCharWidth;
    private List m_streams = new ArrayList();

    @Override
    public long length() throws SQLException {
        this.checkClosed();
        if (this.m_fixedWidthCharset) {
            return this.m_file.length() / (long)this.m_maxCharWidth;
        }
        ReaderAdapter adapter = null;
        try {
            long length;
            adapter = new ReaderAdapter(this.m_file, 0L, Long.MAX_VALUE);
            long l = length = adapter.skip(Long.MAX_VALUE);
            return l;
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
        finally {
            if (adapter != null) {
                try {
                    adapter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        Reader reader = null;
        CharArrayWriter writer = null;
        try {
            int initialCapacity = Math.min(8192, length);
            reader = this.getCharacterStream(pos, length);
            writer = new CharArrayWriter(initialCapacity);
            InOutUtil.copy(reader, writer, (long)length);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return writer.toString();
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return this.getCharacterStream(1L, Long.MAX_VALUE);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        JDBCBlobFile.InputStreamAdapter stream;
        try {
            stream = new JDBCBlobFile.InputStreamAdapter(this.m_file, 0L, Long.MAX_VALUE){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCClobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
        this.m_streams.add(stream);
        return stream;
    }

    public long position(char[] pattern, long start) throws SQLException {
        if (start < 1L) {
            throw Util.outOfRangeArgument("start: " + start);
        }
        if (pattern == null || pattern.length == 0 || start > this.length()) {
            return -1L;
        }
        Reader reader = null;
        try {
            reader = this.getCharacterStream(start, Long.MAX_VALUE);
            long matchOffset = KMPSearchAlgorithm.search(reader, pattern, KMPSearchAlgorithm.computeTable(pattern));
            long l = matchOffset == -1L ? -1L : start + matchOffset;
            return l;
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        return this.position(searchstr == null ? null : searchstr.toCharArray(), start);
    }

    @Override
    public long position(Clob pattern, long start) throws SQLException {
        char[] charPattern;
        if (start < 1L) {
            throw Util.outOfRangeArgument("start: " + start);
        }
        long patternLength = pattern == null ? 0L : pattern.length();
        if (patternLength == 0L) {
            return -1L;
        }
        if (patternLength > Integer.MAX_VALUE) {
            throw Util.outOfRangeArgument("pattern.length(): " + patternLength);
        }
        if (pattern instanceof JDBCClob) {
            charPattern = ((JDBCClob)pattern).data().toCharArray();
        } else {
            Reader reader = null;
            CharArrayWriter writer = new CharArrayWriter();
            try {
                reader = pattern.getCharacterStream();
                InOutUtil.copy(reader, writer, patternLength);
            }
            catch (IOException ex) {
                throw Util.sqlException(ex);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            charPattern = writer.toCharArray();
        }
        return this.position(charPattern, start);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 0, str == null ? 0 : str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        if (str == null) {
            throw Util.nullArgument("str");
        }
        Writer writer = null;
        try {
            writer = this.setCharacterStream(pos);
            writer.write(str, offset, len);
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
        return len;
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        JDBCBlobFile.OutputStreamAdapter stream;
        if (pos < 1L) {
            throw Util.invalidArgument("pos: " + pos);
        }
        this.checkClosed();
        this.createFile();
        try {
            stream = new JDBCBlobFile.OutputStreamAdapter(this.m_file, pos - 1L){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCClobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
        this.m_streams.add(stream);
        return stream;
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        BufferedWriter writer;
        if (pos < 1L) {
            throw Util.invalidArgument("pos: " + pos);
        }
        this.checkClosed();
        this.createFile();
        try {
            WriterAdapter adapter = new WriterAdapter(this.m_file, pos - 1L){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCClobFile.this.m_streams.remove(this);
                    }
                }
            };
            writer = new BufferedWriter(adapter);
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
        this.m_streams.add(writer);
        return writer;
    }

    @Override
    public void truncate(long len) throws SQLException {
        if (len < 0L) {
            throw Util.invalidArgument("len: " + len);
        }
        this.checkClosed();
        ReaderAdapter adapter = null;
        RandomAccessFile randomAccessFile = null;
        try {
            adapter = new ReaderAdapter(this.m_file, len, Long.MAX_VALUE);
            long filePointer = adapter.getFilePointer();
            adapter.close();
            randomAccessFile = new RandomAccessFile(this.m_file, "rw");
            randomAccessFile.setLength(filePointer);
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
        finally {
            if (adapter != null) {
                try {
                    adapter.close();
                }
                catch (Exception exception) {}
            }
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public synchronized void free() throws SQLException {
        if (this.m_closed) {
            return;
        }
        this.m_closed = true;
        ArrayList streams = new ArrayList();
        streams.addAll(this.m_streams);
        this.m_streams = null;
        for (Object stream : streams) {
            if (stream instanceof InputStream) {
                try {
                    ((InputStream)stream).close();
                }
                catch (Exception exception) {}
                continue;
            }
            if (!(stream instanceof OutputStream)) continue;
            try {
                ((OutputStream)stream).close();
            }
            catch (Exception exception) {}
        }
        if (this.m_deleteOnFree) {
            try {
                this.m_file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        ReaderAdapter reader;
        if (pos < 1L) {
            throw Util.outOfRangeArgument("pos: " + pos);
        }
        --pos;
        if (length < 0L) {
            throw Util.outOfRangeArgument("length: " + length);
        }
        try {
            reader = new ReaderAdapter(this.m_file, pos, length){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCClobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
        this.m_streams.add(reader);
        return reader;
    }

    public File getFile() {
        return this.m_file;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public boolean isDeleteOnFree() {
        return this.m_deleteOnFree;
    }

    public void setDeleteOnFree(boolean deleteOnFree) {
        this.m_deleteOnFree = deleteOnFree;
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            try {
                this.free();
            }
            catch (Throwable throwable) {}
        }
    }

    public JDBCClobFile() throws SQLException {
        this((String)null);
    }

    public JDBCClobFile(String encoding) throws SQLException {
        try {
            this.setEncoding(encoding);
            this.m_file = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
            this.m_deleteOnFree = true;
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
    }

    public JDBCClobFile(File file) throws SQLException {
        this(file, null);
    }

    public JDBCClobFile(File file, String encoding) throws SQLException {
        if (file == null) {
            throw Util.nullArgument("file");
        }
        try {
            this.setEncoding(encoding);
            this.m_file = file.getCanonicalFile();
            this.checkIsFile(false);
            this.m_deleteOnFree = false;
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
    }

    protected final void setEncoding(String encoding) throws UnsupportedEncodingException {
        boolean fixedWidthCharset;
        Charset charSet = JDBCClobFile.charsetForName(encoding);
        CharsetEncoder encoder = charSet.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        float maxBytesPerChar = encoder.maxBytesPerChar();
        float averageBytesPerChar = encoder.averageBytesPerChar();
        this.m_fixedWidthCharset = fixedWidthCharset = maxBytesPerChar == (float)Math.round(maxBytesPerChar) && maxBytesPerChar == averageBytesPerChar;
        this.m_maxCharWidth = Math.round(maxBytesPerChar);
        this.m_charset = charSet;
        this.m_encoder = encoder;
        this.m_encoding = this.m_charset.name();
    }

    protected static Charset charsetForName(String charsetName) throws UnsupportedEncodingException {
        String csn = charsetName;
        if (csn == null) {
            csn = Charset.defaultCharset().name();
        }
        try {
            if (Charset.isSupported(csn)) {
                return Charset.forName(csn);
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        throw new UnsupportedEncodingException(csn);
    }

    protected final void checkIsFile(boolean checkExists) throws SQLException {
        boolean exists = false;
        boolean isFile = false;
        try {
            exists = this.m_file.exists();
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
        if (exists) {
            try {
                isFile = this.m_file.isFile();
            }
            catch (Exception ex) {
                throw Util.sqlException(ex);
            }
        }
        if (exists) {
            if (!isFile) {
                throw Util.invalidArgument("Is not a file: " + String.valueOf(this.m_file));
            }
        } else if (checkExists) {
            throw Util.invalidArgument("Does not exist: " + String.valueOf(this.m_file));
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.m_closed) {
            throw Util.sqlException(1251);
        }
    }

    protected void createFile() throws SQLException {
        try {
            if (!this.m_file.exists()) {
                FileUtil.getFileUtil().makeParentDirectories(this.m_file);
                this.m_file.createNewFile();
            }
        }
        catch (Exception ex) {
            throw Util.sqlException(ex);
        }
        this.checkIsFile(true);
    }

    protected class ReaderAdapter
    extends Reader {
        private static final int CHARBUFFER_CAPACTIY = 128;
        private final Reader m_reader;
        private long m_remaining = Long.MAX_VALUE;
        private long m_filePointer;
        private ByteBuffer m_byteBuffer;
        private CharBuffer m_charBuffer;

        public ReaderAdapter(File file, long pos, long length) throws FileNotFoundException, IOException {
            int ch;
            if (file == null) {
                throw new NullPointerException("file");
            }
            if (pos < 0L) {
                throw new IllegalArgumentException("pos: " + pos);
            }
            if (length < 0L) {
                throw new IllegalArgumentException("length: " + length);
            }
            if (!JDBCClobFile.this.m_fixedWidthCharset) {
                int charCapacity = 128;
                int byteCapacity = 128 * JDBCClobFile.this.m_maxCharWidth;
                this.m_charBuffer = CharBuffer.allocate(128);
                this.m_byteBuffer = ByteBuffer.allocate(byteCapacity);
            }
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(fis);
            InputStreamReader isr = new InputStreamReader((InputStream)bis, JDBCClobFile.this.m_charset);
            this.m_reader = isr;
            for (long i = 0L; i < pos && (ch = this.read()) != -1; ++i) {
            }
            this.m_remaining = length;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int bytesRead;
            int charsRead;
            long l_remaining = this.m_remaining;
            if (l_remaining <= 0L) {
                return -1;
            }
            if (l_remaining < (long)len) {
                len = (int)l_remaining;
            }
            if ((charsRead = this.m_reader.read(cbuf, off, len)) == -1) {
                return -1;
            }
            if ((long)charsRead > l_remaining) {
                charsRead = (int)l_remaining;
                this.m_remaining = 0L;
            } else {
                this.m_remaining -= (long)charsRead;
            }
            if (JDBCClobFile.this.m_fixedWidthCharset) {
                bytesRead = JDBCClobFile.this.m_maxCharWidth * charsRead;
            } else {
                boolean reallocate = charsRead > this.m_charBuffer.capacity();
                CharBuffer cb = reallocate ? CharBuffer.allocate(charsRead) : this.m_charBuffer;
                ByteBuffer bb = reallocate ? ByteBuffer.allocate(charsRead * JDBCClobFile.this.m_maxCharWidth) : this.m_byteBuffer;
                cb.clear();
                bb.clear();
                cb.put(cbuf, off, charsRead);
                cb.flip();
                JDBCClobFile.this.m_encoder.encode(cb, bb, true);
                bb.flip();
                bytesRead = bb.limit();
                if (reallocate) {
                    this.m_byteBuffer = bb;
                    this.m_charBuffer = cb;
                }
            }
            this.m_filePointer += (long)bytesRead;
            return charsRead;
        }

        @Override
        public void close() throws IOException {
            this.m_reader.close();
        }

        public long getFilePointer() {
            return this.m_filePointer;
        }
    }

    protected class WriterAdapter
    extends Writer {
        private final RandomAccessFile m_randomAccessFile;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WriterAdapter(File file, long pos) throws FileNotFoundException, IOException {
            long filePointer;
            if (file == null) {
                throw new NullPointerException("file");
            }
            if (pos < 0L) {
                throw new IllegalArgumentException("pos: " + pos);
            }
            ReaderAdapter reader = null;
            try {
                reader = new ReaderAdapter(file, pos, Long.MAX_VALUE);
                filePointer = reader.getFilePointer();
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.m_randomAccessFile = new RandomAccessFile(file, "rw");
            this.m_randomAccessFile.seek(filePointer);
        }

        @Override
        public void flush() throws IOException {
            this.m_randomAccessFile.getFD().sync();
        }

        @Override
        public void close() throws IOException {
            this.m_randomAccessFile.close();
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter writer = JDBCClobFile.this.m_encoding == null ? new OutputStreamWriter(baos) : new OutputStreamWriter((OutputStream)baos, JDBCClobFile.this.m_charset);
            writer.write(cbuf, off, len);
            writer.close();
            this.m_randomAccessFile.write(baos.toByteArray());
        }
    }
}

