/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.jdbc;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.jdbc.JDBCResultSet;
import com.streamscape.ds.jdbc.Util;
import com.streamscape.ds.session.SessionInterface;
import com.streamscape.ds.types.BlobData;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.BlobInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class JDBCBlobClient
implements Blob {
    BlobData originalBlob;
    BlobData blob;
    SessionInterface session;
    int colIndex;
    private boolean isClosed;
    private boolean isWritable;
    JDBCResultSet resultSet;

    @Override
    public synchronized long length() throws SQLException {
        try {
            return this.blob.length(this.session);
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized byte[] getBytes(long pos, int length) throws SQLException {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, pos - 1L, length)) {
            throw Util.outOfRangeArgument();
        }
        try {
            return this.blob.getBytes(this.session, pos - 1L, length);
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized InputStream getBinaryStream() throws SQLException {
        return new BlobInputStream(this.session, this.blob, 0L, this.length());
    }

    @Override
    public synchronized long position(byte[] pattern, long start) throws SQLException {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, start - 1L, 0L)) {
            throw Util.outOfRangeArgument();
        }
        try {
            long position = this.blob.position(this.session, pattern, start - 1L);
            if (position >= 0L) {
                ++position;
            }
            return position;
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized long position(Blob pattern, long start) throws SQLException {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, start - 1L, 0L)) {
            throw Util.outOfRangeArgument();
        }
        if (pattern instanceof JDBCBlobClient) {
            BlobData searchClob = ((JDBCBlobClient)pattern).blob;
            try {
                long position = this.blob.position(this.session, searchClob, start - 1L);
                if (position >= 0L) {
                    ++position;
                }
                return position;
            }
            catch (DataspaceException e) {
                throw Util.sqlException(e);
            }
        }
        if (!JDBCBlobClient.isInLimits(Integer.MAX_VALUE, 0L, pattern.length())) {
            throw Util.outOfRangeArgument();
        }
        byte[] bytePattern = pattern.getBytes(1L, (int)pattern.length());
        return this.position(bytePattern, start);
    }

    @Override
    public synchronized int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public synchronized int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (!JDBCBlobClient.isInLimits(bytes.length, offset, len)) {
            throw Util.outOfRangeArgument();
        }
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, pos - 1L, len)) {
            throw Util.outOfRangeArgument();
        }
        if (!this.isWritable) {
            throw Util.notUpdatableColumn();
        }
        this.startUpdate();
        try {
            this.blob.setBytes(this.session, pos - 1L, bytes, offset, len);
            return len;
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized OutputStream setBinaryStream(long pos) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public synchronized void truncate(long len) throws SQLException {
        try {
            this.blob.truncate(this.session, len);
        }
        catch (DataspaceException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized void free() throws SQLException {
        this.isClosed = true;
    }

    @Override
    public synchronized InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, pos - 1L, length)) {
            throw Util.outOfRangeArgument();
        }
        return new BlobInputStream(this.session, this.blob, pos - 1L, length);
    }

    public JDBCBlobClient(SessionInterface session, BlobData blob) {
        this.session = session;
        this.blob = blob;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public BlobData getBlob() {
        return this.blob;
    }

    public synchronized void setWritable(JDBCResultSet result, int index) {
        this.isWritable = true;
        this.resultSet = result;
        this.colIndex = index;
    }

    public synchronized void clearUpdates() {
        if (this.originalBlob != null) {
            this.blob = this.originalBlob;
            this.originalBlob = null;
        }
    }

    private void startUpdate() throws SQLException {
        if (this.originalBlob != null) {
            return;
        }
        this.originalBlob = this.blob;
        this.blob = (BlobDataID)this.blob.duplicate(this.session);
        this.resultSet.startUpdate(this.colIndex + 1);
        this.resultSet.preparedStatement.parameterValues[this.colIndex] = this.blob;
        this.resultSet.preparedStatement.parameterSet[this.colIndex] = Boolean.TRUE;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw Util.sqlException(1251);
        }
    }

    static boolean isInLimits(long fullLength, long pos, long len) {
        return pos >= 0L && len >= 0L && pos + len <= fullLength;
    }

    public SessionInterface getSession() {
        return this.session;
    }
}

