/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.jdbc;

import com.streamscape.ds.jdbc.Util;
import com.streamscape.ds.lib.KMPSearchAlgorithm;
import com.streamscape.ds.lib.java.JavaSystem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class JDBCBlob
implements Blob {
    public static final long MIN_POS = 1L;
    public static final long MAX_POS = 0x80000000L;
    private boolean m_closed;
    private byte[] m_data;
    private final boolean m_createdByConnection;

    @Override
    public long length() throws SQLException {
        return this.getData().length;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        byte[] data = this.getData();
        int dlen = data.length;
        if (pos < 1L || pos > 1L + (long)dlen) {
            throw Util.outOfRangeArgument("pos: " + pos);
        }
        if (length < 0 || (long)length > (long)dlen - --pos) {
            throw Util.outOfRangeArgument("length: " + length);
        }
        byte[] result = new byte[length];
        System.arraycopy(data, (int)pos, result, 0, length);
        return result;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.getData());
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        byte[] data = this.getData();
        int dlen = data.length;
        if (start < 1L) {
            throw Util.outOfRangeArgument("start: " + start);
        }
        if (start > (long)dlen || pattern == null) {
            return -1L;
        }
        int startIndex = (int)start - 1;
        int plen = pattern.length;
        if (plen == 0 || startIndex > dlen - plen) {
            return -1L;
        }
        int result = KMPSearchAlgorithm.search(data, pattern, KMPSearchAlgorithm.computeTable(pattern), startIndex);
        return result == -1 ? -1L : (long)(result + 1);
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        byte[] data = this.getData();
        int dlen = data.length;
        if (start < 1L) {
            throw Util.outOfRangeArgument("start: " + start);
        }
        if (start > (long)dlen || pattern == null) {
            return -1L;
        }
        int startIndex = (int)start - 1;
        long plen = pattern.length();
        if (plen == 0L || (long)startIndex > (long)dlen - plen) {
            return -1L;
        }
        int iplen = (int)plen;
        byte[] bytePattern = pattern instanceof JDBCBlob ? ((JDBCBlob)pattern).data() : pattern.getBytes(1L, iplen);
        int result = KMPSearchAlgorithm.search(data, bytePattern, KMPSearchAlgorithm.computeTable(bytePattern), startIndex);
        return result == -1 ? -1L : (long)(result + 1);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        if (bytes == null) {
            throw Util.nullArgument("bytes");
        }
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (!this.m_createdByConnection) {
            throw Util.notSupported();
        }
        if (bytes == null) {
            throw Util.nullArgument("bytes");
        }
        if (offset < 0 || offset > bytes.length) {
            throw Util.outOfRangeArgument("offset: " + offset);
        }
        if (len > bytes.length - offset) {
            throw Util.outOfRangeArgument("len: " + len);
        }
        if (pos < 1L || pos > 1L + (long)(Integer.MAX_VALUE - len)) {
            throw Util.outOfRangeArgument("pos: " + pos);
        }
        byte[] data = this.getData();
        int dlen = data.length;
        if (--pos + (long)len > (long)dlen) {
            byte[] temp = new byte[(int)pos + len];
            System.arraycopy(data, 0, temp, 0, dlen);
            data = temp;
            temp = null;
        }
        System.arraycopy(bytes, offset, data, (int)pos, len);
        this.checkClosed();
        this.setData(data);
        return len;
    }

    @Override
    public OutputStream setBinaryStream(final long pos) throws SQLException {
        if (!this.m_createdByConnection) {
            throw Util.notSupported();
        }
        if (pos < 1L || pos > 0x80000000L) {
            throw Util.outOfRangeArgument("pos: " + pos);
        }
        this.checkClosed();
        return new ByteArrayOutputStream(){

            @Override
            public synchronized void close() throws IOException {
                try {
                    JDBCBlob.this.setBytes(pos, this.toByteArray());
                }
                catch (SQLException se) {
                    throw JavaSystem.toIOException(se);
                }
                finally {
                    super.close();
                }
            }
        };
    }

    @Override
    public void truncate(long len) throws SQLException {
        byte[] data = this.getData();
        if (len < 0L || len > (long)data.length) {
            throw Util.outOfRangeArgument("len: " + len);
        }
        if (len == (long)data.length) {
            return;
        }
        byte[] newData = new byte[(int)len];
        System.arraycopy(data, 0, newData, 0, (int)len);
        this.checkClosed();
        this.setData(newData);
    }

    @Override
    public synchronized void free() throws SQLException {
        this.m_closed = true;
        this.m_data = null;
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        byte[] data = this.getData();
        int dlen = data.length;
        if (pos < 1L || pos > (long)dlen) {
            throw Util.outOfRangeArgument("pos: " + pos);
        }
        if (length < 0L || length > (long)dlen - --pos) {
            throw Util.outOfRangeArgument("length: " + length);
        }
        if (pos == 0L && length == (long)dlen) {
            return new ByteArrayInputStream(data);
        }
        byte[] result = new byte[(int)length];
        System.arraycopy(data, (int)pos, result, 0, (int)length);
        return new ByteArrayInputStream(result);
    }

    public JDBCBlob(byte[] data) throws SQLException {
        if (data == null) {
            throw Util.nullArgument();
        }
        this.m_data = data;
        this.m_createdByConnection = false;
    }

    protected JDBCBlob() {
        this.m_data = new byte[0];
        this.m_createdByConnection = true;
    }

    protected synchronized void checkClosed() throws SQLException {
        if (this.m_closed) {
            throw Util.sqlException(1251);
        }
    }

    protected byte[] data() throws SQLException {
        return this.getData();
    }

    private synchronized byte[] getData() throws SQLException {
        this.checkClosed();
        return this.m_data;
    }

    private synchronized void setData(byte[] data) throws SQLException {
        this.checkClosed();
        this.m_data = data;
    }
}

