/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.jdbc;

import com.streamscape.ds.jdbc.JDBCClobClient;
import com.streamscape.ds.jdbc.JDBCConnection;
import com.streamscape.ds.jdbc.JDBCResultSet;
import com.streamscape.ds.jdbc.Util;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.column.ColumnBase;
import com.streamscape.ds.session.SessionInterface;
import com.streamscape.ds.types.Type;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class JDBCArray
implements Array {
    volatile boolean closed;
    Type arrayType;
    Type elementType;
    Object[] data;
    JDBCConnection connection;
    SessionInterface sessionProxy;

    @Override
    public String getBaseTypeName() throws SQLException {
        this.checkClosed();
        return this.elementType.getNameString();
    }

    @Override
    public int getBaseType() throws SQLException {
        this.checkClosed();
        return this.elementType.getJDBCTypeCode();
    }

    @Override
    public Object getArray() throws SQLException {
        this.checkClosed();
        Object[] array = new Object[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            array[i] = this.elementType.convertSQLToJDBC(this.sessionProxy, this.data[i]);
        }
        return array;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        return this.getArray();
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(this.data.length, index - 1L, count)) {
            throw Util.outOfRangeArgument();
        }
        Object[] slice = new Object[count];
        for (int i = 0; i < count; ++i) {
            slice[i] = this.elementType.convertSQLToJDBC(this.sessionProxy, this.data[(int)index + i - 1]);
        }
        return slice;
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        return this.getArray(index, count);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        Result result = this.newColumnResult(0L, this.data.length);
        return new JDBCResultSet(this.connection, result, result.metaData);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        return this.getResultSet();
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        this.checkClosed();
        Result result = this.newColumnResult(index - 1L, count);
        return new JDBCResultSet(this.connection, result, result.metaData);
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        return this.getResultSet(index, count);
    }

    public String toString() {
        if (this.arrayType == null) {
            this.arrayType = Type.getDefaultArrayType(this.elementType.typeCode);
        }
        return this.arrayType.convertToString(this.data);
    }

    @Override
    public void free() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            this.connection = null;
            this.sessionProxy = null;
        }
    }

    public JDBCArray(Object[] data, Type type, Type arrayType, SessionInterface session) {
        this(data, type, arrayType, session.getJDBCConnection());
        this.sessionProxy = session;
    }

    JDBCArray(Object[] data, Type type, JDBCConnection connection) throws SQLException {
        this(data, type, null, connection);
    }

    JDBCArray(Object[] data, Type type, Type arrayType, JDBCConnection connection) {
        this.data = data;
        this.elementType = type;
        this.arrayType = arrayType;
        this.connection = connection;
        this.sessionProxy = connection.sessionProxy;
    }

    public Object[] getArrayInternal() {
        return this.data;
    }

    private Result newColumnResult(long position, int count) throws SQLException {
        if (!JDBCClobClient.isInLimits(this.data.length, position, count)) {
            throw Util.outOfRangeArgument();
        }
        Type[] types = new Type[]{Type.SQL_INTEGER, this.elementType};
        ResultMetaData meta = ResultMetaData.newSimpleResultMetaData(types);
        meta.columnLabels = new String[]{"C1", "C2"};
        meta.colIndexes = new int[]{-1, -1};
        meta.columns = new ColumnBase[2];
        ColumnBase column = new ColumnBase("", "", "", "");
        column.setType(types[0]);
        meta.columns[0] = column;
        column = new ColumnBase("", "", "", "");
        column.setType(types[1]);
        meta.columns[1] = column;
        RowSetNavigatorClient navigator = new RowSetNavigatorClient();
        int i = (int)position;
        while ((long)i < position + (long)count) {
            Object[] rowData = new Object[]{i + 1, this.data[i]};
            navigator.add(rowData);
            ++i;
        }
        Result result = Result.newDataResult(meta);
        result.setNavigator(navigator);
        return result;
    }

    private void checkClosed() throws SQLException {
        if (this.closed) {
            throw Util.sqlException(1251);
        }
    }
}

