/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.ds.jdbc;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.cli.http.HTTPFabricConnectionFactory;
import com.streamscape.cli.http.HTTPSFabricConnectionFactory;
import com.streamscape.cli.tlp.ClientId;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceURL;
import com.streamscape.ds.error.Error;
import com.streamscape.ds.io.rowio.RowInputBinary;
import com.streamscape.ds.io.rowio.RowOutputBinary;
import com.streamscape.ds.io.rowio.RowOutputInterface;
import com.streamscape.ds.jdbc.JDBCConnection;
import com.streamscape.ds.lib.DataOutputStream;
import com.streamscape.ds.lib.HsqlByteArrayOutputStream;
import com.streamscape.ds.lib.store.ValuePool;
import com.streamscape.ds.navigator.RowSetNavigatorClient;
import com.streamscape.ds.parser.Scanner;
import com.streamscape.ds.persist.BaseStoreProperties;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.result.ResultLob;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.session.SessionInterface;
import com.streamscape.ds.types.BlobDataID;
import com.streamscape.ds.types.ClobDataID;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.lib.http.SSLContextFactory;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sef.dispatcher.AbstractClientConnection;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

class ClientConnection
extends AbstractClientConnection
implements SessionInterface {
    public static int DEFAULT_REQUEST_TIMEOUT = 0;
    static final int BUFFER_SIZE = 4096;
    final byte[] mainBuffer = new byte[4096];
    private boolean isClosed = false;
    protected RowOutputInterface rowOut;
    protected RowInputBinary rowIn;
    private Result resultOut;
    private long sessionID;
    private long lobIDSequence = -1L;
    private int requestTimeout = DEFAULT_REQUEST_TIMEOUT;
    private String connectionName;
    private String connectionId;
    private String nodeName;
    private int reconnectAttempts;
    private int reconnectInterval;
    private String protocolType;
    private boolean isReadOnlyDefault = false;
    private boolean isAutoCommit = true;
    private Scanner scanner;
    private Calendar calendar;
    private Calendar calendarGMT;
    private SimpleDateFormat simpleDateFormatGMT;
    private TimeZone timeZone;
    private JDBCConnection connection;
    private String urls;
    private String path;
    private String dataspaceType;
    private String dataspaceName;
    private int databaseID;
    private String clientPropertiesString;
    private String databaseUniqueName;
    private BaseStoreProperties clientProperties;
    private FabricConnection fabricConnection;
    private DataspaceAccessor dataspaceAccessor;

    ClientConnection(String path, String dataspaceType, String dataspaceName, String user, String password, TimeZone timeZone, BaseStoreProperties props) throws SQLException {
        this.urls = props.getProperty("urls");
        this.path = path;
        this.dataspaceType = dataspaceType;
        this.dataspaceName = dataspaceName;
        this.initProperties(timeZone, props);
        if ((StringUtils.equalsNullSafe(this.protocolType, "https") || StringUtils.equalsNullSafe(this.protocolType, "http")) && (this.reconnectAttempts != 0 || this.reconnectInterval != 0)) {
            throw new SQLException("Reconnect parameters not allowed for HTTP[S] connection.");
        }
        this.openDataspaceAccessor(user, password);
        this.connect(user, password);
    }

    ClientConnection(DataspaceAccessor accessor, TimeZone timeZone, BaseStoreProperties props) throws SQLException {
        this.dataspaceType = accessor.getComponentType();
        this.dataspaceName = accessor.getComponentName();
        this.initProperties(timeZone, props);
        if (this.connectionName != null || this.connectionId != null || this.nodeName != null || this.reconnectAttempts != 0 || this.reconnectInterval != 0 || this.protocolType != null) {
            throw new SQLException("connectionId, connectionName, nodeName, reconnectAttempts, reconnectInterval, remote_protocol_type parameters not allowed for connection based on existent dataspace accessor.");
        }
        this.setAccessor(accessor);
        this.connect(null, null);
    }

    private void initProperties(TimeZone timeZone, BaseStoreProperties props) throws SQLException {
        this.timeZone = timeZone;
        this.requestTimeout = props.getIntegerProperty("requestTimeout", DEFAULT_REQUEST_TIMEOUT);
        this.connectionName = props.getProperty("connectionName");
        this.connectionId = props.getProperty("connectionId");
        this.nodeName = props.getProperty("nodeName");
        this.reconnectAttempts = props.getIntegerProperty("reconnectAttempts", 0);
        this.reconnectInterval = props.getIntegerProperty("reconnectInterval", 0);
        this.protocolType = props.getProperty("remote_protocol_type");
        if (this.connectionId != null) {
            this.connectionName = this.connectionId;
        }
    }

    private void connect(String username, String password) throws SQLException {
        this.initStructures();
        Result login = Result.newConnectionAttemptRequest(username, password, this.dataspaceName, this.timeZone);
        try {
            Result resultIn = this.execute(login);
            if (resultIn.isError()) {
                throw Error.error(resultIn);
            }
            this.sessionID = resultIn.getSessionId();
            this.databaseID = resultIn.getDatabaseId();
            this.databaseUniqueName = resultIn.getDatabaseName();
            this.clientPropertiesString = resultIn.getMainString();
        }
        catch (Exception exception) {
            this.close();
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new DataspaceException(exception);
        }
    }

    private void initStructures() {
        RowOutputBinary rowOutTemp = new RowOutputBinary(this.mainBuffer);
        this.rowOut = rowOutTemp;
        this.rowIn = new RowInputBinary(rowOutTemp);
        this.resultOut = Result.newSessionAttributesResult();
    }

    private void openDataspaceAccessor(String user, String password) throws SQLException {
        try {
            FabricConnectionFactory fabricFactory;
            if (StringUtils.equalsNullSafe(this.protocolType, "tlp")) {
                fabricFactory = new FabricConnectionFactory(this.addUrlPrefix("tlp://"));
                fabricFactory.setReconnectAttempts(this.reconnectAttempts);
                if (this.reconnectInterval > 0) {
                    fabricFactory.setReconnectInterval(this.reconnectInterval);
                }
            } else if (StringUtils.equalsNullSafe(this.protocolType, "http")) {
                fabricFactory = new HTTPFabricConnectionFactory(this.addUrlPrefix("http://"));
            } else if (StringUtils.equalsNullSafe(this.protocolType, "https")) {
                fabricFactory = new HTTPSFabricConnectionFactory(this.addUrlPrefix("https://"));
                SSLContextFactory sslContextFactory = new SSLContextFactory();
                sslContextFactory.trustAllCertificates();
                ((HTTPSFabricConnectionFactory)fabricFactory).setSSLContextFactory(sslContextFactory);
            } else {
                throw new Exception("Unknown protocol type '" + this.protocolType + "'.");
            }
            fabricFactory.setType("Client_JDBC");
            this.fabricConnection = fabricFactory.createConnection(user, password);
            if (this.connectionId != null) {
                this.connectionName = this.connectionId;
                try {
                    ClientId clientId = new ClientId(this.connectionId);
                    this.fabricConnection.setClientId(clientId);
                }
                catch (Exception exception) {
                    throw new Exception("Parsing connectionId '" + this.connectionId + "' failed. Cause: " + exception.getMessage());
                }
            } else if (this.connectionName != null) {
                this.fabricConnection.setName(this.connectionName);
            }
            if (this.fabricConnection instanceof HTTPFabricConnection) {
                int httpTimeout = this.requestTimeout;
                if (httpTimeout > 0) {
                    httpTimeout += 10000;
                }
                ((HTTPFabricConnection)this.fabricConnection).setHttpTimeout(httpTimeout);
            }
            this.fabricConnection.open();
            this.timeZone = this.fabricConnection.getNodeTimezone();
        }
        catch (Exception exception) {
            throw new SQLException("Opening TLP connection to " + this.urls + " failed. Cause: " + exception.getMessage(), exception);
        }
        try {
            DataspaceType dataspaceTypeType;
            try {
                dataspaceTypeType = DataspaceType.valueOf(this.dataspaceType);
            }
            catch (Exception exception) {
                throw new SQLException("Invalid dataspace type " + this.dataspaceType + " specified.");
            }
            this.dataspaceAccessor = this.nodeName != null ? this.fabricConnection.createDataspaceAccessor(this.nodeName, dataspaceTypeType, this.dataspaceName) : this.fabricConnection.createDataspaceAccessor(dataspaceTypeType, this.dataspaceName);
            if (!this.dataspaceAccessor.isAvailable()) {
                throw new SQLException("Dataspace '" + this.dataspaceType + "." + this.dataspaceName + "' is not available.");
            }
            this.setAccessor(this.dataspaceAccessor);
        }
        catch (Exception exception) {
            this.closeDataspaceAccessor();
            throw new SQLException("Opening dataspace accessor to '" + this.dataspaceType + "." + this.dataspaceName + "' failed. Cause: " + exception.getMessage(), exception);
        }
    }

    private String addUrlPrefix(String prefix) throws SQLException {
        StringBuilder newUrls = new StringBuilder();
        for (String url : DataspaceURL.validateUrls(this.urls)) {
            newUrls.append(prefix).append(url).append("&");
        }
        if (newUrls.length() > 0) {
            newUrls.setLength(newUrls.length() - 1);
        }
        return newUrls.toString();
    }

    protected void closeDataspaceAccessor() {
        if (this.fabricConnection != null) {
            Trace.logDebug(this, "Closing JDBC Client Connection '" + this.connectionName + "' dataspace accessor and fabric connection...");
            try {
                if (this.dataspaceAccessor != null) {
                    this.dataspaceAccessor.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.fabricConnection != null) {
                    this.fabricConnection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dataspaceAccessor = null;
            this.fabricConnection = null;
        }
    }

    @Override
    public synchronized Result execute(Result r) {
        if (this.isClosed) {
            return Result.newErrorResult(Error.error(1353));
        }
        try {
            r.setSessionId(this.sessionID);
            r.setDatabaseId(this.databaseID);
            return this.write(r);
        }
        catch (Throwable e) {
            throw Error.error(1305, e.toString());
        }
    }

    @Override
    public synchronized RowSetNavigatorClient getRows(long navigatorId, int offset, int size) {
        try {
            this.resultOut.setResultType(13);
            this.resultOut.setResultId(navigatorId);
            this.resultOut.setUpdateCount(offset);
            this.resultOut.setFetchSize(size);
            Result result = this.execute(this.resultOut);
            return (RowSetNavigatorClient)result.getNavigator();
        }
        catch (Throwable e) {
            throw Error.error(1305, e.toString());
        }
    }

    @Override
    public synchronized void closeNavigator(long navigatorId) {
        try {
            this.resultOut.setResultType(40);
            this.resultOut.setResultId(navigatorId);
            this.execute(this.resultOut);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        Trace.logDebug(this, "Closing JDBC Client Connection '" + this.connectionName + "'...");
        try {
            this.resultOut.setResultType(32);
            if (this.dataspaceAccessor != null) {
                this.execute(this.resultOut);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closeDataspaceAccessor();
        this.isClosed = true;
    }

    @Override
    public synchronized Object getAttribute(int id) {
        this.resultOut.setResultType(7);
        this.resultOut.setStatementType(id);
        Result in = this.execute(this.resultOut);
        if (in.isError()) {
            throw Error.error(in);
        }
        Object[] data = in.getSingleRowData();
        switch (id) {
            case 1: {
                return data[2];
            }
            case 2: {
                return data[2];
            }
            case 0: {
                return data[1];
            }
            case 3: {
                return data[3];
            }
        }
        return null;
    }

    @Override
    public synchronized void setAttribute(int id, Object value) {
        this.resultOut.setResultType(6);
        Object[] data = this.resultOut.getSingleRowData();
        data[0] = ValuePool.getInt(id);
        switch (id) {
            case 1: 
            case 2: {
                data[2] = value;
                break;
            }
            case 0: {
                data[1] = value;
                break;
            }
            case 3: {
                data[3] = value;
            }
        }
        Result resultIn = this.execute(this.resultOut);
        if (resultIn.isError()) {
            throw Error.error(resultIn);
        }
    }

    @Override
    public synchronized boolean isReadOnlyDefault() {
        Object info = this.getAttribute(2);
        this.isReadOnlyDefault = (Boolean)info;
        return this.isReadOnlyDefault;
    }

    @Override
    public synchronized void setReadOnlyDefault(boolean mode) {
        if (mode != this.isReadOnlyDefault) {
            this.setAttribute(2, mode ? Boolean.TRUE : Boolean.FALSE);
            this.isReadOnlyDefault = mode;
        }
    }

    @Override
    public synchronized boolean isAutoCommit() {
        Object info = this.getAttribute(1);
        this.isAutoCommit = (Boolean)info;
        return this.isAutoCommit;
    }

    @Override
    public synchronized void setAutoCommit(boolean mode) {
        if (mode != this.isAutoCommit) {
            this.setAttribute(1, mode ? Boolean.TRUE : Boolean.FALSE);
            this.isAutoCommit = mode;
        }
    }

    @Override
    public synchronized void setIsolationDefault(int level) {
        this.setAttribute(0, ValuePool.getInt(level));
    }

    @Override
    public synchronized int getIsolation() {
        Object info = this.getAttribute(0);
        return (Integer)info;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public Session getSession() {
        return null;
    }

    @Override
    public synchronized void startPhasedTransaction() {
    }

    @Override
    public synchronized void prepareCommit() {
        this.resultOut.setAsTransactionEndRequest(12, null);
        Result in = this.execute(this.resultOut);
        if (in.isError()) {
            throw Error.error(in);
        }
    }

    @Override
    public synchronized void commit(boolean chain) {
        this.resultOut.setAsTransactionEndRequest(0, null);
        Result in = this.execute(this.resultOut);
        if (in.isError()) {
            throw Error.error(in);
        }
    }

    @Override
    public synchronized void rollback(boolean chain) {
        this.resultOut.setAsTransactionEndRequest(1, null);
        Result in = this.execute(this.resultOut);
        if (in.isError()) {
            throw Error.error(in);
        }
    }

    @Override
    public synchronized void rollbackToSavepoint(String name) {
        this.resultOut.setAsTransactionEndRequest(2, name);
        Result in = this.execute(this.resultOut);
        if (in.isError()) {
            throw Error.error(in);
        }
    }

    @Override
    public synchronized void savepoint(String name) {
        Result result = Result.newSetSavepointRequest(name);
        Result in = this.execute(result);
        if (in.isError()) {
            throw Error.error(in);
        }
    }

    @Override
    public synchronized void releaseSavepoint(String name) {
        this.resultOut.setAsTransactionEndRequest(4, name);
        Result in = this.execute(this.resultOut);
        if (in.isError()) {
            throw Error.error(in);
        }
    }

    @Override
    public void addWarning(DataspaceException warning) {
    }

    @Override
    public synchronized long getId() {
        return this.sessionID;
    }

    @Override
    public synchronized void resetSession() {
        Result login = Result.newResetSessionRequest();
        Result resultIn = this.execute(login);
        if (resultIn.isError()) {
            this.isClosed = true;
            this.closeDataspaceAccessor();
            throw Error.error(resultIn);
        }
        this.sessionID = resultIn.getSessionId();
        this.databaseID = resultIn.getDatabaseId();
    }

    protected Result write(Result r) throws IOException {
        HsqlByteArrayOutputStream memStream = new HsqlByteArrayOutputStream();
        DataOutputStream tempOutput = new DataOutputStream(memStream);
        r.write(this, tempOutput, this.rowOut);
        byte[] reply = super.invokeWriteRequest(memStream.toByteArray(), this.requestTimeout);
        DataInputStream dataInput = new DataInputStream(new ByteArrayInputStream(reply));
        this.rowOut.reset();
        Result result = Result.newResult(dataInput, this.rowIn);
        result.readAdditionalResults(this, dataInput, this.rowIn);
        dataInput.close();
        return result;
    }

    @Override
    public synchronized String getInternalConnectionURL() {
        return null;
    }

    public synchronized long getLobId() {
        return this.lobIDSequence--;
    }

    @Override
    public BlobDataID createBlob(long length) {
        BlobDataID blob = new BlobDataID(this.getLobId());
        return blob;
    }

    @Override
    public ClobDataID createClob(long length) {
        ClobDataID clob = new ClobDataID(this.getLobId());
        return clob;
    }

    @Override
    public void allocateResultLob(ResultLob resultLob, InputStream dataInput) {
    }

    @Override
    public Scanner getScanner() {
        if (this.scanner == null) {
            this.scanner = new Scanner();
        }
        return this.scanner;
    }

    @Override
    public Calendar getCalendar() {
        if (this.calendar == null) {
            this.calendar = new GregorianCalendar(this.timeZone);
        }
        return this.calendar;
    }

    public Calendar getCalendarGMT() {
        if (this.calendarGMT == null) {
            this.calendarGMT = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        }
        return this.calendarGMT;
    }

    public SimpleDateFormat getSimpleDateFormatGMT() {
        if (this.simpleDateFormatGMT == null) {
            this.simpleDateFormatGMT = new SimpleDateFormat("MMMM", Locale.ENGLISH);
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            this.simpleDateFormatGMT.setCalendar(cal);
        }
        return this.simpleDateFormatGMT;
    }

    @Override
    public TimestampData getCurrentDate() {
        long currentMillis = System.currentTimeMillis();
        return new TimestampData(currentMillis);
    }

    @Override
    public int getZoneSeconds() {
        return this.timeZone.getOffset(System.currentTimeMillis()) / 1000;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public int getStreamBlockSize() {
        return 524288;
    }

    @Override
    public BaseStoreProperties getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = this.clientPropertiesString.length() > 0 ? BaseStoreProperties.delimitedArgPairsToProps(this.clientPropertiesString, "=", ";", null) : new BaseStoreProperties();
        }
        return this.clientProperties;
    }

    @Override
    public JDBCConnection getJDBCConnection() {
        return this.connection;
    }

    @Override
    public void setJDBCConnection(JDBCConnection connection) {
        this.connection = connection;
    }

    @Override
    public String getStoreUniqueName() {
        return this.databaseUniqueName;
    }
}

